/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import net.percederberg.mibble.browser.LicenseDialog;

public class AboutDialog
extends JDialog {
    private static final String ACKNOWLEDGEMENTS = "Written by Watsh Rajneesh & Per Cederberg.\nThanks to Charles F. Schatz, and to Tex Clayton\nat Dartware LLC, for valuable additions.\nThis software uses the Westhawk SNMP Stack.";
    private static final String COPYRIGHT = "(c) 2004-2017 Per Cederberg. All rights reserved.\nThis program comes with ABSOLUTELY NO\nWARRANTY; for details see the accompanying\nlicense.";

    public AboutDialog(JFrame parent, Properties buildInfo) {
        super((Frame)parent, true);
        this.initialize(buildInfo);
        this.setLocationRelativeTo(parent);
    }

    private void initialize(Properties buildInfo) {
        this.setTitle("About Mibble MIB Browser");
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Mibble MIB Browser");
        label.setFont(Font.decode("sans bold 20"));
        label.setForeground(new Color(227, 96, 48));
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 2;
        c.anchor = 10;
        c.insets = new Insets(20, 15, 5, 15);
        this.getContentPane().add((Component)label, c);
        String str = "Version " + buildInfo.getProperty("build.version", "N/A") + " (built on " + buildInfo.getProperty("build.date", "N/A") + ")";
        label = new JLabel(str);
        label.setFont(label.getFont().deriveFont(1));
        c = new GridBagConstraints();
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 10;
        c.insets = new Insets(0, 15, 15, 15);
        this.getContentPane().add((Component)label, c);
        label = new JLabel("Acknowledgments:");
        label.setFont(label.getFont().deriveFont(1));
        c = new GridBagConstraints();
        c.gridy = 2;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 15, 0, 15);
        this.getContentPane().add((Component)label, c);
        JTextArea textArea = new JTextArea(ACKNOWLEDGEMENTS);
        textArea.setEditable(false);
        c = new GridBagConstraints();
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 15, 0, 15);
        this.getContentPane().add((Component)textArea, c);
        label = new JLabel("Copyright & License:");
        label.setFont(label.getFont().deriveFont(1));
        c = new GridBagConstraints();
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(10, 15, 0, 15);
        this.getContentPane().add((Component)label, c);
        textArea = new JTextArea(COPYRIGHT);
        textArea.setEditable(false);
        c = new GridBagConstraints();
        c.gridy = 5;
        c.gridwidth = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 15, 0, 15);
        this.getContentPane().add((Component)textArea, c);
        JButton button = new JButton("View License");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.showLicense();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 6;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(20, 15, 10, 15);
        this.getContentPane().add((Component)button, c);
        button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.anchor = 10;
        c.weightx = 1.0;
        c.insets = new Insets(20, 15, 10, 15);
        this.getContentPane().add((Component)button, c);
        this.pack();
    }

    protected void showLicense() {
        LicenseDialog dialog = new LicenseDialog((JFrame)this.getParent());
        this.dispose();
        dialog.setVisible(true);
    }
}

