/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import net.percederberg.mibble.FileLocation;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;

public abstract class MibSymbol {
    private MibFileRef fileRef;
    private Mib mib;
    private String name;
    private String comment;

    MibSymbol(MibFileRef fileRef, Mib mib, String name) {
        this.fileRef = fileRef;
        this.mib = mib;
        this.name = name;
        if (mib != null) {
            mib.addSymbol(this);
        }
    }

    public abstract void initialize(MibLoaderLog var1) throws MibException;

    abstract void clear();

    public MibFileRef getFileRef() {
        return this.fileRef;
    }

    @Deprecated
    public FileLocation getLocation() {
        return this.fileRef;
    }

    public Mib getMib() {
        return this.mib;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.mib.getText(this.fileRef);
    }

    public String getComment() {
        return this.comment;
    }

    void setComment(String comment) {
        this.comment = comment;
    }
}

