/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.percederberg.mibble.MibSource;

public class MibLocator {
    private static final Pattern NAME = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_]*");
    private ClassLoader classLoader;
    private File dir;
    private HashMap<String, MibSource> nameCache = null;
    private HashMap<String, MibSource> contentCache = null;

    public MibLocator(File dir) {
        this.dir = dir;
    }

    public MibLocator(ClassLoader classLoader, String path) {
        this.classLoader = classLoader;
        this.dir = new File(path);
    }

    public boolean isResourceDir() {
        return this.classLoader != null;
    }

    public File getDir() {
        return this.dir;
    }

    public URL getUrl() {
        if (this.isResourceDir()) {
            return this.classLoader.getResource(this.dir.toString());
        }
        try {
            return this.dir.toURI().toURL();
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }

    public Map<String, MibSource> getNameMap() {
        if (this.nameCache == null) {
            this.nameCache = new HashMap();
            URL url = this.getUrl();
            if (url != null) {
                if (url.getProtocol().equals("jar")) {
                    this.nameCache.putAll(MibLocator.readJar(url, this.dir.toString(), false));
                } else if (url.getProtocol().equals("file")) {
                    this.nameCache.putAll(MibLocator.readDir(new File(url.getPath()), false));
                }
            }
        }
        return this.nameCache;
    }

    public Map<String, MibSource> getContentMap() {
        if (this.contentCache == null) {
            this.contentCache = new HashMap();
            URL url = this.getUrl();
            if (url != null) {
                if (url.getProtocol().equals("jar")) {
                    this.contentCache.putAll(MibLocator.readJar(url, this.dir.toString(), true));
                } else if (url.getProtocol().equals("file")) {
                    this.contentCache.putAll(MibLocator.readDir(new File(url.getPath()), true));
                }
            }
        }
        return this.contentCache;
    }

    public MibSource findByName(String mibName) {
        return this.getNameMap().get(mibName.toUpperCase());
    }

    public MibSource findByContent(String mibName) {
        return this.getContentMap().get(mibName);
    }

    private static Map<String, MibSource> readDir(File dir, boolean readContent) {
        HashMap<String, MibSource> res = new HashMap<String, MibSource>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                String mibName = null;
                mibName = !readContent ? MibLocator.guessMibName(file.getName()) : MibLocator.readMibName(file);
                if (mibName == null) continue;
                res.put(mibName, new MibSource(file));
            }
        }
        return res;
    }

    private static Map<String, MibSource> readJar(URL url, String prefix, boolean readContent) {
        HashMap<String, MibSource> res = new HashMap<String, MibSource>();
        try (JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();){
            String urlBase = url.toString().replaceAll("!.*", "");
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                String path = e.nextElement().getName();
                if (!path.startsWith(prefix)) continue;
                URL resUrl = new URL(urlBase + "!/" + path);
                String mibName = null;
                mibName = !readContent ? MibLocator.guessMibName(path) : MibLocator.readMibName(resUrl);
                if (mibName == null) continue;
                res.put(mibName, new MibSource(path, resUrl));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    private static String guessMibName(String path) {
        File file = new File(path);
        Matcher m = NAME.matcher(file.getName());
        if (m.lookingAt() && !path.endsWith("/") && !file.isDirectory()) {
            return m.group().toUpperCase();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMibName(File file) {
        if (!file.canRead()) return null;
        if (!file.isFile()) {
            return null;
        }
        try (FileReader in = new FileReader(file);){
            String string = MibLocator.readMibName(in);
            return string;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMibName(URL url) {
        try (InputStreamReader in = new InputStreamReader(url.openStream());){
            String string = MibLocator.readMibName(in);
            return string;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMibName(Reader reader) {
        try (BufferedReader in = new BufferedReader(reader);){
            String str;
            do {
                if ((str = in.readLine()) != null) continue;
                return null;
            } while ((str = str.trim()).equals("") || str.startsWith("--"));
            Matcher m = NAME.matcher(str);
            boolean hasDefToken = str.contains("DEFINITIONS");
            String string = m.lookingAt() && hasDefToken ? m.group() : null;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

