/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.percederberg.mibble.DefaultContext;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibLocator;
import net.percederberg.mibble.MibSource;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.asn1.Asn1Parser;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibLoader {
    private ArrayList<MibLocator> dirCaches = new ArrayList();
    private ArrayList<String> resources = new ArrayList();
    private LinkedHashMap<String, Mib> mibs = new LinkedHashMap();
    private ArrayList<Object> queue = new ArrayList();
    private DefaultContext context = new DefaultContext();
    private Asn1Parser parser = null;

    public MibLoader() {
        this.addResourceDir("mibs/iana");
        this.addResourceDir("mibs/ietf");
    }

    public boolean hasDir(File dir) {
        if (dir == null) {
            dir = new File(".");
        } else if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        for (MibLocator cache : this.dirCaches) {
            if (!cache.getDir().equals(dir)) continue;
            return true;
        }
        return false;
    }

    public File[] getDirs() {
        File[] res = new File[this.dirCaches.size()];
        for (int i = 0; i < this.dirCaches.size(); ++i) {
            MibLocator cache = this.dirCaches.get(i);
            res[i] = cache.getDir();
        }
        return res;
    }

    public void addDir(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        if (!this.hasDir(dir) && dir.isDirectory()) {
            this.dirCaches.add(new MibLocator(dir));
        }
    }

    public void addDirs(File[] dirs) {
        for (File file : dirs) {
            this.addDir(file);
        }
    }

    public void addAllDirs(File dir) {
        if (dir == null) {
            dir = new File(".");
        }
        this.addDir(dir);
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            this.addAllDirs(file);
        }
    }

    public void removeDir(File dir) {
        for (int i = 0; i < this.dirCaches.size(); ++i) {
            MibLocator cache = this.dirCaches.get(i);
            if (!cache.getDir().equals(dir)) continue;
            this.dirCaches.remove(i--);
        }
    }

    public void removeAllDirs() {
        this.dirCaches.clear();
    }

    public boolean hasResourceDir(String dir) {
        return this.resources.contains(dir);
    }

    public String[] getResourceDirs() {
        return this.resources.toArray(new String[this.resources.size()]);
    }

    public void addResourceDir(String dir) {
        if (!this.hasResourceDir(dir)) {
            this.resources.add(dir);
        }
    }

    public void removeResourceDir(String dir) {
        this.resources.remove(dir);
    }

    public void removeAllResourceDirs() {
        this.resources.clear();
    }

    public void reset() {
        this.mibs.clear();
        this.queue.clear();
        this.context = new DefaultContext();
    }

    public MibContext getDefaultContext() {
        return this.context;
    }

    public ObjectIdentifierValue getOid(String oid) {
        return this.context.findOid(oid);
    }

    public ObjectIdentifierValue getRootOid() {
        MibSymbol symbol = this.context.findSymbol("iso", false);
        MibValue value = ((MibValueSymbol)symbol).getValue();
        return (ObjectIdentifierValue)value;
    }

    public Mib getMib(String name) {
        return this.mibs.get(name);
    }

    public Mib getMib(File file) {
        for (Mib mib : this.mibs.values()) {
            if (!mib.equals(file)) continue;
            return mib;
        }
        return null;
    }

    public Map<String, Mib> getMibs() {
        return this.mibs;
    }

    public Map<String, Mib> getMibs(File file) {
        LinkedHashMap<String, Mib> res = new LinkedHashMap<String, Mib>();
        for (Mib mib : this.mibs.values()) {
            if (!mib.equals(file)) continue;
            res.put(mib.getName(), mib);
        }
        return res;
    }

    public Map<String, Mib> getMibs(boolean loaded) {
        LinkedHashMap<String, Mib> res = new LinkedHashMap<String, Mib>();
        for (Mib mib : this.mibs.values()) {
            if (mib.isLoaded() != loaded) continue;
            res.put(mib.getName(), mib);
        }
        return res;
    }

    public Mib[] getAllMibs() {
        return this.mibs.values().toArray(new Mib[this.mibs.size()]);
    }

    public Mib load(String name) throws IOException, MibLoaderException {
        Mib mib = this.getMib(name);
        if (mib == null) {
            MibSource src = this.locate(name);
            if (src == null) {
                throw new FileNotFoundException("couldn't locate MIB: '" + name + "'");
            }
            mib = this.load(src);
        } else {
            mib.setLoaded(true);
        }
        return mib;
    }

    public Mib load(File file) throws IOException, MibLoaderException {
        Map<String, Mib> found = this.getMibs(file);
        for (Mib mib : found.values()) {
            mib.setLoaded(true);
        }
        if (found.size() <= 0) {
            return this.load(new MibSource(file));
        }
        return found.values().iterator().next();
    }

    public Mib load(URL url) throws IOException, MibLoaderException {
        return this.load(new MibSource(url));
    }

    public Mib load(Reader input) throws IOException, MibLoaderException {
        return this.load(new MibSource(input));
    }

    public Mib load(MibSource src) throws IOException, MibLoaderException {
        this.queue.clear();
        this.queue.add(src);
        return this.loadQueue();
    }

    public void unload(String name) throws MibLoaderException {
        this.unload(this.getMib(name));
    }

    public void unload(File file) throws MibLoaderException {
        for (Mib mib : this.mibs.values()) {
            if (!mib.equals(file)) continue;
            this.unload(mib);
            return;
        }
    }

    public void unload(Mib mib) throws MibLoaderException {
        if (mib != null) {
            Mib[] referers = mib.getImportingMibs();
            if (referers.length > 0) {
                String msg = "cannot be unloaded due to reference in " + referers[0];
                throw new MibLoaderException(msg);
            }
            this.mibs.remove(mib.getName());
            mib.clear();
        }
    }

    public void unloadAll() {
        Iterator<Mib> iter = this.mibs.values().iterator();
        while (iter.hasNext()) {
            iter.next().clear();
        }
        this.reset();
    }

    void scheduleLoad(String name) {
        if (this.getMib(name) == null && !this.queue.contains(name)) {
            this.queue.add(name);
        }
    }

    private Mib loadQueue() throws IOException, MibLoaderException {
        int i;
        MibLoaderLog log = new MibLoaderLog();
        ArrayList<Mib> processed = new ArrayList<Mib>();
        Mib firstMib = null;
        while (this.queue.size() > 0) {
            try {
                boolean loaded = false;
                MibSource src = null;
                Object obj = this.queue.get(0);
                if (obj instanceof MibSource) {
                    loaded = true;
                    src = (MibSource)obj;
                } else if (this.getMib((String)obj) == null) {
                    src = this.locate((String)obj);
                }
                if (src != null && this.getMib(src.getFile()) == null) {
                    ArrayList<Mib> list = this.parseMib(src, log);
                    for (Mib mib : list) {
                        mib.setLoaded(loaded);
                        this.mibs.put(mib.getName(), mib);
                        if (firstMib != null) continue;
                        firstMib = mib;
                    }
                    processed.addAll(list);
                }
            }
            catch (MibLoaderException loaded) {
                // empty catch block
            }
            this.queue.remove(0);
        }
        for (i = processed.size() - 1; i >= 0; --i) {
            try {
                ((Mib)processed.get(i)).initialize();
                continue;
            }
            catch (MibLoaderException src) {
                // empty catch block
            }
        }
        for (i = processed.size() - 1; i >= 0; --i) {
            try {
                ((Mib)processed.get(i)).validate();
                continue;
            }
            catch (MibLoaderException src) {
                // empty catch block
            }
        }
        if (log.errorCount() > 0) {
            for (Mib mib : processed) {
                this.mibs.remove(mib.getName());
                mib.clear();
            }
            throw new MibLoaderException(log);
        }
        return firstMib;
    }

    /*
     * Exception decompiling
     */
    private ArrayList<Mib> parseMib(MibSource src, MibLoaderLog log) throws IOException, MibLoaderException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MibSource locate(String name) {
        for (MibLocator cache : this.dirCaches) {
            MibSource src = cache.findByName(name);
            if (src == null) continue;
            return src;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        for (String path : this.resources) {
            URL url = loader.getResource(path + "/" + name);
            if (url == null) continue;
            return new MibSource(name, url);
        }
        for (MibLocator cache : this.dirCaches) {
            MibSource src = cache.findByContent(name);
            if (src == null) continue;
            return src;
        }
        return null;
    }
}

