/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaPackage;

public class JavaImport
extends CodeElement {
    private String packageName;
    private String className;

    public JavaImport(JavaPackage pkg) {
        this(pkg.toString());
    }

    public JavaImport(String packageName) {
        this(packageName, "");
    }

    public JavaImport(JavaPackage pkg, JavaClass cls) {
        this(pkg.toString(), cls.toString());
    }

    public JavaImport(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    @Override
    public int compareTo(Object obj) {
        int value = super.compareTo(obj);
        if (value == 0) {
            return this.toString().compareTo(obj.toString());
        }
        return value;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.className.equals("")) {
            return this.packageName + ".*";
        }
        return this.packageName + "." + this.className;
    }

    @Override
    public int category() {
        return this.packageName.startsWith("java") ? 2 : 3;
    }

    @Override
    public void print(PrintWriter out, CodeStyle style, int indent) {
        out.println("import " + this.toString() + ";");
    }
}

