/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.csharp;

abstract class CSharpModifier {
    public static final int PUBLIC = 1;
    public static final int PROTECTED_INTERNAL = 2;
    public static final int PROTECTED = 3;
    public static final int INTERNAL = 4;
    public static final int PRIVATE = 5;
    public static final int STATIC = 8;
    public static final int NEW = 16;
    public static final int VIRTUAL = 32;
    public static final int SEALED = 64;
    public static final int OVERRIDE = 128;
    public static final int ABSTRACT = 256;
    public static final int EXTERN = 512;
    public static final int CONST = 1024;
    public static final int READONLY = 2048;
    public static final int VOLATILE = 4096;

    CSharpModifier() {
    }

    public static String createModifierDecl(int modifiers) {
        StringBuffer res = new StringBuffer();
        switch (modifiers % 8) {
            case 1: {
                res.append("public ");
                break;
            }
            case 2: {
                res.append("protected internal ");
                break;
            }
            case 3: {
                res.append("protected ");
                break;
            }
            case 4: {
                res.append("internal ");
                break;
            }
            case 5: {
                res.append("private ");
            }
        }
        if ((modifiers & 8) > 0) {
            res.append("static ");
        }
        if ((modifiers & 0x10) > 0) {
            res.append("new ");
        }
        if ((modifiers & 0x20) > 0) {
            res.append("virtual ");
        }
        if ((modifiers & 0x40) > 0) {
            res.append("sealed ");
        }
        if ((modifiers & 0x80) > 0) {
            res.append("override ");
        }
        if ((modifiers & 0x100) > 0) {
            res.append("abstract ");
        }
        if ((modifiers & 0x200) > 0) {
            res.append("extern ");
        }
        if ((modifiers & 0x400) > 0) {
            res.append("const ");
        }
        if ((modifiers & 0x800) > 0) {
            res.append("readonly ");
        }
        if ((modifiers & 0x1000) > 0) {
            res.append("volatile ");
        }
        return res.toString();
    }
}

