/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica;

public class GrammarException
extends Exception {
    private String file;
    private String message;
    private int startLine;
    private int endLine;

    public GrammarException(String file, String message) {
        this(file, message, -1, -1);
    }

    public GrammarException(String file, String message, int startLine, int endLine) {
        this.file = file;
        this.message = message;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public String getFile() {
        return this.file;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public String getMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getErrorMessage());
        if (this.startLine > 0 && this.endLine > 0) {
            if (this.startLine == this.endLine) {
                buffer.append(", on line ");
                buffer.append(this.startLine);
            } else {
                buffer.append(", on lines ");
                buffer.append(this.startLine);
                buffer.append("-");
                buffer.append(this.endLine);
            }
        }
        return buffer.toString();
    }

    public String getErrorMessage() {
        return this.message;
    }
}

