/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.BThumbnail;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;

public class ViewportDragState
extends WsState {
    private Point anchor;
    private double pOrig;
    private double qOrig;

    public ViewportDragState(BWireSheetPane ws, Point anchor, double mx, double my) {
        super(ws);
        BThumbnail thumb = ws.getThumbnail();
        anchor.translate(-thumb.getX(), -thumb.getY());
        this.anchor = anchor;
        RectGeom rect = ws.getScrollPane().getViewport();
        this.pOrig = rect.x / (double)ws.grid.wixel;
        this.qOrig = rect.y / (double)ws.grid.wixel;
        this.updateViewport(mx, my);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.transition(new NormalState(this.ws));
        Point abs = this.translateToCanvasPane(event);
        double mx = abs.x;
        double my = abs.y;
        this.updateViewport(mx, my);
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        Point abs = this.translateToCanvasPane(event);
        double mx = abs.x;
        double my = abs.y;
        this.updateViewport(mx, my);
    }

    private void updateViewport(double mx, double my) {
        double sb = Theme.scrollBar().getFixedWidth();
        double w = this.ws.getWidth() - sb;
        double h = this.ws.getHeight() - sb;
        BThumbnail thumb = this.ws.getThumbnail();
        double p = (mx -= thumb.getX()) - (this.anchor.x - this.pOrig);
        double q = (my -= thumb.getY()) - (this.anchor.y - this.qOrig);
        RectGeom viewport = new RectGeom(p * (double)this.ws.grid.wixel, q * (double)this.ws.grid.wixel, w, h);
        this.ws.getScrollPane().scrollToVisible(viewport);
    }
}

