/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.util.ArrayUtil;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.ResizeZone;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.commands.ResizeCommand;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.BWsAnnotation;

public class ResizeState
extends WsState {
    private double x;
    private double y;
    private double w;
    private double h;
    private ResizeZone zone;
    private ComponentGlyph[] otherGlyphs;
    private RectGeom[] otherRects;

    public ResizeState(BWireSheetPane ws, ResizeZone zone, double mx, double my) {
        super(ws);
        this.zone = zone;
        this.x = zone.glyph.x;
        this.y = zone.glyph.y;
        this.w = zone.glyph.pw;
        this.h = zone.glyph.ph;
        Object[] sel = this.selection.getComponentGlyphs();
        this.otherGlyphs = (ComponentGlyph[])ArrayUtil.removeOne((Object[])sel, (Object)zone.glyph);
        this.otherRects = new RectGeom[this.otherGlyphs.length];
        for (int i = 0; i < this.otherRects.length; ++i) {
            ComponentGlyph o = this.otherGlyphs[i];
            this.otherRects[i] = new RectGeom((double)(o.x - 5), (double)(o.y - 5), (double)(o.pw + 10), (double)(o.ph + 10));
        }
        this.computeResizeBox(mx, my);
        ws.getCanvas().repaint();
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.transition(new NormalState(this.ws));
        double mx = event.getX();
        double my = event.getY();
        this.computeResizeBox(mx, my);
        ComponentGlyph[] glyphs = new ComponentGlyph[this.otherGlyphs.length + 1];
        BWsAnnotation[] annos = new BWsAnnotation[glyphs.length];
        glyphs[0] = this.zone.glyph;
        annos[0] = BWsAnnotation.make((int)((int)this.x / this.ws.grid.wixel), (int)((int)this.y / this.ws.grid.wixel), (int)((int)this.w / this.ws.grid.wixel), (int)((int)this.h / this.ws.grid.wixel));
        for (int i = 0; i < this.otherGlyphs.length; ++i) {
            RectGeom r = this.otherRects[i];
            glyphs[i + 1] = this.otherGlyphs[i];
            annos[i + 1] = BWsAnnotation.make((int)((int)r.x / this.ws.grid.wixel), (int)((int)r.y / this.ws.grid.wixel), (int)((int)r.width / this.ws.grid.wixel), (int)((int)r.height / this.ws.grid.wixel));
        }
        new ResizeCommand(this.ws, glyphs, annos).invoke();
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        double mx = event.getX();
        double my = event.getY();
        this.computeResizeBox(mx, my);
        this.ws.getCanvas().repaint();
    }

    @Override
    public void mousePulsed(BMouseEvent event) {
        if (this.pulseViewport(event)) {
            this.mouseDragged(event);
        }
    }

    private void computeResizeBox(double mx, double my) {
        mx = this.snapToGrid(mx);
        my = this.snapToGrid(my);
        ComponentGlyph glyph = this.zone.glyph;
        if (this.zone.onRight()) {
            if (mx < (double)(glyph.x + 2 * this.ws.grid.wixel)) {
                mx = glyph.x + 2 * this.ws.grid.wixel;
            }
            if (mx > (double)(this.ws.grid.getWixelWidth() * this.ws.grid.wixel)) {
                mx = this.ws.grid.getWixelWidth() * this.ws.grid.wixel;
            }
            this.w = mx - (double)glyph.x;
        }
        if (this.zone.onLeft()) {
            if (mx > (double)(glyph.x + glyph.pw - 2 * this.ws.grid.wixel)) {
                mx = glyph.x + glyph.pw - 2 * this.ws.grid.wixel;
            }
            if (mx < 0.0) {
                mx = 0.0;
            }
            this.x = mx;
            this.w = (double)(glyph.x + glyph.pw) - mx;
        }
        if (this.zone.onBottom()) {
            if (my < (double)(glyph.y + 2 * this.ws.grid.wixel)) {
                my = glyph.y + 2 * this.ws.grid.wixel;
            }
            if (my > (double)(this.ws.grid.getWixelHeight() * this.ws.grid.wixel)) {
                my = this.ws.grid.getWixelHeight() * this.ws.grid.wixel;
            }
            this.h = my - (double)glyph.y;
        }
        if (this.zone.onTop()) {
            if (my > (double)(glyph.y + glyph.ph - 2 * this.ws.grid.wixel)) {
                my = glyph.y + glyph.ph - 2 * this.ws.grid.wixel;
            }
            if (my < 0.0) {
                my = 0.0;
            }
            this.y = my;
            this.h = (double)(glyph.y + glyph.ph) - my;
        }
        double dx = this.x - (double)glyph.x;
        double dy = this.y - (double)glyph.y;
        double dw = this.w - (double)glyph.pw;
        double dh = this.h - (double)glyph.ph;
        for (int i = 0; i < this.otherGlyphs.length; ++i) {
            ComponentGlyph g = this.otherGlyphs[i];
            RectGeom r = this.otherRects[i];
            r.x = (double)g.x + dx;
            r.y = (double)g.y + dy;
            r.width = (double)g.pw + dw;
            r.height = (double)g.ph + dh;
        }
    }

    @Override
    public void paintFx(Graphics g) {
        g.setBrush(BColor.black);
        g.strokeRect(this.x, this.y, this.w, this.h);
        for (int i = 0; i < this.otherRects.length; ++i) {
            g.stroke((IGeom)this.otherRects[i]);
        }
    }
}

