/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.pin;

import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.pin.BPinPad;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.ui.table.TableModel;

public class SlotModel
extends TableModel {
    public BPinPad pad;
    public String title;
    public StdComponentGlyph glyph;
    public BComponent component;
    public Slot[] slots;
    public String[] displayNames;
    public boolean[] pinned;

    public SlotModel(BPinPad pad) {
        this.pad = pad;
        this.glyph = pad.glyph;
        this.component = this.glyph.component;
        this.title = this.component.getName();
        this.slots = this.glyph.getPotentialSlots(false);
        this.displayNames = new String[this.slots.length];
        this.pinned = new boolean[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            this.displayNames[i] = this.component.getDisplayName(this.slots[i], null);
            this.pinned[i] = Flags.isSummary((BComplex)this.component, (Slot)this.slots[i]);
        }
    }

    public int getRowCount() {
        return this.slots.length;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int col) {
        return this.title;
    }

    public Object getSubject(int row) {
        return this.slots[row];
    }

    public Object getValueAt(int row, int col) {
        return this.slots[row];
    }
}

