/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.WiresheetTheme;
import com.tridium.wiresheet.ActionBarGlyph;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.PropertyBarGlyph;
import com.tridium.wiresheet.RelationBarGlyph;
import com.tridium.wiresheet.TopicBarGlyph;
import com.tridium.wiresheet.WsController;
import com.tridium.wiresheet.WsPrinting;
import com.tridium.workbench.util.SlotBarUtil;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;

public abstract class SlotBarGlyph
extends Glyph {
    protected static final int nameX = 3;
    final ComponentGlyph parent;
    final BComponent component;
    final String relationId;
    final Slot slot;
    final String name;
    final String statusMessage;
    protected double nameWidth;
    protected BColor statusBg;
    protected BColor statusFg;

    public static SlotBarGlyph make(BWireSheetPane ws, ComponentGlyph parent, BComponent comp, Slot slot) {
        Type type;
        if (BWsOptions.make().getShowRelations() && slot.isProperty() && !(type = slot.asProperty().getType()).is(BLink.TYPE) && type.is(BRelation.TYPE)) {
            BRelation relation = (BRelation)comp.get(slot.asProperty());
            return new RelationBarGlyph(ws, parent, comp, slot.asProperty(), relation.getRelationId());
        }
        if (!BWsOptions.make().getShowLinks()) {
            return null;
        }
        if (slot.isAction()) {
            return new ActionBarGlyph(ws, parent, comp, slot.asAction());
        }
        if (slot.isTopic()) {
            return new TopicBarGlyph(ws, parent, comp, slot.asTopic());
        }
        return new PropertyBarGlyph(ws, parent, comp, slot.asProperty());
    }

    protected SlotBarGlyph(BWireSheetPane ws, ComponentGlyph parent, BComponent component, Slot slot) {
        super(ws);
        this.parent = parent;
        this.component = component;
        this.slot = slot;
        this.relationId = null;
        this.name = component.getDisplayName(slot, null);
        this.statusMessage = slot.toString();
        this.visible = Flags.isSummary((BComplex)component, (Slot)slot);
    }

    protected SlotBarGlyph(BWireSheetPane ws, ComponentGlyph parent, BComponent component, String relationId, boolean isRelationKnob) {
        super(ws);
        this.parent = parent;
        this.component = component;
        this.slot = null;
        this.relationId = relationId;
        this.statusMessage = this.name = SlotPath.unescape((String)relationId);
        this.visible = true;
    }

    @Override
    public int getLinkHotSpot(int p, int q) {
        if (q == 0) {
            if (p >= this.ww - this.getLinkHotSpotWidth()) {
                return 1;
            }
            if (p < this.getLinkHotSpotWidth()) {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public BComponent getLinkComponent() {
        return this.component;
    }

    @Override
    public Slot getLinkSlot() {
        return this.slot;
    }

    public String getRelationId() {
        return this.relationId;
    }

    @Override
    protected void doLayout(Glyph[] kids) {
        WiresheetTheme theme = Theme.wiresheet();
        BFont font = theme.glyph().getFont((IStylable)this);
        this.nameWidth = WsController.getFont(font, this.ws.grid.wixel - 2).width(this.name);
    }

    @Override
    public void paint(Graphics g) {
        WiresheetTheme theme = Theme.wiresheet();
        BFont font = theme.glyph().getFont((IStylable)this);
        font = WsController.getFont(font, this.ws.grid.wixel - 2);
        g.setFont(font);
        if (this.component.isPendingMove()) {
            g.setBrush(cutComponentFg);
            g.drawString(this.name, 3.0, (double)(this.ws.grid.wixel - 2));
            this.paintValue(g);
            g.strokeLine(1.0, 0.0, (double)this.pw, 0.0);
            return;
        }
        if (this.statusBg == null) {
            g.drawImage(SlotBarUtil.getSlotBar((BWidget)this.ws, (Slot)this.slot, (int)this.ww).transform(BTransform.makeScale((double)((double)this.ws.grid.wixel / 12.0), (double)((double)this.ws.grid.wixel / 12.0))), 0.0, 0.0);
        } else {
            g.setBrush(this.statusBg);
            g.fillRect(0.0, 0.0, (double)this.pw, (double)this.ph);
        }
        if (this.getLinkOver() != 0) {
            int hotSpotWidth = this.getLinkHotSpotWidth() * this.ws.grid.wixel;
            if (this.getLinkOver() == 2) {
                g.setBrush(linkOverTarget);
                g.fillRect(0.0, 0.0, (double)hotSpotWidth, (double)this.ph);
            } else {
                g.setBrush(linkOverSource);
                g.fillRect((double)(this.pw - hotSpotWidth), 0.0, (double)hotSpotWidth, (double)this.ph);
            }
        }
        if (this.statusFg != null) {
            g.setBrush(this.statusFg);
        } else {
            g.setBrush(componentFg);
        }
        g.setFont(font);
        g.drawString(this.name, 3.0, (double)(this.ws.grid.wixel - 2));
        this.paintValue(g);
        g.setBrush(theme.glyph().getOutline((IStylable)this));
        g.strokeLine(1.0, 0.0, (double)this.pw, 0.0);
    }

    protected void paintValue(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(WsPrinting p) {
        Graphics g = p.graphics;
        g.push();
        try {
            double w = (double)this.ww * p.wixel;
            double h = (double)this.wh * p.wixel;
            g.clip(0.0, 0.0, w, h);
            g.setBrush(BColor.black.toBrush());
            g.setFont(p.plain);
            g.drawString(this.name, 1.0, p.plain.getAscent());
            g.strokeLine(0.0, h, w, h);
        }
        finally {
            g.pop();
        }
    }

    @Override
    public void mouseEntered() {
        this.repaint();
        this.showStatus(this.statusMessage);
    }

    @Override
    public void mouseExited() {
        this.repaint();
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.name;
    }

    double calcWidth() {
        BFont font = Theme.wiresheet().glyph().getFont((IStylable)this);
        return 6.0 + WsController.getFont(font, this.ws.grid.wixel - 2).width(this.name);
    }
}

