/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.math;

import com.tridium.kitControl.math.BQuadMath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="inC", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=8, override=true), @NiagaraProperty(name="inD", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=8, override=true), @NiagaraProperty(name="in", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=8), @NiagaraProperty(name="limitBelow", type="boolean", defaultValue="true"), @NiagaraProperty(name="limitAbove", type="boolean", defaultValue="true"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
public final class BLine
extends BQuadMath {
    @Generated
    public static final Property inC = BLine.newProperty((int)8, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property inD = BLine.newProperty((int)8, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property in = BLine.newProperty((int)8, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property limitBelow = BLine.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property limitAbove = BLine.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property faultCause = BLine.newProperty((int)3, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLine.class);
    private static final BIcon ICON = BIcon.std((String)"control/util/xy.png");
    private static final Lexicon lex = Lexicon.make(BLine.class);

    @Generated
    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    @Generated
    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public boolean getLimitBelow() {
        return this.getBoolean(limitBelow);
    }

    @Generated
    public void setLimitBelow(boolean v) {
        this.setBoolean(limitBelow, v, null);
    }

    @Generated
    public boolean getLimitAbove() {
        return this.getBoolean(limitAbove);
    }

    @Generated
    public void setLimitAbove(boolean v) {
        this.setBoolean(limitAbove, v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected double calculate(BStatusNumeric in1, BStatusNumeric f1, BStatusNumeric in2, BStatusNumeric f2) {
        double x = this.getIn().getValue();
        double x1 = in1.getValue();
        double x2 = in2.getValue();
        boolean limBelow = this.getLimitBelow();
        boolean limAbove = this.getLimitAbove();
        if ((limBelow || limAbove) && x1 >= x2) {
            return Double.NaN;
        }
        double y1 = f1.getValue();
        double y2 = f2.getValue();
        double m = (y2 - y1) / (x2 - x1);
        double b = y2 - m * x2;
        double xLim = limBelow ? Math.max(x1, x) : x;
        xLim = limAbove ? Math.min(x2, xLim) : xLim;
        return m * xLim + b;
    }

    @Override
    public void onExecute(BStatusValue o, Context cx) {
        super.onExecute(o, cx);
        boolean invalidPoints = (this.getLimitBelow() || this.getLimitAbove()) && this.getInA().getValue() >= this.getInC().getValue();
        this.setFaultCause(invalidPoints ? lex.getText("line.invalidPoints") : "");
        if (invalidPoints) {
            o.setStatus(o.getStatus().getBits() | 2);
        } else {
            o.setStatus(o.getStatus().getBits() & 0xFFFFFFFD);
        }
    }

    @Override
    public int minInputs() {
        return 4;
    }

    public String getDisplayName(Slot slot, Context cx) {
        BNameMap nameMap;
        BFormat format;
        Property p = this.getProperty("displayNames");
        if (p != null && p.getType().is(BNameMap.TYPE) && (format = (nameMap = (BNameMap)this.get(p)).get(slot.getName())) != null) {
            return format.format(null, cx);
        }
        String text = lex.get("line." + slot.getName());
        if (text != null) {
            return text;
        }
        return slot.getDefaultDisplayName(cx);
    }

    public BIcon getIcon() {
        return ICON;
    }
}

