/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.math;

import com.tridium.kitControl.math.BUnaryMath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="inMin", type="BDouble", defaultValue="BDouble.make(0)"), @NiagaraProperty(name="inMax", type="BDouble", defaultValue="BDouble.make(0)"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
public class BLimiter
extends BUnaryMath {
    @Generated
    public static final Property inMin = BLimiter.newProperty((int)0, (double)((BDouble)BDouble.make((double)0.0).as(BDouble.class)).getDouble(), null);
    @Generated
    public static final Property inMax = BLimiter.newProperty((int)0, (double)((BDouble)BDouble.make((double)0.0).as(BDouble.class)).getDouble(), null);
    @Generated
    public static final Property faultCause = BLimiter.newProperty((int)3, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLimiter.class);
    private static final BIcon ICON = BIcon.std((String)"control/logic/limiter.png");
    public static final String INVALID_LIMITS = Lexicon.make(BLimiter.class).getText("limiter.invalidLimits");

    @Generated
    public double getInMin() {
        return this.getDouble(inMin);
    }

    @Generated
    public void setInMin(double v) {
        this.setDouble(inMin, v, null);
    }

    @Generated
    public double getInMax() {
        return this.getDouble(inMax);
    }

    @Generated
    public void setInMax(double v) {
        this.setDouble(inMax, v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric inA = this.getInA();
        BStatus sa = inA.getStatus();
        BStatusNumeric out = (BStatusNumeric)o;
        if (sa.isNull()) {
            out.setValue(Double.NaN);
            out.setStatus(BStatus.nullStatus);
        } else if (this.getInMax() < this.getInMin()) {
            out.setValue(Double.NaN);
            this.setFaultCause(INVALID_LIMITS);
            out.setStatus(BStatus.fault);
        } else {
            out.setValue(this.calculate(inA.getValue()));
            out.setStatus(this.propagate(sa));
            this.setFaultCause("");
        }
    }

    @Override
    protected double calculate(double a) {
        return Math.min(this.getInMax(), Math.max(this.getInMin(), a));
    }

    public BIcon getIcon() {
        return ICON;
    }
}

