/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.math;

import com.tridium.kitControl.math.BUnaryMath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="k", type="double", defaultValue="1.0", flags=8)
public class BDerivative
extends BUnaryMath {
    @Generated
    public static final Property k = BDerivative.newProperty((int)8, (double)1.0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDerivative.class);
    private static final BIcon ICON = BIcon.std((String)"control/math/derivative.png");
    private long initialTime;
    private double initialVal;

    @Generated
    public double getK() {
        return this.getDouble(k);
    }

    @Generated
    public void setK(double v) {
        this.setDouble(k, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected double calculate(double a) {
        if (this.initialTime == 0L) {
            this.initialTime = Clock.nanoTicks();
            this.initialVal = a;
            return 0.0;
        }
        long now = Clock.nanoTicks();
        double deltaT = (double)(now - this.initialTime) / 1.0E9;
        double derivative = this.getK() * (a - this.initialVal) / deltaT;
        this.initialTime = now;
        this.initialVal = a;
        return derivative;
    }

    public BIcon getIcon() {
        return ICON;
    }
}

