/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.logic;

import com.tridium.kitControl.logic.BLogic;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BDouble;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="in", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=10), @NiagaraProperty(name="inLow", type="BDouble", defaultValue="BDouble.make(0)"), @NiagaraProperty(name="inHigh", type="BDouble", defaultValue="BDouble.make(0)"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
public class BHysteresis
extends BLogic {
    @Generated
    public static final Property in = BHysteresis.newProperty((int)10, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    @Generated
    public static final Property inLow = BHysteresis.newProperty((int)0, (double)((BDouble)BDouble.make((double)0.0).as(BDouble.class)).getDouble(), null);
    @Generated
    public static final Property inHigh = BHysteresis.newProperty((int)0, (double)((BDouble)BDouble.make((double)0.0).as(BDouble.class)).getDouble(), null);
    @Generated
    public static final Property faultCause = BHysteresis.newProperty((int)3, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHysteresis.class);
    private static final BIcon ICON = BIcon.std((String)"control/logic/hysteresis.png");
    private boolean previousOutput = false;
    public static final String INVALID_THRESHOLDS = Lexicon.make(BHysteresis.class).getText("hysteresis.invalidThresholds");

    @Generated
    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    @Generated
    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public double getInLow() {
        return this.getDouble(inLow);
    }

    @Generated
    public void setInLow(double v) {
        this.setDouble(inLow, v, null);
    }

    @Generated
    public double getInHigh() {
        return this.getDouble(inHigh);
    }

    @Generated
    public void setInHigh(double v) {
        this.setDouble(inHigh, v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric in = this.getIn();
        BStatus aStatus = in.getStatus();
        BStatusBoolean out = (BStatusBoolean)o;
        if (aStatus.isNull()) {
            out.setValue(false);
            out.setStatus(BStatus.nullStatus);
            this.setFaultCause("");
            return;
        }
        if (this.getInHigh() < this.getInLow()) {
            out.setValue(false);
            out.setStatus(BStatus.fault);
            this.setFaultCause(INVALID_THRESHOLDS);
            return;
        }
        out.setValue(this.calculate(in.getValue()));
        out.setStatus(this.propagate(BStatus.make((int)aStatus.getBits())));
        this.setFaultCause("");
        if (this.getNullOnInactive() && !out.getValue()) {
            out.setStatusNull(true);
        }
    }

    protected boolean calculate(double input) {
        double inHigh = this.getInHigh();
        double inLow = this.getInLow();
        boolean currentOutput = !this.previousOutput && input > inHigh ? true : (this.previousOutput && input < inLow ? false : this.previousOutput);
        this.previousOutput = currentOutput;
        return currentOutput;
    }

    public BIcon getIcon() {
        return ICON;
    }
}

