/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import com.tridium.kitControl.hvac.BSequence;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="action", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(\"rotating\", \"linear\" )")}), @NiagaraProperty(name="rotateTime", type="BRelTime", defaultValue="BRelTime.make(1000)"), @NiagaraProperty(name="rotateTimerActive", type="boolean", defaultValue="false", flags=3)})
@NiagaraAction(name="rotateTimerExpired", flags=4)
public class BSequenceLinear
extends BSequence {
    @Generated
    public static final Property action = BSequenceLinear.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)"rotating", (String)"linear"));
    @Generated
    public static final Property rotateTime = BSequenceLinear.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    @Generated
    public static final Property rotateTimerActive = BSequenceLinear.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Action rotateTimerExpired = BSequenceLinear.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSequenceLinear.class);
    Clock.Ticket rotateTicket;

    @Generated
    public boolean getAction() {
        return this.getBoolean(action);
    }

    @Generated
    public void setAction(boolean v) {
        this.setBoolean(action, v, null);
    }

    @Generated
    public BRelTime getRotateTime() {
        return (BRelTime)this.get(rotateTime);
    }

    @Generated
    public void setRotateTime(BRelTime v) {
        this.set(rotateTime, (BValue)v, null);
    }

    @Generated
    public boolean getRotateTimerActive() {
        return this.getBoolean(rotateTimerActive);
    }

    @Generated
    public void setRotateTimerActive(boolean v) {
        this.setBoolean(rotateTimerActive, v, null);
    }

    @Generated
    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == action) {
            if (!this.isRotating()) {
                this.setFlags((Slot)rotateTime, 4, null);
            } else {
                this.setFlags((Slot)rotateTime, 0, null);
            }
            if (this.rotateTicket != null) {
                this.rotateTicket.cancel();
            }
            this.reinitialize();
        } else if (p == rotateTimerActive) {
            this.calculate();
            this.setOutputs();
        } else {
            super.changed(p, cx);
        }
    }

    public void doRotateTimerExpired() {
        this.setRotateTimerActive(false);
        this.setOutputs();
    }

    @Override
    public void calculate() {
        this.numOutputs = this.getNumberOutputs();
        double maxInValue = this.getInMaximum();
        double minInValue = this.getInMinimum();
        double range = maxInValue - minInValue;
        double spDelta = range / (double)this.numOutputs;
        double cv = this.getIn().getValue();
        if (cv > maxInValue) {
            cv = maxInValue;
        } else if (cv < minInValue) {
            cv = minInValue;
        }
        int currentStagesOn = this.numStagesOn;
        if (this.getIn().getStatus().isValid()) {
            this.numStagesOn = (int)((cv - this.getInMinimum()) / spDelta);
            if (cv > this.getInMinimum() && currentStagesOn > this.numStagesOn) {
                ++this.numStagesOn;
            }
        }
        if (this.numStagesOn < 0) {
            this.numStagesOn = 0;
        }
        this.setDesiredStagesOn(this.numStagesOn);
    }

    boolean isRotating() {
        return this.getAction();
    }

    @Override
    public void setOutputs() {
        if (this.numStagesOn == this.curStagesOn) {
            if (this.isRotating() && this.isRotateTimeProgrammed() && this.numStagesOn > 0 && this.numStagesOn < this.numOutputs && !this.getRotateTimerActive()) {
                if (!this.wasEqual) {
                    this.startRotateTimer();
                    this.wasEqual = true;
                } else {
                    this.rotateNextStageOff();
                    this.rotateNextStageOn();
                    this.startRotateTimer();
                    this.setRotateTimerActive(true);
                }
            }
            return;
        }
        this.wasEqual = false;
        if (this.getRotateTimerActive()) {
            this.rotateTicket.cancel();
            this.rotateTicket = null;
            this.setRotateTimerActive(false);
        }
        if (this.numStagesOn > this.curStagesOn) {
            if (this.getOnDelayActive() || this.getOffDelayActive()) {
                return;
            }
            if (this.isDelayProgrammed()) {
                this.setNextStageOn();
                this.startOnDelayTimer();
            } else {
                while (this.numStagesOn > this.curStagesOn) {
                    this.setNextStageOn();
                }
            }
        } else if (this.numStagesOn < this.curStagesOn) {
            if (this.getOffDelayActive() || this.getOnDelayActive()) {
                return;
            }
            if (this.isDelayProgrammed()) {
                this.setNextStageOff();
                this.startOffDelayTimer();
            } else {
                while (this.numStagesOn < this.curStagesOn) {
                    this.setNextStageOff();
                }
            }
        }
        this.setCurrentStagesOn(this.curStagesOn);
        if (this.numStagesOn == this.curStagesOn && this.isRotating() && this.isRotateTimeProgrammed() && this.numStagesOn > 0 && this.numStagesOn < this.numOutputs) {
            this.startRotateTimer();
            this.wasEqual = true;
        }
    }

    void setNextStageOn() {
        if (this.isRotating()) {
            this.rotateNextStageOn();
        } else {
            this.linearNextStageOn();
        }
    }

    void setNextStageOff() {
        if (this.isRotating()) {
            this.rotateNextStageOff();
        } else {
            this.linearNextStageOff();
        }
    }

    void linearNextStageOn() {
        this.nxtStageOff = this.nxtStageOn;
        this.curStagesOn = this.nxtStageOn;
        this.getStatusOutput(this.nxtStageOff).setValue(true);
        this.nxtStageOn = this.nxtStageOff + 1;
        this.setNextStageOff(this.nxtStageOff);
        this.setNextStageOn(this.nxtStageOn);
    }

    void linearNextStageOff() {
        this.nxtStageOn = this.nxtStageOff;
        this.curStagesOn = this.nxtStageOff - 1;
        this.getStatusOutput(this.nxtStageOff).setValue(false);
        --this.nxtStageOff;
        this.setNextStageOff(this.nxtStageOff);
        this.setNextStageOn(this.nxtStageOn);
    }

    void rotateNextStageOn() {
        if (this.curStagesOn == 0) {
            this.nxtStageOff = this.nxtStageOn;
            this.setNextStageOff(this.nxtStageOff);
            this.startStage = this.nxtStageOn;
        }
        this.getStatusOutput(this.nxtStageOn).setValue(true);
        ++this.curStagesOn;
        this.incNextStageOn();
    }

    void incNextStageOn() {
        this.nxtStageOn = this.nxtStageOn < this.getNumberOutputs() ? ++this.nxtStageOn : (this.curStagesOn == this.numOutputs ? 0 : 1);
        this.setNextStageOn(this.nxtStageOn);
    }

    void rotateNextStageOff() {
        if (this.curStagesOn == this.numOutputs) {
            this.nxtStageOn = this.nxtStageOff;
            this.setNextStageOn(this.nxtStageOn);
        }
        this.getStatusOutput(this.nxtStageOff).setValue(false);
        --this.curStagesOn;
        this.incNextStageOff();
    }

    void incNextStageOff() {
        this.nxtStageOff = this.nxtStageOff < this.getNumberOutputs() ? ++this.nxtStageOff : (this.curStagesOn == 0 ? 0 : 1);
        if (this.curStagesOn == 0) {
            this.startStage = this.startStage < this.numOutputs ? ++this.startStage : 1;
            this.nxtStageOn = this.startStage;
            this.setNextStageOn(this.nxtStageOn);
        }
        this.setNextStageOff(this.nxtStageOff);
    }

    boolean isRotateTimeProgrammed() {
        return this.getRotateTime().getMillis() != 0L;
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.setRotateTimerActive(true);
        this.rotateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getRotateTime(), (Action)rotateTimerExpired, null);
    }
}

