/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import com.tridium.kitControl.enums.BNightPurgeMode;
import com.tridium.kitControl.hvac.Psychrometric;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="temperatureFacets", type="BFacets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"fahrenheit\"), 1)"), @NiagaraProperty(name="humidityFacets", type="BFacets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"percent relative humidity\"), 1)"), @NiagaraProperty(name="purgeEnabled", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=8), @NiagaraProperty(name="outsideTemp", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="outsideHumidity", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="insideTemp", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="insideHumidity", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="lowTemperatureLimit", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="nightSetpoint", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=8), @NiagaraProperty(name="outsideEnthalpy", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=11, facets={@Facet(value="BFacets.makeNumeric(UnitDatabase.getUnit(\"btu per pound\"), 2)")}), @NiagaraProperty(name="insideEnthalpy", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=11, facets={@Facet(value="BFacets.makeNumeric(UnitDatabase.getUnit(\"btu per pound\"), 2)")}), @NiagaraProperty(name="freeCooling", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=11), @NiagaraProperty(name="currentMode", type="BStatusEnum", defaultValue="new BStatusEnum(BNightPurgeMode.disabled)", flags=11), @NiagaraProperty(name="setpointDeadband", type="float", defaultValue="1.0f"), @NiagaraProperty(name="thresholdSpan", type="float", defaultValue="1.0f"), @NiagaraProperty(name="useEnthalpy", type="boolean", defaultValue="true"), @NiagaraProperty(name="freeCoolingCommand", type="boolean", defaultValue="true"), @NiagaraProperty(name="useNullOutput", type="boolean", defaultValue="true")})
@NiagaraAction(name="calculate", flags=4)
public class BNightPurge
extends BComponent {
    @Generated
    public static final Property temperatureFacets = BNightPurge.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1), null);
    @Generated
    public static final Property humidityFacets = BNightPurge.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent relative humidity"), (int)1), null);
    @Generated
    public static final Property purgeEnabled = BNightPurge.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property outsideTemp = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outsideHumidity = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property insideTemp = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property insideHumidity = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property lowTemperatureLimit = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property nightSetpoint = BNightPurge.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property outsideEnthalpy = BNightPurge.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)2));
    @Generated
    public static final Property insideEnthalpy = BNightPurge.newProperty((int)11, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)2));
    @Generated
    public static final Property freeCooling = BNightPurge.newProperty((int)11, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property currentMode = BNightPurge.newProperty((int)11, (BValue)new BStatusEnum((BEnum)BNightPurgeMode.disabled), null);
    @Generated
    public static final Property setpointDeadband = BNightPurge.newProperty((int)0, (float)1.0f, null);
    @Generated
    public static final Property thresholdSpan = BNightPurge.newProperty((int)0, (float)1.0f, null);
    @Generated
    public static final Property useEnthalpy = BNightPurge.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property freeCoolingCommand = BNightPurge.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property useNullOutput = BNightPurge.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action calculate = BNightPurge.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNightPurge.class);
    private static final int DISABLED = 0;
    private static final int INPUT_ERROR = 1;
    private static final int LOW_TEMPERATURE = 2;
    private static final int ENTHALPY_NO_FREE_COOLING = 3;
    private static final int ENTHALPY_FREE_COOLING = 4;
    private static final int TEMP_NO_FREE_COOLING = 5;
    private static final int TEMP_FREE_COOLING = 6;
    private static final int SATISFIED = 7;
    int mode = 0;
    Clock.Ticket ticket = null;

    @Generated
    public BFacets getTemperatureFacets() {
        return (BFacets)this.get(temperatureFacets);
    }

    @Generated
    public void setTemperatureFacets(BFacets v) {
        this.set(temperatureFacets, (BValue)v, null);
    }

    @Generated
    public BFacets getHumidityFacets() {
        return (BFacets)this.get(humidityFacets);
    }

    @Generated
    public void setHumidityFacets(BFacets v) {
        this.set(humidityFacets, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getPurgeEnabled() {
        return (BStatusBoolean)this.get(purgeEnabled);
    }

    @Generated
    public void setPurgeEnabled(BStatusBoolean v) {
        this.set(purgeEnabled, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideTemp() {
        return (BStatusNumeric)this.get(outsideTemp);
    }

    @Generated
    public void setOutsideTemp(BStatusNumeric v) {
        this.set(outsideTemp, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideHumidity() {
        return (BStatusNumeric)this.get(outsideHumidity);
    }

    @Generated
    public void setOutsideHumidity(BStatusNumeric v) {
        this.set(outsideHumidity, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInsideTemp() {
        return (BStatusNumeric)this.get(insideTemp);
    }

    @Generated
    public void setInsideTemp(BStatusNumeric v) {
        this.set(insideTemp, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInsideHumidity() {
        return (BStatusNumeric)this.get(insideHumidity);
    }

    @Generated
    public void setInsideHumidity(BStatusNumeric v) {
        this.set(insideHumidity, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getLowTemperatureLimit() {
        return (BStatusNumeric)this.get(lowTemperatureLimit);
    }

    @Generated
    public void setLowTemperatureLimit(BStatusNumeric v) {
        this.set(lowTemperatureLimit, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getNightSetpoint() {
        return (BStatusNumeric)this.get(nightSetpoint);
    }

    @Generated
    public void setNightSetpoint(BStatusNumeric v) {
        this.set(nightSetpoint, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOutsideEnthalpy() {
        return (BStatusNumeric)this.get(outsideEnthalpy);
    }

    @Generated
    public void setOutsideEnthalpy(BStatusNumeric v) {
        this.set(outsideEnthalpy, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getInsideEnthalpy() {
        return (BStatusNumeric)this.get(insideEnthalpy);
    }

    @Generated
    public void setInsideEnthalpy(BStatusNumeric v) {
        this.set(insideEnthalpy, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getFreeCooling() {
        return (BStatusBoolean)this.get(freeCooling);
    }

    @Generated
    public void setFreeCooling(BStatusBoolean v) {
        this.set(freeCooling, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getCurrentMode() {
        return (BStatusEnum)this.get(currentMode);
    }

    @Generated
    public void setCurrentMode(BStatusEnum v) {
        this.set(currentMode, (BValue)v, null);
    }

    @Generated
    public float getSetpointDeadband() {
        return this.getFloat(setpointDeadband);
    }

    @Generated
    public void setSetpointDeadband(float v) {
        this.setFloat(setpointDeadband, v, null);
    }

    @Generated
    public float getThresholdSpan() {
        return this.getFloat(thresholdSpan);
    }

    @Generated
    public void setThresholdSpan(float v) {
        this.setFloat(thresholdSpan, v, null);
    }

    @Generated
    public boolean getUseEnthalpy() {
        return this.getBoolean(useEnthalpy);
    }

    @Generated
    public void setUseEnthalpy(boolean v) {
        this.setBoolean(useEnthalpy, v, null);
    }

    @Generated
    public boolean getFreeCoolingCommand() {
        return this.getBoolean(freeCoolingCommand);
    }

    @Generated
    public void setFreeCoolingCommand(boolean v) {
        this.setBoolean(freeCoolingCommand, v, null);
    }

    @Generated
    public boolean getUseNullOutput() {
        return this.getBoolean(useNullOutput);
    }

    @Generated
    public void setUseNullOutput(boolean v) {
        this.setBoolean(useNullOutput, v, null);
    }

    @Generated
    public void calculate() {
        this.invoke(calculate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(purgeEnabled) || property.equals(nightSetpoint) || property.equals(lowTemperatureLimit) || property.equals(outsideTemp) || property.equals(outsideHumidity) || property.equals(insideTemp) || property.equals(insideHumidity) || property.equals(thresholdSpan) || property.equals(freeCoolingCommand) || property.equals(useEnthalpy)) {
            this.doCalculate();
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)insideTemp) || slot.equals((Object)outsideTemp) || slot.equals((Object)nightSetpoint) || slot.equals((Object)setpointDeadband) || slot.equals((Object)lowTemperatureLimit)) {
            return this.getTemperatureFacets();
        }
        if (slot.equals((Object)insideHumidity) || slot.equals((Object)outsideHumidity)) {
            return this.getHumidityFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void atSteadyState() {
        this.doCalculate();
    }

    public void doCalculate() {
        double purgeTempLimit = this.getNightSetpoint().getValue();
        if (!this.getPurgeEnabled().getValue()) {
            this.setOutput(false);
            this.mode = 0;
        } else if (!(this.getOutsideTemp().getStatus().isValid() && this.getOutsideHumidity().getStatus().isValid() && this.getInsideTemp().getStatus().isValid() && this.getInsideHumidity().getStatus().isValid())) {
            this.mode = 1;
        } else if (this.getOutsideTemp().getValue() < this.getLowTemperatureLimit().getValue()) {
            this.mode = 2;
        } else {
            if (this.mode == 7) {
                purgeTempLimit = this.getNightSetpoint().getValue() + (double)this.getSetpointDeadband();
            }
            if (this.getInsideTemp().getValue() < purgeTempLimit) {
                this.mode = 7;
            } else if (this.getUseEnthalpy()) {
                this.getOutsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getOutsideTemp().getValue(), (float)this.getOutsideHumidity().getValue()));
                this.getInsideEnthalpy().setValue((double)Psychrometric.enthalpy((float)this.getInsideTemp().getValue(), (float)this.getInsideHumidity().getValue()));
                boolean outEntError = this.getOutsideEnthalpy().getValue() <= 0.0;
                this.getOutsideEnthalpy().setStatus(BStatus.makeFault((BStatus)BStatus.make((int)0), (boolean)outEntError));
                boolean inEntError = this.getInsideEnthalpy().getValue() <= 0.0;
                this.getInsideEnthalpy().setStatus(BStatus.makeFault((BStatus)BStatus.make((int)0), (boolean)inEntError));
                if (outEntError || inEntError) {
                    this.mode = 1;
                } else if (this.getOutsideEnthalpy().getValue() >= this.getInsideEnthalpy().getValue()) {
                    this.mode = 3;
                } else if (this.getOutsideEnthalpy().getValue() <= this.getInsideEnthalpy().getValue() - Math.abs((double)this.getThresholdSpan())) {
                    this.mode = 4;
                }
            } else {
                this.getOutsideEnthalpy().setValue(0.0);
                this.getInsideEnthalpy().setValue(0.0);
                this.getOutsideEnthalpy().setStatus(BStatus.make((int)0, (BFacets)BFacets.make((String)"unused", (boolean)true)));
                this.getInsideEnthalpy().setStatus(BStatus.make((int)0, (BFacets)BFacets.make((String)"unused", (boolean)true)));
                if (this.getOutsideTemp().getValue() >= this.getInsideTemp().getValue()) {
                    this.mode = 5;
                } else if (this.getOutsideTemp().getValue() <= this.getInsideTemp().getValue() - Math.abs((double)this.getThresholdSpan())) {
                    this.mode = 6;
                }
            }
        }
        switch (this.mode) {
            case 0: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.disabled);
                break;
            }
            case 1: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.inputError);
                break;
            }
            case 2: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.lowTemperature);
                break;
            }
            case 3: 
            case 5: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.noFreeCooling);
                break;
            }
            case 4: 
            case 6: {
                this.setOutput(true);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.freeCooling);
                break;
            }
            case 7: {
                this.setOutput(false);
                this.getCurrentMode().setValue((BEnum)BNightPurgeMode.satisfied);
                break;
            }
        }
    }

    private void setOutput(boolean value) {
        if (value) {
            this.setFreeCooling(new BStatusBoolean(this.getFreeCoolingCommand(), BStatus.ok));
        } else if (this.getUseNullOutput()) {
            this.setFreeCooling(new BStatusBoolean(!this.getFreeCoolingCommand(), BStatus.nullStatus));
        } else {
            this.setFreeCooling(new BStatusBoolean(!this.getFreeCoolingCommand(), BStatus.ok));
        }
    }
}

