/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.conversion;

import java.text.NumberFormat;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="out", type="BStatusString", defaultValue="new BStatusString()", flags=11), @NiagaraProperty(name="in", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10), @NiagaraProperty(name="integerDigits", type="int", defaultValue="6"), @NiagaraProperty(name="decimalDigits", type="int", defaultValue="6")})
public class BStatusNumericToStatusString
extends BComponent
implements BIStatus {
    @Generated
    public static final Property out = BStatusNumericToStatusString.newProperty((int)11, (BValue)new BStatusString(), null);
    @Generated
    public static final Property in = BStatusNumericToStatusString.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property integerDigits = BStatusNumericToStatusString.newProperty((int)0, (int)6, null);
    @Generated
    public static final Property decimalDigits = BStatusNumericToStatusString.newProperty((int)0, (int)6, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStatusNumericToStatusString.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    BStatusString workingValue = new BStatusString();

    @Generated
    public BStatusString getOut() {
        return (BStatusString)this.get(out);
    }

    @Generated
    public void setOut(BStatusString v) {
        this.set(out, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    @Generated
    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public int getIntegerDigits() {
        return this.getInt(integerDigits);
    }

    @Generated
    public void setIntegerDigits(int v) {
        this.setInt(integerDigits, v, null);
    }

    @Generated
    public int getDecimalDigits() {
        return this.getInt(decimalDigits);
    }

    @Generated
    public void setDecimalDigits(int v) {
        this.setInt(decimalDigits, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.calculate();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == in || p == decimalDigits || p == integerDigits) {
            this.calculate();
        }
    }

    void calculate() {
        double inValue = this.getIn().getValue();
        this.workingValue.setStatus(this.getIn().getStatus());
        int precision = this.getDecimalDigits();
        int integer = this.getIntegerDigits();
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(precision);
        format.setMinimumFractionDigits(precision);
        format.setMaximumIntegerDigits(integer);
        format.setMinimumIntegerDigits(integer);
        format.setGroupingUsed(false);
        String value = format.format(inValue);
        try {
            this.workingValue.setValue(value);
        }
        catch (Exception e) {
            this.workingValue.setStatusNull(true);
            this.workingValue.setStatusFault(true);
        }
        this.setOut(this.workingValue);
    }

    public String toString(Context cx) {
        return this.getOut().toString(cx);
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public BIcon getIcon() {
        return icon;
    }
}

