/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo.nd;

import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.remoteVideo.BRemoteVideoSource;
import com.tridium.util.PxUtil;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.gx.BColor;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="proxyExt", type="BAbstractProxyExt", defaultValue="new BNullProxyExt()", flags=4, override=true)
@NiagaraAction(name="printRemoteOrd")
public class BNiagaraCameraPoint
extends BStringPoint
implements BIRemoteVideoCamera {
    @Generated
    public static final Property proxyExt = BNiagaraCameraPoint.newProperty((int)4, (BValue)new BNullProxyExt(), null);
    @Generated
    public static final Action printRemoteOrd = BNiagaraCameraPoint.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraCameraPoint.class);
    protected Object cachingRemoteVideoSource = new Object();
    protected BRemoteVideoSource cachedRemoteVideoSource;
    protected long cacheTime = 0L;
    protected static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/camera.png");
    protected BNiagaraStation niagaraStation;

    @Generated
    public void printRemoteOrd() {
        this.invoke(printRemoteOrd, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isCameraFault() {
        return this.getRemoteVideoSource().isCameraFault();
    }

    public String getCameraFaultCause() {
        return this.getRemoteVideoSource().getCameraFaultCause();
    }

    public void doPrintRemoteOrd() {
        System.out.println(this.getRemoteVideoOrd());
        this.getRemoteVideoSource();
    }

    public BOrd getRemoteVideoHandleOrd() {
        BNiagaraStation remoteStation = this.getNiagaraStation();
        return BOrd.make((String)("remoteVideo:" + remoteStation.getStationName() + "//" + this.getRemoteVideoSource().getCameraHandleOrd()));
    }

    public BOrd getRemoteVideoOrd() {
        BNiagaraStation remoteStation = this.getNiagaraStation();
        BNiagaraProxyExt niagaraProxy = (BNiagaraProxyExt)this.getProxyExt();
        niagaraProxy.lease();
        try {
            niagaraProxy.getComponentSpace().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String remotePath = niagaraProxy.getPointId();
        if (remotePath.startsWith("slot:/")) {
            remotePath = remotePath.substring(6);
        }
        return BOrd.make((String)("remoteVideo:" + remoteStation.getStationName() + "//" + remotePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BRemoteVideoSource getRemoteVideoSource() {
        Object object = this.cachingRemoteVideoSource;
        synchronized (object) {
            long ticks = Clock.ticks();
            if (ticks - this.cacheTime > 15000L) {
                this.cachedRemoteVideoSource = (BRemoteVideoSource)this.getRemoteVideoOrd().get((BObject)this);
                this.cacheTime = ticks;
            }
            return this.cachedRemoteVideoSource;
        }
    }

    public BNiagaraStation getNiagaraStation() {
        if (this.niagaraStation == null) {
            BComplex ancestor;
            for (ancestor = this.getParent(); ancestor != null && !(ancestor instanceof BNiagaraStation); ancestor = ancestor.getParent()) {
            }
            this.niagaraStation = (BNiagaraStation)ancestor;
        }
        return this.niagaraStation;
    }

    public BFoxVideoStreamEnum getFoxVideoStreamSetting() {
        return this.getRemoteVideoSource().getFoxVideoStreamSetting();
    }

    public BRelTime getInterframeTimeout() {
        return this.getRemoteVideoSource().getInterframeTimeout();
    }

    public BColor getPreferredBackgroundColor() {
        return this.getRemoteVideoSource().getPreferredBackgroundColor();
    }

    public BVideoAspectRatioEnum getPreferredAspectRatio() {
        return this.getRemoteVideoSource().getPreferredAspectRatio();
    }

    public BVideoCompressionEnum getPreferredCompression() {
        return this.getRemoteVideoSource().getPreferredCompression();
    }

    public BVideoFrameRateEnum getPreferredFrameRate() {
        return this.getRemoteVideoSource().getPreferredFrameRate();
    }

    public BVideoResolutionEnum getPreferredResolution() {
        return this.getRemoteVideoSource().getPreferredResolution();
    }

    public void initPlaybackParams(BPlaybackParams arg0, IVideoSession arg1) {
        this.getRemoteVideoSource().initPlaybackParams(arg0, arg1);
    }

    public boolean isFoxVideoStreamPreferred() {
        return this.getRemoteVideoSource().isFoxVideoStreamPreferred();
    }

    public boolean isTimestampPreferred() {
        return this.getRemoteVideoSource().isTimestampPreferred();
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams arg0) {
        return this.getRemoteVideoSource().makeVideoDecoder(arg0);
    }

    public void streamToDestination(BPlaybackParams arg0, IVideoDestination arg1) {
        if (this.getComponentSpace().isProxyComponentSpace()) {
            this.getRemoteVideoSource().streamToDestination(arg0, arg1);
        } else {
            this.getRemoteVideoSource().getFoxVideoSourceMasterStation().streamToDestination(arg0, arg1);
        }
    }

    public boolean supportsPlaybackControl() {
        return this.getRemoteVideoSource().supportsPlaybackControl();
    }

    public boolean isPanTiltEnabled() {
        return this.getRemoteVideoSource().isPanTiltEnabled();
    }

    public void move(BVideoPanTiltEnum arg0) {
        this.getRemoteVideoSource().move(arg0);
    }

    public boolean isZoomEnabled() {
        return this.getRemoteVideoSource().isZoomEnabled();
    }

    public void zoom(BVideoZoomEnum arg0) {
        this.getRemoteVideoSource().zoom(arg0);
    }

    public void focusControl(BVideoFocusEnum arg0) {
        this.getRemoteVideoSource().focusControl(arg0);
    }

    public boolean isFocusEnabled() {
        return this.getRemoteVideoSource().isFocusEnabled();
    }

    public void irisControl(BVideoIrisEnum arg0) {
        this.getRemoteVideoSource().irisControl(arg0);
    }

    public boolean isIrisEnabled() {
        return this.getRemoteVideoSource().isIrisEnabled();
    }

    public Action getMoveToPresetAction() {
        return this.getRemoteVideoSource().getMoveToPresetAction();
    }

    public boolean isMoveToPresetEnabled() {
        return this.getRemoteVideoSource().isMoveToPresetEnabled();
    }

    public void moveToPreset(BDynamicEnum arg0) {
        this.getRemoteVideoSource().moveToPreset(arg0);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.getDeclaringType().equals(this.getType())) {
            return super.getActionParameterDefault(action);
        }
        return this.getRemoteVideoSource().getActionParameterDefault(action);
    }

    public Action getStorePresetAction() {
        return this.getRemoteVideoSource().getStorePresetAction();
    }

    public boolean isStorePresetEnabled() {
        return this.getRemoteVideoSource().isStorePresetEnabled();
    }

    public void storePreset(BDynamicEnum arg0) {
        this.getRemoteVideoSource().storePreset(arg0);
    }

    public String getCameraDescription() {
        BRemoteVideoSource remoteVideoSource = this.getRemoteVideoSource();
        return remoteVideoSource.getCameraDescription();
    }

    public BAbsTime getCameraTime() {
        return this.getRemoteVideoSource().getCameraTime();
    }

    public BIVideoDvr getDvr() {
        return this.getRemoteVideoSource().getDvr();
    }

    public BVideoEventRecall getEventRecaller() {
        return this.getRemoteVideoSource().getEventRecaller();
    }

    public BPointDeviceExt getEvents() {
        return this.getRemoteVideoSource().getEvents();
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        if (this.addLiveVideoView()) {
            String cameraViewTypeSpec = this.getCameraViewTypeSpec();
            AgentInfo cameraView = Sys.getRegistry().getType(cameraViewTypeSpec).getAgentInfo();
            agents.add(cameraView);
            if (this.areCameraViewsTopMost()) {
                agents.toTop(cameraView);
            }
        }
        if (this.addPlaybackView()) {
            String playbackViewTypeSpec = this.getPlaybackViewTypeSpec();
            AgentInfo playbackView = Sys.getRegistry().getType(playbackViewTypeSpec).getAgentInfo();
            agents.add(playbackView);
            if (this.areCameraViewsTopMost()) {
                agents.toTop(playbackView);
            }
        }
        try {
            AgentInfo accessControlView = Sys.getRegistry().getType("accessControl:HxWbAccessView").getAgentInfo();
            agents.add(accessControlView);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PxUtil.movePxViewsToTop((AgentList)agents);
    }

    public void startRecordingAlarm(BAlarmRecord alarmRecord) {
        this.getRemoteVideoSource().startRecordingAlarm(alarmRecord);
    }

    protected boolean addLiveVideoView() {
        return true;
    }

    protected boolean addPlaybackView() {
        return true;
    }

    protected String getCameraViewTypeSpec() {
        return "videoDriver:LiveVideo";
    }

    protected String getPlaybackViewTypeSpec() {
        return "videoDriver:VideoPlayback";
    }

    protected boolean areCameraViewsTopMost() {
        return true;
    }

    public BIcon getIcon() {
        return icon;
    }
}

