/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.remoteVideo;

import com.tridium.remoteVideo.BogEncoderCopy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Stack;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class RemoteVideoSourceBogEncoder
extends BogEncoderCopy {
    protected BComponent mostRecentVideoSrcNavAncestor;
    protected Stack<BComponent> ancestryStack;
    protected BComponent videoSrcComponent;
    protected boolean encodedVideoSrcComponent;

    public RemoteVideoSourceBogEncoder(File file, Context context) throws IOException {
        super(file, context);
    }

    public RemoteVideoSourceBogEncoder(File file) throws IOException {
        super(file);
    }

    public RemoteVideoSourceBogEncoder(OutputStream out, Context context) throws IOException {
        super(out, context);
    }

    public RemoteVideoSourceBogEncoder(OutputStream out) throws IOException {
        super(out);
    }

    protected void encodeVideoSrcNavAncestor(String name, BComponent v) throws IOException {
        this.w("<!-- foo -->\n");
        this.mostRecentVideoSrcNavAncestor = v;
        this.indent(this.indent);
        this.encode(name, (BValue)v, Integer.MAX_VALUE);
    }

    @Override
    protected void encodingComponent(BComponent c) throws IOException {
        if (this.ancestryStack != null && this.mostRecentVideoSrcNavAncestor == c) {
            if (this.ancestryStack.size() > 0) {
                BComponent ancestor = this.ancestryStack.pop();
                this.encodeVideoSrcNavAncestor(ancestor.getName(), ancestor);
            } else if (!this.encodedVideoSrcComponent) {
                this.encodedVideoSrcComponent = true;
                this.encodeVideoSrcNavAncestor(this.videoSrcComponent.getName(), this.videoSrcComponent);
            } else if (this.mostRecentVideoSrcNavAncestor == this.videoSrcComponent) {
                String nameThatIsHighlyLikelyToBeUnique = "videoSourceToken" + (int)(Math.random() * 1000.0);
                this.indent(this.indent).w((Object)("<p n=\"" + nameThatIsHighlyLikelyToBeUnique + "\" t=\"rv:RemoteVideoSourceToken\" />\n"));
            }
        }
    }

    @Override
    protected boolean shouldSkip(BComplex parent, Property prop, int flags) throws IOException {
        if (prop.isDynamic()) {
            return true;
        }
        BValue v = parent.get(prop);
        Enumeration e = this.ancestryStack.elements();
        while (e.hasMoreElements()) {
            if (e.nextElement() != v) continue;
            return true;
        }
        return false;
    }

    public void encodeVideoSource(Stack<BComponent> ancestryStack, BComponent videoSrcComponent) throws IOException {
        this.ancestryStack = ancestryStack;
        this.videoSrcComponent = videoSrcComponent;
        this.encodedVideoSrcComponent = false;
        BDeviceNetwork videoSrcNet = (BDeviceNetwork)ancestryStack.pop();
        this.mostRecentVideoSrcNavAncestor = videoSrcNet;
        this.setEncodeTransients(true);
        this.w("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.w("<bajaObjectGraph version=\"1.0\">\n");
        ++this.indent;
        this.indent(this.indent).w((Object)"<p n=\"Container\" m=\"rv=remoteVideo\" t=\"rv:RemoteVideoSource\">\n");
        ++this.indent;
        this.indent(this.indent);
        this.encode(videoSrcNet.getName(), (BValue)videoSrcNet, Integer.MAX_VALUE);
        --this.indent;
        this.indent(this.indent).w((Object)"</p>\n");
        this.w("</bajaObjectGraph>\n");
        this.flush();
    }
}

