/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui.file;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BNiagaraFileDescriptor;
import com.tridium.nd.file.BNiagaraFileDeviceExt;
import com.tridium.nd.file.BNiagaraFileImport;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.util.BSimpleMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.driver.util.BDescriptor;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraFileDeviceExt"})})
public final class BNiagaraFileManager
extends BAbstractManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraFileManager.class);
    static final Logger LOG = Logger.getLogger("niagaraDriver");
    private static Property[] timePath = new Property[]{BDescriptor.executionTime, BTimeTrigger.triggerMode};
    private MgrColumn timeCol = new MgrColumn.PropPath(BDescriptor.executionTime.getDefaultDisplayName(null), timePath, 3);
    private MgrColumn colFiles = new FileCol();
    private MgrColumn[] cols = new MgrColumn[]{new MgrColumn.Name(1), new MgrColumn.Type(4), this.timeCol, new MgrColumn.Prop(BDescriptor.enabled, 3), new MgrColumn.Prop(BNiagaraFileDescriptor.fileOverwritePolicy, 1), new MgrColumn.Prop(BDescriptor.status, 0), new MgrColumn.Prop(BDescriptor.state), new MgrColumn.Prop(BDescriptor.lastAttempt, 2), new MgrColumn.Prop(BDescriptor.lastSuccess), new MgrColumn.Prop(BNiagaraFileDescriptor.routeToStation, 3), this.colFiles, new MgrColumn.Prop(BDescriptor.lastFailure, 2), new MgrColumn.Prop(BDescriptor.faultCause, 2)};
    private static final Lexicon lex = Lexicon.make(BNiagaraFileManager.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    private BNiagaraFileDeviceExt getDeviceExt() {
        return (BNiagaraFileDeviceExt)this.getCurrentValue();
    }

    private static class FileCol
    extends MgrColumn.Prop {
        private FileCol() {
            super(BNiagaraFileDescriptor.files, 1);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            String s = super.toDisplayString(row, value, cx);
            if (s.length() > 50) {
                return s.substring(0, 49) + "...";
            }
            return s;
        }
    }

    private class State
    extends MgrState {
        Object[] roots;
        String lastSessionId = "";

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            Learn learn = (Learn)m.getLearn();
            this.roots = learn.getRoots();
            BFoxSession session = (BFoxSession)m.getCurrentValue().asComponent().getSession();
            this.lastSessionId = session.getConnection().session().getId();
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BFoxSession session = (BFoxSession)m.getCurrentValue().asComponent().getSession();
            String sessionId = session.getConnection().session().getId();
            if (!this.lastSessionId.isEmpty() && !this.lastSessionId.equals(sessionId)) {
                this.roots = null;
            }
            this.lastSessionId = sessionId;
            if (this.roots != null) {
                Learn learn = (Learn)m.getLearn();
                learn.updateRoots(this.roots);
            }
        }
    }

    private class ExecuteCmd
    extends MgrController.MgrCommand {
        public ExecuteCmd(BWidget owner) {
            super(owner, lex, "commands.execute");
        }

        public CommandArtifact doInvoke() throws Exception {
            BComponent[] comps = BNiagaraFileManager.this.getController().getSelectedComponents();
            for (int i = 0; i < comps.length; ++i) {
                BNiagaraFileDescriptor des = (BNiagaraFileDescriptor)comps[i];
                des.execute();
            }
            return null;
        }
    }

    private class Controller
    extends MgrController {
        private ExecuteCmd executeCmd;

        public Controller(BNiagaraFileManager mgr) {
            super((BAbstractManager)mgr);
            this.executeCmd = new ExecuteCmd((BWidget)mgr);
            this.executeCmd.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.executeCmd});
        }

        public void updateCommands() {
            super.updateCommands();
            this.executeCmd.setEnabled(this.getSelectedComponents().length > 0);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            Learn learn = (Learn)BNiagaraFileManager.this.getLearn();
            learn.updateRoots(learn.getFileKids(new FilePath("^")));
            return super.doDiscover(cx);
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            MgrTypeInfo[] infos = BNiagaraFileManager.this.getModel().getNewTypes();
            MgrEdit edit = this.makeEdit(this.add.getLabel());
            MgrEditRow row = edit.addRow((Object)discovery, infos);
            LinkedHashMap<BOrd, BOrd> fileMap = new LinkedHashMap<BOrd, BOrd>();
            for (int i = 0; i < discovery.length; ++i) {
                BIFileStore file = (BIFileStore)discovery[i];
                BOrd fileOrd = BOrd.make((OrdQuery)file.getFilePath());
                fileMap.put(fileOrd, fileOrd);
            }
            row.setCell(BNiagaraFileManager.this.colFiles, (BValue)BSimpleMap.make(fileMap));
            return edit.invoke(cx);
        }
    }

    private class Learn
    extends MgrLearn {
        public Learn(BNiagaraFileManager mgr) {
            super((BAbstractManager)mgr);
        }

        public String makeTableTitle() {
            return lex.getText("fileDiscover.remoteDiscovered");
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(){

                public Object get(Object row) {
                    return ((BIFileStore)row).getFileName();
                }
            }};
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
        }

        public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
            return new MgrTypeInfo[0];
        }

        public boolean isDepthExpandable(int depth) {
            return true;
        }

        public boolean hasChildren(Object discovery) {
            return ((BIFileStore)discovery).isDirectory();
        }

        public Object[] getChildren(Object discovery) {
            BIFileStore file = (BIFileStore)discovery;
            return this.getFileKids(file.getFilePath());
        }

        public BImage getIcon(Object discovery) {
            return BImage.make((BIcon)((BObject)discovery).getIcon());
        }

        private Object[] getFileKids(FilePath path) {
            BNiagaraStation station = BNiagaraFileManager.this.getDeviceExt().getNiagaraStation();
            BFoxSession session = (BFoxSession)station.getSession();
            BPointChannel channel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
            try {
                return channel.discoverFiles(station.getStationName(), path);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not discover files for " + path, e);
                return new Object[0];
            }
        }
    }

    private class Model
    extends MgrModel {
        public Model(BNiagaraFileManager mgr) {
            super((BAbstractManager)mgr);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BNiagaraFileDescriptor.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BNiagaraFileImport.TYPE)};
        }

        protected MgrColumn[] makeColumns() {
            return BNiagaraFileManager.this.cols;
        }
    }
}

