/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.nd.ui.BStationMgrTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BMixinMgrAgent;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class StationModel
extends DeviceModel {
    public StationModel(BDeviceManager manager) {
        super(manager);
    }

    protected boolean hasChildNeedingSubscribe(BComponent parent) {
        return parent instanceof BNiagaraStation || parent instanceof BNiagaraSysDefDeviceExt || parent instanceof BReachableStations;
    }

    protected boolean subscribeToChild(BComponent parent, BComponent child) {
        if (child instanceof BFoxConnection) {
            return true;
        }
        if (child instanceof BIMixIn && Sys.getRegistry().isAgent(child.getType().getTypeInfo(), parent.getType().getTypeInfo())) {
            AgentList mixinAgents = child.getAgents();
            mixinAgents = mixinAgents.filter(AgentFilter.is((Type)BMixinMgrAgent.TYPE));
            return (mixinAgents = mixinAgents.filter(new AgentFilter(){

                public boolean include(AgentInfo agent) {
                    return !agent.getAgentType().isInterface() && !agent.getAgentType().isAbstract();
                }
            })).size() > 0;
        }
        return false;
    }

    protected List<BComponent> getDescendantsToSubscribe(BComponent parent, BComponent child) {
        if (child instanceof BIMixIn && Sys.getRegistry().isAgent(child.getType().getTypeInfo(), parent.getType().getTypeInfo())) {
            AgentList mixinAgents = child.getAgents();
            mixinAgents = mixinAgents.filter(AgentFilter.is((Type)BMixinMgrAgent.TYPE));
            if ((mixinAgents = mixinAgents.filter(new AgentFilter(){

                public boolean include(AgentInfo agent) {
                    return !agent.getAgentType().isInterface() && !agent.getAgentType().isAbstract();
                }
            })).size() > 0) {
                ArrayList<BComponent> list = new ArrayList<BComponent>();
                mixinAgents.forEach(mixinAgent -> ((BMixinMgrAgent)mixinAgent.getInstance()).addDescendentsToManagerSubscription((BIMixIn)child, list));
                return list;
            }
        }
        return Collections.emptyList();
    }

    public BComponent newInstance(MgrTypeInfo type) throws Exception {
        BNiagaraStation station = (BNiagaraStation)type.newInstance();
        station.getClientConnection().setPort(4911);
        station.getClientConnection().setUseFoxs(true);
        return station;
    }

    protected BMgrTable makeTable() {
        return new BStationMgrTable(this);
    }
}

