/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BFoxwssScheme;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.BICredentials;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;

public class FoxSessionSupport {
    static Lexicon lex = Lexicon.make(FoxSessionSupport.class);
    BAbstractManager manager;
    BFoxSession targetSession;

    public FoxSessionSupport(BAbstractManager manager, BFoxSession targetSession) {
        this.manager = manager;
        this.targetSession = targetSession;
    }

    public BFoxSession getTargetSession() {
        return this.targetSession;
    }

    public BFoxSession connect(BNiagaraStation s) {
        s.lease(1);
        return this.connect(s.getName(), s.getAddress(), s.getClientConnection().getPort(), s.getClientConnection().getUseFoxs(), s.getClientConnection().getFoxOverWebsocket(), s.getClientConnection().getFoxOverWebsocketPort());
    }

    public BFoxSession connect(BLearnStation s) {
        BFoxClientWebsocketBehavior foxwssBehavior = BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails;
        boolean useFoxs = false;
        int websocketPort = s.getFoxwssPort();
        if (s.getScheme().equalsIgnoreCase("foxs")) {
            useFoxs = true;
        }
        if ("foxwss".equalsIgnoreCase(s.getScheme())) {
            useFoxs = true;
            foxwssBehavior = BFoxClientWebsocketBehavior.useWebsocketOnly;
            if (websocketPort == 0) {
                websocketPort = s.getFoxPort();
            }
        } else if (websocketPort == 0) {
            foxwssBehavior = BFoxClientWebsocketBehavior.websocketDisabled;
        }
        return this.connect(s.getStationName(), BOrd.make((String)("ip:" + s.getHostAddress())), s.getFoxPort(), useFoxs, foxwssBehavior, websocketPort);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs) {
        return this.connect(stationName, host, foxPort, useFoxs, BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails, -1);
    }

    public BFoxSession connect(String stationName, BOrd host, int foxPort, boolean useFoxs, BFoxClientWebsocketBehavior foxwssBehavior, int websocketPort) {
        if (this.targetSession == null) {
            BDialog.error((BWidget)this.manager, (Object)lex.getText("mgr.connect.noTargetSession"));
            return null;
        }
        BFoxSession sourceSession = null;
        BFoxSession[] sessions = BFoxSession.list();
        for (int i = 0; i < sessions.length; ++i) {
            if (!stationName.equals(sessions[i].getStationName())) continue;
            sourceSession = sessions[i];
            break;
        }
        if (sourceSession == null) {
            BHost hostInstance = (BHost)host.get();
            sourceSession = BFoxSession.make((String)stationName, (BHost)hostInstance, (int)foxPort, (FoxConnectionTypeEnum)BFoxClientWebsocketBehavior.getFoxConnectionType((BFoxClientWebsocketBehavior)foxwssBehavior, (boolean)useFoxs), (int)websocketPort);
        }
        if (!sourceSession.isConnected()) {
            BOrd ord = sourceSession.getNavOrd();
            BNiagaraWbShell shell = (BNiagaraWbShell)this.manager.getWbShell();
            try {
                BICredentials credentials = this.targetSession.getCredentials();
                if (credentials != null && credentials instanceof BValue) {
                    credentials = (BICredentials)((BValue)credentials).newCopy(true);
                }
                sourceSession = (BFoxSession)BOrd.toSession((BObject)shell.resolve(ord, credentials, BFoxwssScheme.addFoxwssPortToContext(null, (int)websocketPort)).get());
            }
            catch (Throwable e) {
                if (e instanceof UnresolvedException) {
                    e = e.getCause();
                }
                String msg = shell.isAppletOrWebStart() ? lex.getText("mgr.connect.cannotConnect.applet") : lex.getText("mgr.connect.cannotConnect", new Object[]{stationName, ord});
                BDialog.error((BWidget)this.manager, (String)BDialog.TITLE_ERROR, (Object)msg, (Throwable)e);
                return null;
            }
        }
        if (!sourceSession.isConnected()) {
            throw new IllegalStateException();
        }
        if (!stationName.equals(sourceSession.getStationName())) {
            BDialog.error((BWidget)this.manager, (Object)lex.getText("mgr.connect.mismatchStationName", new Object[]{host, sourceSession.getStationName(), stationName}));
            return null;
        }
        return sourceSession;
    }
}

