/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraNetwork", "niagaraDriver:NiagaraStationFolder"})})
public class BUserSyncManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BUserSyncManager.class);
    protected final Lexicon lex = Lexicon.make(BUserSyncManager.class);
    protected BIDeviceFolder folder;
    protected BNiagaraNetwork network;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        this.folder = (BIDeviceFolder)value;
        try {
            this.network = (BNiagaraNetwork)this.folder.getNetwork();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Model
    extends DeviceModel {
        private MgrColumn colPath;
        private MgrColumn colParent;
        private MgrColumn colType;
        private MgrColumn colSyncIn;
        private MgrColumn colSyncOut;
        private MgrColumn colStatus;
        private MgrColumn colFaultCause;
        private MgrColumn colSyncStrategy;
        private MgrColumn colSyncRequired;
        private MgrColumn colSyncDelay;
        private MgrColumn colSyncRetry;
        private MgrColumn colLastSyncAttempt;
        private MgrColumn colLastSyncSuccess;
        private MgrColumn[] cols;

        Model(BUserSyncManager manager) {
            super((BDeviceManager)manager);
            this.colPath = new MgrColumn.Path(2);
            this.colParent = new ParentStation(4);
            this.colType = new MgrColumn.Type(2);
            this.colSyncIn = new MgrColumn.Prop(BNiagaraUserDeviceExt.syncInEnabled, 1);
            this.colSyncOut = new MgrColumn.Prop(BNiagaraUserDeviceExt.syncOutEnabled, 1);
            this.colStatus = new MgrColumn.Prop(BNiagaraUserDeviceExt.status, 4);
            this.colFaultCause = new MgrColumn.Prop(BNiagaraUserDeviceExt.faultCause, 6);
            this.colSyncStrategy = new MgrColumn.Prop(BNiagaraUserDeviceExt.syncStrategy, 1);
            this.colSyncRequired = new MgrColumn.Prop(BNiagaraUserDeviceExt.syncRequired, 4);
            this.colSyncDelay = new MgrColumn.Prop(BNiagaraUserDeviceExt.syncDelay, 1);
            this.colSyncRetry = new MgrColumn.Prop(BNiagaraUserDeviceExt.syncRetry, 1);
            this.colLastSyncAttempt = new MgrColumn.Prop(BNiagaraUserDeviceExt.lastSyncAttempt, 6);
            this.colLastSyncSuccess = new MgrColumn.Prop(BNiagaraUserDeviceExt.lastSyncSuccess, 6);
            this.cols = new MgrColumn[]{this.colPath, this.colParent, this.colType, this.colSyncIn, this.colSyncOut, this.colStatus, this.colFaultCause, this.colSyncStrategy, this.colSyncRequired, this.colSyncDelay, this.colSyncRetry, this.colLastSyncAttempt, this.colLastSyncSuccess};
        }

        protected String makeTableTitle() {
            return TYPE.getDisplayName(null);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BNiagaraUserDeviceExt.TYPE};
        }

        public int getSubscribeDepth() {
            return 1;
        }

        protected MgrColumn[] makeColumns() {
            return this.appendMixInColumns(this.cols, BNiagaraUserDeviceExt.TYPE);
        }

        protected class ParentStation
        extends MgrColumn {
            public ParentStation(int flags) {
                super(BUserSyncManager.this.lex.getText("userSyncManager.parentStation"), flags);
            }

            public Object get(Object row) {
                BNiagaraUserDeviceExt user = (BNiagaraUserDeviceExt)row;
                return user.getParent().getName();
            }
        }
    }

    class Controller
    extends DeviceController {
        private Sync sync;

        Controller(BUserSyncManager manager) {
            super((BDeviceManager)manager);
            this.sync = new Sync((BWidget)manager);
            this.sync.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            return new MgrController.IMgrCommand[]{this.edit, this.sync};
        }

        public void updateCommands() {
            super.updateCommands();
            if (this.getSelectedRows().length > 0) {
                this.sync.setEnabled(true);
            } else {
                this.sync.setEnabled(false);
            }
        }

        protected class Sync
        extends MgrController.MgrCommand {
            public Sync(BWidget owner) {
                super(owner, BUserSyncManager.this.lex, "sync");
            }

            public CommandArtifact doInvoke() {
                BComponent[] selected = BUserSyncManager.this.getController().getSelectedComponents();
                for (int i = 0; i < selected.length; ++i) {
                    selected[i].invoke(BNiagaraUserDeviceExt.sync, null);
                }
                return null;
            }
        }
    }
}

