/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.ui;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxClientWebsocketBehavior;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BLearnStation;
import com.tridium.nd.BIExternallyManagedNiagaraStation;
import com.tridium.nd.BNiagaraEdgeLiteStation;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.ui.BStationMgrCommand;
import com.tridium.nd.ui.NiagaraLearn;
import com.tridium.nd.ui.StationModel;
import com.tridium.util.ArrayUtil;
import com.tridium.util.CompUtil;
import com.tridium.workbench.job.BJobBar;
import java.util.Arrays;
import javax.baja.driver.BDevice;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.fox.FoxConnectionTypeEnum;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BClientCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:NiagaraNetwork", "niagaraDriver:NiagaraStationFolder"})})
public class BStationManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationManager.class);
    static final Version VERSION_4_3 = new Version("4.3.0");
    private static final Version VERSION_4_15 = new Version("4.15");
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    static BImage secureStationIcon = BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/lock.png")));
    static BImage webSocketStationIcon = BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/socketConnected.png")));
    static BImage edgeIcon = BImage.make((BIcon)BNiagaraEdgeLiteStation.EDGE_LITE_ICON);
    static BImage secureEdgeIcon = BImage.make((BIcon)BNiagaraEdgeLiteStation.SECURE_EDGE_LITE_ICON);
    static BImage webSocketEdgeIcon = BImage.make((BIcon)BNiagaraEdgeLiteStation.WEB_SOCKET_EDGE_LITE_ICON);
    static boolean lastUseHostName = false;
    final Lexicon lex = Lexicon.make(BStationManager.class);
    final String lexFoxPort = this.lex.getText("stationManager.foxPort");
    final String lexFoxOverWebSocket = this.lex.getText("stationManager.foxOverWebsocket");
    final String lexFoxOverWebSocketPort = this.lex.getText("stationManager.foxOverWebsocketPort");
    final String lexUseFoxs = this.lex.getText("stationManager.useFoxs");
    final String lexClientConn = this.lex.getText("stationManager.clientConn");
    final String lexServerConn = this.lex.getText("stationManager.serverConn");
    MgrColumn colPath = new MgrColumn.Path(2);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(3);
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BNiagaraStation());
    MgrColumn colAddress = new MgrColumn.Prop(BNiagaraStation.address, 1);
    MgrColumn colFoxPort = new MgrColumn.PropPath(this.lexFoxPort, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.port}, 3);
    MgrColumn colFoxOverWebSocket = new MgrColumn.PropPath(this.lexFoxOverWebSocket, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.foxOverWebsocket}, 3);
    MgrColumn colFoxOverWebSocketPort = new MgrColumn.PropPath(this.lexFoxOverWebSocketPort, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.foxOverWebsocketPort}, 3);
    MgrColumn colUseFoxs = new MgrColumn.PropPath(this.lexUseFoxs, new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.useFoxs}, 3);
    MgrColumn colHostModel = new MgrColumn.Prop(BNiagaraStation.hostModel);
    MgrColumn colHostModelVersion = new MgrColumn.Prop(BNiagaraStation.hostModelVersion, 2);
    MgrColumn colVersion = new MgrColumn.Prop(BNiagaraStation.version);
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colFatalCause = new MgrColumn.Prop(BDevice.faultCause, 2);
    MgrColumn colClientConn = new MgrColumn.PropPath(this.lexClientConn, new Property[]{BNiagaraStation.clientConnection, BFoxConnection.state}, 0);
    MgrColumn colServerConn = new ServerConnectionStatusColumn();
    MgrColumn colCredentials = new CredentialsColumn(new Property[]{BNiagaraStation.clientConnection, BFoxClientConnection.credentialStore}, 3);
    MgrColumn colVirtualsEnabled = new MgrColumn.Prop(BNiagaraStation.virtualsEnabled, 1);
    MgrColumn[] cols_pre_4_15 = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colDeviceExts, this.colAddress, this.colFoxPort, this.colUseFoxs, this.colHostModel, this.colHostModelVersion, this.colVersion, this.colCredentials, this.colStatus, this.colEnabled, this.colHealth, this.colFatalCause, this.colClientConn, this.colServerConn, this.colVirtualsEnabled};
    MgrColumn[] cols_post_4_15 = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colDeviceExts, this.colAddress, this.colFoxPort, this.colUseFoxs, this.colFoxOverWebSocket, this.colFoxOverWebSocketPort, this.colHostModel, this.colHostModelVersion, this.colVersion, this.colCredentials, this.colStatus, this.colEnabled, this.colHealth, this.colFatalCause, this.colClientConn, this.colServerConn, this.colVirtualsEnabled};
    BIDeviceFolder folder;
    BNiagaraNetwork network;
    BLearnStation[] lastLearn;
    ToggleCommand useHostName = new ToggleCommand((BWidget)this, "Use Host Name");
    ToggleCommand useHostAddress = new ToggleCommand((BWidget)this, "Use Host Address");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationManager() {
        boolean lastUseHostName = BStationManager.lastUseHostName;
        HostToggle toggleGroup = new HostToggle();
        toggleGroup.add(this.useHostName);
        toggleGroup.add(this.useHostAddress);
        if (lastUseHostName) {
            this.useHostName.setSelected(true);
        } else {
            this.useHostAddress.setSelected(true);
        }
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    private boolean checkRemoteVersion(Version version) {
        try {
            BISession session;
            BNiagaraNetwork network = this.getNetwork();
            if (network != null && (session = network.getSession()) instanceof BFoxSession) {
                return ((BFoxSession)session).getConnection().getRemoteVersion().compareTo(version) >= 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public BNiagaraNetwork getNetwork() {
        return CompUtil.closestAncestor((BComplex)this.getCurrentValue().asComplex(), BNiagaraNetwork.class).orElse(null);
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
        this.folder = (BIDeviceFolder)value;
        try {
            this.network = (BNiagaraNetwork)this.folder.getNetwork();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateDiscoveryRows(BComponent event) {
        Object[] rows = (BLearnStation[])event.getChildren(BLearnStation.class);
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = (BLearnStation)rows[i].newCopy();
        }
        this.learnRowsInvariant(rows);
        this.lastLearn = rows;
        this.getLearn().updateRoots(rows);
    }

    public void learnRowsInvariant(Object[] rows) {
        boolean useHostName = this.useHostName.isSelected();
        for (Object row1 : rows) {
            BLearnStation row = (BLearnStation)row1;
            row.invariant(useHostName);
        }
    }

    private static class NiagaraTypeColumn
    extends MgrColumn {
        public NiagaraTypeColumn(int flags) {
            super(UiLexicon.bajaui().getText("type"), flags);
        }

        public Object get(Object row) {
            BLearnStation learnStation = (BLearnStation)row;
            if (learnStation.getNiagaraPlatformType().isEmpty()) {
                return BNiagaraStation.TYPE.getTypeInfo().getDisplayName(null);
            }
            return BNiagaraEdgeLiteStation.TYPE.getTypeInfo().getDisplayName(null);
        }
    }

    private class ServerConnectionStatusColumn
    extends MgrColumn.PropPath {
        public ServerConnectionStatusColumn() {
            super(BStationManager.this.lexServerConn, new Property[]{BFoxConnection.state}, 0);
        }

        public Object get(Object row) {
            if (this.getRowBase(row) == null) {
                return BFoxConnection.state.getDefaultValue();
            }
            return super.get(row);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (this.getRowBase(row) == null) {
                BFacets f = BFoxConnection.state.getFacets();
                if (!f.isNull()) {
                    cx = new BasicContext(cx, f);
                }
                return BFoxConnection.state.getDefaultValue().toString(cx);
            }
            return super.toDisplayString(row, value, cx);
        }

        protected BComplex getRowBase(Object row) {
            return ((BNiagaraStation)row).getServerConnection();
        }
    }

    class CredentialsColumn
    extends MgrColumn.PropPath {
        public CredentialsColumn(Property[] props, int flags) {
            super(props, flags);
        }

        public BValue load(MgrEditRow row) {
            BComplex val = this.getTargetBase(row);
            for (int i = 0; i < this.props.length; ++i) {
                val = val.get(this.props[i]);
            }
            BValue copy = val.newCopy();
            if (val instanceof BClientCredentials) {
                ((BClientCredentials)val).lease();
                BValue creds = ((BClientCredentials)val).getClientCredentials();
                if (creds instanceof BUsernameAndPassword) {
                    BPassword pass = ((BUsernameAndPassword)creds).getPassword();
                    ((BUsernameAndPassword)((BClientCredentials)copy).getClientCredentials()).setPassword(pass);
                }
            }
            return copy;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BValue creds;
            BComplex target = this.getTargetBase(row);
            int len = this.props.length;
            for (int i = 0; i < len - 1; ++i) {
                target = (BComplex)target.get(this.props[i]);
            }
            Property prop = this.props[len - 1];
            BValue old = target.get(prop);
            BValue copy = value.newCopy();
            if (value instanceof BClientCredentials && (creds = ((BClientCredentials)value).getClientCredentials()) instanceof BUsernameAndPassword) {
                BPassword pass = ((BUsernameAndPassword)creds).getPassword();
                ((BUsernameAndPassword)((BClientCredentials)copy).getClientCredentials()).setPassword(pass);
                ((BUsernameAndPassword)((BClientCredentials)copy).getClientCredentials()).setPassword(pass);
            }
            if (!old.equivalent((Object)value)) {
                target.set(prop, copy, cx);
            }
        }
    }

    class OpenStationCommand
    extends Command {
        String stationName;
        BOrd host;
        int port;
        boolean useFoxs;
        BFoxClientWebsocketBehavior foxwssBehavior;
        int websocketPort;
        BMouseEvent event;

        OpenStationCommand(BWidget owner, BNiagaraStation station, BMouseEvent event) {
            super(owner, BStationManager.this.lex.module, "stationManager.openStation");
            this.stationName = station.getName();
            this.host = station.getAddress();
            this.port = station.getClientConnection().getPort();
            this.useFoxs = station.getClientConnection().getUseFoxs();
            this.websocketPort = station.getClientConnection().getFoxOverWebsocketPort();
            this.foxwssBehavior = station.getClientConnection().getFoxOverWebsocket();
            this.event = event;
        }

        OpenStationCommand(BWidget owner, BLearnStation station, BMouseEvent event) {
            super(owner, BStationManager.this.lex.module, "stationManager.openStation");
            String host = BStationManager.this.useHostName.isSelected() ? station.getHostName() : station.getHostAddress();
            this.stationName = station.getStationName();
            this.host = BOrd.make((String)("ip:" + host));
            this.port = station.getFoxPort();
            this.websocketPort = station.getFoxwssPort();
            this.useFoxs = station.getScheme().equalsIgnoreCase("foxs");
            boolean useFoxOverWebSocket = station.getScheme().equalsIgnoreCase("foxwss");
            this.foxwssBehavior = useFoxOverWebSocket ? BFoxClientWebsocketBehavior.useWebsocketOnly : (station.getFoxwssPort() != 0 ? BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails : BFoxClientWebsocketBehavior.websocketDisabled);
            this.event = event;
        }

        public CommandArtifact doInvoke() throws Exception {
            Learn learn = (Learn)BStationManager.this.getLearn();
            BFoxSession session = learn.connect(this.stationName, this.host, this.port, this.useFoxs, this.foxwssBehavior, this.websocketPort);
            if (session != null) {
                BStationManager.this.getWbShell().hyperlink(new HyperlinkInfo(session.getNavOrd(), (BInputEvent)this.event));
            }
            return null;
        }
    }

    class Controller
    extends DeviceController {
        Controller(BStationManager mgr) {
            super((BDeviceManager)mgr);
            this.allDescendants.setFlags(this.allDescendants.getFlags() | 8);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BStationManager.this.getLearn().setJob(BStationManager.this.network.submitStationDiscoveryJob());
            return null;
        }

        public BMenu makePopup(BLearnTable table, TreeTableSubject subject, BMenu menu) {
            menu = super.makePopup(table, subject, menu);
            if (subject.size() == 1) {
                BLearnStation station = (BLearnStation)subject.get(0);
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), station, null));
            }
            return menu;
        }

        public BMenu makePopup(BMgrTable table, ComponentTableSubject subject, BMenu menu) {
            menu = super.makePopup(table, subject, menu);
            if (subject.size() == 1 && subject.get(0) instanceof BNiagaraStation) {
                BNiagaraStation station = (BNiagaraStation)subject.get(0);
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, (Command)new OpenStationCommand((BWidget)this.getManager(), station, null));
            }
            return menu;
        }

        public BMenu makeOptionsMenu(BLearnTable table, BMenu menu) {
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)BStationManager.this.useHostName);
            menu.add(null, (Command)BStationManager.this.useHostAddress);
            return menu;
        }

        public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
            block12: {
                try {
                    Mark data = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
                    BObject[] objects = data.getValues();
                    boolean allSessions = objects.length > 0;
                    for (BObject object : objects) {
                        if (object instanceof BFoxSession) continue;
                        allSessions = false;
                        break;
                    }
                    if (!allSessions) break block12;
                    MgrEdit edit = new MgrEdit(this.getManager(), this.add.getLabel());
                    for (BObject object : objects) {
                        BFoxSession session = (BFoxSession)object;
                        FoxMessage remoteHello = null;
                        try {
                            remoteHello = session.getConnection().session().getRemoteHello();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        BNiagaraStation station = BNiagaraEdgeLiteStation.getSuitableNiagaraStationInstance(remoteHello);
                        station.setAddress(session.getHost().getAbsoluteOrd());
                        station.getClientConnection().setPort(session.getPort());
                        FoxConnectionTypeEnum foxConnectionTypeEnum = session.getFoxConnectionType();
                        switch (foxConnectionTypeEnum) {
                            case FOX_OR_FOXWSS: {
                                station.getClientConnection().setUseFoxs(false);
                                station.getClientConnection().setFoxOverWebsocket(BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails);
                                station.getClientConnection().setFoxOverWebsocketPort(session.getWebsocketPort());
                                break;
                            }
                            case FOXS_OR_FOXWSS: {
                                station.getClientConnection().setUseFoxs(true);
                                station.getClientConnection().setFoxOverWebsocket(BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails);
                                station.getClientConnection().setFoxOverWebsocketPort(session.getWebsocketPort());
                                break;
                            }
                            case FOXWSS: {
                                station.getClientConnection().setUseFoxs(true);
                                station.getClientConnection().setFoxOverWebsocket(BFoxClientWebsocketBehavior.useWebsocketOnly);
                                station.getClientConnection().setFoxOverWebsocketPort(session.getWebsocketPort());
                                break;
                            }
                            case FOXS: {
                                station.getClientConnection().setUseFoxs(true);
                                station.getClientConnection().setFoxOverWebsocket(BFoxClientWebsocketBehavior.websocketDisabled);
                                break;
                            }
                            default: {
                                station.getClientConnection().setUseFoxs(false);
                                station.getClientConnection().setFoxOverWebsocket(BFoxClientWebsocketBehavior.websocketDisabled);
                            }
                        }
                        MgrEditRow row = new MgrEditRow((BComponent)station, null, null);
                        edit.addRow(row);
                        if (session.getStationName() == null) continue;
                        row.setName(session.getStationName());
                    }
                    return edit.invoke(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.drop(table, cx);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            TypeInfo[] infos = Sys.getRegistry().getConcreteTypes(BStationMgrCommand.TYPE.getTypeInfo());
            Array cmdArray = new Array(MgrController.IMgrCommand.class);
            for (TypeInfo info : infos) {
                BStationMgrCommand stationCmd = (BStationMgrCommand)info.getInstance();
                if (!stationCmd.isCommandActive(BStationManager.this)) continue;
                cmdArray.add((Object)stationCmd.makeCommand(BStationManager.this));
            }
            return Controller.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])((MgrController.IMgrCommand[])cmdArray.trim()));
        }

        public void updateCommands() {
            MgrController.IMgrCommand[] cmds;
            for (MgrController.IMgrCommand cmd : cmds = this.getCommands()) {
                if (!(cmd instanceof BStationMgrCommand.Cmd)) continue;
                BStationMgrCommand.Cmd stationCmd = (BStationMgrCommand.Cmd)cmd;
                stationCmd.updateCommand();
            }
            super.updateCommands();
        }
    }

    static class State
    extends DeviceState {
        BLearnStation[] lastLearn;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BStationManager manager = (BStationManager)m;
            this.lastLearn = manager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BStationManager manager = (BStationManager)m;
            if (this.lastLearn != null) {
                manager.lastLearn = this.lastLearn;
                manager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    class HostToggle
    extends ToggleCommandGroup<ToggleCommand> {
        HostToggle() {
        }

        protected void selected(ToggleCommand command) {
            lastUseHostName = command == BStationManager.this.useHostName;
            MgrLearn learn = BStationManager.this.getLearn();
            if (learn == null) {
                return;
            }
            Object[] rows = BStationManager.this.getLearn().getRoots();
            if (rows == null) {
                return;
            }
            BStationManager.this.learnRowsInvariant(rows);
            learn.getTable().repaint();
        }
    }

    class Learn
    extends NiagaraLearn {
        Learn(BStationManager mgr) {
            super((BAbstractManager)mgr);
        }

        @Override
        public BWidget makeJobBar() {
            return new BJobBar();
        }

        protected MgrColumn[] makeColumns() {
            Property[] props = new BLearnStation().getPropertiesArray();
            MgrColumn[] cols = new MgrColumn[props.length];
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                int propFlags = prop.getDefaultFlags();
                int colFlags = 0;
                if ((propFlags & 8) == 0) {
                    colFlags |= 2;
                }
                cols[i] = prop.equals(BLearnStation.niagaraPlatformType) ? new NiagaraTypeColumn(colFlags) : new MgrColumn.Prop(props[i], colFlags);
            }
            return cols;
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return true;
        }

        @Override
        public BImage getIcon(Object dis) {
            BLearnStation learn = (BLearnStation)dis;
            if (learn.getNiagaraPlatformType().isEmpty()) {
                if (learn.getScheme().equalsIgnoreCase("foxs")) {
                    return secureStationIcon;
                }
                if (learn.getScheme().equalsIgnoreCase("foxwss")) {
                    return webSocketStationIcon;
                }
                return stationIcon;
            }
            if (learn.getScheme().equalsIgnoreCase("foxs")) {
                return secureEdgeIcon;
            }
            if (learn.getScheme().equalsIgnoreCase("foxwss")) {
                return webSocketEdgeIcon;
            }
            return edgeIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            Object[] newTypes = BStationManager.this.getModel().getNewTypes();
            BLearnStation learn = (BLearnStation)dis;
            if (!learn.getNiagaraPlatformType().isEmpty()) {
                int idx = -1;
                MgrTypeInfo edgeLiteInfo = MgrTypeInfo.make((Type)BNiagaraEdgeLiteStation.TYPE);
                for (int i = 0; i < newTypes.length; ++i) {
                    if (!newTypes[i].equals((Object)edgeLiteInfo)) continue;
                    idx = i;
                    break;
                }
                if (idx >= 0) {
                    return (MgrTypeInfo[])ArrayUtil.toTop((Object[])newTypes, (int)idx);
                }
            }
            return newTypes;
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            block2: {
                BLearnStation learn = (BLearnStation)dis;
                String host = BStationManager.this.useHostName.isSelected() ? learn.getHostName() : learn.getHostAddress();
                row.setName(learn.getStationName());
                row.setCell(BStationManager.this.colAddress, (BValue)BOrd.make((String)("ip:" + host)));
                BInteger port = BInteger.make((int)learn.getFoxPort());
                row.setCell(BStationManager.this.colFoxPort, (BValue)port);
                row.setCell(BStationManager.this.colUseFoxs, (BValue)(learn.getScheme().equalsIgnoreCase("foxs") ? BBoolean.TRUE : BBoolean.FALSE));
                boolean useFoxOverWebSocket = learn.getScheme().equalsIgnoreCase("foxwss");
                boolean hasFoxwssPort = learn.getFoxwssPort() != 0;
                try {
                    row.getColumnIndex(BStationManager.this.colFoxOverWebSocket);
                    row.getColumnIndex(BStationManager.this.colFoxOverWebSocketPort);
                    BFoxClientWebsocketBehavior websocketBehavior = useFoxOverWebSocket ? BFoxClientWebsocketBehavior.useWebsocketOnly : (hasFoxwssPort ? BFoxClientWebsocketBehavior.useWebsocketIfFoxOrFoxsFails : BFoxClientWebsocketBehavior.websocketDisabled);
                    row.setCell(BStationManager.this.colFoxOverWebSocket, (BValue)websocketBehavior);
                    BInteger websocketPort = useFoxOverWebSocket ? port : (hasFoxwssPort ? BInteger.make((int)learn.getFoxwssPort()) : BInteger.make((int)443));
                    row.setCell(BStationManager.this.colFoxOverWebSocketPort, (BValue)websocketPort);
                }
                catch (IllegalArgumentException iae) {
                    if (!useFoxOverWebSocket) break block2;
                    throw new LocalizableException("niagaraDriver", "StationManager.illegalFoxwssDiscoveryAdd");
                }
            }
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BLearnStation learn = (BLearnStation)dis;
            if (comp instanceof BNiagaraStation) {
                BNiagaraStation station = (BNiagaraStation)comp;
                return learn.getStationName().equals(station.getName());
            }
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BStationManager.this.updateDiscoveryRows((BComponent)job);
        }
    }

    class Model
    extends StationModel {
        Model(BStationManager manager) {
            super(manager);
        }

        public MgrTypeInfo[] getNewTypes() {
            TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BNiagaraStation.TYPE.getTypeInfo());
            types = (TypeInfo[])Arrays.stream(types).filter(t -> !t.is(BIExternallyManagedNiagaraStation.TYPE)).toArray(TypeInfo[]::new);
            Object[] newTypes = MgrTypeInfo.makeArray((TypeInfo[])types);
            int idx = -1;
            MgrTypeInfo edgeLiteInfo = MgrTypeInfo.make((Type)BNiagaraEdgeLiteStation.TYPE);
            for (int i = 0; i < newTypes.length; ++i) {
                if (!newTypes[i].equals((Object)edgeLiteInfo)) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                if (BStationManager.this.checkRemoteVersion(VERSION_4_3)) {
                    return (MgrTypeInfo[])ArrayUtil.toBottom((Object[])newTypes, (int)idx);
                }
                return (MgrTypeInfo[])ArrayUtil.removeOne((Object[])newTypes, (int)idx);
            }
            return newTypes;
        }

        public int getSubscribeDepth() {
            return 1;
        }

        protected MgrColumn[] makeColumns() {
            if (BStationManager.this.checkRemoteVersion(VERSION_4_15)) {
                return this.appendMixInColumns(BStationManager.this.cols_post_4_15, BNiagaraStation.TYPE);
            }
            return this.appendMixInColumns(BStationManager.this.cols_pre_4_15, BNiagaraStation.TYPE);
        }
    }
}

