/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import obix.Time;
import obix.test.Test;

public class TimeTest
extends Test {
    public static final long S = 1000L;
    public static final long M = 60000L;
    public static final long H = 3600000L;

    @Override
    public void run() throws Exception {
        Time t = new Time(1, 2, 3, 4);
        this.verify(t.getHour(), 1L);
        this.verify(t.getMinute(), 2L);
        this.verify(t.getSecond(), 3L);
        this.verify(t.getMillisecond(), 4L);
        this.verify(t.equals(new Time(1, 2, 3, 4)));
        this.verify(!t.equals(new Time(1, 2, 3, 0)));
        this.verify(!t.equals(new Time(1, 2, 0, 4)));
        this.verify(!t.equals(new Time(1, 0, 3, 4)));
        this.verify(!t.equals(new Time(0, 2, 3, 4)));
        this.verify(new Time(1, 2, 3, 4).compareTo(new Time(1, 2, 3, 4)) == 0);
        this.verify(new Time(1, 2, 3, 3).compareTo(new Time(1, 2, 3, 4)) < 0);
        this.verify(new Time(1, 2, 3, 5).compareTo(new Time(1, 2, 3, 4)) > 0);
        this.verify(new Time(1, 2, 10, 4).compareTo(new Time(1, 2, 3, 4)) > 0);
        this.verify(new Time(1, 2, 3, 4).compareTo(new Time(13, 2, 3, 4)) < 0);
        this.verify("12:34", 45240000L);
        this.verify("00:00", 0L);
        this.verify("00:00:00", 0L);
        this.verify("02:00:00", 0x6DDD00L);
        this.verify("02:03:00", 7380000L);
        this.verify("02:03:04", 7384000L);
        this.verify("02:03:04.007", 7384007L);
        this.verify("02:03:04.087", 7384087L);
        this.verify("02:03:04.987", 7384987L);
        this.verify("23:58:36.030", 86316030L);
        this.verify("12:34:56.0123", 45296012L);
        this.verify("12:34:56.01234", 45296012L);
        this.verifyInvalid("2:30");
        this.verifyInvalid("12:4");
        this.verifyInvalid("12.34");
        this.verifyInvalid("12:34.3");
        this.verifyInvalid("12:34:3");
        this.verifyInvalid("12:34:35x");
    }

    public void verify(String s, long millis) throws Exception {
        Time t = new Time();
        t.decodeVal(s);
        this.verify(t.getMillis() == millis);
        Time x = new Time();
        x.decodeVal(t.encodeVal());
        this.verify(x.equals(t));
        this.verify(x.getMillis() == millis);
        this.verify(new Time(millis), t);
    }

    public void verifyInvalid(String s) throws Exception {
        Exception ex = null;
        Time t = new Time();
        try {
            t.decodeVal(s);
        }
        catch (Exception e) {
            ex = e;
        }
        this.verify(ex != null);
    }
}

