/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import obix.Abstime;
import obix.Bool;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Reltime;
import obix.Str;
import obix.Time;
import obix.Val;
import obix.io.ObixBinDecoder;
import obix.io.ObixBinEncoder;
import obix.io.ObixDecoder;
import obix.io.ObixEncoder;
import obix.io.ObixJsonDecoder;
import obix.io.ObixJsonEncoder;
import obix.io.ObixXmlEncoder;
import obix.test.AbstimeTest;
import obix.test.ContractTest;
import obix.test.DateTest;
import obix.test.FragmentsTest;
import obix.test.IOTest;
import obix.test.ReltimeTest;
import obix.test.TestException;
import obix.test.TimeTest;
import obix.test.TreeTest;
import obix.test.UriTest;

public abstract class Test {
    public static final Test[] tests = new Test[]{new TreeTest(), new IOTest(), new AbstimeTest(), new ReltimeTest(), new TimeTest(), new DateTest(), new UriTest(), new ContractTest(), new FragmentsTest()};
    static boolean verbose;
    int count;
    byte[] binaryRoundtrip;

    public String getName() {
        return this.getClass().getName();
    }

    public abstract void run() throws Exception;

    public void verify(boolean condition) {
        if (!condition) {
            throw new TestException("Failed verify");
        }
        ++this.count;
    }

    public void verify(boolean condition, String msg) {
        if (!condition) {
            throw new TestException("Failed verify: " + msg);
        }
        ++this.count;
    }

    public void verify(Object a, Object b) {
        if (a == null) {
            this.verify(b == null);
        } else if (b == null) {
            this.verify(a == null);
        } else {
            this.verify(a.equals(b));
        }
    }

    public void verify(long a, long b) {
        this.verify(a == b);
    }

    public void verifyEquivalent(Obj a, Obj b) {
        if (verbose) {
            System.out.println("  " + a + " ?= " + b);
        }
        this.verify(a.getClass() == b.getClass());
        this.verify(a.getName(), (Object)b.getName());
        this.verify(a.getHref(), b.getHref());
        this.verify(a.getIs(), b.getIs());
        if (a instanceof Val) {
            this.verify(((Val)a).encodeVal(), (Object)((Val)b).encodeVal());
        }
        if (a instanceof List) {
            this.verify(((List)a).getOf(), ((List)b).getOf());
        }
        if (a instanceof Op) {
            this.verify(((Op)a).getIn(), ((Op)b).getIn());
            this.verify(((Op)a).getOut(), ((Op)b).getOut());
        }
        if (a instanceof Feed) {
            this.verify(((Feed)a).getIn(), ((Feed)b).getIn());
            this.verify(((Feed)a).getOf(), ((Feed)b).getOf());
        }
        this.verify(a.getDisplay(), (Object)b.getDisplay());
        this.verify(a.getDisplayName(), (Object)b.getDisplayName());
        this.verify(a.getIcon(), b.getIcon());
        this.verify(a.getStatus() == b.getStatus());
        this.verify(a.isNull() == b.isNull());
        this.verify(a.isWritable() == b.isWritable());
        if (a instanceof Bool) {
            this.verify(((Bool)a).getRange(), ((Bool)b).getRange());
        } else if (a instanceof Enum) {
            this.verify(((Enum)a).getRange(), ((Enum)b).getRange());
        } else if (a instanceof Int) {
            this.verify(((Int)a).getMin() == ((Int)b).getMin());
            this.verify(((Int)a).getMax() == ((Int)b).getMax());
            this.verify(((Int)a).getUnit(), ((Int)b).getUnit());
        } else if (a instanceof Real) {
            this.verify(((Real)a).getMin() == ((Real)b).getMin());
            this.verify(((Real)a).getMax() == ((Real)b).getMax());
            this.verify(((Real)a).getUnit(), ((Real)b).getUnit());
            this.verify(((Real)a).getPrecision() == ((Real)b).getPrecision());
        } else if (a instanceof Str) {
            this.verify(((Str)a).getMin() == ((Str)b).getMin());
            this.verify(((Str)a).getMax() == ((Str)b).getMax());
        } else if (a instanceof Reltime) {
            this.verify(((Reltime)a).getMin(), ((Reltime)b).getMin());
            this.verify(((Reltime)a).getMax(), ((Reltime)b).getMax());
        } else if (a instanceof Abstime) {
            this.verify(((Abstime)a).getMin(), ((Abstime)b).getMin());
            this.verify(((Abstime)a).getMax(), ((Abstime)b).getMax());
            this.verify(((Abstime)a).getTz(), (Object)((Abstime)b).getTz());
        } else if (a instanceof Time) {
            this.verify(((Time)a).getMin(), ((Time)b).getMin());
            this.verify(((Time)a).getMax(), ((Time)b).getMax());
            this.verify(((Time)a).getTz(), (Object)((Time)b).getTz());
        } else if (a instanceof Date) {
            this.verify(((Date)a).getMin(), ((Date)b).getMin());
            this.verify(((Date)a).getMax(), ((Date)b).getMax());
            this.verify(((Date)a).getTz(), (Object)((Date)b).getTz());
        } else if (a instanceof List) {
            this.verify(((List)a).getMin() == ((List)b).getMin());
            this.verify(((List)a).getMax() == ((List)b).getMax());
        }
        Obj[] akids = a.list();
        Obj[] bkids = b.list();
        this.verify(akids.length == bkids.length);
        for (int i = 0; i < akids.length; ++i) {
            this.verifyEquivalent(akids[i], bkids[i]);
        }
    }

    public Obj roundtrip(Obj orig) throws Exception {
        return this.roundtrip(orig, true);
    }

    public Obj roundtrip(Obj orig, boolean testAll) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObixXmlEncoder out = new ObixXmlEncoder(bout);
        ((ObixEncoder)out).encode(orig);
        ((ObixEncoder)out).flush();
        byte[] buf = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(buf);
        ObixDecoder in = ObixDecoder.make(bin);
        Obj piped = in.decodeDocument();
        if (verbose) {
            System.out.println("");
            System.out.println("============");
            System.out.write(buf);
            System.out.println("--- xml ---");
            ObixEncoder.dump(piped);
        }
        this.verifyEquivalent(orig, piped);
        this.binaryRoundtrip = null;
        if (testAll) {
            byte[] binary = ObixBinEncoder.toBytes(orig);
            this.binaryRoundtrip = binary;
            Obj binaryPiped = ObixBinDecoder.fromBytes(binary);
            if (verbose) {
                System.out.println("");
                System.out.println("============");
                System.out.print("Bin:");
                for (int i = 0; i < binary.length; ++i) {
                    int c = binary[i] & 0xFF;
                    System.out.print(" " + (c < 10 ? "0" : "") + Integer.toHexString(c));
                }
                System.out.println();
                ObixEncoder.dump(binaryPiped);
            }
            this.verifyEquivalent(orig, binaryPiped);
            bout.reset();
            ObixJsonEncoder encj = new ObixJsonEncoder(bout);
            ((ObixEncoder)encj).encode(orig);
            ((ObixEncoder)encj).flush();
            buf = bout.toByteArray();
            bin = new ByteArrayInputStream(buf);
            ObixJsonDecoder decj = new ObixJsonDecoder(bin);
            Obj jsonPiped = ((ObixDecoder)decj).decode();
            if (verbose) {
                System.out.println("");
                System.out.println("============");
                System.out.write(buf);
                System.out.println("\n--- json ---");
                ObixEncoder.dump(piped);
            }
            this.verifyEquivalent(orig, jsonPiped);
        }
        return piped;
    }

    public static void main(String[] args) {
        int i;
        String filter = "";
        if (args.length > 0 && !args[0].startsWith("/")) {
            filter = "obix.test." + args[0];
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].equals("/v")) continue;
            verbose = true;
        }
        for (i = 0; i < tests.length; ++i) {
            Test test = tests[i];
            if (!test.getName().startsWith(filter)) continue;
            try {
                test.run();
                System.out.println("Success: " + test.getName() + " [" + test.count + "]");
                continue;
            }
            catch (Throwable e) {
                System.out.println("FAILED:  " + test.getName());
                e.printStackTrace();
            }
        }
    }
}

