/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import obix.Obj;
import obix.io.ObixJsonEncoder;
import obix.io.ObixXmlEncoder;
import obix.util.TextUtil;

public abstract class ObixEncoder {
    public static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_BINARY = "application/octet-stream";
    public static final String CONTENT_TYPE_NIAGARA_XML = "application/vnd.tridium.com-obix+xml; version=1.1";
    public static final String CONTENT_TYPE_NIAGARA_JSON = "application/vnd.tridium.com-obix+json; version=1.1";
    public static final String CONTENT_TYPE_NIAGARA_BINARY = "application/vnd.tridium.com-obix+binary; version=1.1";
    protected final OutputStream out;

    public static void dump(Obj obj) {
        try {
            ObixXmlEncoder encoder = new ObixXmlEncoder(System.out);
            ((ObixEncoder)encoder).encode(obj);
            ((ObixEncoder)encoder).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static String toString(Obj obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObixXmlEncoder encoder = new ObixXmlEncoder(out);
            ((ObixEncoder)encoder).encode(obj);
            ((ObixEncoder)encoder).flush();
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static ObixEncoder make(OutputStream out, String acceptType) throws IOException {
        if (acceptType == null) {
            return new ObixXmlEncoder(out);
        }
        if (acceptType.equals(CONTENT_TYPE_APPLICATION_JSON) || acceptType.equals(CONTENT_TYPE_NIAGARA_JSON)) {
            return new ObixJsonEncoder(out);
        }
        return new ObixXmlEncoder(out);
    }

    public ObixEncoder(File file) throws IOException {
        this.out = new BufferedOutputStream(new FileOutputStream(file));
    }

    public ObixEncoder(OutputStream out) throws IOException {
        this.out = out;
    }

    public abstract void encode(Obj var1) throws IOException;

    public abstract void flush();

    public abstract String getContentType();

    protected static Set<String> initParams(String[] pv) {
        if (pv == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String s : pv) {
            String[] tokens = TextUtil.split(s, ',');
            Collections.addAll(set, tokens);
        }
        return set;
    }

    static class Buffer
    extends ByteArrayOutputStream {
        Buffer() {
        }

        byte[] getBytes() {
            return this.buf;
        }
    }
}

