/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Err;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.io.ObixDecoder;

public class ObixBinDecoder
extends ObixDecoder {
    private DataInputStream din;
    private ArrayList<String> strTable = new ArrayList();

    public static Obj fromBytes(byte[] bytes) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ObixBinDecoder decoder = new ObixBinDecoder(in);
            return decoder.decode();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public ObixBinDecoder(InputStream in) throws Exception {
        super(in);
        this.din = new DataInputStream(in);
    }

    @Override
    public Obj decode() throws Exception {
        return this.decode(true);
    }

    public Obj decode(boolean close) throws Exception {
        try {
            this.strTable.clear();
            Obj obj = this.decode(this.din.readUnsignedByte());
            return obj;
        }
        finally {
            if (close) {
                this.din.close();
            }
        }
    }

    private Obj decode(int code) throws Exception {
        Obj obj;
        switch (code & 0x7C) {
            case 4: {
                obj = new Obj();
                break;
            }
            case 8: {
                obj = new Bool(this.readBoolVal(code));
                break;
            }
            case 12: {
                obj = new Int(this.readIntVal(code));
                break;
            }
            case 16: {
                obj = new Real(this.readRealVal(code));
                break;
            }
            case 20: {
                obj = new Str(this.readStrVal(code));
                break;
            }
            case 24: {
                obj = new Enum(this.readStrVal(code));
                break;
            }
            case 32: {
                obj = this.readAbstimeVal(code);
                break;
            }
            case 36: {
                obj = this.readReltimeVal(code);
                break;
            }
            case 44: {
                obj = this.readTimeVal(code);
                break;
            }
            case 40: {
                obj = this.readDateVal(code);
                break;
            }
            case 28: {
                obj = new Uri(this.readStrVal(code));
                break;
            }
            case 48: {
                obj = new List();
                break;
            }
            case 52: {
                obj = new Op();
                break;
            }
            case 56: {
                obj = new Feed();
                break;
            }
            case 60: {
                obj = new Ref();
                break;
            }
            case 64: {
                obj = new Err();
                break;
            }
            default: {
                throw new IOException("Invalid object code 0x" + Integer.toHexString(code));
            }
        }
        boolean hasChildren = false;
        block39: while ((code & 0x80) != 0) {
            code = this.din.readUnsignedByte();
            switch (code & 0x7C) {
                case 4: {
                    hasChildren = true;
                    continue block39;
                }
                case 8: {
                    obj.setName(this.readStrVal(code));
                    continue block39;
                }
                case 12: {
                    obj.setHref(new Uri(this.readStrVal(code)));
                    continue block39;
                }
                case 16: {
                    obj.setIs(this.readContractVal(code));
                    continue block39;
                }
                case 76: 
                case 80: {
                    obj.setStatus(this.readStatusVal(code));
                    continue block39;
                }
                case 44: {
                    obj.setDisplay(this.readStrVal(code));
                    continue block39;
                }
                case 40: {
                    obj.setDisplayName(this.readStrVal(code));
                    continue block39;
                }
                case 36: {
                    obj.setIcon(new Uri(this.readStrVal(code)));
                    continue block39;
                }
                case 32: {
                    obj.setNull(this.readBoolVal(code));
                    continue block39;
                }
                case 48: {
                    obj.setWritable(this.readBoolVal(code));
                    continue block39;
                }
                case 20: {
                    this.readOf(obj, code);
                    continue block39;
                }
                case 24: {
                    this.readIn(obj, code);
                    continue block39;
                }
                case 28: {
                    this.readOut(obj, code);
                    continue block39;
                }
                case 52: {
                    this.readMin(obj, code);
                    continue block39;
                }
                case 56: {
                    this.readMax(obj, code);
                    continue block39;
                }
                case 68: {
                    this.readRange(obj, code);
                    continue block39;
                }
                case 60: {
                    this.readUnit(obj, code);
                    continue block39;
                }
                case 64: {
                    this.readPrecision(obj, code);
                    continue block39;
                }
                case 72: {
                    this.readTz(obj, code);
                    continue block39;
                }
            }
            throw new IOException("Invalid facet code 0x" + Integer.toHexString(code));
        }
        if (hasChildren) {
            while ((code = this.din.readUnsignedByte()) != 68) {
                Obj child = this.decode(code);
                obj.add(child);
            }
        }
        return obj;
    }

    private void readOf(Obj obj, int code) throws IOException {
        Contract c = this.readContractVal(code);
        switch (obj.getBinCode()) {
            case 48: {
                ((List)obj).setOf(c);
                break;
            }
            case 56: {
                ((Feed)obj).setOf(c);
                break;
            }
            default: {
                throw new IOException("Invalid 'of' facet on " + obj.getElement());
            }
        }
    }

    private void readIn(Obj obj, int code) throws IOException {
        Contract c = this.readContractVal(code);
        switch (obj.getBinCode()) {
            case 52: {
                ((Op)obj).setIn(c);
                break;
            }
            case 56: {
                ((Feed)obj).setIn(c);
                break;
            }
            default: {
                throw new IOException("Invalid 'in' facet on " + obj.getElement());
            }
        }
    }

    private void readOut(Obj obj, int code) throws IOException {
        Contract c = this.readContractVal(code);
        switch (obj.getBinCode()) {
            case 52: {
                ((Op)obj).setOut(c);
                break;
            }
            default: {
                throw new IOException("Invalid 'out' facet on " + obj.getElement());
            }
        }
    }

    private void readMin(Obj obj, int code) throws IOException {
        switch (obj.getBinCode()) {
            case 12: {
                ((Int)obj).setMin(this.readIntVal(code));
                break;
            }
            case 16: {
                ((Real)obj).setMin(this.readRealVal(code));
                break;
            }
            case 20: {
                ((Str)obj).setMin((int)this.readIntVal(code));
                break;
            }
            case 48: {
                ((List)obj).setMin((int)this.readIntVal(code));
                break;
            }
            case 32: {
                ((Abstime)obj).setMin(this.readAbstimeVal(code));
                break;
            }
            case 36: {
                ((Reltime)obj).setMin(this.readReltimeVal(code));
                break;
            }
            case 44: {
                ((Time)obj).setMin(this.readTimeVal(code));
                break;
            }
            case 40: {
                ((Date)obj).setMin(this.readDateVal(code));
                break;
            }
            default: {
                throw new IOException("Invalid 'min' facet on " + obj.getElement());
            }
        }
    }

    private void readMax(Obj obj, int code) throws IOException {
        switch (obj.getBinCode()) {
            case 12: {
                ((Int)obj).setMax(this.readIntVal(code));
                break;
            }
            case 16: {
                ((Real)obj).setMax(this.readRealVal(code));
                break;
            }
            case 20: {
                ((Str)obj).setMax((int)this.readIntVal(code));
                break;
            }
            case 48: {
                ((List)obj).setMax((int)this.readIntVal(code));
                break;
            }
            case 32: {
                ((Abstime)obj).setMax(this.readAbstimeVal(code));
                break;
            }
            case 36: {
                ((Reltime)obj).setMax(this.readReltimeVal(code));
                break;
            }
            case 44: {
                ((Time)obj).setMax(this.readTimeVal(code));
                break;
            }
            case 40: {
                ((Date)obj).setMax(this.readDateVal(code));
                break;
            }
            default: {
                throw new IOException("Invalid 'max' facet on " + obj.getElement());
            }
        }
    }

    private void readRange(Obj obj, int code) throws IOException {
        Uri uri = new Uri(this.readStrVal(code));
        switch (obj.getBinCode()) {
            case 8: {
                ((Bool)obj).setRange(uri);
                break;
            }
            case 24: {
                ((Enum)obj).setRange(uri);
                break;
            }
            default: {
                throw new IOException("Invalid 'range' facet on " + obj.getElement());
            }
        }
    }

    private void readUnit(Obj obj, int code) throws IOException {
        Uri uri = new Uri(this.readStrVal(code));
        switch (obj.getBinCode()) {
            case 12: {
                ((Int)obj).setUnit(uri);
                break;
            }
            case 16: {
                ((Real)obj).setUnit(uri);
                break;
            }
            default: {
                throw new IOException("Invalid 'unit' facet on " + obj.getElement());
            }
        }
    }

    private void readPrecision(Obj obj, int code) throws IOException {
        int prec = (int)this.readIntVal(code);
        switch (obj.getBinCode()) {
            case 16: {
                ((Real)obj).setPrecision(prec);
                break;
            }
            default: {
                throw new IOException("Invalid 'precision' facet on " + obj.getElement());
            }
        }
    }

    private void readTz(Obj obj, int code) throws IOException {
        String tz = this.readStrVal(code);
        switch (obj.getBinCode()) {
            case 32: {
                ((Abstime)obj).setTz(tz);
                break;
            }
            case 44: {
                ((Time)obj).setTz(tz);
                break;
            }
            case 40: {
                ((Date)obj).setTz(tz);
                break;
            }
            default: {
                throw new IOException("Invalid 'tz' facet on " + obj.getElement());
            }
        }
    }

    private boolean readBoolVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException("Invalid bool value code 0x" + Integer.toHexString(code));
    }

    private long readIntVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                return this.din.readUnsignedByte();
            }
            case 1: {
                return this.din.readUnsignedShort();
            }
            case 2: {
                return this.din.readInt();
            }
            case 3: {
                return this.din.readLong();
            }
        }
        throw new IOException("Invalid int value code 0x" + Integer.toHexString(code));
    }

    private double readRealVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                return this.din.readFloat();
            }
            case 1: {
                return this.din.readDouble();
            }
        }
        throw new IOException("Invalid float value code 0x" + Integer.toHexString(code));
    }

    private Abstime readAbstimeVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                return new Abstime((long)this.din.readInt() * 1000L + 946684800000L);
            }
            case 1: {
                return new Abstime(this.din.readLong() / 1000000L + 946684800000L);
            }
        }
        throw new IOException("Invalid abstime value code 0x" + Integer.toHexString(code));
    }

    private Reltime readReltimeVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                return new Reltime((long)this.din.readInt() * 1000L);
            }
            case 1: {
                return new Reltime(this.din.readLong() / 1000000L);
            }
        }
        throw new IOException("Invalid reltime value code 0x" + Integer.toHexString(code));
    }

    private Time readTimeVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                return new Time((long)this.din.readInt() * 1000L);
            }
            case 1: {
                return new Time(this.din.readLong() / 1000000L);
            }
        }
        throw new IOException("Invalid time value code 0x" + Integer.toHexString(code));
    }

    private Date readDateVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                return new Date(this.din.readUnsignedShort(), this.din.readUnsignedByte(), this.din.readUnsignedByte());
            }
        }
        throw new IOException("Invalid date value code 0x" + Integer.toHexString(code));
    }

    private Contract readContractVal(int code) throws IOException {
        return new Contract(this.readStrVal(code));
    }

    private Status readStatusVal(int code) throws IOException {
        switch (code & 0x7F) {
            case 76: {
                return Status.disabled;
            }
            case 77: {
                return Status.fault;
            }
            case 78: {
                return Status.down;
            }
            case 79: {
                return Status.unackedAlarm;
            }
            case 80: {
                return Status.alarm;
            }
            case 81: {
                return Status.unacked;
            }
            case 82: {
                return Status.overridden;
            }
        }
        throw new IOException("Invalid status value code 0x" + Integer.toHexString(code));
    }

    private String readStrVal(int code) throws IOException {
        switch (code & 3) {
            case 0: {
                String str = this.readStr();
                this.strTable.add(str);
                return str;
            }
            case 1: {
                int index = this.din.readUnsignedShort();
                if (index >= this.strTable.size()) {
                    throw new IOException("Str table index out of bounds " + index + " >= " + this.strTable.size());
                }
                return this.strTable.get(index);
            }
        }
        throw new IOException("Invalid str value code 0x" + Integer.toHexString(code));
    }

    String readStr() throws IOException {
        int c;
        StringBuilder s = new StringBuilder();
        while ((c = this.din.readUnsignedByte()) != 0) {
            s.append((char)c);
        }
        return s.toString();
    }
}

