/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import obix.asm.Assembler;
import obix.asm.AttributeInfo;
import obix.asm.Buffer;
import obix.asm.ConstantPool;
import obix.asm.Jvm;

public class Code
extends AttributeInfo {
    public final ConstantPool cp;
    public int maxStack = 10;
    public int maxLocals = 10;
    public Buffer code = new Buffer(512);

    public Code(Assembler asm) {
        super(asm, "Code");
        this.cp = asm.cp;
    }

    public int add(int opcode) {
        if (Jvm.OPCODE_ARGS[opcode] != 0) {
            throw new IllegalStateException("Opcode requires arguments: " + opcode);
        }
        return this.code.u1(opcode);
    }

    public int add(int opcode, int arg) {
        int ref = this.code.count;
        if (opcode == 18) {
            if (arg < 255) {
                this.code.u1(18);
                this.code.u1(arg);
            } else {
                this.code.u1(19);
                this.code.u2(arg);
            }
            return ref;
        }
        byte argType = Jvm.OPCODE_ARGS[opcode];
        this.code.u1(opcode);
        if (argType == 1) {
            this.code.u1(arg);
        } else if (argType == 2) {
            this.code.u2(arg);
        } else {
            throw new IllegalStateException("Opcode does not take u1 or u2 args: " + opcode);
        }
        return ref;
    }

    public int addIntConst(int v) {
        switch (v) {
            case -1: {
                return this.add(2);
            }
            case 0: {
                return this.add(3);
            }
            case 1: {
                return this.add(4);
            }
            case 2: {
                return this.add(5);
            }
            case 3: {
                return this.add(6);
            }
            case 4: {
                return this.add(7);
            }
            case 5: {
                return this.add(8);
            }
        }
        if (-128 <= v && v <= 127) {
            return this.add(16, v);
        }
        if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
            return this.add(17, v);
        }
        return this.add(18, this.cp.integer(v));
    }

    public int addPad(int opcode) {
        int ref = this.code.u1(opcode);
        int pad = 3 - ref % 4;
        for (int i = 0; i < pad; ++i) {
            this.code.u1(0);
        }
        return ref;
    }

    public int invoke(Method m) {
        int method = this.cp.method(m);
        int flags = m.getModifiers();
        if (Modifier.isInterface(flags)) {
            return this.invokeInterface(method, m.getParameterTypes().length + 1);
        }
        if (Modifier.isStatic(flags)) {
            return this.add(184, method);
        }
        return this.add(182, method);
    }

    public int invokeInterface(int method, int nargs) {
        int ref = this.code.count;
        this.code.u1(185);
        this.code.u2(method);
        this.code.u1(nargs);
        this.code.u1(0);
        return ref;
    }

    @Override
    void compile(Buffer buf) {
        int len = 8 + this.code.count + 4;
        buf.u2(this.name);
        buf.u4(len);
        buf.u2(this.maxStack);
        buf.u2(this.maxLocals);
        buf.u4(this.code.count);
        buf.append(this.code);
        buf.u2(0);
        buf.u2(0);
    }
}

