/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Val;

public class Reltime
extends Val {
    private long val;
    private Reltime min;
    private Reltime max;

    public Reltime(String name, long millis) {
        super(name);
        this.set(millis);
    }

    public Reltime(String name) {
        super(name);
        this.set(0L);
    }

    public Reltime(long millis) {
        this.set(millis);
    }

    public Reltime() {
        this.set(0L);
    }

    public long getMillis() {
        return this.val;
    }

    public long get() {
        return this.val;
    }

    public void set(long millis) {
        this.val = millis;
    }

    @Override
    public String getElement() {
        return "reltime";
    }

    @Override
    public int getBinCode() {
        return 36;
    }

    @Override
    public boolean valEquals(Val that) {
        if (that instanceof Reltime) {
            return ((Reltime)that).val == this.val;
        }
        return false;
    }

    @Override
    public int compareTo(Val that) {
        long a = this.val;
        long b = ((Reltime)that).val;
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String encodeVal() {
        StringBuilder s = new StringBuilder();
        if (this.val < 0L) {
            s.append('-');
        }
        s.append("PT");
        long abs = Math.abs(this.val);
        long sec = abs / 1000L;
        long frac = abs % 1000L;
        s.append(sec);
        if (frac != 0L) {
            s.append('.');
            if (frac < 10L) {
                s.append("00");
            } else if (frac < 100L) {
                s.append("0");
            }
            s.append(frac);
        }
        s.append('S');
        return s.toString();
    }

    public static Reltime parse(String s) throws Exception {
        Reltime r = new Reltime();
        r.decodeVal(s);
        return r;
    }

    @Override
    public void decodeVal(String s) throws Exception {
        try {
            long millis = 0L;
            boolean neg = false;
            Parser p = new Parser(s);
            if (p.cur == 45) {
                neg = true;
                p.consume();
            } else if (p.cur == 43) {
                p.consume();
            }
            p.consume(80);
            if (p.cur == -1) {
                throw new Exception();
            }
            int num = p.num();
            if (p.cur == 68) {
                p.consume();
                millis += (long)num * 24L * 60L * 60L * 1000L;
                num = p.num();
            }
            if (num >= 0 && p.cur == 72) {
                if (!p.time) {
                    throw new Exception();
                }
                p.consume();
                millis += (long)num * 60L * 60L * 1000L;
                num = p.num();
            }
            if (num >= 0 && p.cur == 77) {
                if (!p.time) {
                    throw new Exception();
                }
                p.consume();
                millis += (long)num * 60L * 1000L;
                num = p.num();
            }
            if (num >= 0 && p.cur == 83 || p.cur == 46) {
                if (!p.time) {
                    throw new Exception();
                }
                millis += (long)num * 1000L;
                if (p.cur == 46) {
                    p.consume();
                    millis += (long)p.frac();
                }
                p.consume(83);
            }
            if (p.cur != -1) {
                throw new Exception();
            }
            if (neg) {
                millis *= -1L;
            }
            this.set(millis);
        }
        catch (Exception e) {
            throw new Exception("Invalid reltime: " + s);
        }
    }

    @Override
    public String encodeJava() {
        return String.valueOf(this.val) + "L";
    }

    public Reltime getMin() {
        return this.min;
    }

    public void setMin(Reltime min) {
        this.min = min;
    }

    public Reltime getMax() {
        return this.max;
    }

    public void setMax(Reltime max) {
        this.max = max;
    }

    static class Parser {
        String s;
        int off;
        int cur;
        boolean curIsDigit;
        boolean time;

        Parser(String s) {
            this.s = s;
            this.cur = s.charAt(0);
        }

        int frac() {
            int millis = 0;
            if (this.curIsDigit) {
                millis += this.digit() * 100;
                this.consume();
                if (this.curIsDigit) {
                    millis += this.digit() * 10;
                    this.consume();
                    if (this.curIsDigit) {
                        millis += this.digit();
                        this.consume();
                        while (this.curIsDigit) {
                            this.consume();
                        }
                    }
                }
            }
            return millis;
        }

        int num() {
            if (this.cur == 84) {
                this.time = true;
                this.consume();
            }
            int num = 0;
            while (this.curIsDigit) {
                num = num * 10 + this.digit();
                this.consume();
            }
            return num;
        }

        int digit() {
            return this.cur - 48;
        }

        void consume(int ch) {
            if (this.cur != ch) {
                throw new IllegalStateException();
            }
            this.consume();
        }

        void consume() {
            ++this.off;
            if (this.off < this.s.length()) {
                this.cur = this.s.charAt(this.off);
                this.curIsDigit = 48 <= this.cur && this.cur <= 57;
            } else {
                this.cur = -1;
                this.curIsDigit = false;
            }
        }
    }
}

