/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.search;

import com.tridium.util.CompUtil;
import java.lang.ref.SoftReference;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ord", type="BOrd", defaultValue="BOrd.NULL", flags=3), @NiagaraProperty(name="epoch", type="BSimple", defaultValue="BAbsTime.NULL", flags=3)})
public final class BSearchResult
extends BComponent {
    @Generated
    public static final Property ord = BSearchResult.newProperty((int)3, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property epoch = BSearchResult.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSearchResult.class);
    private static final Id historyTagId = Id.newId((String)"n:history");
    private static final String N_TYPE_SLOT_NAME = SlotPath.escape((String)"n:type");
    private static final String N_DISPLAYNAME_SLOT_NAME = SlotPath.escape((String)"n:displayName");
    private static final String N_HISTORY_SLOT_NAME = SlotPath.escape((String)"n:history");
    private SoftReference<BIObject> object;

    @Generated
    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    @Generated
    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    @Generated
    public BSimple getEpoch() {
        return (BSimple)this.get(epoch);
    }

    @Generated
    public void setEpoch(BSimple v) {
        this.set(epoch, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSearchResult() {
        this(BOrd.DEFAULT, null, (BSimple)BAbsTime.DEFAULT);
    }

    private BSearchResult(BOrd ord, BIObject object, BSimple epoch) {
        this.setOrd(ord == null ? BOrd.DEFAULT : ord);
        if (object != null) {
            this.object = new SoftReference<BIObject>(object);
        }
        this.setEpoch((BSimple)(epoch == null ? BAbsTime.now() : epoch));
    }

    public static BSearchResult make(BOrd ord) {
        return new BSearchResult(ord, null, null);
    }

    public static BSearchResult make(BOrd ord, BIObject object) {
        return BSearchResult.make(ord, object, null);
    }

    public static BSearchResult make(BOrd ord, BIObject object, BSimple epoch) {
        BSearchResult result = new BSearchResult(ord, object, epoch);
        if (object instanceof Entity) {
            result.applyTags((Entity)object, null);
        }
        return result;
    }

    public BIObject getObject() {
        BObject obj;
        if (!(this.object != null && this.object.get() != null || this.getOrd().equals((Object)BOrd.DEFAULT) || (obj = this.getOrd().resolve().get()) == null)) {
            this.object = new SoftReference<BObject>(obj);
            if (obj instanceof BINavNode) {
                BINavNode navNode = (BINavNode)obj;
                this.setOrd(navNode.getNavOrd().relativizeToSession());
                CompUtil.setOrAdd((BComponent)this, (String)N_TYPE_SLOT_NAME, (BValue)BString.make((String)obj.getType().toString()), null);
                CompUtil.setOrAdd((BComponent)this, (String)N_DISPLAYNAME_SLOT_NAME, (BValue)BString.make((String)navNode.getNavDisplayName(null)), null);
            }
        }
        if (this.object != null) {
            return this.object.get();
        }
        return null;
    }

    public void setObject(BIObject object) {
        if (object != null) {
            this.object = new SoftReference<BIObject>(object);
        }
    }

    public boolean hasObject() {
        return this.object != null && this.object.get() != null;
    }

    void applyTags(Entity e, Context cx) {
        Optional historyTag;
        String displayName;
        Tags tags = e.tags();
        if (!this.applyTagIfPresent(tags, "n:displayName") && e instanceof BComplex && (displayName = ((BComplex)e).getDisplayName(null)) != null) {
            this.add(N_DISPLAYNAME_SLOT_NAME, (BValue)BString.make((String)displayName));
        }
        if (!this.applyTagIfPresent(tags, "n:type") && e instanceof BIObject) {
            this.add(N_TYPE_SLOT_NAME, (BValue)BString.make((String)((BIObject)e).getType().toString()));
        }
        if (!(e instanceof BIObject) && (historyTag = tags.get(historyTagId)).isPresent()) {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            try (HistorySpaceConnection conn = service.getDatabase().getConnection(cx);){
                BIHistory history = conn.getHistory(BHistoryId.make((String)((BIDataValue)historyTag.get()).toString()));
                if (history == null || !history.getPermissions(cx).hasOperatorRead()) {
                    return;
                }
            }
            catch (Exception ex) {
                return;
            }
        }
        if (!this.applyTagIfPresent(tags, "n:history") && e instanceof BControlPoint) {
            BHistoryId.getHistoryIdFromPoint((BControlPoint)((BControlPoint)e)).ifPresent(id -> this.add(N_HISTORY_SLOT_NAME, (BValue)BString.make((String)id.toString())));
        }
    }

    private boolean applyTagIfPresent(Tags tags, String tagName) {
        Optional maybe = tags.get(Id.newId((String)tagName));
        if (maybe.isPresent()) {
            CompUtil.setOrAdd((BComponent)this, (String)SlotPath.escape((String)tagName), (BValue)((BValue)((BIDataValue)maybe.get()).as(BValue.class)), null);
            return true;
        }
        return false;
    }
}

