/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.auth;

import com.tridium.awsUtils.BAwsService;
import com.tridium.awsUtils.auth.AwsAuthException;
import com.tridium.awsUtils.auth.AwsAuthUtils;
import com.tridium.awsUtils.auth.BAwsAccessKey;
import com.tridium.awsUtils.auth.BAwsStoredAccessKey;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="add", parameterType="BAwsAccessKey", defaultValue="new BAwsAccessKey()"), @NiagaraAction(name="purgeKeys", flags=20), @NiagaraAction(name="rollKeyMaterial", flags=20), @NiagaraAction(name="cleanupPurgedKeys")})
public final class BAwsAccessKeyFolder
extends BFolder {
    @Generated
    public static final Action add = BAwsAccessKeyFolder.newAction((int)0, (BValue)new BAwsAccessKey(), null);
    @Generated
    public static final Action purgeKeys = BAwsAccessKeyFolder.newAction((int)20, null);
    @Generated
    public static final Action rollKeyMaterial = BAwsAccessKeyFolder.newAction((int)20, null);
    @Generated
    public static final Action cleanupPurgedKeys = BAwsAccessKeyFolder.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAwsAccessKeyFolder.class);
    private Clock.Ticket purgeTicket;
    private Clock.Ticket cleanupTicket;
    private Clock.Ticket keyMaterialTicket;
    private static final BIcon ICON = BIcon.make((BIcon)BIcon.std((String)"folder.png"), (BIcon)BIcon.std((String)"badges/keys.png"));
    private static final String MAX_KM_AGE_PROP = "aws.max.km.age";
    private static final long MAX_AGE_MINIMUM = 60000L;
    private static final long MAX_KM_AGE = Long.parseLong(AccessController.doPrivileged(() -> System.getProperty(MAX_KM_AGE_PROP, String.valueOf(31536000000L))));

    @Generated
    public void add(BAwsAccessKey parameter) {
        this.invoke(add, (BValue)parameter, null);
    }

    @Generated
    public void purgeKeys() {
        this.invoke(purgeKeys, null, null);
    }

    @Generated
    public void rollKeyMaterial() {
        this.invoke(rollKeyMaterial, null, null);
    }

    @Generated
    public void cleanupPurgedKeys() {
        this.invoke(cleanupPurgedKeys, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BAwsService;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BAwsStoredAccessKey;
    }

    public void started() throws Exception {
        if (Sys.isStation()) {
            this.purgeKeys();
            this.scheduleCleanup();
            this.rollKeyMaterial();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        new Thread((Runnable)new Invocation((BComponent)this, action, argument, cx), "awsKeysFolder").start();
        return null;
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (Sys.isStation() && oldValue instanceof BAwsStoredAccessKey) {
            BAwsStoredAccessKey stored = (BAwsStoredAccessKey)oldValue.as(BAwsStoredAccessKey.class);
            try {
                AwsAuthUtils.removeFromKeyRing(stored);
            }
            catch (Exception e) {
                AwsAuthUtils.LOG.log(Level.SEVERE, "Failed to clear keyring entry for AWS Access Key: " + stored.getAccessKeyId(), e);
            }
        }
    }

    public void doAdd(BAwsAccessKey accessKey) throws AwsAuthException, PrivilegedActionException {
        BAwsStoredAccessKey storedAccessKey = AwsAuthUtils.saveToKeyRing(accessKey);
        if (accessKey.getStorageTime().equals((Object)BRelTime.DEFAULT)) {
            throw new AwsAuthException(BAwsService.LEX.getText("missing.expiry.value"));
        }
        storedAccessKey.setPurgeDate(BAbsTime.now().add(accessKey.getStorageTime()));
        String slotName = SlotPath.escape((String)storedAccessKey.getAccessKeyId());
        this.add(slotName, (BValue)storedAccessKey);
        this.doPurgeKeys();
    }

    public void doPurgeKeys() {
        BAwsStoredAccessKey[] storedKeys = (BAwsStoredAccessKey[])this.getChildren(BAwsStoredAccessKey.class);
        BAbsTime nextPurge = null;
        for (BAwsStoredAccessKey storedAccessKey : storedKeys) {
            BAbsTime purgeDate = storedAccessKey.getPurgeDate();
            if (storedAccessKey.getStored() && purgeDate.getMillis() <= BAbsTime.now().getMillis()) {
                AwsAuthUtils.purge(storedAccessKey);
                continue;
            }
            if (nextPurge != null && !purgeDate.isBefore(nextPurge)) continue;
            nextPurge = purgeDate;
        }
        if (nextPurge != null && nextPurge.isAfter(BAbsTime.now())) {
            this.schedulePurge(nextPurge);
        }
    }

    public void doCleanupPurgedKeys() {
        BAwsStoredAccessKey[] storedKeys = (BAwsStoredAccessKey[])this.getChildren(BAwsStoredAccessKey.class);
        Arrays.stream(storedKeys).filter(storedKey -> !storedKey.getStored()).forEach(storedKey -> this.remove(storedKey.getName()));
    }

    public void doRollKeyMaterial() {
        if (this.keyMaterialTicket != null && !this.keyMaterialTicket.isExpired()) {
            this.keyMaterialTicket.cancel();
        }
        long maxAgeMillis = Math.max(MAX_KM_AGE, 60000L);
        AwsAuthUtils.rollKeyMaterial(maxAgeMillis);
        long nextCheckMillis = Math.min(maxAgeMillis, 86400000L);
        this.keyMaterialTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)nextCheckMillis), (Action)rollKeyMaterial, null);
    }

    private void schedulePurge(BAbsTime purgeDate) {
        if (this.purgeTicket != null && !this.purgeTicket.isExpired()) {
            this.purgeTicket.cancel();
        }
        if (AwsAuthUtils.LOG.isLoggable(Level.FINE)) {
            AwsAuthUtils.LOG.fine(String.format("Scheduled next access key purge at %s", purgeDate));
        }
        this.purgeTicket = Clock.schedule((BComponent)this, (BAbsTime)purgeDate, (Action)purgeKeys, null);
    }

    private void scheduleCleanup() {
        if (this.cleanupTicket != null && !this.cleanupTicket.isExpired()) {
            this.cleanupTicket.cancel();
        }
        this.cleanupTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.DAY, (Action)cleanupPurgedKeys, null);
    }

    public BIcon getIcon() {
        return ICON;
    }
}

