/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils;

import com.tridium.nre.security.NiagaraBasicPermission;
import java.security.Permission;
import java.util.regex.Pattern;
import javax.baja.naming.SlotPath;

public final class AwsUtils {
    private static final Pattern LEGAL_REGION_REGEX = Pattern.compile("^[a-zA-Z0-9-]+$");

    private AwsUtils() {
    }

    public static void checkAwsPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new NiagaraBasicPermission("MANAGE_AWS_ASSETS"));
        }
    }

    public static String sanitizeRegionForUrl(String region) {
        String unescRegion = SlotPath.unescape((String)region);
        if (LEGAL_REGION_REGEX.matcher(unescRegion).matches()) {
            return unescRegion;
        }
        throw new IllegalArgumentException("Illegal region characters");
    }
}

