/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.control.ui.trigger;

import java.util.ArrayList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BPane;

@NiagaraType
public class BWidgetSwapper
extends BPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BWidgetSwapper.class);
    private ArrayList<BWidget> widgets = new ArrayList();
    private BWidget current;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void addWidget(BWidget w) {
        this.widgets.add(w);
        if (this.widgets.size() == 1) {
            this.setDisplay(w);
        }
        this.relayout();
    }

    public void removeWidget(BWidget w) {
        this.widgets.remove(w);
        this.relayout();
    }

    public void computePreferredSize() {
        int count = this.widgets.size();
        double pw = 0.0;
        double ph = 0.0;
        for (int i = 0; i < count; ++i) {
            BWidget w = this.widgets.get(i);
            w.computePreferredSize();
            pw = Math.max(pw, w.getPreferredWidth());
            ph = Math.max(ph, w.getPreferredHeight());
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        if (this.current != null) {
            double h = this.getHeight();
            this.current.computePreferredSize();
            this.current.setBounds(0.0, (h - this.current.getPreferredHeight()) / 2.0, this.current.getPreferredWidth(), this.current.getPreferredHeight());
        }
    }

    public void setDisplay(BWidget w) {
        if (this.current == w) {
            return;
        }
        if (this.current != null) {
            this.remove((BComplex)this.current);
        }
        this.current = w;
        if (this.current != null) {
            if (!this.widgets.contains(this.current)) {
                this.widgets.add(this.current);
            }
            this.add(null, (BValue)this.current);
        }
        this.relayout();
    }

    public BWidget getDisplay() {
        return this.current;
    }
}

