/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BStringPromptDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.file.BListView;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="handleTextModified", flags=4)
public class BCreateFileDialog
extends BEdgePane {
    @Generated
    public static final Action handleTextModified = BCreateFileDialog.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCreateFileDialog.class);
    private FileChooserModel model;
    private BListView listView;
    private BTreeView treeView;
    private BLabel currentDirectoryLabel;
    private BTextField fileNameTextField;
    private Ok okCommand;
    private NewDirCommand newDirCommand;
    private UpLevelCommand upLevelCommand;
    private String defaultExtension;
    private static Lexicon lex = null;

    @Generated
    public void handleTextModified() {
        this.invoke(handleTextModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BCreateFileDialog(BImage icon, String title, String message, BIFile initialDir, String defaultExtension) {
        this.defaultExtension = defaultExtension;
        this.model = new FileChooserModel((BSpace)BFileSystem.INSTANCE);
        this.model.setSupport((FileChooserModel.Support)new FileBrowserSupport());
        this.listView = new BListView(this.model);
        this.listView.setDetailsView();
        this.listView.setMultipleSelection(false);
        this.treeView = new BTreeView(this.model);
        this.treeView.setController((TreeController)new Controller());
        BSplitPane split = new BSplitPane();
        split.setDividerPosition(33.0);
        split.setWidget1((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BFlowPane toolFlow = new BFlowPane(BHalign.left);
        this.currentDirectoryLabel = new BLabel();
        toolFlow.add(null, (BValue)this.currentDirectoryLabel);
        BToolBar tools = new BToolBar();
        tools.add(null, (BValue)new BSeparator());
        tools.add(null, (Command)new HomeCommand());
        this.upLevelCommand = new UpLevelCommand();
        tools.add(null, (Command)this.upLevelCommand);
        this.newDirCommand = new NewDirCommand();
        tools.add(null, (Command)this.newDirCommand);
        toolFlow.add(null, (BValue)tools);
        split.setWidget2((BWidget)new BEdgePane((BWidget)toolFlow, null, null, null, (BWidget)new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
        this.setTop((BWidget)new BWizardHeader(icon, title, message == null ? "" : message));
        BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)split, 6.0, 4.0, 4.0, 4.0));
        pane.setFixedSize(550.0, 330.0);
        this.setCenter((BWidget)pane);
        BGridPane bottomGrid = new BGridPane(1);
        bottomGrid.setColumnAlign(BHalign.center);
        BGridPane textAndFilters = new BGridPane(2);
        textAndFilters.setColumnAlign(BHalign.left);
        textAndFilters.add(null, (BValue)new BLabel(BCreateFileDialog.lex().getText("CreateFileDialog.fileNameLabel")));
        this.fileNameTextField = new BTextField("", 40, true);
        textAndFilters.add(null, (BValue)this.fileNameTextField);
        this.linkTo((BComponent)this.fileNameTextField, (Slot)BTextEditor.textModified, (Slot)handleTextModified);
        bottomGrid.add(null, (BValue)textAndFilters);
        this.setBottom((BWidget)new BBorderPane((BWidget)bottomGrid, 0.0, 4.0, 6.0, 4.0));
        if (initialDir != null && initialDir.isDirectory()) {
            this.model.setDirectory((BINavNode)initialDir);
            this.treeView.scrollToVisible((BINavNode)initialDir);
            this.currentDirectoryLabel.setImage(BImage.make((BIcon)initialDir.getNavIcon()));
            this.currentDirectoryLabel.setText(initialDir.getFileName());
        }
        this.okCommand = new Ok();
    }

    public static FilePath getPath(BWidget owner, BIFile initialDir, String defaultExtension) {
        return BCreateFileDialog.getPath(owner, BImage.make((String)BCreateFileDialog.lex().getText("CreateFileDialog.defaultIcon")), BCreateFileDialog.lex().getText("CreateFileDialog.defaultTitle"), "", initialDir, defaultExtension);
    }

    public static FilePath getPath(BWidget owner, BImage dlgIcon, String dlgTitle, String dlgMessage, BIFile initialDir, String defaultExtension) {
        BCreateFileDialog content = new BCreateFileDialog(dlgIcon, dlgTitle, dlgMessage, initialDir, defaultExtension);
        if (1 == BCommandDialog.open((BWidget)owner, (String)dlgTitle, (Object)((Object)content), (DialogCommand[])new DialogCommand[]{content.getOkCommand(), DialogCommand.makeCancel((BWidget)owner)})) {
            return content.getFilePath();
        }
        return null;
    }

    public FilePath getFilePath() {
        String fileName = this.fileNameTextField.getText();
        if (BajaFileUtil.getExtension((String)fileName) == null && this.defaultExtension != null) {
            fileName = fileName + '.' + this.defaultExtension;
        }
        return ((BIFile)this.model.getDirectory()).getFilePath().merge(fileName);
    }

    private DialogCommand getOkCommand() {
        return this.okCommand;
    }

    private static Lexicon lex() {
        if (lex == null) {
            lex = TYPE.getModule().getLexicon();
        }
        return lex;
    }

    public void doHandleTextModified() {
        this.okCommand.checkEnabled();
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void mouseSelection(TreeNode target, BMouseEvent evt) {
            super.mouseSelection(target, evt);
            BCreateFileDialog.this.listView.getSelection().deselectAll();
        }

        protected void doSelectAction(TreeNode target, double x, double y) {
            BINavNode navNode = BCreateFileDialog.this.treeView.getFileForNode(target);
            if (navNode != null) {
                BCreateFileDialog.this.model.setDirectory(navNode);
            }
        }
    }

    class HomeCommand
    extends Command {
        public HomeCommand() {
            super((BWidget)BCreateFileDialog.this, TYPE.getModule(), "CreateFileDialog.home");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory dir = BFileSystem.INSTANCE.getSysHome();
                BCreateFileDialog.this.model.setDirectory((BINavNode)dir);
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    class NewDirCommand
    extends Command {
        public NewDirCommand() {
            super((BWidget)BCreateFileDialog.this, TYPE.getModule(), "CreateFileDialog.newDir");
            this.checkEnabled();
        }

        public void checkEnabled() {
            this.setEnabled(BCreateFileDialog.this.model != null && BCreateFileDialog.this.model.getDirectory() != null);
        }

        public CommandArtifact doInvoke() {
            try {
                String dirName = BStringPromptDialog.getString((BWidget)BCreateFileDialog.this, null, (String)BCreateFileDialog.lex().getText("CreateFileDialog.newDir.nameTitle"), (String)BCreateFileDialog.lex().getText("CreateFileDialog.newDir.nameMessage"));
                if (dirName != null && BCreateFileDialog.this.model.getDirectory() != null) {
                    FilePath newDirPath = ((BIFile)BCreateFileDialog.this.model.getDirectory()).getFilePath().merge(dirName);
                    BFileSystem.INSTANCE.makeDir(newDirPath, null);
                    BCreateFileDialog.this.model.setDirectory(BCreateFileDialog.this.model.getDirectory());
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    class UpLevelCommand
    extends Command {
        public UpLevelCommand() {
            super((BWidget)BCreateFileDialog.this, TYPE.getModule(), "CreateFileDialog.upLevel");
            this.checkEnabled();
        }

        public void checkEnabled() {
            this.setEnabled(BCreateFileDialog.this.model != null && BCreateFileDialog.this.model.getDirectory() != null);
        }

        public CommandArtifact doInvoke() {
            try {
                BCreateFileDialog.this.model.moveUpDirectory();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    class Ok
    extends DialogCommand {
        public Ok() {
            super((BWidget)BCreateFileDialog.this, 1, UiLexicon.bajaui().getText("dialog.ok"));
            this.checkEnabled();
        }

        public void checkEnabled() {
            this.setEnabled(BCreateFileDialog.this.model.getDirectory() != null && BCreateFileDialog.this.fileNameTextField.getText().trim().length() > 0);
        }
    }

    class FileBrowserSupport
    extends FileChooserModel.Support {
        FileBrowserSupport() {
        }

        public void pathModified() {
            BCreateFileDialog.this.listView.populateChildren();
            BCreateFileDialog.this.listView.relayout();
            BIFile dir = (BIFile)BCreateFileDialog.this.model.getDirectory();
            BCreateFileDialog.this.newDirCommand.checkEnabled();
            BCreateFileDialog.this.upLevelCommand.checkEnabled();
            if (dir != null) {
                BCreateFileDialog.this.treeView.scrollToVisible((BINavNode)dir);
                BCreateFileDialog.this.currentDirectoryLabel.setImage(BImage.make((BIcon)dir.getNavIcon()));
                BCreateFileDialog.this.currentDirectoryLabel.setText(dir.getFileName());
                BCreateFileDialog.this.currentDirectoryLabel.relayout();
            }
        }

        public void selectionModified() {
            BIFile[] selectedFiles = BCreateFileDialog.this.model.getSelectedFiles();
            if (selectedFiles.length == 0) {
                return;
            }
            BCreateFileDialog.this.treeView.getSelection().deselectAll();
            if (!(selectedFiles[0] instanceof BIDirectory)) {
                BCreateFileDialog.this.fileNameTextField.setText(selectedFiles[0].getFileName());
            }
        }

        public void chooseSelectedFiles() {
        }
    }
}

