/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.stationtransfer;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BRemoteModuleList;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.util.FileLock;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopier;
import com.tridium.platDaemon.ui.stationtransfer.BStationCopierOptions;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platDaemon.ui.stationtransfer.FinalStep;
import com.tridium.platDaemon.ui.stationtransfer.StationNameController;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BDirectoryTree;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.platform.ui.util.EnumRadioGroup;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.BViewScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.platform.BStationStatus;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.PatternFilter;
import javax.baja.workbench.BWbShell;

public class StationWizardModel
extends WizardModel {
    BDirectoryTree.DirectoryTreeModel directoryTreeModel;
    private BDirectory stationDir;
    private String targetStationName = null;
    private final BDaemonSession session;
    private boolean promptForPassPhrase = false;
    private SecretChars stationBogPassPhrase = null;
    private PBEEncodingInfo encodingInfo = null;
    private final DependencyUtil.AnalysisResults analysisResults;
    private final DaemonSessionTaskHandler sessionTaskHandler;
    private final List<String> stationsToDelete = new ArrayList<String>();
    private boolean isLocalToRemote;
    private boolean startStation = true;
    private boolean autoStart = true;
    private boolean autoRestart = true;
    private final BStationCopier stationCopier;
    private boolean openApplicationDirector = false;
    private boolean isAxMigration = false;
    private BStationCopierOptions stationCopierOptions = null;
    private PatternFilter[] fileExcludePatterns = null;
    private PatternFilter[] directoryExcludePatterns = null;
    private BStationContentEnum stationContent = BStationContentEnum.configOnly;
    private BStationDispositionEnum stationDisposition = BStationDispositionEnum.replaceDuplicates;
    private StationWizardStep currentStep;
    private ContentStep contentStep;
    private final PassPhraseStep passPhraseStep;
    private final SetLocalPassPhraseStep setLocalPassPhraseStep;
    private final StationNameStep nameStep;
    private final CannotProceedStep cannotProceedStep;
    private final boolean shortCircuit;
    private FileLock localStationBogLock = null;
    private boolean sourceHasSubdirs = false;
    private boolean targetDirectoryExists = false;
    private boolean reboot = false;
    private final BDirectory targetStationsRoot;
    private boolean isSoftwareReadonly;
    private final BRemoteModuleList remoteModuleList;
    private BStationSurrogate stationSurrogate;
    public static final BImage WIZ_IMAGE = BImage.make((String)"module://icons/x32/sync.png");
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    private static final String IGNORE_STATION_DIR_DEF_NAME = "station.copy.ignoreDirectory";

    public static boolean open(BDirectory sourceStationDir, BDirectory targetStationsRoot, BRemoteModuleList remoteModuleList, BStationCopier plugin) throws Exception {
        return StationWizardModel.open(sourceStationDir, targetStationsRoot, remoteModuleList, plugin, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean open(BDirectory sourceStationDir, BDirectory targetStationsRoot, BRemoteModuleList remoteModuleList, BStationCopier plugin, boolean shortCircuit) throws Exception {
        BDaemonSession session = plugin.getDaemonSession();
        DaemonSessionTaskHandler sessionTaskHandler = new DaemonSessionTaskHandler((BWidget)plugin);
        DependencyUtil.AnalysisResults analysisResults = null;
        if (sourceStationDir.getStore() instanceof BLocalFileStore) {
            BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make((BDaemonSession)session, (DaemonSessionTaskListener)sessionTaskHandler);
            platform.loadPreferredVerificationMode();
            CertificateChainValidator certValidator = CertificateChainValidator.make((ICoreCryptoManager)new BPlatCryptoManager(platform.getDaemonSession()));
            analysisResults = DependencyUtil.analyzeAllDependencies((BDaemonPlatform)platform, (BFileSpace)sourceStationDir.getFileSpace(), (FilePath)sourceStationDir.getFilePath(), null, (DaemonSessionTaskListener)sessionTaskHandler, (CertificateChainValidator)certValidator);
            if (analysisResults.anyUnsolvable()) {
                boolean canCommission;
                boolean bl = canCommission = session.getHostProperties().hasFullAccess() && session.getHostProperties().isNiagara4() && !session.getHostProperties().getNiagaraR2Enabled() && !session.usesLocalNiagaraHome();
                if (!canCommission) {
                    BDialog.error((BWidget)plugin, (String)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.title"), (Object)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.message"));
                    return false;
                }
                if (4 == BDialog.confirm((BWidget)plugin, (String)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.title"), (Object)BDaemonSessionView.lexicon.getText("StationWizard.mustCommission.prompt"), (int)12)) {
                    try {
                        BDaemonSessionView.stopAllRefreshTimers(plugin.getWbShell(), session.getHost());
                        BWizard.open((BWidget)plugin, (WizardModel)new CommissioningWizardModel((BWidget)plugin, session, true));
                        boolean bl2 = true;
                        return bl2;
                    }
                    finally {
                        BDaemonSessionView.startAllRefreshTimers(plugin.getWbShell(), session.getHost());
                    }
                }
                return false;
            }
        }
        StationWizardModel model = new StationWizardModel(session, sessionTaskHandler, analysisResults, sourceStationDir, targetStationsRoot, remoteModuleList, plugin, shortCircuit);
        BWizard.open((BWidget)plugin, (WizardModel)model);
        plugin.resetAppSurrogates();
        if (model.shouldReboot()) {
            return false;
        }
        BWbShell shell = BWbShell.getWbShell((BWidget)plugin);
        if (model.openApplicationDirector() && shell != null) {
            shell.hyperlink(BOrd.make((BOrd)session.getNavOrd(), (OrdQuery)BViewScheme.INSTANCE.parse("platDaemon:ApplicationDirector")));
            return true;
        }
        return false;
    }

    private StationWizardModel(BDaemonSession session, DaemonSessionTaskHandler sessionTaskHandler, DependencyUtil.AnalysisResults analysisResults, BDirectory sourceStationDir, BDirectory targetStationsRoot, BRemoteModuleList remoteModuleList, BStationCopier plugin, boolean shortCircuit) throws Exception {
        String[] ignoreDirs;
        BDirectoryTree.DirectoryTreeNode dataRecoveryNode;
        BDirectoryTree.DirectoryTreeNode alarmNode;
        this.session = session;
        this.sessionTaskHandler = sessionTaskHandler;
        this.analysisResults = analysisResults;
        sessionTaskHandler = new DaemonSessionTaskHandler((BWidget)plugin);
        this.stationDir = sourceStationDir;
        this.targetStationsRoot = targetStationsRoot;
        this.remoteModuleList = remoteModuleList;
        this.isSoftwareReadonly = session.getHostProperties().getIsSoftwareReadonly();
        this.stationCopier = plugin;
        this.isLocalToRemote = sourceStationDir.getStore() instanceof BLocalFileStore;
        remoteModuleList.init((DaemonSessionTaskListener)sessionTaskHandler);
        this.directoryTreeModel = new BDirectoryTree.DirectoryTreeModel();
        this.directoryTreeModel.setRootDirectory(sourceStationDir);
        this.stationCopierOptions = BStationCopierOptions.make();
        this.isAxMigration = false;
        BDirectoryTree.DirectoryTreeNode histNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild("history");
        if (histNode != null) {
            if (!this.isAxMigration && session.getHostProperties().isNiagara4() && this.isLocalToRemote()) {
                boolean hdbFilePresent;
                boolean zipFilePresent = histNode.getDirectory().getNavChild("history.zip") != null;
                boolean bl = hdbFilePresent = histNode.getDirectory().getNavChild("station") != null;
                if (zipFilePresent && session.getHostProperties().getOsName().toLowerCase().contains("qnx") || hdbFilePresent && session.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
                    this.isAxMigration = true;
                }
            }
            if (this.isAxMigration()) {
                histNode.setChecked(true, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                histNode.setCheckEnabled(true, true);
                histNode.setExpanded(false);
            } else {
                histNode.setChecked(!this.isLocalToRemote() && this.stationCopierOptions.getCopyRemoteStationHistoryData(), BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                histNode.setCheckEnabled(!this.isLocalToRemote() && this.stationCopierOptions.getCopyRemoteStationHistoryData(), true);
                histNode.setExpanded(false);
            }
        }
        if ((alarmNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild("alarm")) != null) {
            if (!this.isAxMigration && session.getHostProperties().isNiagara4() && this.isLocalToRemote()) {
                boolean adbFilePresent;
                boolean zipFilePresent = alarmNode.getDirectory().getNavChild("alarm.zip") != null;
                boolean bl = adbFilePresent = alarmNode.getDirectory().getNavChild("alarm.adb") != null;
                if (zipFilePresent && session.getHostProperties().getOsName().toLowerCase().contains("qnx") || adbFilePresent && session.getHostProperties().getOsName().toLowerCase().startsWith("win")) {
                    this.isAxMigration = true;
                }
            }
            if (this.isAxMigration()) {
                alarmNode.setChecked(true, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                alarmNode.setCheckEnabled(true, true);
                alarmNode.setExpanded(false);
            } else {
                alarmNode.setChecked(!this.isLocalToRemote() && this.stationCopierOptions.getCopyRemoteStationAlarmData(), BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                alarmNode.setCheckEnabled(!this.isLocalToRemote() && this.stationCopierOptions.getCopyRemoteStationAlarmData(), true);
                alarmNode.setExpanded(false);
            }
        }
        if ((dataRecoveryNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild("dataRecovery")) != null) {
            dataRecoveryNode.setChecked(!this.isLocalToRemote() && this.stationCopierOptions.getCopyRemoteStationDataRecovery(), BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
            if (this.isLocalToRemote()) {
                dataRecoveryNode.setCheckEnabled(false, true);
                dataRecoveryNode.setExpanded(false);
            }
        }
        for (String string : ignoreDirs = Sys.getRegistry().getDefs(IGNORE_STATION_DIR_DEF_NAME)) {
            BDirectoryTree.DirectoryTreeNode ignoreDirNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0)).getChild(string);
            if (ignoreDirNode == null) continue;
            ignoreDirNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
            ignoreDirNode.setCheckEnabled(false, true);
            ignoreDirNode.setExpanded(false);
            BDaemonSessionView.log.log(Level.FINE, () -> "Excluding directory " + ignoreDirNode.getDirectory().getFilePath() + " in station transfer due to a '" + IGNORE_STATION_DIR_DEF_NAME + "' def specified in an installed module with a value of '" + ignoreDir + "'.");
        }
        try {
            this.sourceHasSubdirs = false;
            for (String string : this.getStationDirectory().listFiles()) {
                if (!string.isDirectory()) continue;
                this.sourceHasSubdirs = true;
                break;
            }
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.SEVERE, "error checking for station directory existence", e);
            this.sourceHasSubdirs = false;
        }
        this.setStationSurrogate(plugin.getStationSurrogate(sourceStationDir.getFileName(), true));
        if (this.isLocalToRemote && this.getStationSurrogate() != null) {
            this.setAutoStart(this.getStationSurrogate().getIsAutoStart());
            this.setAutoRestart(this.getStationSurrogate().getIsAutoRestart());
        }
        String fileExcludeList = this.stationCopierOptions.getFilePatternExcludeList();
        String directoryExcludeList = this.stationCopierOptions.getDirectoryPatternExcludeList();
        this.fileExcludePatterns = PatternFilter.parseList((String)fileExcludeList, (String)" ");
        this.directoryExcludePatterns = PatternFilter.parseList((String)directoryExcludeList, (String)" ");
        if (BDaemonSessionView.log.isLoggable(Level.FINE)) {
            StringBuilder patterns = new StringBuilder();
            for (PatternFilter fileExcludePattern : this.fileExcludePatterns) {
                patterns.append(fileExcludePattern.getPattern()).append(' ');
            }
            if (BDaemonSessionView.log.isLoggable(Level.FINE)) {
                BDaemonSessionView.log.fine("Excluding file patterns: \"" + patterns.toString() + "\" in station transfer");
            }
            patterns = new StringBuilder();
            for (PatternFilter directoryExcludePattern : this.directoryExcludePatterns) {
                patterns.append(directoryExcludePattern.getPattern()).append(' ');
            }
            if (BDaemonSessionView.log.isLoggable(Level.FINE)) {
                BDaemonSessionView.log.fine("Excluding directory patterns: \"" + patterns.toString() + "\" in station transfer");
            }
        }
        this.directoryTreeModel.setDirectoryStates((BDirectoryTree.DirectoryTreeNode)this.directoryTreeModel.getRoot(0), this.directoryExcludePatterns, false, false, false);
        this.reboot = this.isLocalToRemote() && !this.allowStationRestart();
        this.passPhraseStep = new PassPhraseStep();
        this.setLocalPassPhraseStep = new SetLocalPassPhraseStep();
        this.nameStep = new StationNameStep();
        DeleteStep deleteStep = new DeleteStep();
        this.nameStep.setNextStep(deleteStep);
        this.contentStep = new ContentStep();
        deleteStep.setNextStep(this.contentStep);
        DispositionStep dispositionStep = new DispositionStep();
        this.contentStep.setNextStep(dispositionStep);
        StartStationStep startStep = new StartStationStep();
        dispositionStep.setNextStep(startStep);
        DetailsStep detailsStep = new DetailsStep();
        startStep.setNextStep(detailsStep);
        ModulesStep modulesStep = new ModulesStep();
        detailsStep.setNextStep(modulesStep);
        StopStationStep stopStep = new StopStationStep();
        modulesStep.setNextStep(stopStep);
        RebootStep rebootStep = new RebootStep();
        stopStep.setNextStep(rebootStep);
        rebootStep.setNextStep(new ReviewStep());
        this.cannotProceedStep = new CannotProceedStep();
        this.shortCircuit = shortCircuit;
        if (shortCircuit) {
            this.setTargetStationName(this.getSourceStationName());
            this.setStationSurrogate(this.stationCopier.getStationSurrogate(this.getTargetStationName(), true));
            if (this.getStationSurrogate() != null) {
                this.setAutoStart(this.getStationSurrogate().getIsAutoStart());
                this.setAutoRestart(this.getStationSurrogate().getIsAutoRestart());
            }
            this.setStationContent(BStationContentEnum.everything);
            this.setStationDisposition(BStationDispositionEnum.clean);
        }
    }

    public void setWizard(BWizard wizard) {
        super.setWizard(wizard);
        this.sessionTaskHandler.setOwner((BWidget)wizard);
    }

    public String getTitle() {
        return BDaemonSessionView.lexicon.getText("StationWizard.title");
    }

    public boolean cancel() {
        if (this.getCurrentStep().getMode() == 0) {
            if (this.localStationBogLock != null) {
                try {
                    this.localStationBogLock.unlock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        if (BDialog.confirm((BWidget)this.getWizard(), (String)BDaemonSessionView.lexicon.getText("StationWizard.cancel.title"), (Object)BDaemonSessionView.lexicon.getText("StationWizard.cancel.message")) == 4 && this.getCurrentStep().cancel()) {
            if (this.localStationBogLock != null) {
                try {
                    this.localStationBogLock.unlock();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void init() {
        this.localStationBogLock = null;
        step = this.nameStep;
        if (this.isLocalToRemote()) {
            stationBog = (BBogFile)BFileSystem.INSTANCE.findFile(SystemFilePaths.getStationsDirPath((boolean)true).merge(this.getSourceStationName()).merge("config.bog"));
            if (stationBog != null) {
                if (stationBog.isModified()) {
                    this.cannotProceed("StationCopier.CannotProceedStep.message.uploadLocked");
                    return;
                }
                try {
                    if (stationBog.usesKeyRingEncryption()) {
                        this.cannotProceed("StationCopier.CannotProceedStep.message.cannotTransferKeyring");
                        return;
                    }
                    this.encodingInfo = stationBog.getPBEEncodingInfo();
                    v0 = this.promptForPassPhrase = stationBog.usesReversibleEncryptionPassPhrase() != false && this.encodingInfo != null && this.session.validateSystemPassPhrase((PBEValidator)this.encodingInfo) == false;
                    if (!this.promptForPassPhrase) ** GOTO lbl37
                    this.passPhraseStep.setNextStep(this.nameStep);
                    this.nameStep.setPriorStep(this.passPhraseStep);
                    step = this.passPhraseStep;
                }
                catch (Exception e) {
                    this.cannotProceed("StationCopier.CannotProceedStep.message.passPhraseError");
                    BDaemonSessionView.log.log(Level.SEVERE, "error processing bog password encoding", e);
                    return;
                }
            }
        } else {
            stationBog = (BBogFile)BFileSystem.INSTANCE.findFile(SystemFilePaths.getStationsDirPath((boolean)true).merge(this.getTargetStationName()).merge("config.bog"));
            if (stationBog != null) {
                localFile = ((BLocalFileStore)stationBog.getStore()).getLocalFile();
                try {
                    this.localStationBogLock = FileLock.lock((File)localFile);
                }
                catch (Exception e) {
                    this.cannotProceed("StationCopier.CannotProceedStep.message.downloadLocked");
                    return;
                }
            }
            this.setLocalPassPhraseStep.setNextStep(this.nameStep);
            this.nameStep.setPriorStep(this.setLocalPassPhraseStep);
            step = this.setLocalPassPhraseStep;
        }
lbl37:
        // 5 sources

        while (step != null && step.isSkipped()) {
            step = step.getNextStep();
        }
        if (step == null) {
            throw new IllegalStateException("Unexpected program error in StationWizardModel.init(): next step is null");
        }
        this.update(step);
        try {
            step.enter();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void back() {
        StationWizardStep step = this.getCurrentStep().getPriorStep();
        if (step != null && this.getCurrentStep().exit()) {
            this.update(step);
            try {
                step.enter();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    public void next() {
        StationWizardStep step = this.getCurrentStep().getNextStep();
        if (step != null && this.getCurrentStep().exit()) {
            while (step != null && step.isSkipped()) {
                step = step.getNextStep();
            }
            if (step == null) {
                throw new IllegalStateException("Unexpected program error in StationWizardModel.next(): next step is null");
            }
            step.setPriorStep(this.getCurrentStep());
            this.update(step);
            try {
                step.enter();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    public boolean finish() {
        if (this.localStationBogLock != null) {
            try {
                this.localStationBogLock.unlock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (new FinalStep(this).open()) {
            this.setOpenApplicationDirector();
        }
        return true;
    }

    private StationWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(StationWizardStep step) {
        this.currentStep = step;
        this.update(step.getWidget(), step.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(500.0, 330.0);
    }

    public void setReboot(boolean value) {
        this.reboot = value;
    }

    public boolean shouldReboot() {
        return this.reboot;
    }

    public BDirectory getStationDirectory() {
        return this.stationDir;
    }

    public String getSourceStationName() {
        return this.stationDir.getFileName();
    }

    public String getTargetStationName() {
        if (this.targetStationName == null) {
            this.targetStationName = this.getSourceStationName();
        }
        return this.targetStationName;
    }

    public void setTargetStationName(String value) {
        this.targetStationName = value;
        try {
            BDirectory targetStations = this.getTargetStationsRoot();
            BDirectory subdir = (BDirectory)targetStations.getNavChild(this.getTargetStationName());
            if (subdir == null) {
                this.targetDirectoryExists = false;
                this.stationContent = this.isAxMigration() ? BStationContentEnum.selectedDirectories : BStationContentEnum.everything;
            } else {
                this.targetDirectoryExists = true;
                this.stationContent = BStationContentEnum.configOnly;
            }
        }
        catch (Exception e) {
            BDaemonSessionView.log.log(Level.SEVERE, "error checking for station directory existance", e);
            this.targetDirectoryExists = false;
        }
    }

    public BDirectory getTargetStationsRoot() {
        return this.targetStationsRoot;
    }

    public BRemoteModuleList getRemoteModuleList() {
        return this.remoteModuleList;
    }

    public String getTargetSystemName() {
        return this.isLocalToRemote() ? "\"" + this.getDaemonSession().getRemoteAddressString() + "\"" : BDaemonSessionView.lexicon.getText("StationCopier.localSystemName");
    }

    public String getSourceSystemName() {
        return this.isLocalToRemote() ? BDaemonSessionView.lexicon.getText("StationCopier.localSystemName") : "\"" + this.getDaemonSession().getRemoteAddressString() + "\"";
    }

    public boolean isLocalToRemote() {
        return this.isLocalToRemote;
    }

    public boolean isAxMigration() {
        return this.isAxMigration;
    }

    public boolean allowStationRestart() {
        return this.getDaemonSession().getHostProperties().getAllowStationRestart();
    }

    public boolean mustStopStations() throws Exception {
        if (!this.isLocalToRemote()) {
            return false;
        }
        if (this.getDependencyAnalysis().getSolution().getToInstall().length > 0 && BStationSurrogate.isAnyStationRunning((BDaemonSession)this.getDaemonSession())) {
            return true;
        }
        return this.getStationSurrogate() != null && this.getStationSurrogate().isStationRunning();
    }

    public void setIsLocalToRemote(boolean value) {
        if (this.isLocalToRemote != value) {
            this.isLocalToRemote = value;
            this.stationDir = null;
            this.directoryTreeModel = new BDirectoryTree.DirectoryTreeModel();
        }
    }

    public void setStationContent(BStationContentEnum value) {
        this.stationContent = value;
    }

    public BStationContentEnum getStationContent() {
        return this.stationContent;
    }

    public void setStationDisposition(BStationDispositionEnum value) {
        this.stationDisposition = value;
    }

    public BStationDispositionEnum getStationDisposition() {
        return this.stationDisposition;
    }

    public DependencyUtil.AnalysisResults getDependencyAnalysis() {
        return this.analysisResults;
    }

    public BDaemonPlatform getDaemonPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.sessionTaskHandler);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected BDaemonSession getDaemonSession() {
        return this.session;
    }

    public void setStationSurrogate(BStationSurrogate value) {
        this.stationSurrogate = value;
    }

    public BStationSurrogate getStationSurrogate() {
        return this.stationSurrogate;
    }

    public BStationSurrogate getStationSurrogate(String stationName) {
        return this.stationCopier.getStationSurrogate(stationName, true);
    }

    public void setStartStation(boolean value) {
        this.startStation = value;
    }

    public boolean startStation() {
        return this.isLocalToRemote() && this.startStation;
    }

    public void setAutoStart(boolean value) {
        this.autoStart = value;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoRestart(boolean value) {
        this.autoRestart = value;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public List<String> getStationsToDelete() {
        return this.stationsToDelete;
    }

    public Collection<BIFile> getTransferContents() {
        return StationWizardModel.getTransferContents(this.getStationContent(), this.stationDir, this.directoryTreeModel.getCheckedDirectories(), this.isLocalToRemote, this.stationCopierOptions, this.fileExcludePatterns, this.directoryExcludePatterns);
    }

    public static Collection<BIFile> getTransferContents(BStationContentEnum stationContent, BDirectory stationDir, Iterator<BDirectory> checkedDirectories, boolean isLocalToRemote, BStationCopierOptions options, PatternFilter[] fileExcludePatterns, PatternFilter[] directoryExcludePatterns) {
        TreeMap<FilePath, BIFile> toTransfer = new TreeMap<FilePath, BIFile>();
        if (stationContent == BStationContentEnum.selectedDirectories) {
            while (checkedDirectories.hasNext()) {
                BDirectory checkedDirectory = checkedDirectories.next();
                toTransfer.remove(checkedDirectory.getFilePath().getParent());
                boolean emptyDir = true;
                for (BIFile file : checkedDirectory.listFiles()) {
                    if (file instanceof BDirectory || StationWizardModel.ignoreFile(file, fileExcludePatterns)) continue;
                    emptyDir = false;
                    toTransfer.put(file.getFilePath(), file);
                }
                if (!emptyDir || StationWizardModel.ignoreDirectory(checkedDirectory, directoryExcludePatterns)) continue;
                toTransfer.put(checkedDirectory.getFilePath(), (BIFile)checkedDirectory);
            }
        } else if (stationContent == BStationContentEnum.everything) {
            String[] ignoreDirs;
            TreeSet<FilePath> exclude = new TreeSet<FilePath>();
            if (isLocalToRemote || !options.getCopyRemoteStationAlarmData()) {
                exclude.add(stationDir.getFilePath().merge("alarm"));
            }
            if (isLocalToRemote || !options.getCopyRemoteStationDataRecovery()) {
                exclude.add(stationDir.getFilePath().merge("dataRecovery"));
            }
            if (isLocalToRemote || !options.getCopyRemoteStationHistoryData()) {
                exclude.add(stationDir.getFilePath().merge("history"));
            }
            for (String ignoreDir : ignoreDirs = Sys.getRegistry().getDefs(IGNORE_STATION_DIR_DEF_NAME)) {
                FilePath excludePath = stationDir.getFilePath().merge(ignoreDir);
                exclude.add(excludePath);
                BDaemonSessionView.log.log(Level.FINE, () -> "Excluded directory " + excludePath + " in station transfer due to a '" + IGNORE_STATION_DIR_DEF_NAME + "' def specified in an installed module with a value of '" + ignoreDir + "'.");
            }
            StationWizardModel.addAllDataFiles(stationDir, exclude, toTransfer, fileExcludePatterns, directoryExcludePatterns);
        } else if (stationContent == BStationContentEnum.configOnly) {
            BIFile configBog = (BIFile)stationDir.getNavChild("config.bog");
            if (configBog != null) {
                toTransfer.put(configBog.getFilePath(), configBog);
            }
        } else {
            throw new IllegalArgumentException("invalid StationContentEnum " + (Object)((Object)stationContent));
        }
        return toTransfer.values();
    }

    public Consumer<FileTransferMessage> makeFileTransferInitializer() throws Exception {
        return DaemonClientEncodingInfo.makeMessageInitializer((BDaemonSession)this.getDaemonSession(), Optional.ofNullable(this.encodingInfo), Optional.ofNullable(this.stationBogPassPhrase));
    }

    public boolean openApplicationDirector() {
        return this.openApplicationDirector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOpenApplicationDirector() {
        if (this.isLocalToRemote()) {
            if (this.shouldReboot()) {
                this.openApplicationDirector = false;
                return;
            }
            try {
                BOptions options = BOptions.load((String)BStationCopier.TYPE.toString(), (Type)BOptions.TYPE);
                BBoolean b = (BBoolean)options.get("openApplicationDirector");
                if (b == null) {
                    BGridPane grid = new BGridPane(1);
                    grid.setRowGap(12.0);
                    BCheckBox checkBox = new BCheckBox(BDaemonSessionView.lexicon.getText("StationCopier.openApplicationDirector.dontAsk"), false);
                    grid.add(null, (BValue)new BLabel(BDaemonSessionView.lexicon.getText("StationCopier.openApplicationDirector.question")));
                    grid.add(null, (BValue)checkBox);
                    boolean bl = this.openApplicationDirector = 4 == BDialog.confirm((BWidget)this.getWizard(), (String)BDaemonSessionView.lexicon.getText("StationCopier.openApplicationDirector.dlgTitle"), (Object)new BBorderPane((BWidget)grid, 0.0, 5.0, 5.0, 5.0));
                    if (!checkBox.isSelected()) return;
                    options.add("openApplicationDirector", (BValue)BBoolean.make((boolean)this.openApplicationDirector()));
                    options.save();
                    return;
                }
                this.openApplicationDirector = b.getBoolean();
                return;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        } else {
            this.openApplicationDirector = false;
        }
    }

    public DaemonSessionTaskHandler getTaskHandler() {
        return this.sessionTaskHandler;
    }

    public static boolean addAllDataFiles(BDirectory dir, Set<FilePath> exclude, Map<FilePath, BIFile> result, PatternFilter[] fileExcludePatterns, PatternFilter[] directoryExcludePatterns) {
        if (exclude.contains(dir.getFilePath()) || StationWizardModel.ignoreDirectory(dir, directoryExcludePatterns)) {
            return false;
        }
        boolean emptyDir = true;
        for (BIFile file : dir.listFiles()) {
            if (exclude.contains(file.getFilePath())) continue;
            if (file.isDirectory()) {
                if (!StationWizardModel.addAllDataFiles((BDirectory)file, exclude, result, fileExcludePatterns, directoryExcludePatterns)) continue;
                emptyDir = false;
                continue;
            }
            if (StationWizardModel.ignoreFile(file, fileExcludePatterns)) continue;
            emptyDir = false;
            result.put(file.getFilePath(), file);
        }
        if (emptyDir && !StationWizardModel.ignoreDirectory(dir, directoryExcludePatterns)) {
            result.put(dir.getFilePath(), (BIFile)dir);
        }
        return true;
    }

    private boolean ignoreFile(BIFile file) {
        return StationWizardModel.ignoreFile(file, this.fileExcludePatterns);
    }

    public void cannotProceed(String reasonLexiconKey) {
        this.cannotProceedStep.setMessage(reasonLexiconKey);
        this.update(this.cannotProceedStep);
    }

    private static boolean ignoreFile(BIFile file, PatternFilter[] fileExcludePatterns) {
        assert (!(file instanceof BDirectory));
        for (PatternFilter fileExcludePattern : fileExcludePatterns) {
            if (!fileExcludePattern.accept(file)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreDirectory(BDirectory directory) {
        return StationWizardModel.ignoreDirectory(directory, this.directoryExcludePatterns);
    }

    private static boolean ignoreDirectory(BDirectory directory, PatternFilter[] directoryExcludePatterns) {
        for (PatternFilter directoryExcludePattern : directoryExcludePatterns) {
            if (!directoryExcludePattern.accept((BIFile)directory)) continue;
            return true;
        }
        return false;
    }

    private class DeleteStationListModel
    extends ListModel {
        private final List<String> names = new ArrayList<String>();

        private DeleteStationListModel() {
        }

        public void load(BStationSurrogate[] surrogates, BStationSurrogate existingTarget) {
            this.names.clear();
            for (BStationSurrogate surrogate : surrogates) {
                if (existingTarget != null && existingTarget.getStationName().equals(surrogate.getStationName())) continue;
                this.names.add(surrogate.getStationName());
            }
            this.updateList();
        }

        public int getItemCount() {
            return this.names.size();
        }

        public String getStationName(int i) {
            return this.names.get(i);
        }

        public Object getItem(int i) {
            return this.getStationName(i);
        }
    }

    private class DeleteStationListSelection
    extends ListSelection {
        private final StationWizardStep step;

        public DeleteStationListSelection(StationWizardStep pStep) {
            this.step = pStep;
        }

        public void updateList() {
            StationWizardModel.this.update(this.step.getMode());
            super.updateList();
        }
    }

    private class DeleteStep
    extends StationWizardStep {
        private BStationSurrogate[] surrogates;
        private int max;
        private DeleteStationListModel listModel;

        public DeleteStep() {
            this.listModel = null;
            if (!StationWizardModel.this.isLocalToRemote()) {
                return;
            }
            try {
                ArrayList<BAppSurrogate> surrogatesArray = new ArrayList<BAppSurrogate>();
                Collections.addAll(surrogatesArray, StationWizardModel.this.stationCopier.getAppSurrogates());
                surrogatesArray.removeIf(o -> !(o instanceof BStationSurrogate));
                this.surrogates = new BStationSurrogate[surrogatesArray.size()];
                for (int i = 0; i < surrogatesArray.size(); ++i) {
                    this.surrogates[i] = (BStationSurrogate)surrogatesArray.get(i);
                }
                this.max = StationWizardModel.this.getDaemonSession().getHostProperties().getMaxStations();
                if (this.surrogates.length == 1) {
                    BLabel label = new BLabel(BDialog.WARNING_ICON, LEX.getText("StationCopier.DeleteStep.deleteOnlyStation", new Object[]{this.surrogates[0].getStationName()}));
                    label.setHalign(BHalign.left);
                    label.setWordWrapEnabled(true);
                    this.setContent((BWidget)new BEdgePane((BWidget)label, null, null, null, null));
                } else if (this.surrogates.length > 1) {
                    BLabel label = new BLabel(BDialog.WARNING_ICON, LEX.getText("StationCopier.DeleteStep.deleteStation", new Object[]{String.valueOf(this.max)}));
                    label.setHalign(BHalign.left);
                    this.listModel = new DeleteStationListModel();
                    BList list = new BList((ListModel)this.listModel);
                    this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)label, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)list, BBorder.inset, BInsets.DEFAULT)));
                    list.setSelection((ListSelection)new DeleteStationListSelection(this));
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public String getStepName() {
            return "DeleteStep";
        }

        @Override
        public void enter() {
            if (this.listModel != null) {
                this.listModel.load(this.surrogates, StationWizardModel.this.getStationSurrogate());
                ArrayList<Integer> selArray = new ArrayList<Integer>();
                for (int i = 0; i < StationWizardModel.this.getStationsToDelete().size(); ++i) {
                    int idx = this.listModel.indexOfItem(StationWizardModel.this.getStationsToDelete().get(i));
                    if (idx < 0) continue;
                    selArray.add(idx);
                }
                int[] sel = new int[selArray.size()];
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = (Integer)selArray.get(i);
                }
                this.listModel.getList().getSelection().select(sel);
            }
        }

        @Override
        public boolean isSkipped() {
            if (!StationWizardModel.this.isLocalToRemote()) {
                return true;
            }
            try {
                int adjustedMax = this.max;
                if (StationWizardModel.this.getStationSurrogate() != null) {
                    ++adjustedMax;
                }
                if (this.surrogates.length < adjustedMax) {
                    StationWizardModel.this.getStationsToDelete().clear();
                    return true;
                }
                return false;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public boolean exit() {
            StationWizardModel.this.getStationsToDelete().clear();
            if (this.surrogates.length == 1) {
                StationWizardModel.this.getStationsToDelete().add(this.surrogates[0].getStationName());
            } else {
                for (int sel : this.listModel.getList().getSelection().getItems()) {
                    StationWizardModel.this.getStationsToDelete().add(this.listModel.getStationName(sel));
                }
            }
            return true;
        }

        @Override
        public int getMode() {
            int numToDelete;
            StationWizardStep ps;
            int result = 0;
            for (ps = this.getPriorStep(); ps != null && ps.isSkipped(); ps = ps.getPriorStep()) {
            }
            if (ps != null) {
                result |= 1;
            }
            int adjustedMax = this.max;
            if (StationWizardModel.this.getStationSurrogate() != null) {
                ++adjustedMax;
            }
            if (this.surrogates.length - (numToDelete = this.listModel == null ? 1 : this.listModel.getList().getSelection().getItems().length) < adjustedMax) {
                StationWizardStep ns;
                for (ns = this.getNextStep(); ns != null && ns.isSkipped(); ns = ns.getNextStep()) {
                }
                if (ns != null) {
                    result |= 2;
                }
            }
            return result;
        }
    }

    private class RebootStep
    extends StationWizardStep {
        private BCheckBox rebootCheckBox;

        public RebootStep() {
            if (!StationWizardModel.this.isLocalToRemote()) {
                return;
            }
            BGridPane grid = new BGridPane(1);
            grid.setHalign(BHalign.left);
            grid.setValign(BValign.top);
            this.rebootCheckBox = new BCheckBox(LEX.getText("StationCopier.RebootStep.label"));
            grid.add(null, (BValue)this.rebootCheckBox);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)grid, 0.0, 0.0, 8.0, 0.0), null, null, null, null));
        }

        @Override
        public String getStepName() {
            return "RebootStep";
        }

        @Override
        public void enter() {
            this.rebootCheckBox.setSelected(StationWizardModel.this.shouldReboot());
        }

        @Override
        public boolean isSkipped() {
            return !StationWizardModel.this.isLocalToRemote() || StationWizardModel.this.allowStationRestart();
        }

        @Override
        public boolean exit() {
            StationWizardModel.this.setReboot(this.rebootCheckBox.isSelected());
            return true;
        }

        @Override
        public int getMode() {
            return this.getNavMode();
        }
    }

    private class StartStationStep
    extends StationWizardStep {
        private BCheckBox startStationCheckBox;
        private BCheckBox autoStartCheckBox;

        public StartStationStep() {
            BGridPane grid = new BGridPane(1);
            grid.setHalign(BHalign.left);
            grid.setValign(BValign.top);
            this.startStationCheckBox = new BCheckBox(LEX.getText("StationCopier.StartStationStep.start.description"));
            grid.add(null, (BValue)this.startStationCheckBox);
            this.autoStartCheckBox = new BCheckBox(LEX.getText("StationCopier.StartStationStep.autoStart.description"));
            grid.add(null, (BValue)this.autoStartCheckBox);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)grid, 0.0, 0.0, 8.0, 0.0), null, null, null, null));
        }

        @Override
        public String getStepName() {
            return "StartStationStep";
        }

        @Override
        public void enter() throws Exception {
            if (StationWizardModel.this.allowStationRestart()) {
                this.startStationCheckBox.setSelected(StationWizardModel.this.startStation());
                this.startStationCheckBox.setEnabled(true);
            } else {
                boolean allIdle = true;
                for (BStationSurrogate station : BStationSurrogate.makeAll((BDaemonSession)StationWizardModel.this.getDaemonSession())) {
                    if (station.getStationStatus().equals((Object)BStationStatus.idle)) continue;
                    allIdle = false;
                    break;
                }
                if (allIdle) {
                    this.startStationCheckBox.setSelected(StationWizardModel.this.startStation());
                    this.startStationCheckBox.setEnabled(true);
                } else {
                    this.startStationCheckBox.setSelected(false);
                    this.startStationCheckBox.setEnabled(false);
                    StationWizardModel.this.setStartStation(false);
                }
            }
            this.autoStartCheckBox.setSelected(StationWizardModel.this.isAutoStart());
        }

        @Override
        public boolean isSkipped() {
            return !StationWizardModel.this.isLocalToRemote() || !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit();
        }

        @Override
        public boolean exit() {
            StationWizardModel.this.setStartStation(this.startStationCheckBox.isSelected());
            StationWizardModel.this.setAutoStart(this.autoStartCheckBox.isSelected());
            return true;
        }

        @Override
        public int getMode() {
            return this.getNavMode();
        }
    }

    private class StopStationStep
    extends StationWizardStep {
        private BLabel stepMessage;
        private BGridPane grid;

        public StopStationStep() {
            this.grid = new BGridPane(1);
            this.grid.setHalign(BHalign.left);
            this.grid.setValign(BValign.top);
            this.setContent((BWidget)this.grid);
        }

        @Override
        public String getStepName() {
            return "StopStationStep";
        }

        @Override
        public void enter() {
            this.grid.removeAll();
            boolean anyRows = false;
            if (StationWizardModel.this.getStationSurrogate() != null && StationWizardModel.this.getStationSurrogate().isStationRunning()) {
                this.grid.add(null, (BValue)new BLabel(LEX.getText("StationCopier.StopStationStep.message.newStation", new Object[]{StationWizardModel.this.getTargetStationName()}), BHalign.left));
                anyRows = true;
            }
            if (StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall().length > 0) {
                try {
                    for (BStationSurrogate station : BStationSurrogate.makeAll((BDaemonSession)StationWizardModel.this.getDaemonSession())) {
                        if (!station.isStationRunning() || StationWizardModel.this.getStationsToDelete().contains(station.getStationName()) || StationWizardModel.this.getStationSurrogate() != null && StationWizardModel.this.getStationSurrogate().getStationName().equals(station.getStationName())) continue;
                        if (StationWizardModel.this.allowStationRestart()) {
                            this.grid.add(null, (BValue)new BLabel(LEX.getText("StationCopier.StopStationStep.message.existingStation.restart", new Object[]{station.getStationName(), StationWizardModel.this.getTargetStationName()}), BHalign.left));
                        } else {
                            this.grid.add(null, (BValue)new BLabel(LEX.getText("StationCopier.StopStationStep.message.existingStation.noRestart", new Object[]{station.getStationName(), StationWizardModel.this.getTargetStationName()}), BHalign.left));
                        }
                        anyRows = true;
                    }
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            if (!anyRows) {
                this.grid.add(null, (BValue)new BLabel(LEX.getText("StationCopier.StopStationStep.message.existingStation.unknown", new Object[]{StationWizardModel.this.getTargetStationName()}), BHalign.left));
            }
        }

        @Override
        public boolean isSkipped() {
            try {
                return StationWizardModel.this.getStationDisposition() == BStationDispositionEnum.clean || !StationWizardModel.this.isLocalToRemote() || (StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall().length <= 0 || !BStationSurrogate.isAnyStationRunning((BDaemonSession)StationWizardModel.this.getDaemonSession())) && (StationWizardModel.this.getStationSurrogate() == null || !StationWizardModel.this.getStationSurrogate().isStationRunning());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        @Override
        public boolean exit() {
            return true;
        }

        @Override
        public int getMode() {
            return this.getNavMode();
        }
    }

    private class CannotProceedStep
    extends StationWizardStep {
        public final BLabel messageLabel;

        public CannotProceedStep() {
            BGridPane pane = new BGridPane(1);
            pane.setHalign(BHalign.left);
            pane.setValign(BValign.top);
            this.messageLabel = new BLabel("", BHalign.left);
            pane.add(null, (BValue)this.messageLabel);
            this.setContent((BWidget)pane);
        }

        @Override
        public String getStepName() {
            return "CannotProceedStep";
        }

        @Override
        public int getMode() {
            return StationWizardModel.this.isLocalToRemote() ? 0 : 1;
        }

        @Override
        public StationWizardStep getPriorStep() {
            return StationWizardModel.this.isLocalToRemote() ? null : StationWizardModel.this.nameStep;
        }

        public void setMessage(String messageKey) {
            this.messageLabel.setText(LEX.getText(messageKey));
        }
    }

    private class ReviewStep
    extends StationWizardStep {
        private final BIndentPane indent;
        private final BIcon dirIconRef;

        public ReviewStep() {
            this.dirIconRef = BIcon.std((String)"folder.png");
            this.indent = new BIndentPane();
            BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)this.indent, 3.0, 5.0, 3.0, 5.0));
            scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
            scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
            this.setContent((BWidget)scroll);
        }

        @Override
        public String getStepName() {
            return "ReviewStep";
        }

        @Override
        public int getMode() {
            StationWizardStep ps;
            int result = 4;
            for (ps = this.getPriorStep(); ps != null && ps.isSkipped(); ps = ps.getPriorStep()) {
            }
            if (ps != null) {
                result |= 1;
            }
            return result;
        }

        @Override
        public void enter() {
            String sourceName = StationWizardModel.this.getSourceSystemName();
            String targetName = StationWizardModel.this.getTargetSystemName();
            this.indent.clear();
            if (StationWizardModel.this.getStationContent() == BStationContentEnum.everything) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.content.everything"), new Object[]{sourceName, targetName});
            } else if (StationWizardModel.this.getStationContent() == BStationContentEnum.configOnly) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.content.configOnly"), new Object[]{sourceName, targetName});
            } else if (StationWizardModel.this.getStationContent() == BStationContentEnum.selectedDirectories) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.content.selectedDirectories"), new Object[]{sourceName, targetName});
                this.indent.indent();
                Iterator i = StationWizardModel.this.directoryTreeModel.getCheckedDirectories();
                while (i.hasNext()) {
                    this.indent.add((BWidget)new BLabel(BImage.make((BIcon)this.dirIconRef), ((BDirectory)i.next()).getFilePath().getBody()));
                }
                this.indent.unindent();
            }
            this.indent.add((BWidget)new BBox(0.0, 5.0));
            if (StationWizardModel.this.isLocalToRemote() && StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall().length > 0) {
                this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ModulesStep.top"));
                boolean installingEarlyModuleVersion = false;
                this.indent.indent();
                for (int i = 0; i < StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall().length; ++i) {
                    BInstallable inst = StationWizardModel.this.getDependencyAnalysis().getSolution().getToInstall()[i];
                    if (!installingEarlyModuleVersion) {
                        try {
                            BInstallable latestModule = LocalInstallableRegistry.getInstance().findInstallable(BDependency.forModule((String)inst.getInstallableName()), null);
                            if (latestModule.getVersion().getVendorVersion().compareTo(inst.getVersion().getVendorVersion()) > 0) {
                                installingEarlyModuleVersion = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.indent.add((BWidget)new BLabel(BImage.make((BIcon)inst.getIcon()), inst.toString()));
                }
                this.indent.unindent();
                if (installingEarlyModuleVersion) {
                    this.indent.add((BWidget)new BBox(0.0, 5.0));
                    BLabel label = new BLabel(BImage.make((BIcon)BIcon.std((String)"warning.png")), LEX.getText("StationCopier.ModulesStep.confirm.laterVersionAvail"));
                    label.setHalign(BHalign.left);
                    this.indent.add((BWidget)label);
                } else {
                    this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ModulesStep.confirm.bottom"));
                }
                this.indent.add((BWidget)new BBox(0.0, 5.0));
            }
            this.indent.add(LexiconText.make((String)"platDaemon", (String)"StationCopier.ReviewStep.footer"));
        }
    }

    private class ModulesStep
    extends StationWizardStep {
        private final BIcon iconRef;
        private final BIndentPane indent;
        private final BBorderPane pane;

        public ModulesStep() {
            this.iconRef = BIcon.std((String)"module.png");
            this.indent = new BIndentPane();
            this.pane = new BBorderPane((BWidget)new BNullWidget(), 3.0, 5.0, 3.0, 5.0);
            BScrollPane scroll = new BScrollPane((BWidget)this.pane);
            scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
            scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
            this.setContent((BWidget)scroll);
        }

        @Override
        public void enter() {
            InstallScenario scenario = StationWizardModel.this.getDependencyAnalysis().getSolution();
            Map failed = scenario.getSignatureFailures();
            if (!failed.isEmpty()) {
                BWidget failurePane = this.makeSignatureFailurePane(failed, scenario.getVerificationMode());
                this.pane.setContent(failurePane);
            } else if (scenario.getUnmeetableDependencies().length > 0) {
                BIndentPane indent = new BIndentPane();
                int targetWidth = (int)StationWizardModel.this.getWizard().getPreferredWidth() - 35;
                BLabel label = new BLabel(StationWizardModel.this.isSoftwareReadonly ? LEX.getText("StationCopier.readonlySoftware") : LEX.getText("StationCopier.unavailableSoftware"));
                label.setWordWrapEnabled(true, (double)targetWidth);
                label.setHalign(BHalign.left);
                indent.add((BWidget)label);
                indent.add((BWidget)new BBox(0.0, 5.0));
                indent.indent();
                for (UnmeetableDependency dependency : scenario.getUnmeetableDependencies()) {
                    indent.add(dependency.toString());
                }
                indent.unindent();
                indent.add((BWidget)new BBox(0.0, 5.0));
                indent.add(LEX.getText("StationCopier.cancelInstall"));
                this.pane.setContent((BWidget)indent);
            } else {
                BWidget warningPane = this.makeSignatureWarningPane(scenario, scenario.getCertValidator());
                if (warningPane != null) {
                    this.pane.setContent(warningPane);
                }
            }
        }

        @Override
        public String getStepName() {
            return "ModulesStep";
        }

        @Override
        public boolean isSkipped() {
            if (!StationWizardModel.this.isLocalToRemote) {
                return true;
            }
            InstallScenario scenario = StationWizardModel.this.getDependencyAnalysis().getSolution();
            return scenario.canCommit() && this.getSignatureWarnings(scenario, scenario.getCertValidator()).isEmpty();
        }

        @Override
        public int getMode() {
            StationWizardStep ps;
            int result = 0;
            for (ps = this.getPriorStep(); ps != null && ps.isSkipped(); ps = ps.getPriorStep()) {
            }
            if (ps != null) {
                result |= 1;
            }
            if (this.getNextStep() != null && (!StationWizardModel.this.isLocalToRemote() || StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit())) {
                result |= 2;
            }
            return result;
        }

        private BWidget makeSignatureFailurePane(Map<BModuleInstallable, List<ModuleSignatureStatusEnum>> failed, ModuleVerificationMode verificationMode) {
            HashMap<ModuleSignatureStatusEnum, List> warnings = new HashMap<ModuleSignatureStatusEnum, List>();
            for (Map.Entry<BModuleInstallable, List<ModuleSignatureStatusEnum>> entry : failed.entrySet()) {
                List<ModuleSignatureStatusEnum> statuses = entry.getValue();
                for (ModuleSignatureStatusEnum moduleSignatureStatusEnum : statuses) {
                    if (moduleSignatureStatusEnum.isAcceptable(verificationMode)) continue;
                    warnings.computeIfAbsent(moduleSignatureStatusEnum, k -> new ArrayList()).add(entry.getKey().toString());
                }
            }
            int targetWidth = (int)StationWizardModel.this.getWizard().getPreferredWidth() - 35;
            BIndentPane result = new BIndentPane();
            BLabel error = new BLabel(LEX.getText("StationCopier.signatureError"));
            error.setWordWrapEnabled(true, (double)targetWidth);
            error.setHalign(BHalign.left);
            result.add((BWidget)error);
            result.add((BWidget)new BBox(0.0, 5.0));
            for (Map.Entry entry : warnings.entrySet()) {
                BLabel label = new BLabel(LEX.getText("InstallCommand." + ((ModuleSignatureStatusEnum)entry.getKey()).toString() + ".error"));
                label.setWordWrapEnabled(true, (double)targetWidth);
                label.setHalign(BHalign.left);
                result.add((BWidget)label);
                result.indent();
                for (String module : (List)entry.getValue()) {
                    result.add((BWidget)new BLabel(BImage.make((BIcon)this.iconRef), module));
                }
                result.unindent();
                result.add((BWidget)new BBox(0.0, 5.0));
            }
            BLabel bottom = new BLabel(LEX.getText("StationCopier.signatureError.cancel"));
            bottom.setWordWrapEnabled(true, (double)targetWidth);
            bottom.setHalign(BHalign.left);
            result.add((BWidget)bottom);
            return result;
        }

        private BWidget makeSignatureWarningPane(InstallScenario solution, CertificateChainValidator validator) {
            Map<ModuleSignatureStatusEnum, List<String>> warnings = this.getSignatureWarnings(solution, validator);
            if (!warnings.isEmpty()) {
                int targetWidth = (int)StationWizardModel.this.getWizard().getPreferredWidth() - 35;
                BIndentPane result = new BIndentPane();
                BLabel warning = new BLabel(LEX.getText("StationCopier.signatureWarning"));
                warning.setWordWrapEnabled(true, (double)targetWidth);
                warning.setHalign(BHalign.left);
                result.add((BWidget)warning);
                result.add((BWidget)new BBox(0.0, 5.0));
                for (Map.Entry<ModuleSignatureStatusEnum, List<String>> entry : warnings.entrySet()) {
                    BLabel label = new BLabel(LEX.getText("InstallCommand." + entry.getKey().toString() + ".warning"));
                    label.setWordWrapEnabled(true, (double)targetWidth);
                    label.setHalign(BHalign.left);
                    result.add((BWidget)label);
                    result.indent();
                    for (String module : entry.getValue()) {
                        result.add((BWidget)new BLabel(BImage.make((BIcon)this.iconRef), module));
                    }
                    result.unindent();
                    result.add((BWidget)new BBox(0.0, 5.0));
                }
                BLabel label = new BLabel(LEX.getText("StationCopier.continueInstall"));
                label.setWordWrapEnabled(true, (double)targetWidth);
                label.setHalign(BHalign.left);
                result.add((BWidget)label);
                return result;
            }
            return null;
        }

        private Map<ModuleSignatureStatusEnum, List<String>> getSignatureWarnings(InstallScenario solution, CertificateChainValidator validator) {
            BInstallable[] toInstall;
            HashMap<ModuleSignatureStatusEnum, List<String>> warnings = new HashMap<ModuleSignatureStatusEnum, List<String>>();
            for (BInstallable installable : toInstall = solution.getToInstall()) {
                BModulePart part;
                List statuses;
                if (!(installable instanceof BModuleInstallable) || (statuses = (part = ((BModuleInstallable)installable).getModulePart()).getSignatureStatus(validator)).contains(ModuleSignatureStatusEnum.OK)) continue;
                for (ModuleSignatureStatusEnum status : statuses) {
                    warnings.computeIfAbsent(status, k -> new ArrayList()).add(installable.toString());
                }
            }
            return warnings;
        }
    }

    private class DispositionStep
    extends StationWizardStep {
        private EnumRadioGroup group;

        private DispositionStep() {
        }

        @Override
        public String getStepName() {
            return "DispositionStep";
        }

        @Override
        public int getMode() {
            StationWizardStep ps;
            int result = 2;
            for (ps = this.getPriorStep(); ps != null && ps.isSkipped(); ps = ps.getPriorStep()) {
            }
            if (ps != null) {
                result |= 1;
            }
            return result;
        }

        @Override
        public boolean isSkipped() {
            if (StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit()) {
                return true;
            }
            return !StationWizardModel.this.targetDirectoryExists;
        }

        @Override
        public void enter() {
            BGridPane gridPane = new BGridPane(1);
            gridPane.setValign(BValign.top);
            gridPane.setHalign(BHalign.left);
            this.group = new EnumRadioGroup((BWidget)StationWizardModel.this.getWizard(), new String[]{LEX.getText("StationCopier.clean.fullDesc", new Object[]{StationWizardModel.this.getTargetStationName()}), BStationDispositionEnum.replaceDuplicates.getDisplayTag(null)}, (BEnum[])new BFrozenEnum[]{BStationDispositionEnum.clean, BStationDispositionEnum.replaceDuplicates}, (BEnum)StationWizardModel.this.getStationDisposition());
            for (BWidget groupWidget : this.group.getWidgets()) {
                gridPane.add(null, (BValue)groupWidget);
            }
            this.setContent((BWidget)gridPane);
        }

        @Override
        public boolean exit() {
            StationWizardModel.this.setStationDisposition((BStationDispositionEnum)this.group.getValue());
            return true;
        }
    }

    private class DetailsStep
    extends StationWizardStep {
        private BDirectoryTree tree;
        private final BEdgePane rightPane;

        public DetailsStep() {
            this.tree = null;
            this.rightPane = new BEdgePane();
            if (StationWizardModel.this.isAxMigration()) {
                BLabel label = new BLabel(LEX.getText("StationCopier.DetailsStep.description.migration"), BHalign.left);
                label.setWordWrapEnabled(true);
                BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)label);
                constrainedPane.setMinHeight(80.0);
                this.rightPane.setTop((BWidget)new BBorderPane((BWidget)constrainedPane, 0.0, 0.0, 8.0, 0.0));
            } else {
                BLabel label = new BLabel(LEX.getText("StationCopier.DetailsStep.description"), BHalign.left);
                this.rightPane.setTop((BWidget)new BBorderPane((BWidget)label, 0.0, 0.0, 8.0, 0.0));
            }
            this.setContent((BWidget)this.rightPane);
        }

        @Override
        public void enter() {
            if (this.tree == null) {
                this.tree = new BDirectoryTree((TreeModel)StationWizardModel.this.directoryTreeModel);
                this.rightPane.setCenter((BWidget)new BScrollPane((BWidget)new BBorderPane((BWidget)this.tree, BBorder.inset, BInsets.DEFAULT)));
            } else if (StationWizardModel.this.directoryTreeModel != this.tree.getModel()) {
                this.tree.setModel((TreeModel)StationWizardModel.this.directoryTreeModel);
            }
            this.getWidget().relayout();
        }

        @Override
        public int getMode() {
            return this.getNavMode();
        }

        @Override
        public String getStepName() {
            return "DetailsStep";
        }

        @Override
        public boolean isSkipped() {
            if (StationWizardModel.this.getStationContent() != BStationContentEnum.selectedDirectories || StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit()) {
                return true;
            }
            try {
                for (BIFile kid : StationWizardModel.this.getStationDirectory().listFiles()) {
                    if (!kid.isDirectory()) continue;
                    return false;
                }
            }
            catch (Exception e) {
                BDaemonSessionView.log.log(Level.SEVERE, "error checking for subdirectories", e);
            }
            return true;
        }
    }

    private class ContentStep
    extends StationWizardStep {
        private EnumRadioGroup group;
        private boolean hasSetDispositionDefault;

        private ContentStep() {
            this.hasSetDispositionDefault = false;
        }

        @Override
        public String getStepName() {
            return "ContentStep";
        }

        @Override
        public int getMode() {
            return 3;
        }

        @Override
        public boolean isSkipped() {
            if (StationWizardModel.this.shortCircuit || StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit()) {
                return true;
            }
            return this.configBogOnly();
        }

        @Override
        public void enter() {
            BGridPane gridPane = new BGridPane(1);
            gridPane.setValign(BValign.top);
            gridPane.setHalign(BHalign.left);
            this.group = StationWizardModel.this.isAxMigration() ? new EnumRadioGroup((BWidget)StationWizardModel.this.getWizard(), (BEnum[])new BFrozenEnum[]{BStationContentEnum.selectedDirectories, BStationContentEnum.configOnly}, (BEnum)StationWizardModel.this.getStationContent(), null) : (StationWizardModel.this.sourceHasSubdirs ? new EnumRadioGroup((BWidget)StationWizardModel.this.getWizard(), (BEnum[])new BFrozenEnum[]{BStationContentEnum.selectedDirectories, BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)StationWizardModel.this.getStationContent(), null) : new EnumRadioGroup((BWidget)StationWizardModel.this.getWizard(), (BEnum[])new BFrozenEnum[]{BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)StationWizardModel.this.getStationContent(), null));
            for (BWidget groupWidget : this.group.getWidgets()) {
                gridPane.add(null, (BValue)groupWidget);
            }
            this.setContent((BWidget)gridPane);
        }

        @Override
        public boolean exit() {
            StationWizardModel.this.setStationContent((BStationContentEnum)this.group.getValue());
            if (!this.hasSetDispositionDefault) {
                this.hasSetDispositionDefault = true;
                if (this.group.getValue() == BStationContentEnum.everything) {
                    StationWizardModel.this.setStationDisposition(BStationDispositionEnum.clean);
                }
            }
            return true;
        }

        private boolean configBogOnly() {
            try {
                for (BIFile file : StationWizardModel.this.getStationDirectory().listFiles()) {
                    if (!(file.isDirectory() ? !StationWizardModel.this.ignoreDirectory((BDirectory)file) : !file.getFileName().equals("config.bog") && !StationWizardModel.this.ignoreFile(file))) continue;
                    return false;
                }
            }
            catch (Exception e) {
                BDaemonSessionView.log.log(Level.SEVERE, "error checking for station directory existance", e);
            }
            return true;
        }
    }

    private class StationNameStep
    extends StationWizardStep {
        private BTextField nameTextField;

        public StationNameStep() {
            BGridPane gridPane = new BGridPane(2);
            gridPane.setValign(BValign.top);
            gridPane.setHalign(BHalign.left);
            this.nameTextField = new BTextField("", 30);
            LabelUtil.addLabelWidgetPair((BPane)gridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"StationCopier.StationNameStep.name"), (BWidget)this.nameTextField);
            this.nameTextField.setController((TextController)new StationNameController());
            this.nameTextField.setModel((TextModel)new StationNameModel());
            this.setContent((BWidget)gridPane);
        }

        @Override
        public String getStepName() {
            return "StationNameStep";
        }

        @Override
        public int getMode() {
            return this.getPriorStep() == null ? 2 : 3;
        }

        @Override
        public void enter() {
            this.nameTextField.setText(StationWizardModel.this.getTargetStationName());
        }

        @Override
        public boolean exit() {
            if (this.nameTextField.getText().trim().length() == 0) {
                return false;
            }
            StationWizardModel.this.setTargetStationName(this.nameTextField.getText());
            if (StationWizardModel.this.isLocalToRemote()) {
                StationWizardModel.this.setStationSurrogate(StationWizardModel.this.stationCopier.getStationSurrogate(StationWizardModel.this.getTargetStationName(), true));
                if (StationWizardModel.this.getStationSurrogate() != null) {
                    StationWizardModel.this.setAutoStart(StationWizardModel.this.getStationSurrogate().getIsAutoStart());
                    StationWizardModel.this.setAutoRestart(StationWizardModel.this.getStationSurrogate().getIsAutoRestart());
                }
            } else {
                BBogFile stationBog;
                this.setNextStep(StationWizardModel.this.contentStep);
                if (StationWizardModel.this.localStationBogLock != null) {
                    try {
                        StationWizardModel.this.localStationBogLock.unlock();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StationWizardModel.this.localStationBogLock = null;
                }
                if ((stationBog = (BBogFile)BFileSystem.INSTANCE.findFile(SystemFilePaths.getStationsDirPath((boolean)true).merge(StationWizardModel.this.getTargetStationName()).merge("config.bog"))) != null) {
                    File localFile = ((BLocalFileStore)stationBog.getStore()).getLocalFile();
                    try {
                        StationWizardModel.this.localStationBogLock = FileLock.lock((File)localFile);
                    }
                    catch (Exception e) {
                        StationWizardModel.this.cannotProceed("StationCopier.CannotProceedStep.message.downloadLocked");
                    }
                }
            }
            return true;
        }

        @Override
        public boolean isSkipped() {
            return StationWizardModel.this.shortCircuit || StationWizardModel.this.isLocalToRemote() && !StationWizardModel.this.getDependencyAnalysis().getSolution().canCommit();
        }

        class StationNameModel
        extends TextModel {
            StationNameModel() {
            }

            protected void textModified() {
                String text = StationNameStep.this.nameTextField.getText();
                if (StationWizardModel.this.getWizard() != null) {
                    StationWizardModel.this.getWizard().setNextEnabled(SlotPath.isValidName((String)text) && text.length() <= 32);
                }
            }
        }
    }

    private class SetLocalPassPhraseStep
    extends StationWizardStep {
        final BLabel stepContent;

        public SetLocalPassPhraseStep() {
            this.stepContent = new BLabel(BDialog.INFO_ICON, LEX.get("StationCopier.SetLocalPassphraseStep.header"));
            this.stepContent.setTextIconGap(8.0);
            this.stepContent.setHalign(BHalign.left);
            BGridPane gridPane = new BGridPane(1);
            gridPane.setValign(BValign.top);
            gridPane.setHalign(BHalign.left);
            BBorderPane borderPane = new BBorderPane((BWidget)this.stepContent, 3.0, 5.0, 3.0, 5.0);
            gridPane.add(null, (BValue)borderPane);
            this.setContent((BWidget)gridPane);
        }

        @Override
        public void enter() {
            int targetWidth = (int)StationWizardModel.this.getWizard().getPreferredWidth() - 35;
            this.stepContent.setWordWrapEnabled(true, (double)targetWidth);
        }

        @Override
        public String getStepName() {
            return "SetLocalPassphraseStep";
        }

        @Override
        public int getMode() {
            return 2;
        }
    }

    private class PassPhraseStep
    extends StationWizardStep {
        private BPasswordFE passwordFE;
        private BLabel errorLabel;

        public PassPhraseStep() {
            BGridPane gridPane = new BGridPane(2);
            gridPane.setValign(BValign.top);
            gridPane.setHalign(BHalign.left);
            this.passwordFE = new BPasswordFE();
            LabelUtil.addLabelWidgetPair((BPane)gridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"StationCopier.PassPhraseStep.passPhrase"), (BWidget)this.passwordFE);
            this.errorLabel = new BLabel("", BHalign.left);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)new BLabel(LEX.getText("StationCopier.PassPhraseStep.header"), BHalign.left), 0.0, 0.0, 5.0, 0.0), (BWidget)new BBorderPane((BWidget)this.errorLabel, 10.0, 0.0, 0.0, 0.0), null, null, (BWidget)gridPane));
            StyleUtils.addStyleClass((IStylable)this.errorLabel, (String)"error");
            this.errorLabel.setWordWrapEnabled(true);
        }

        @Override
        public String getStepName() {
            return "PassPhraseStep";
        }

        @Override
        public boolean isSkipped() {
            return !StationWizardModel.this.promptForPassPhrase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean exit() {
            try (SecretChars passPhraseTestCopy = null;){
                BPassword value = (BPassword)this.passwordFE.saveValue();
                if (value != null) {
                    passPhraseTestCopy = value.getSecretChars();
                    if (StationWizardModel.this.encodingInfo.test(passPhraseTestCopy)) {
                        StationWizardModel.this.stationBogPassPhrase = value.getSecretChars();
                        this.errorLabel.setText("");
                        boolean bl = true;
                        return bl;
                    }
                }
                EnumSet errors = EnumSet.noneOf(PBEValidator.ValidationFault.class);
                if (value != null) {
                    try (SecretChars secretChars = value.getSecretChars();){
                        errors = PBEValidator.checkPassPhraseValidity((SecretChars)secretChars);
                    }
                }
                if (errors.contains(PBEValidator.ValidationFault.FIPS_MIN_LENGTH)) {
                    this.errorLabel.setText(LEX.getText("StationCopier.PassPhraseStep.passPhraseLength", new Object[]{SecurityInitializer.getInstance().getFipsInformation().getFipsVersion(), PasswordStrength.MINIMUM_ALLOWED_LENGTH}));
                } else {
                    this.errorLabel.setText(LEX.getText("StationCopier.PassPhraseStep.badPassPhrase"));
                }
                boolean bl = false;
                return bl;
            }
        }

        @Override
        public int getMode() {
            return 2;
        }
    }

    public abstract class StationWizardStep {
        private BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private final BEdgePane widget;
        private StationWizardStep priorStep = null;
        private StationWizardStep nextStep = null;
        protected static final int WORD_WRAP_LABEL_BUFFER = 35;

        public StationWizardStep() {
            this.widget = new BEdgePane((BWidget)new BWizardHeader(WIZ_IMAGE, LEX.getText("StationCopier.headerTitle", new Object[]{StationWizardModel.this.getStationDirectory().getFilePath().getName()}), LEX.getText("StationCopier." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        }

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget content) {
            this.contentPane.setCenter(content);
        }

        public int getMode() {
            return 0;
        }

        public int getNavMode() {
            StationWizardStep ns;
            StationWizardStep ps;
            int result = 0;
            for (ps = this.getPriorStep(); ps != null && ps.isSkipped(); ps = ps.getPriorStep()) {
            }
            if (ps != null) {
                result |= 1;
            }
            for (ns = this.getNextStep(); ns != null && ns.isSkipped(); ns = ns.getNextStep()) {
            }
            if (ns != null) {
                result |= 2;
            }
            return result;
        }

        public StationWizardStep getPriorStep() {
            return this.priorStep;
        }

        public StationWizardStep getNextStep() {
            return this.nextStep;
        }

        public void setNextStep(StationWizardStep step) {
            this.nextStep = step;
        }

        public void enter() throws Exception {
        }

        public boolean exit() {
            return true;
        }

        public void setPriorStep(StationWizardStep step) {
            this.priorStep = step;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }
}

