/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class InstallVersionCommand
extends AsyncCommand {
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    protected InstallerTableModel tableModel;
    protected BInstallable installable;

    public InstallVersionCommand(InstallerTableModel tableModel, BInstallable installable) {
        super((BWidget)tableModel.getTable(), LEX.getText("SoftwareManager.status.install", new Object[]{installable.getVersion()}), null, null, null);
        this.tableModel = tableModel;
        this.installable = installable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        block25: {
            try {
                BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
                try {
                    BInstallable[] inst;
                    boolean raiseDialogs = true;
                    if (shell != null) {
                        shell.enterBusy();
                    }
                    TreeMap<PartSpec, BInstallable> initialInstallablesByPartSpec = new TreeMap<PartSpec, BInstallable>();
                    for (BInstallable bInstallable : inst = this.tableModel.getScenario().getToInstall()) {
                        initialInstallablesByPartSpec.put(bInstallable.getPart().getPartSpec(), bInstallable);
                    }
                    initialInstallablesByPartSpec.put(this.installable.getPart().getPartSpec(), this.installable);
                    inst = initialInstallablesByPartSpec.values().toArray(new BInstallable[0]);
                    SolutionParameters params = this.tableModel.getScenario().getSolutionParameters().newCopy();
                    params.latestOnly = false;
                    InstallScenario solution = InstallScenario.solve((BDaemonPlatform)this.tableModel.getScenario().getTargetPlatform(), (String[])this.tableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])inst, (SolutionParameters)params, (Set)this.tableModel.getScenario().getNewEnabledRuntimeProfiles(), (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)this.tableModel.getCertValidator());
                    Map failed = solution.getSignatureFailures();
                    if (!failed.isEmpty()) {
                        if (raiseDialogs) {
                            BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("InstallCommand.signingError.title"), (Object)InstallCommand.makeSigningErrorDialog(failed, this.tableModel.getModuleVerificationMode()));
                        }
                        break block25;
                    }
                    if (solution.getExcludedInstallables().length > 0) {
                        if (raiseDialogs) {
                            BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("InstallCommand.excluded.title"), (Object)LEX.getText("InstallCommand.excluded.message"));
                        }
                        break block25;
                    }
                    if (solution.getUnmeetableDependencies().length > 0) {
                        UnmeetableDependency[] unmet = solution.getUnmeetableDependencies();
                        boolean anyUnsolvable = false;
                        for (UnmeetableDependency unmeetableDependency : unmet) {
                            if (!unmeetableDependency.isUnsolvable) continue;
                            anyUnsolvable = true;
                            break;
                        }
                        if (anyUnsolvable) {
                            if (raiseDialogs) {
                                boolean canCommission;
                                BDaemonSession session = this.tableModel.getScenario().getTargetPlatform().getDaemonSession();
                                boolean bl = canCommission = session.getHostProperties().hasFullAccess() && session.getHostProperties().isNiagara4() && !session.getHostProperties().getNiagaraR2Enabled() && !session.usesLocalNiagaraHome() && CommissioningWizardModel.hostModelAllowsCommissioning(session);
                                if (!canCommission) {
                                    BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("InstallCommand.mustCommission.title"), (Object)LEX.getText("InstallCommand.mustCommission.message"));
                                    break block25;
                                }
                                if (4 != BDialog.confirm((BWidget)this.getOwner(), (String)LEX.getText("InstallCommand.mustCommission.title"), (Object)LEX.getText("InstallCommand.mustCommission.prompt"), (int)12)) break block25;
                                try {
                                    BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), session.getHost());
                                    BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), this.tableModel.getScenario().getTargetPlatform().getDaemonSession(), true));
                                    break block25;
                                }
                                finally {
                                    BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)this.getOwner()), session.getHost());
                                }
                            }
                            solution.getSolutionParameters().latestOnly = true;
                            this.tableModel.setScenario(solution);
                            break block25;
                        }
                        if (raiseDialogs) {
                            BDialog.error((BWidget)this.getOwner(), (String)LEX.getText("InstallCommand.unmet.title"), (Object)InstallCommand.makeUnmetDialog(solution));
                        }
                        break block25;
                    }
                    if (raiseDialogs) {
                        boolean signatureWarningConfirmed;
                        boolean alsoInstallConfirmed = false;
                        BWidget widget = InstallCommand.makeSigningWarningDialog(solution, this.tableModel.getScenario(), this.tableModel.getCertValidator());
                        boolean bl = signatureWarningConfirmed = widget == null || 1 == BDialog.open((BWidget)this.getOwner(), (String)LEX.getText("InstallCommand.signingWarning.title"), (Object)widget, (int)3, (BImage)BDialog.WARNING_ICON, (String)null);
                        if (signatureWarningConfirmed) {
                            widget = InstallCommand.makeAlsoInstallDialog(initialInstallablesByPartSpec, solution);
                            boolean bl2 = alsoInstallConfirmed = widget == null || 1 == BDialog.confirm((BWidget)this.getOwner(), (String)LEX.getText("InstallCommand.alsoInstall.title"), (Object)widget, (int)3);
                        }
                        if (signatureWarningConfirmed && alsoInstallConfirmed) {
                            solution.getSolutionParameters().latestOnly = true;
                            this.tableModel.setScenario(solution);
                        }
                    } else {
                        solution.getSolutionParameters().latestOnly = true;
                        this.tableModel.setScenario(solution);
                    }
                }
                finally {
                    if (shell != null) {
                        shell.exitBusy();
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }
}

