/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.crypto.core.cert.CertificateChainValidator;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.ModuleSignatureStatusEnum;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;

public class InstallCommand
extends AsyncCommand {
    private final InstallerTableModel tableModel;
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    private static final int ALSO_INSTALL_DIALOG_WIDTH = 275;
    private static final int ALSO_INSTALL_DIALOG_HEIGHT = 300;
    private static final int UNMET_DIALOG_WIDTH = 275;
    private static final int UNMET_DIALOG_HEIGHT = 160;
    private static final int SIGNATURE_WARNING_DIALOG_WIDTH = 375;
    private static final int SIGNATURE_WARNING_DIALOG_HEIGHT = 160;
    private static final int SIGNATURE_ERROR_DIALOG_WIDTH = 375;
    private static final int SIGNATURE_ERROR_DIALOG_HEIGHT = 160;
    private static final int WORD_WRAP_LABEL_BUFFER = 35;

    public InstallCommand(BWidget owner, InstallerTableModel tableModel, String lexKey) {
        super(owner, LEX, lexKey);
        this.tableModel = tableModel;
    }

    public InstallCommand(BWidget owner, InstallerTableModel tableModel) {
        this(owner, tableModel, "SoftwareManager.command.installSelected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstallScenario install(BWidget owner, InstallerTableModel tableModel, int[] rows, boolean raiseDialogs) throws Exception {
        BWbShell shell = BWbShell.getWbShell((BWidget)owner);
        try {
            BInstallable[] inst;
            if (shell != null) {
                shell.enterBusy();
            }
            TreeMap<PartSpec, BInstallable> initialInstallablesByPartSpec = new TreeMap<PartSpec, BInstallable>();
            for (BInstallable anInst : inst = tableModel.getScenario().getToInstall()) {
                initialInstallablesByPartSpec.put(anInst.getPart().getPartSpec(), anInst);
            }
            for (int row : rows) {
                UnmeetableDependency[] toAdd = tableModel.getInstallableAt(row);
                initialInstallablesByPartSpec.put(toAdd.getPart().getPartSpec(), (BInstallable)toAdd);
            }
            inst = initialInstallablesByPartSpec.values().toArray(new BInstallable[0]);
            InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)tableModel.getScenario().getTargetPlatform(), (String[])tableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])inst, (SolutionParameters)tableModel.getScenario().getSolutionParameters(), (Set)tableModel.getScenario().getNewEnabledRuntimeProfiles(), (InstallableRegistry)LocalInstallableRegistry.getInstance(), (CertificateChainValidator)tableModel.getCertValidator());
            Map failed = installScenario.getSignatureFailures();
            if (!failed.isEmpty()) {
                if (raiseDialogs) {
                    BDialog.error((BWidget)owner, (String)LEX.getText("InstallCommand.signingError.title"), (Object)InstallCommand.makeSigningErrorDialog(failed, installScenario.getVerificationMode()));
                }
            } else if (installScenario.getExcludedInstallables().length > 0) {
                if (raiseDialogs) {
                    BDialog.error((BWidget)owner, (String)LEX.getText("InstallCommand.excluded.title"), (Object)LEX.getText("InstallCommand.excluded.message"));
                }
            } else if (installScenario.getUnmeetableDependencies().length > 0) {
                UnmeetableDependency[] unmet = installScenario.getUnmeetableDependencies();
                boolean anyCommissioning = false;
                for (UnmeetableDependency anUnmet : unmet) {
                    if (!anUnmet.isUnsolvable) continue;
                    anyCommissioning = true;
                    break;
                }
                if (anyCommissioning) {
                    if (raiseDialogs) {
                        boolean canCommission;
                        BDaemonSession session = tableModel.getScenario().getTargetPlatform().getDaemonSession();
                        BHostProperties hostProperties = session.getHostProperties();
                        boolean bl = canCommission = hostProperties.hasFullAccess() && hostProperties.isNiagara4() && !hostProperties.getNiagaraR2Enabled() && !session.usesLocalNiagaraHome() && CommissioningWizardModel.hostModelAllowsCommissioning(session);
                        if (!canCommission) {
                            BDialog.error((BWidget)owner, (String)LEX.getText("InstallCommand.mustCommission.title"), (Object)LEX.getText("InstallCommand.mustCommission.message"));
                        } else if (4 == BDialog.confirm((BWidget)owner, (String)LEX.getText("InstallCommand.mustCommission.title"), (Object)LEX.getText("InstallCommand.mustCommission.prompt"), (int)12)) {
                            try {
                                BDaemonSessionView.stopAllRefreshTimers(BWbShell.getWbShell((BWidget)owner), session.getHost());
                                BWizard.open((BWidget)owner, (WizardModel)new CommissioningWizardModel(owner, tableModel.getScenario().getTargetPlatform().getDaemonSession(), true));
                            }
                            finally {
                                BDaemonSessionView.startAllRefreshTimers(BWbShell.getWbShell((BWidget)owner), session.getHost());
                            }
                        }
                    } else {
                        tableModel.setScenario(installScenario);
                    }
                } else if (raiseDialogs) {
                    BDialog.error((BWidget)owner, (String)LEX.getText("InstallCommand.unmet.title"), (Object)InstallCommand.makeUnmetDialog(installScenario));
                }
            } else if (raiseDialogs) {
                boolean signatureWarningConfirmed;
                boolean alsoInstallConfirmed = false;
                BWidget widget = InstallCommand.makeSigningWarningDialog(installScenario, tableModel.getScenario(), tableModel.getCertValidator());
                boolean bl = signatureWarningConfirmed = widget == null || 1 == BDialog.open((BWidget)owner, (String)LEX.getText("InstallCommand.signingWarning.title"), (Object)widget, (int)3, (BImage)BDialog.WARNING_ICON, (String)null);
                if (signatureWarningConfirmed) {
                    widget = InstallCommand.makeAlsoInstallDialog(initialInstallablesByPartSpec, installScenario);
                    boolean bl2 = alsoInstallConfirmed = widget == null || 1 == BDialog.confirm((BWidget)owner, (String)LEX.getText("InstallCommand.alsoInstall.title"), (Object)widget, (int)3);
                }
                if (signatureWarningConfirmed && alsoInstallConfirmed) {
                    tableModel.setScenario(installScenario);
                }
            } else {
                tableModel.setScenario(installScenario);
            }
            InstallScenario installScenario2 = installScenario;
            return installScenario2;
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    public void doInvokeAsync() {
        try {
            InstallCommand.install(this.getOwner(), this.tableModel, this.tableModel.getTable().getSelection().getRows(), true);
        }
        catch (Throwable t) {
            CommandUtil.error((Command)this, (Throwable)t);
        }
    }

    public static BWidget makeAlsoInstallDialog(Map<PartSpec, BInstallable> initialInstallablesByPartSpec, InstallScenario solution) {
        BInstallable[] toInstall;
        BIndentPane pane = null;
        for (BInstallable aToInstall : toInstall = solution.getToInstall()) {
            BPart part = aToInstall.getPart();
            if (initialInstallablesByPartSpec.containsKey(part.getPartSpec())) continue;
            if (pane == null) {
                pane = new BIndentPane();
                pane.add(LexiconText.make((String)"platDaemon", (String)"InstallCommand.alsoInstall.toSatisfy"));
                pane.indent();
            }
            pane.add(aToInstall.getInstallableFileName());
        }
        if (pane == null) {
            return null;
        }
        pane.unindent();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane(pane, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)scroll);
        constrainedPane.setFixedSize(275.0, 300.0);
        return new BEdgePane(null, null, null, null, (BWidget)constrainedPane);
    }

    public static BWidget makeUnmetDialog(InstallScenario scenario) {
        BIndentPane result = new BIndentPane();
        result.add(LexiconText.make((String)"platDaemon", (String)"InstallCommand.unmet.heading"));
        UnmeetableDependency[] unmet = scenario.getUnmeetableDependencies();
        result.indent();
        for (UnmeetableDependency anUnmet : unmet) {
            if (anUnmet.isUnsolvable) continue;
            result.add(anUnmet.toString(null));
        }
        result.unindent();
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)result, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)scroll);
        constrainedPane.setFixedSize(275.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)constrainedPane);
    }

    public static BWidget makeSigningWarningDialog(InstallScenario solution, InstallScenario origScenario, CertificateChainValidator validator) {
        HashMap<ModuleSignatureStatusEnum, List> warnings = new HashMap<ModuleSignatureStatusEnum, List>();
        BInstallable[] toInstall = solution.getToInstall();
        List<BInstallable> origToInstall = Arrays.asList(origScenario.getToInstall());
        for (BInstallable installable : toInstall) {
            BModulePart part;
            List statuses;
            if (!(installable instanceof BModuleInstallable) || origToInstall.contains(installable) || (statuses = (part = ((BModuleInstallable)installable).getModulePart()).getSignatureStatus(validator)).contains(ModuleSignatureStatusEnum.OK)) continue;
            for (ModuleSignatureStatusEnum status : statuses) {
                warnings.computeIfAbsent(status, k -> new ArrayList()).add(installable.toString());
            }
        }
        if (!warnings.isEmpty()) {
            int targetWidth = 340;
            BIndentPane result = new BIndentPane();
            for (Map.Entry entry : warnings.entrySet()) {
                BLabel label = new BLabel(LEX.getText("InstallCommand." + ((ModuleSignatureStatusEnum)entry.getKey()).toString() + ".warning"));
                label.setWordWrapEnabled(true, (double)targetWidth);
                label.setHalign(BHalign.left);
                result.add((BWidget)label);
                result.indent();
                for (String module : (List)entry.getValue()) {
                    result.add(module);
                }
                result.unindent();
                result.add(" ");
            }
            BLabel label = new BLabel(LEX.getText("InstallCommand.continue"));
            label.setWordWrapEnabled(true, (double)targetWidth);
            label.setHalign(BHalign.left);
            result.add((BWidget)label);
            BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)result, 5.0, 5.0, 5.0, 5.0));
            scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
            scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
            BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)scroll);
            constrainedPane.setFixedSize(375.0, 160.0);
            return new BEdgePane(null, null, null, null, (BWidget)constrainedPane);
        }
        return null;
    }

    public static BWidget makeSigningErrorDialog(Map<BModuleInstallable, List<ModuleSignatureStatusEnum>> failed, ModuleVerificationMode verificationMode) {
        HashMap<ModuleSignatureStatusEnum, List> warnings = new HashMap<ModuleSignatureStatusEnum, List>();
        for (Map.Entry<BModuleInstallable, List<ModuleSignatureStatusEnum>> entry : failed.entrySet()) {
            List<ModuleSignatureStatusEnum> statuses = entry.getValue();
            Iterator<ModuleSignatureStatusEnum> iterator = statuses.iterator();
            while (iterator.hasNext()) {
                ModuleSignatureStatusEnum status = iterator.next();
                if (status.isAcceptable(verificationMode)) continue;
                warnings.computeIfAbsent(status, k -> new ArrayList()).add(entry.getKey().toString());
            }
        }
        int targetWidth = 340;
        BIndentPane result = new BIndentPane();
        for (Map.Entry entry : warnings.entrySet()) {
            BLabel label = new BLabel(LEX.getText("InstallCommand." + ((ModuleSignatureStatusEnum)entry.getKey()).toString() + ".error"));
            label.setWordWrapEnabled(true, (double)targetWidth);
            label.setHalign(BHalign.left);
            result.add((BWidget)label);
            result.indent();
            for (String module : (List)entry.getValue()) {
                result.add(module);
            }
            result.unindent();
            result.add(" ");
        }
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)result, 5.0, 5.0, 5.0, 5.0));
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)scroll);
        bConstrainedPane.setFixedSize(375.0, 160.0);
        return new BEdgePane(null, null, null, null, (BWidget)bConstrainedPane);
    }
}

