/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardStep;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BDaisyChainSettings;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.BTcpIpLinkSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public final class TcpIpStep
extends DistInstallWizardStep {
    private final BCheckBox updateTcpIpCheckBox;

    public TcpIpStep(DistInstallWizardModel wizardModel) {
        super(wizardModel);
        Throwable throwable;
        ZipFile distFile;
        File file;
        boolean isTridiumQNX;
        BDistribution distribution = wizardModel.getDistribution();
        BTcpIpHostSettings hostSettings = distribution.getTcpIpChanges();
        BDaemonSession daemonSession = wizardModel.getSession();
        BHostProperties hostProperties = daemonSession.getHostProperties();
        boolean bl = isTridiumQNX = !hostProperties.getIsNpsdk() && hostProperties.getOsName().toLowerCase().contains("qnx");
        if (hostProperties.supportsServlet("dhcpd")) {
            BDhcpdHostSettings dhcpdHostSettingsForRestoreTarget = new BDhcpdHostSettings();
            file = distribution.getLocalInstallableFile();
            try {
                distFile = new ZipFile(file);
                throwable = null;
                try {
                    DhcpdUtil.loadFromSession((BDhcpdHostSettings)dhcpdHostSettingsForRestoreTarget, (BDaemonSession)daemonSession);
                    String absoluteConfigurationFilePathBody2 = TcpIpStep.daemonUriToAbsoluteFilePathBody(dhcpdHostSettingsForRestoreTarget.getDhcpdConfPath());
                    String absoluteEnabledAdaptersFilePath = TcpIpStep.daemonUriToAbsoluteFilePathBody(dhcpdHostSettingsForRestoreTarget.getDhcpdAdaptersListPath());
                    DistributionManifest distributionManifest = distribution.getManifest();
                    String configurationFilePath = distributionManifest.getEntryPath(new FilePath(absoluteConfigurationFilePathBody2), true);
                    String enabledAdapterFilePath = distributionManifest.getEntryPath(new FilePath(absoluteEnabledAdaptersFilePath), true);
                    boolean foundConfFile = false;
                    String[] enabledAdapters = null;
                    Enumeration<? extends ZipEntry> zipEntryEnumeration = distFile.entries();
                    while (zipEntryEnumeration.hasMoreElements() && (!foundConfFile || enabledAdapters == null)) {
                        ZipEntry entry = zipEntryEnumeration.nextElement();
                        if (entry.getName().equals(configurationFilePath)) {
                            foundConfFile = true;
                            DhcpdUtil.stringToDhcpdSettings((BDhcpdHostSettings)dhcpdHostSettingsForRestoreTarget, (InputStream)distFile.getInputStream(entry), (boolean)isTridiumQNX);
                            continue;
                        }
                        if (!entry.getName().equals(enabledAdapterFilePath)) continue;
                        enabledAdapters = TextUtil.split((String)FileUtil.readString((Reader)new InputStreamReader(distFile.getInputStream(entry), StandardCharsets.UTF_8)).trim(), (char)',');
                        for (int i = 0; i < enabledAdapters.length; ++i) {
                            enabledAdapters[i] = DhcpdUtil.adapterOsNameToAdapterId((String)enabledAdapters[i], (boolean)isTridiumQNX);
                        }
                    }
                    if (foundConfFile) {
                        SlotCursor c = dhcpdHostSettingsForRestoreTarget.getDhcpdSubnets().loadSlots().getProperties();
                        while (c.next()) {
                            BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)c.get();
                            dhcpdAdapterSettings.setIsDhcpdIpv4Supported(true);
                            dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(false);
                        }
                        if (enabledAdapters != null) {
                            for (void var22_38 : enabledAdapters) {
                                String propName = SlotPath.escape((String)var22_38);
                                BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettingsForRestoreTarget.getDhcpdSubnets().get(propName);
                                if (dhcpdAdapterSettings == null) continue;
                                dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(true);
                            }
                        }
                    } else {
                        dhcpdHostSettingsForRestoreTarget = null;
                    }
                }
                catch (Throwable absoluteConfigurationFilePathBody2) {
                    throwable = absoluteConfigurationFilePathBody2;
                    throw absoluteConfigurationFilePathBody2;
                }
                finally {
                    if (distFile != null) {
                        if (throwable != null) {
                            try {
                                distFile.close();
                            }
                            catch (Throwable absoluteConfigurationFilePathBody2) {
                                throwable.addSuppressed(absoluteConfigurationFilePathBody2);
                            }
                        } else {
                            distFile.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                wizardModel.getLogger().log(Level.SEVERE, "Failed to read DHCPD settings from distribution, skipping DHCPD handling", e);
                dhcpdHostSettingsForRestoreTarget = null;
            }
            if (dhcpdHostSettingsForRestoreTarget != null) {
                DhcpdUtil.copyDhcpdSlotToAdapters((BDhcpdHostSettings)dhcpdHostSettingsForRestoreTarget, (BTcpIpHostSettings)hostSettings);
            }
        }
        if (hostProperties.supportsServlet("linkcfg")) {
            BLinkCfgHostSettings linkCfgHostSettingsForRestoreTarget = new BLinkCfgHostSettings();
            file = wizardModel.getDistribution().getLocalInstallableFile();
            try {
                distFile = new ZipFile(file);
                throwable = null;
                try {
                    LinkCfgUtil.loadFromSession((BLinkCfgHostSettings)linkCfgHostSettingsForRestoreTarget, (BDaemonSession)daemonSession);
                    String absoluteConfigurationFilePathBody3 = TcpIpStep.daemonUriToAbsoluteFilePathBody(linkCfgHostSettingsForRestoreTarget.getLinkConfPath());
                    DistributionManifest distributionManifest = distribution.getManifest();
                    String configurationFilePathEntry = distributionManifest.getEntryPath(new FilePath(absoluteConfigurationFilePathBody3), true);
                    boolean foundConfFile = false;
                    Enumeration<? extends ZipEntry> zipEntryEnumeration = distFile.entries();
                    while (zipEntryEnumeration.hasMoreElements() && !foundConfFile) {
                        ZipEntry entry = zipEntryEnumeration.nextElement();
                        if (!entry.getName().equals(configurationFilePathEntry)) continue;
                        foundConfFile = true;
                        LinkCfgUtil.linkCfgToSettings((BLinkCfgHostSettings)linkCfgHostSettingsForRestoreTarget, (InputStream)distFile.getInputStream(entry));
                        break;
                    }
                    if (!foundConfFile) {
                        linkCfgHostSettingsForRestoreTarget = null;
                    }
                }
                catch (Throwable absoluteConfigurationFilePathBody3) {
                    throwable = absoluteConfigurationFilePathBody3;
                    throw absoluteConfigurationFilePathBody3;
                }
                finally {
                    if (distFile != null) {
                        if (throwable != null) {
                            try {
                                distFile.close();
                            }
                            catch (Throwable absoluteConfigurationFilePathBody3) {
                                throwable.addSuppressed(absoluteConfigurationFilePathBody3);
                            }
                        } else {
                            distFile.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                wizardModel.getLogger().log(Level.SEVERE, "Failed to read Link settings from distribution, skipping Link handling", e);
                linkCfgHostSettingsForRestoreTarget = null;
            }
            if (linkCfgHostSettingsForRestoreTarget != null) {
                LinkCfgUtil.copyLinkCfgSlotToHost((BLinkCfgHostSettings)linkCfgHostSettingsForRestoreTarget, (BTcpIpHostSettings)hostSettings);
            }
        }
        BIndentPane indent = new BIndentPane();
        indent.add((BWidget)LabelUtil.makeLabel((LexiconText)this.getLexiconText("DistInstaller.TcpIpStep.header"), (boolean)true));
        indent.indent();
        BGridPane grid = new BGridPane(2);
        grid.setColumnGap(6.0);
        grid.setValign(BValign.top);
        grid.setHalign(BHalign.left);
        boolean ipv6Supported = false;
        SlotCursor c = hostSettings.getAdapters().getProperties();
        while (c.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c.get();
            if (!adapter.getIsIpv6Supported()) continue;
            ipv6Supported = true;
            break;
        }
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.hostName"), (BWidget)new BLabel(this.nvl(hostSettings.getHostName())), (boolean)false);
        if (ipv6Supported) {
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.niagaraUsesIpv6"), (BWidget)new BLabel(String.valueOf(hostSettings.getNiagaraUsesIpv6())), (boolean)false);
        }
        if (!hostSettings.getUsesAdapterLevelSettings()) {
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.domain"), (BWidget)new BLabel(this.nvl(hostSettings.getDomain())), (boolean)false);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.gateway"), (BWidget)new BLabel(this.nvl(hostSettings.getDefaultGateway())), (boolean)false);
            StringBuilder dnsHosts = new StringBuilder();
            SlotCursor dnsList = hostSettings.getDnsHosts().getProperties();
            while (dnsList.next(BString.class)) {
                dnsHosts.append(dnsList.get().toString());
                dnsHosts.append(" ");
            }
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)new BLabel(this.nvl(dnsHosts.toString())), (boolean)false);
            if (ipv6Supported) {
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)new BLabel(this.nvl(hostSettings.getIpv6DefaultGateway())), (boolean)false);
                StringBuilder dns6Hosts = new StringBuilder();
                SlotCursor dnsList2 = hostSettings.getIpv6DnsHosts().getProperties();
                while (dnsList2.next(BString.class)) {
                    dns6Hosts.append(dnsList2.get().toString());
                    dns6Hosts.append(" ");
                }
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)new BLabel(this.nvl(dns6Hosts.toString())), (boolean)false);
            }
        }
        BTcpIpLinkSettings tcpIpLinkSettings = (BTcpIpLinkSettings)hostSettings.get("linkModeSettings");
        BVector linkModesSupported = (BVector)hostSettings.get("linkModesSupported");
        if (tcpIpLinkSettings != null && linkModesSupported != null) {
            boolean showLinkReview = true;
            if (linkModesSupported.getPropertyCount() == 1 && tcpIpLinkSettings.getLinkMode().getOrdinal() == 0) {
                showLinkReview = false;
            }
            if (showLinkReview) {
                BDaisyChainSettings daisyChainSettings;
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.activeLinkMode"), (BWidget)new BLabel(tcpIpLinkSettings.getLinkMode().getDisplayTag(null)), (boolean)false);
                if (tcpIpLinkSettings instanceof BDaisyChainSettings && (daisyChainSettings = (BDaisyChainSettings)tcpIpLinkSettings).getIsStpSupported()) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpLabel"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getIsStpEnabled())), (boolean)false);
                    if (daisyChainSettings.getIsStpEnabled()) {
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpBridgePriority"), (BWidget)new BLabel(daisyChainSettings.getBridgePriority().getDisplayTag(null)), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpPortPriority1"), (BWidget)new BLabel(daisyChainSettings.getPortPriority1().getDisplayTag(null)), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpPortPriority2"), (BWidget)new BLabel(daisyChainSettings.getPortPriority2().getDisplayTag(null)), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpHelloTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getHelloTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpForwardDelayTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getForwardDelayTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.link.daisychain.stpMaxAgingTime"), (BWidget)new BLabel(String.valueOf(daisyChainSettings.getMaxAgingTime())), (boolean)false);
                    }
                }
            }
        }
        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpHostEditor.interfaceCategory"), (BWidget)new BNullWidget(), (boolean)false);
        indent.indent();
        indent.add((BWidget)grid);
        indent.indent();
        boolean firstPass = true;
        SlotCursor c2 = hostSettings.getAdapters().getProperties();
        while (c2.next(BTcpIpAdapterSettings.class)) {
            BTcpIpAdapterSettings adapter = (BTcpIpAdapterSettings)c2.get();
            grid = new BGridPane(2);
            grid.setColumnGap(6.0);
            grid.setValign(BValign.top);
            grid.setHalign(BHalign.left);
            if (!firstPass) {
                grid.add(null, (BValue)new BBox(1.0, 1.0));
                grid.add(null, (BValue)new BBox(1.0, 1.0));
            }
            firstPass = false;
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.interfaceId"), (BWidget)new BLabel(adapter.getAdapterId()), (boolean)false);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.interfaceDesc"), (BWidget)new BLabel(adapter.getDescription()), (boolean)false);
            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isAdapterEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsAdapterEnabled())), (boolean)false);
            if (adapter.getIsAdapterEnabled()) {
                BDhcpdAdapterSettings dhcpdAdapterSettings;
                if (adapter.getCanUseDhcp()) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isDhcpEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsDhcpEnabled())), (boolean)false);
                    if (!adapter.getIsDhcpEnabled()) {
                        if (hostSettings.getUsesAdapterLevelSettings()) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.domain"), (BWidget)new BLabel(this.nvl(adapter.getDomain())), (boolean)false);
                        }
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipAddress"), (BWidget)new BLabel(this.nvl(adapter.getIpAddress())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.subnetMask"), (BWidget)new BLabel(this.nvl(adapter.getSubnetMask())), (boolean)false);
                        if (hostSettings.getUsesAdapterLevelSettings()) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.gateway"), (BWidget)new BLabel(this.nvl(adapter.getDefaultGateway())), (boolean)false);
                            StringBuilder dnsHosts = new StringBuilder();
                            SlotCursor dnsList = adapter.getDnsHosts().getProperties();
                            while (dnsList.next(BString.class)) {
                                dnsHosts.append(dnsList.get().toString());
                                dnsHosts.append(" ");
                            }
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)new BLabel(this.nvl(dnsHosts.toString())), (boolean)false);
                        }
                    }
                }
                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6Supported"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6Supported())), (boolean)false);
                if (adapter.getIsIpv6Supported()) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6Enabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6Enabled())), (boolean)false);
                    if (adapter.getIsIpv6Enabled()) {
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.isIpv6DhcpEnabled"), (BWidget)new BLabel(String.valueOf(adapter.getIsIpv6DhcpEnabled())), (boolean)false);
                        if (!adapter.getIsIpv6DhcpEnabled()) {
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Address"), (BWidget)new BLabel(this.nvl(adapter.getIpv6Address())), (boolean)false);
                            LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6SubnetPrefixLength"), (BWidget)new BLabel(this.nvl(String.valueOf(adapter.getIpv6SubnetPrefixLength()))), (boolean)false);
                            if (hostSettings.getUsesAdapterLevelSettings()) {
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6Gateway"), (BWidget)new BLabel(this.nvl(adapter.getIpv6DefaultGateway())), (boolean)false);
                                StringBuilder dns6Hosts = new StringBuilder();
                                SlotCursor dnsList = adapter.getIpv6DnsHosts().getProperties();
                                while (dnsList.next(BString.class)) {
                                    dns6Hosts.append(dnsList.get().toString());
                                    dns6Hosts.append(" ");
                                }
                                LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)new BLabel(this.nvl(dns6Hosts.toString())), (boolean)false);
                            }
                        }
                    }
                }
                if ((dhcpdAdapterSettings = (BDhcpdAdapterSettings)adapter.get("dhcpdAdapterSettings")) != null) {
                    LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.isDhcpdEnabled"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getIsDhcpdIpv4Enabled())), (boolean)false);
                    if (dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) {
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.defaultLeaseTime.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getDefaultLeaseTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.maxLeaseTime.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getMaxLeaseTime())), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.subnet.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getSubnet()), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.netmask.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getSubnetMask()), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.rangestart.label"), (BWidget)new BLabel(dhcpdAdapterSettings.getStartClientAddress()), (boolean)false);
                        LabelUtil.addLabelWidgetPair((BPane)grid, (LexiconText)LexiconText.make((String)"platform", (String)"TcpIpAdapterEditorDhcpd.rangesize.label"), (BWidget)new BLabel(String.valueOf(dhcpdAdapterSettings.getRange())), (boolean)false);
                    }
                }
            }
            indent.add((BWidget)grid);
        }
        indent.unindent();
        indent.unindent();
        this.updateTcpIpCheckBox = new BCheckBox(Lexicon.make((String)"platDaemon").getText("DistInstaller.TcpIpStep.checkBox"));
        indent.add((BWidget)this.updateTcpIpCheckBox);
        BScrollPane scroll = new BScrollPane((BWidget)new BBorderPane((BWidget)indent, 3.0, 3.0, 3.0, 3.0));
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)scroll);
    }

    private String nvl(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Lexicon.make((String)"platDaemon").getText("DistInstaller.TcpIpStep.empty");
        }
        return value;
    }

    private static String daemonUriToAbsoluteFilePathBody(String daemonUriPath) {
        if (daemonUriPath.startsWith("/niagara/")) {
            return TextUtil.replace((String)daemonUriPath, (String)"/niagara/", (String)"!");
        }
        if (daemonUriPath.startsWith("/niagara_user/")) {
            return TextUtil.replace((String)daemonUriPath, (String)"/niagara_user/", (String)"~");
        }
        throw new IllegalArgumentException("Invalid daemonuri path '" + daemonUriPath + "'provided");
    }

    @Override
    public String getStepName() {
        return "TcpIpStep";
    }

    @Override
    public void enter() {
        this.updateTcpIpCheckBox.setSelected(this.getWizardModel().updateTcpIp());
    }

    @Override
    public boolean exit() {
        this.getWizardModel().setUpdateTcpIp(this.updateTcpIpCheckBox.isSelected());
        return true;
    }
}

