/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.PasswordStrength;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardStep;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import java.util.EnumSet;
import java.util.logging.Logger;
import javax.baja.security.BPassword;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class PromptPassPhraseStep
extends DistInstallWizardStep {
    private BPasswordFE passwordFE;
    private BLabel errorLabel;
    private static final Lexicon LEX = Lexicon.make((String)"platDaemon");
    private static final Logger LOG = Logger.getLogger("platDaemon");

    public PromptPassPhraseStep(DistInstallWizardModel wizardModel) {
        super(wizardModel);
        BGridPane gridPane = new BGridPane(2);
        gridPane.setValign(BValign.top);
        gridPane.setHalign(BHalign.left);
        this.passwordFE = new BPasswordFE();
        LabelUtil.addLabelWidgetPair((BPane)gridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"DistInstaller.PromptPassPhraseStep.passPhrase"), (BWidget)this.passwordFE);
        this.errorLabel = new BLabel("", BHalign.left);
        this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)new BLabel(LEX.getText("DistInstaller.PromptPassPhraseStep.header"), BHalign.left), 0.0, 0.0, 5.0, 0.0), (BWidget)new BBorderPane((BWidget)this.errorLabel, 10.0, 0.0, 0.0, 0.0), null, null, (BWidget)gridPane));
        StyleUtils.addStyleClass((IStylable)this.errorLabel, (String)"error");
        this.errorLabel.setWordWrapEnabled(true);
    }

    @Override
    public String getStepName() {
        return "PromptPassPhraseStep";
    }

    @Override
    public boolean isSkipped() {
        return !this.getWizardModel().promptForPassPhrase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exit() {
        try (SecretChars passPhraseTestCopy = null;){
            BPassword value = (BPassword)this.passwordFE.saveValue();
            if (value != null) {
                passPhraseTestCopy = value.getSecretChars();
                if (this.getWizardModel().getDistribution().getManifest().getPBEEncodingInfo().test(passPhraseTestCopy)) {
                    this.getWizardModel().setDistFilePassPhrase(value.getSecretChars());
                    this.errorLabel.setText("");
                    boolean bl = true;
                    return bl;
                }
            }
            EnumSet validationFaults = EnumSet.noneOf(PBEValidator.ValidationFault.class);
            if (value != null) {
                try (SecretChars secretChars = value.getSecretChars();){
                    validationFaults = PBEValidator.checkPassPhraseValidity((SecretChars)secretChars);
                }
            }
            if (validationFaults.contains(PBEValidator.ValidationFault.FIPS_MIN_LENGTH)) {
                this.errorLabel.setText(LEX.getText("DistInstaller.PromptPassPhraseStep.passPhraseLength", new Object[]{SecurityInitializer.getInstance().getFipsInformation().getFipsVersion(), PasswordStrength.MINIMUM_ALLOWED_LENGTH}));
            } else {
                this.errorLabel.setText(LEX.getText("DistInstaller.PromptPassPhraseStep.badPassPhrase"));
            }
            boolean bl = false;
            return bl;
        }
    }
}

