/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.ui.config.BDaemonBackupJob;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.util.LabelUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class DaemonBackupJobDialog
implements Runnable,
DaemonFileUtil.TransferStatus {
    private final BDaemonBackupJob job;
    private final InputStream in;
    private final BCommandDialog dialog;
    private final Context cx;
    private final BIFile file;
    private final BWidget owner;
    private final BLabel jobStateLabel;
    private final BLabel fileLabel;
    private final DialogCommand detailsCommand;
    private JobWatcher watcher = null;
    private final BProgressBar progress;
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");
    private static final Logger log = Logger.getLogger("platDaemon");
    public static final int DETAILS = 32;
    static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final String lexStatus = UiLexicon.bajaui().getText("status");
    static final String lexTimestamp = UiLexicon.bajaui().getText("timestamp");
    static final String lexMessage = UiLexicon.bajaui().getText("message");
    static final String lexDetails = UiLexicon.bajaui().getText("details");

    private DaemonBackupJobDialog(BWidget owner, BDaemonBackupJob job, InputStream in, BIFile file, Context cx) throws Exception {
        this.owner = owner;
        this.in = in;
        this.job = job;
        this.cx = cx;
        this.file = file;
        BEdgePane edge = new BEdgePane();
        BGridPane ledger = new BGridPane(2);
        ledger.setHalign(BHalign.left);
        ledger.setValign(BValign.top);
        ledger.setColumnGap(10.0);
        ledger.setRowGap(6.0);
        this.fileLabel = new BLabel(lex.getText("DaemonBackupJobDialog.file.text", new Object[]{file.getFilePath().getBody(), DaemonFileUtil.fileSize((long)0L)}));
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((String)"platDaemon", (String)"DaemonBackupJobDialog.file.label"), (BWidget)this.fileLabel, (boolean)true);
        this.jobStateLabel = new BLabel(DaemonBackupJobDialog.stateToIcon(job.getJobState()), job.getJobState().toString(cx));
        LabelUtil.addLabelWidgetPair((BPane)ledger, (LexiconText)LexiconText.make((String)"platDaemon", (String)"DaemonBackupJobDialog.job.label"), (BWidget)this.jobStateLabel, (boolean)true);
        edge.setCenter((BWidget)ledger);
        BGridPane bottom = new BGridPane(1);
        bottom.setColumnAlign(BHalign.fill);
        bottom.setStretchColumn(0);
        this.progress = new BProgressBar();
        bottom.add(null, (BValue)this.progress);
        BConstrainedPane content = new BConstrainedPane((BWidget)edge);
        content.setMinWidth(500.0);
        this.dialog = BCommandDialog.make((BWidget)owner, (String)lex.getText("DaemonBackupJobDialog.dlgTitle"), (boolean)true, (Object)new BBorderPane((BWidget)content, 5.0, 5.0, 5.0, 5.0), (DialogCommand[])new DialogCommand[]{new CancelCommand(), this.detailsCommand = new DetailsCommand()}, null);
        this.dialog.setBoundsCenteredOnOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void raise(BWidget owner, BRemoteDaemonPlatform platform, BIFile file, Context cx) throws Exception {
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream(out);
        try {
            BDaemonBackupJob job = new BDaemonBackupJob(file, out, platform);
            DaemonBackupJobDialog dialog = new DaemonBackupJobDialog(owner, job, in, file, cx);
            new Thread((Runnable)dialog, "DaemonBackupJobDialog").start();
            if (16 == dialog.open()) {
                if (dialog.watcher != null) {
                    dialog.watcher.stopWatcher();
                }
            } else {
                if (dialog.watcher != null) {
                    dialog.watcher.stopWatcher();
                }
                JobLog log = JobLog.decode((String)job.readLog().toString());
                BTable table = new BTable((TableModel)new JobLogTable(log), (TableController)new JobLogController(log));
                BConstrainedPane pane = new BConstrainedPane((BWidget)table);
                pane.setFixedSize(800.0, 400.0);
                BDialog.open((BWidget)owner, (String)lex.getText("DaemonBackupJobDialog.detailsCommand.dlgTitle"), (Object)pane, (int)1);
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
    }

    public int open() {
        this.dialog.open();
        return this.dialog.getResult();
    }

    public void updateBytesWritten(long written) {
        this.fileLabel.setText(lex.getText("DaemonBackupJobDialog.file.text", new Object[]{this.file.getFilePath().getBody(), DaemonFileUtil.fileSize((long)written)}));
    }

    public boolean isCanceled() {
        try {
            BJobState state = this.job.getJobState();
            return state == BJobState.canceling || state == BJobState.canceled || state == BJobState.failed;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void run() {
        OutputStream out = null;
        this.watcher = null;
        try {
            out = this.file.getOutputStream();
            this.job.submit(this.cx);
            this.watcher = new JobWatcher();
            this.watcher.start();
            DaemonFileUtil.pipe((InputStream)this.in, (OutputStream)out, (DaemonFileUtil.TransferStatus)this);
            this.progress.setValue(100.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            this.dialog.replaceCommand(0, DialogCommand.makeClose((BWidget)this.owner));
        }
    }

    static BImage itemToIcon(JobLogItem item) {
        switch (item.getId()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return successIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return messageIcon;
    }

    static BImage stateToIcon(BJobState state) {
        switch (state.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: 
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    private class JobWatcher
    extends Thread {
        private boolean stopped = false;

        private JobWatcher() {
        }

        @Override
        public void run() {
            BJobState lastState = null;
            try {
                while (!this.stopped) {
                    if (DaemonBackupJobDialog.this.job.getJobState() != lastState) {
                        lastState = DaemonBackupJobDialog.this.job.getJobState();
                        DaemonBackupJobDialog.this.jobStateLabel.setText(lastState.toString(DaemonBackupJobDialog.this.cx));
                        DaemonBackupJobDialog.this.jobStateLabel.setImage(DaemonBackupJobDialog.stateToIcon(lastState));
                    }
                    if (lastState != null && lastState.isComplete()) {
                        DaemonBackupJobDialog.this.dialog.replaceCommand(0, DialogCommand.makeClose((BWidget)DaemonBackupJobDialog.this.owner));
                        DaemonBackupJobDialog.this.progress.setValue(100.0);
                        DaemonBackupJobDialog.this.detailsCommand.setEnabled(true);
                        this.stopWatcher();
                        return;
                    }
                    DaemonBackupJobDialog.this.progress.setValue((double)DaemonBackupJobDialog.this.job.getProgress());
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "DaemonBackupJobDialog JobWatcher watcher failed with exception", e);
            }
        }

        public void stopWatcher() {
            this.stopped = true;
        }
    }

    private static class JobLogController
    extends TableController {
        JobLog log;

        JobLogController(JobLog log) {
            this.log = log;
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            JobLogItem item = this.log.getItem(row);
            BTextEditor text = new BTextEditor(item.toString(), false);
            BTextEditorPane pane = new BTextEditorPane(text, 40, 80);
            BDialog.open((BWidget)this.getTable(), (String)lex.getText("DaemonBackupJobDialog.logDetails.dlgTitle"), (Object)pane, (int)1);
        }
    }

    private static class JobLogTable
    extends TableModel {
        JobLogItem[] items;
        String[] messages;
        String[] details;

        JobLogTable(JobLog log) {
            this.items = log.getItems();
            this.messages = new String[this.items.length];
            this.details = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                this.messages[i] = this.str(this.items[i].getMessage());
                this.details[i] = this.str(this.items[i].getDetails());
            }
        }

        String str(String s) {
            if (s == null) {
                return "";
            }
            int n = s.indexOf(10);
            if (n < 0) {
                return s;
            }
            return s.substring(0, n);
        }

        public int getRowCount() {
            return this.items.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lexStatus;
                }
                case 1: {
                    return lexTimestamp;
                }
                case 2: {
                    return lexMessage;
                }
                case 3: {
                    return lexDetails;
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.items[row].getIdString();
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.messages[row];
                }
                case 3: {
                    return this.details[row];
                }
            }
            return "???";
        }

        public Object getSubject(int row) {
            return this.items[row];
        }

        public BObject export(int row, int col) {
            switch (col) {
                case 0: {
                    return this.export(this.items[row].getIdString());
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.export(this.items[row].getMessage());
                }
                case 3: {
                    return this.export(this.items[row].getDetails());
                }
            }
            return BString.DEFAULT;
        }

        BString export(String s) {
            if (s == null) {
                return BString.DEFAULT;
            }
            return BString.make((String)s);
        }

        public BImage getRowIcon(int row) {
            return DaemonBackupJobDialog.itemToIcon(this.items[row]);
        }
    }

    private class CancelCommand
    extends DialogCommand {
        public CancelCommand() {
            super(DaemonBackupJobDialog.this.owner, 2, UiLexicon.bajaui().getText("dialog.cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() throws Exception {
            DaemonBackupJobDialog.this.job.cancel();
            return null;
        }
    }

    private class DetailsCommand
    extends DialogCommand {
        public DetailsCommand() {
            super(DaemonBackupJobDialog.this.owner, 32, lex.getText("DaemonBackupJobDialog.detailsCommand.label"), null, null, null);
            this.setEnabled(false);
        }
    }
}

