/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.nre.security.SecretChars;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platcrypto.daemon.messages.SendClientAliasesMessage;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.UpdateSyslogConfigurationMessage;
import com.tridium.platform.syslog.BSyslogFacilityEnum;
import com.tridium.platform.syslog.BSyslogLevelEnum;
import com.tridium.platform.syslog.BSyslogMessageTypeEnum;
import com.tridium.platform.syslog.BSyslogSettings;
import com.tridium.platform.syslog.BSyslogTransportProtocolEnum;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BDefaultPasswordFE;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import com.tridium.workbench.fieldeditors.BLimitedFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BStringFE;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraAction(name="configurationModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)
public class BSyslogConfigurationDialog
extends BDaemonSessionView {
    @Generated
    public static final Action configurationModified = BSyslogConfigurationDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSyslogConfigurationDialog.class);
    public static BIcon ICON = BIcon.std((String)"log.png");
    private static final boolean EDITABLE = true;
    private static final int MAX_ALIAS_DISPLAY_WIDTH = 25;
    private final DialogCommand saveCommand;
    private final BGridPane grid = new BGridPane(2);
    private BTextDropDown clientAliasTextDropdown;
    private BSyslogSettings settings;
    private BBooleanFE enabledDropdown;
    private BFrozenEnumFE logLevelFilterDropdown;
    private BBooleanFE platformLogEnabledDropdown;
    private BBooleanFE stationLogEnabledDropdown;
    private BBooleanFE stationAuditEnabledDropdown;
    private BBooleanFE securityAuditEnabledDropdown;
    private BStringFE hostField;
    private BDefaultPasswordFE clientPasswordField;
    private BIntegerFE queueSizeField;
    private BIntegerFE portField;
    private BFrozenEnumFE messageTypeDropdown;
    private BLimitedFrozenEnumFE facilityDropdown;
    private BFrozenEnumFE transportProtocolDropdown;
    private UpdateSyslogConfigurationMessage message;
    private boolean wasChanged;
    private boolean wasSaved;

    @Generated
    public void configurationModified(BWidgetEvent parameter) {
        this.invoke(configurationModified, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSyslogConfigurationDialog() {
        this.grid.setRowGap(5.0);
        this.grid.setHalign(BHalign.center);
        this.grid.setValign(BValign.center);
        BScrollPane scrollPane = new BScrollPane((BWidget)this.grid);
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bounded = new BConstrainedPane((BWidget)scrollPane);
        bounded.setMinSize(200.0, 300.0);
        this.setContent((BWidget)bounded);
        this.saveCommand = new SaveCommand();
    }

    @Override
    protected void doLoadSession(BDaemonSession session, Context cx) {
        if (session.getHostProperties().getSyslogSupported()) {
            this.wasChanged = false;
            this.wasSaved = false;
            BSyslogSettings settings = session.getHostProperties().getSyslogSettings();
            this.settings = (BSyslogSettings)settings.newCopy();
            this.createEnabledDropdown(settings);
            this.createTargetHostField(settings);
            this.createPortField(settings);
            this.createMessageTypeDropdown(settings);
            this.createTransportProtocolDropdown(settings);
            this.createClientAliasField(session, settings);
            this.createClientPasswordField(settings);
            this.createPlatformLogEnabledDropdown(settings);
            this.createStationLogEnabledDropdown(settings);
            this.createLogLevelFilterDropdown(settings);
            this.createStationAuditEnabledDropdown(settings);
            this.createSecurityAuditEnabledDropdown(settings);
            this.createFacilityDropdown(settings);
            this.createQueueSizeField(settings);
            try {
                this.message = AccessController.doPrivileged(() -> new UpdateSyslogConfigurationMessage(settings, this.getDaemonSession().generateSharedSecretKey("updateSyslogSettings")));
            }
            catch (PrivilegedActionException e) {
                log.log(Level.WARNING, "error retrieving shared secret key", e.getCause());
            }
        } else {
            this.createSyslogUnsupportedMessage();
        }
    }

    private void createSyslogUnsupportedMessage() {
        BLabel warningLabel = new BLabel(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.unsupported").getText(null), BHalign.center);
        BConstrainedPane bounded = new BConstrainedPane((BWidget)warningLabel);
        bounded.setMinSize(150.0, 50.0);
        BBorderPane borderPane = new BBorderPane();
        borderPane.setContent((BWidget)bounded);
        borderPane.setPadding(BInsets.make((double)15.0, (double)15.0, (double)15.0, (double)15.0));
        this.setContent((BWidget)borderPane);
    }

    private void createEnabledDropdown(BSyslogSettings settings) {
        this.enabledDropdown = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.enabled"), (BWidget)this.enabledDropdown);
        this.enabledDropdown.loadValue((BObject)BBoolean.make((boolean)settings.getEnabled()));
        this.enabledDropdown.setReadonly(settings.getIsReadonly());
        this.linkTo((BComponent)this.enabledDropdown, (Slot)BBooleanFE.setModified, (Slot)configurationModified);
    }

    private void createTargetHostField(BSyslogSettings settings) {
        this.hostField = new BStringFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.targetHost"), (BWidget)this.hostField);
        BFacets facets = BFacets.make((String)"fieldWidth", (int)20);
        BasicContext cx = new BasicContext((Context)facets);
        this.hostField.loadValue((BObject)BString.make((String)settings.getServerHost()), (Context)cx);
        this.hostField.setReadonly(settings.getIsReadonly());
        this.linkTo((BComponent)this.hostField, (Slot)BStringFE.setModified, (Slot)configurationModified);
    }

    private void createPortField(BSyslogSettings settings) {
        this.portField = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.targetPort"), (BWidget)this.portField);
        BFacets facets = BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)65535), (String)"fieldWidth", (BIDataValue)BInteger.make((int)5));
        BasicContext cx = new BasicContext((Context)facets);
        this.portField.loadValue((BObject)BInteger.make((int)settings.getServerPort()), (Context)cx);
        this.linkTo((BComponent)this.portField, (Slot)BIntegerFE.setModified, (Slot)configurationModified);
        this.portField.setReadonly(settings.getIsReadonly());
    }

    private void createMessageTypeDropdown(BSyslogSettings settings) {
        this.messageTypeDropdown = new BFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.messageType"), (BWidget)this.messageTypeDropdown);
        BSyslogMessageTypeEnum messageTypeEnum = BSyslogMessageTypeEnum.bsd;
        this.messageTypeDropdown.loadValue((BObject)messageTypeEnum);
        this.linkTo((BComponent)this.messageTypeDropdown, (Slot)BFrozenEnumFE.setModified, (Slot)configurationModified);
        this.messageTypeDropdown.setReadonly(true);
        this.messageTypeDropdown.setEnabled(false);
    }

    private void createTransportProtocolDropdown(BSyslogSettings settings) {
        this.transportProtocolDropdown = new BFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.transportProtocol"), (BWidget)this.transportProtocolDropdown);
        this.transportProtocolDropdown.loadValue((BObject)settings.getTransportProtocol());
        this.linkTo((BComponent)this.transportProtocolDropdown, (Slot)BFrozenEnumFE.setModified, (Slot)configurationModified);
    }

    private void loadClientAliases(BDaemonSession session, BSyslogSettings settings) {
        BHostProperties props = session.getHostProperties();
        if (props.getSslSupported() && props.supportsServlet("crypto")) {
            try {
                InputStream in = session.getInputStream((DaemonMessage)new SendClientAliasesMessage("userKeyStore"));
                XElem aliasesElem = XParser.make((InputStream)in).parse();
                settings.parseClientAliases(aliasesElem);
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.SEVERE, "Exception loading aliases", e);
                }
                log.log(Level.SEVERE, "Exception loading aliases: " + e.getMessage());
            }
        }
    }

    private void createClientAliasField(BDaemonSession session, BSyslogSettings settings) {
        this.loadClientAliases(session, settings);
        String currentClientAlias = settings.getClientAliasAndPassword().getAlias();
        List clientAliasesList = settings.getClientAliasesList();
        if (!clientAliasesList.contains(currentClientAlias)) {
            clientAliasesList.add(currentClientAlias);
        }
        this.clientAliasTextDropdown = new BTextDropDown(clientAliasesList, 25, true);
        BList list = this.clientAliasTextDropdown.getList();
        for (int i = 0; i < list.getItemCount(); ++i) {
            String listAlias = (String)list.getItem(i);
            if (!listAlias.equalsIgnoreCase(currentClientAlias)) continue;
            list.setSelectedIndex(i);
            this.clientAliasTextDropdown.setText((String)list.getSelectedItem());
            break;
        }
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.clientAlias"), (BWidget)this.clientAliasTextDropdown);
        this.linkTo((BComponent)this.clientAliasTextDropdown, (Slot)BDropDown.valueModified, (Slot)configurationModified);
    }

    private void createClientPasswordField(BSyslogSettings settings) {
        this.clientPasswordField = new BDefaultPasswordFE(1);
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.clientPassword"), (BWidget)this.clientPasswordField);
        BFacets facets = BFacets.make((String)"placeholderText", (BIDataValue)BString.make((String)"%lexicon(workbench:default.password.placeholder.label)%"), (String)"fieldWidth", (BIDataValue)BInteger.make((int)20));
        BasicContext cx = new BasicContext((Context)facets);
        this.clientPasswordField.loadValue((BObject)BPassword.DEFAULT, (Context)cx);
        this.clientPasswordField.setReadonly(settings.getIsReadonly());
        this.linkTo((BComponent)this.clientPasswordField, (Slot)BDefaultPasswordFE.modified, (Slot)configurationModified);
    }

    private void createPlatformLogEnabledDropdown(BSyslogSettings settings) {
        this.platformLogEnabledDropdown = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.platformLog"), (BWidget)this.platformLogEnabledDropdown);
        this.platformLogEnabledDropdown.loadValue((BObject)BBoolean.make((boolean)settings.getPlatformLogEnabled()));
        this.platformLogEnabledDropdown.setReadonly(settings.getIsReadonly());
        this.linkTo((BComponent)this.platformLogEnabledDropdown, (Slot)BBooleanFE.setModified, (Slot)configurationModified);
    }

    private void createStationLogEnabledDropdown(BSyslogSettings settings) {
        this.stationLogEnabledDropdown = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.stationLog"), (BWidget)this.stationLogEnabledDropdown);
        this.stationLogEnabledDropdown.loadValue((BObject)BBoolean.make((boolean)settings.getStationLogEnabled()));
        this.stationLogEnabledDropdown.setReadonly(settings.getIsReadonly());
        this.linkTo((BComponent)this.stationLogEnabledDropdown, (Slot)BBooleanFE.setModified, (Slot)configurationModified);
    }

    private void createStationAuditEnabledDropdown(BSyslogSettings settings) {
        this.stationAuditEnabledDropdown = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.stationAudit"), (BWidget)this.stationAuditEnabledDropdown);
        this.stationAuditEnabledDropdown.loadValue((BObject)BBoolean.make((boolean)settings.getStationAuditEnabled()));
        this.stationAuditEnabledDropdown.setReadonly(settings.getIsReadonly());
        this.linkTo((BComponent)this.stationAuditEnabledDropdown, (Slot)BBooleanFE.setModified, (Slot)configurationModified);
    }

    private void createSecurityAuditEnabledDropdown(BSyslogSettings settings) {
        this.securityAuditEnabledDropdown = new BBooleanFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.securityAudit"), (BWidget)this.securityAuditEnabledDropdown);
        this.securityAuditEnabledDropdown.loadValue((BObject)BBoolean.make((boolean)settings.getSecurityAuditEnabled()));
        this.securityAuditEnabledDropdown.setReadonly(settings.getIsReadonly());
        this.linkTo((BComponent)this.securityAuditEnabledDropdown, (Slot)BBooleanFE.setModified, (Slot)configurationModified);
    }

    private void createFacilityDropdown(BSyslogSettings settings) {
        this.facilityDropdown = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.facility"), (BWidget)this.facilityDropdown);
        this.facilityDropdown.loadValue((BObject)settings.getFacility(), (Context)new BasicContext(this.getCurrentContext(), BSyslogFacilityEnum.makeFacilitiesFacets()));
        this.linkTo((BComponent)this.facilityDropdown, (Slot)BLimitedFrozenEnumFE.setModified, (Slot)configurationModified);
    }

    private void createQueueSizeField(BSyslogSettings settings) {
        this.queueSizeField = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.queueSize"), (BWidget)this.queueSizeField);
        BFacets facets = BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1), (String)"max", (BIDataValue)BInteger.make((int)10000), (String)"fieldWidth", (BIDataValue)BInteger.make((int)5));
        BasicContext cx = new BasicContext((Context)facets);
        this.queueSizeField.loadValue((BObject)BInteger.make((int)settings.getQueueSize()), (Context)cx);
        this.linkTo((BComponent)this.queueSizeField, (Slot)BIntegerFE.setModified, (Slot)configurationModified);
        this.queueSizeField.setReadonly(settings.getIsReadonly());
    }

    private void createLogLevelFilterDropdown(BSyslogSettings settings) {
        this.logLevelFilterDropdown = new BFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.syslogSettings.logLevelFilter"), (BWidget)this.logLevelFilterDropdown);
        this.logLevelFilterDropdown.loadValue((BObject)BSyslogLevelEnum.make((String)settings.getLogLevelFilter().getTag().toLowerCase(Locale.ENGLISH)));
        this.linkTo((BComponent)this.logLevelFilterDropdown, (Slot)BFrozenEnumFE.setModified, (Slot)configurationModified);
    }

    public DialogCommand getSaveCommand() {
        return this.saveCommand;
    }

    public BSyslogSettings getSettings() {
        return this.settings;
    }

    public UpdateSyslogConfigurationMessage getMessage() {
        return this.message;
    }

    public boolean areSettingsChanged() {
        return this.wasChanged && this.wasSaved;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void doConfigurationModified(BWidgetEvent event) {
        this.wasChanged = true;
        this.saveCommand.setEnabled(true);
    }

    private class SaveCommand
    extends DialogCommand {
        public SaveCommand() {
            super((BWidget)BSyslogConfigurationDialog.this, 1, UiLexicon.bajaui().getText("commands.save.label"), null, null, null);
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            block32: {
                try {
                    if (BSyslogConfigurationDialog.this.enabledDropdown.isModified()) {
                        BSyslogConfigurationDialog.this.settings.setEnabled(((BIBoolean)BSyslogConfigurationDialog.this.enabledDropdown.saveValue()).getBoolean());
                    }
                    if (BSyslogConfigurationDialog.this.platformLogEnabledDropdown.isModified()) {
                        BSyslogConfigurationDialog.this.settings.setPlatformLogEnabled(((BIBoolean)BSyslogConfigurationDialog.this.platformLogEnabledDropdown.saveValue()).getBoolean());
                    }
                    if (BSyslogConfigurationDialog.this.stationLogEnabledDropdown.isModified()) {
                        BSyslogConfigurationDialog.this.settings.setStationLogEnabled(((BIBoolean)BSyslogConfigurationDialog.this.stationLogEnabledDropdown.saveValue()).getBoolean());
                    }
                    if (BSyslogConfigurationDialog.this.stationAuditEnabledDropdown.isModified()) {
                        BSyslogConfigurationDialog.this.settings.setStationAuditEnabled(((BIBoolean)BSyslogConfigurationDialog.this.stationAuditEnabledDropdown.saveValue()).getBoolean());
                    }
                    if (BSyslogConfigurationDialog.this.securityAuditEnabledDropdown.isModified()) {
                        BSyslogConfigurationDialog.this.settings.setSecurityAuditEnabled(((BIBoolean)BSyslogConfigurationDialog.this.securityAuditEnabledDropdown.saveValue()).getBoolean());
                    }
                }
                catch (Exception e) {
                    if (BDaemonSessionView.log.isLoggable(Level.FINE)) {
                        BDaemonSessionView.log.log(Level.SEVERE, "Unable to parse enabled dropdown value and save to settings.", e);
                    } else {
                        BDaemonSessionView.log.log(Level.SEVERE, "Unable to parse enabled dropdown value and save to settings.");
                    }
                    BSyslogConfigurationDialog.this.settings.setEnabled(false);
                }
                if (BSyslogConfigurationDialog.this.hostField.isModified()) {
                    BSyslogConfigurationDialog.this.settings.setServerHost(((BString)BSyslogConfigurationDialog.this.hostField.saveValue()).getString());
                }
                if (BSyslogConfigurationDialog.this.portField.isModified()) {
                    BSyslogConfigurationDialog.this.settings.setServerPort(((BInteger)BSyslogConfigurationDialog.this.portField.saveValue()).getInt());
                }
                if (BSyslogConfigurationDialog.this.messageTypeDropdown.isModified()) {
                    BSyslogConfigurationDialog.this.settings.setMessageType((BSyslogMessageTypeEnum)BSyslogConfigurationDialog.this.messageTypeDropdown.saveValue());
                }
                if (BSyslogConfigurationDialog.this.transportProtocolDropdown.isModified()) {
                    BSyslogConfigurationDialog.this.settings.setTransportProtocol((BSyslogTransportProtocolEnum)BSyslogConfigurationDialog.this.transportProtocolDropdown.saveValue());
                }
                BSyslogConfigurationDialog.this.settings.getClientAliasAndPassword().setAlias(BSyslogConfigurationDialog.this.clientAliasTextDropdown.getText());
                try {
                    if (BSyslogConfigurationDialog.this.clientPasswordField.isModified()) {
                        BSyslogConfigurationDialog.this.settings.setClientPasswordModified(true);
                        BPassword keyPassword = (BPassword)BSyslogConfigurationDialog.this.clientPasswordField.saveValue();
                        try (SecretChars secretChars = keyPassword.getSecretChars();){
                            BSyslogConfigurationDialog.this.settings.getClientAliasAndPassword().setPassword(secretChars.size() > 0 ? keyPassword : BPassword.DEFAULT);
                            break block32;
                        }
                    }
                    BSyslogConfigurationDialog.this.settings.setClientPasswordModified(false);
                }
                catch (Exception e) {
                    BDaemonSessionView.log.log(Level.SEVERE, "error processing key password, setting to DEFAULT", e);
                    BSyslogConfigurationDialog.this.settings.getClientAliasAndPassword().setPassword(BPassword.DEFAULT);
                }
            }
            if (BSyslogConfigurationDialog.this.clientPasswordField.isModified()) {
                BSyslogConfigurationDialog.this.settings.getClientAliasAndPassword().setPassword((BPassword)BSyslogConfigurationDialog.this.clientPasswordField.saveValue());
            }
            if (BSyslogConfigurationDialog.this.facilityDropdown.isModified()) {
                BSyslogConfigurationDialog.this.settings.setFacility((BSyslogFacilityEnum)BSyslogConfigurationDialog.this.facilityDropdown.saveValue());
            }
            if (BSyslogConfigurationDialog.this.queueSizeField.isModified()) {
                BSyslogConfigurationDialog.this.settings.setQueueSize(((BInteger)BSyslogConfigurationDialog.this.queueSizeField.saveValue()).getInt());
            }
            if (BSyslogConfigurationDialog.this.logLevelFilterDropdown.isModified()) {
                BSyslogConfigurationDialog.this.settings.setLogLevelFilter(BSyslogLevelEnum.make((String)((BSyslogLevelEnum)BSyslogConfigurationDialog.this.logLevelFilterDropdown.saveValue()).getTag()));
            }
            BSyslogConfigurationDialog.this.message = AccessController.doPrivileged(() -> new UpdateSyslogConfigurationMessage(BSyslogConfigurationDialog.this.settings, BSyslogConfigurationDialog.this.getDaemonSession().generateSharedSecretKey("updateSyslogSettings")));
            BSyslogConfigurationDialog.this.wasSaved = true;
            super.doInvoke();
            return null;
        }
    }
}

