/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.authn.AuthenticationClient;
import com.tridium.crypto.core.io.CertificateStatusEnum;
import com.tridium.crypto.core.io.ServerCertificateHealth;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platDaemon.ui.BDaemonLogSettingsView;
import com.tridium.platDaemon.ui.BDaemonSSLSettingsView;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.BOutputDialog;
import com.tridium.platDaemon.ui.acctmgt.BNativeUserTable;
import com.tridium.platDaemon.ui.appsurrogate.RebootCommand;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.config.AdvancedOptionsPrompt;
import com.tridium.platDaemon.ui.config.AuthenticationWizardModel;
import com.tridium.platDaemon.ui.config.BConfigDetailsPane;
import com.tridium.platDaemon.ui.config.BNreConfigurationPrompt;
import com.tridium.platDaemon.ui.config.BPortPrompt;
import com.tridium.platDaemon.ui.config.BSyslogConfigurationDialog;
import com.tridium.platDaemon.ui.config.BSystemLogDialog;
import com.tridium.platDaemon.ui.config.BTimePrompt;
import com.tridium.platDaemon.ui.config.BackupDistCommand;
import com.tridium.platDaemon.ui.config.RuntimeProfileWizardModel;
import com.tridium.platDaemon.ui.config.SystemPasswordPrompt;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.CertHealthMessage;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.CheckDefaultCredentialsMessage;
import com.tridium.platform.daemon.message.DaemonDebugMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.message.QnxInetdMessage;
import com.tridium.platform.daemon.message.SshdMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import com.tridium.platform.daemon.message.UpdateDaemonMessage;
import com.tridium.platform.daemon.message.UpdateSSLSettingsMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.util.BSessionInfo;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.WbAuthenticationClient;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.NHyperlinkInfo;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.file.FilePath;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.CancelledAuthenticationException;
import javax.baja.security.ChangeUserAuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
public class BPlatformAdministration
extends BDaemonSessionView {
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatformAdministration.class);
    private BHostIdStatus hostIdStatus;
    private final Command updatePortCommand;
    private final Command authCommand;
    private final Command manageUsersCommand;
    private final Command updateTimeCommand;
    private final Command detailsCommand;
    private final Command logSettingsCommand;
    private final Command daemonOutputDialogCommand;
    private final Command systemLogDialogCommand;
    private final RebootCommand rebootCommand;
    private final Command runtimeProfilesCommand;
    private final Command commissioningCommand;
    private final Command backupCommand;
    private final Command sslSettingsCommand;
    private final Command syslogConfigurationCommand;
    private final Command systemPasswordCommand;
    private final Command advancedOptionsCommand;
    private final Command configureNreCommand;
    private final BLabel bajaVersionLabel;
    private final BLabel daemonVersionLabel;
    private final BLabel homeDirLabel;
    private final BLabel userHomeDirDescription;
    private final BLabel userHomeDirLabel;
    private final BLabel addressLabel;
    private final BLabel hostIdLabel;
    private final BLabel hostIdStatusLabel;
    private final BLabel archLabel;
    private final BLabel osLabel;
    private final BLabel nreLabel;
    private final BLabel daemonHttpPortLabel;
    private final BLabel daemonHttpsPortLabel;
    private final BLabel modelLabel;
    private final BLabel productLabel;
    private final BLabel serialNumberLabel;
    private final BLabel runtimeProfilesLabel;
    private final BLabel vmLabel;
    private final BLabel niagaraStationsLabel;
    private final BLabel timeLabel;
    private final BLabel dateLabel;
    private final BLabel tzLabel;
    private final BLabel numCpusLabel;
    private final BLabel currentCpuLabel;
    private final BLabel overallCpuLabel;
    private final BGridPane filesystemPane;
    private final BLabel totalPhysicalMemoryLabel;
    private final BLabel freePhysicalMemoryLabel;
    private BTimeZone[] timeZones;
    private boolean factoryDefaultCredentials;
    private String factoryDefaultUsername;
    private boolean authenticationReadonly;
    private boolean httpEnabled;
    private boolean sshdEnabled;
    private boolean factoryDefaultSystemPassword;
    private boolean systemPasswordReadonly;
    private boolean daemonDebugEnabled;
    private boolean ftpEnabled;
    private boolean telnetEnabled;
    private ServerCertificateHealth certHealth;
    private ArrayList<BPart> unknownVersionParts;
    private static final Set<String> UNKNOWN_VERSION_STRINGS = new HashSet<String>(Arrays.asList(new BVersion("0.0").toString()));
    private boolean nreCoreVersionMismatch;
    private String nreCoreBuildVersion;
    private String bajaBuildVersion;
    private final BLabel sedonaLabel;
    private final BLabel sedonaStatus;
    private final BLabel niagaraR2Label;
    private final BLabel niagaraR2Status;
    private final BGridPane buttons;
    private final BGridPane otherGrid;
    private final BGridPane ledger;
    private final BTitlePane titlePane;
    static BImage faultIcon = BImage.make((String)"module://icons/x32/warning.png");
    private final Object RESTART_LOCK = new Object();
    private boolean restarting = false;
    private static final int KB_PADDING = 19;
    private static final int INT_MAX_PADDING = 14;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPlatformAdministration() {
        this.ledger = new BGridPane(2);
        this.ledger.setRowAlign(BValign.top);
        this.ledger.setHalign(BHalign.left);
        this.ledger.setRowGap(5.0);
        this.bajaVersionLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.bajaVersion"), (BWidget)this.bajaVersionLabel);
        this.daemonVersionLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.daemonVersion"), (BWidget)this.daemonVersionLabel);
        this.homeDirLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.homeDir"), (BWidget)this.homeDirLabel);
        this.userHomeDirDescription = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.userHomeDir"), (boolean)true);
        this.ledger.add(null, (BValue)this.userHomeDirDescription);
        this.userHomeDirLabel = new BLabel("", BHalign.left);
        this.ledger.add(null, (BValue)this.userHomeDirLabel);
        this.addressLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.address"), (BWidget)this.addressLabel);
        this.daemonHttpPortLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.port"), (BWidget)this.daemonHttpPortLabel);
        this.daemonHttpsPortLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.httpsPort"), (BWidget)this.daemonHttpsPortLabel);
        this.hostIdLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.hostId"), (BWidget)this.hostIdLabel);
        this.hostIdStatusLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.hostIdStatusLabel"), (BWidget)this.hostIdStatusLabel);
        this.modelLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.model"), (BWidget)this.modelLabel);
        this.productLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.product"), (BWidget)this.productLabel);
        this.serialNumberLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.serialNumber"), (BWidget)this.serialNumberLabel);
        this.dateLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.date"), (BWidget)this.dateLabel);
        this.timeLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.time"), (BWidget)this.timeLabel);
        this.tzLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.tz"), (BWidget)this.tzLabel);
        this.osLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.os"), (BWidget)this.osLabel);
        this.nreLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.nre"), (BWidget)this.nreLabel);
        this.archLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.arch"), (BWidget)this.archLabel);
        this.runtimeProfilesLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.runtimeProfiles"), (BWidget)this.runtimeProfilesLabel);
        this.vmLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.vm"), (BWidget)this.vmLabel);
        this.niagaraStationsLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.niagaraStationsEnabled"), (BWidget)this.niagaraStationsLabel);
        this.sedonaLabel = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.sedonaSupport"), (boolean)true);
        this.ledger.add(null, (BValue)this.sedonaLabel);
        this.sedonaStatus = new BLabel("", BHalign.left);
        this.ledger.add(null, (BValue)this.sedonaStatus);
        this.niagaraR2Label = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.niagaraR2Support"), (boolean)true);
        this.ledger.add(null, (BValue)this.niagaraR2Label);
        this.niagaraR2Status = new BLabel("", BHalign.left);
        this.ledger.add(null, (BValue)this.niagaraR2Status);
        this.numCpusLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.numCpus"), (BWidget)this.numCpusLabel);
        this.currentCpuLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.currentCpuUsage"), (BWidget)this.currentCpuLabel);
        this.overallCpuLabel = new BLabel("", BHalign.left);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.overallCpuUsage"), (BWidget)this.overallCpuLabel);
        this.filesystemPane = new BGridPane(5);
        this.filesystemPane.setColumnAlign(BHalign.fill);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.filesystem"), (BWidget)this.filesystemPane);
        BGridPane memoryPane = new BGridPane(2);
        memoryPane.setColumnAlign(BHalign.fill);
        memoryPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.totalKb"), (boolean)true, (BHalign)BHalign.left));
        memoryPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.freeKb"), (boolean)true, (BHalign)BHalign.left));
        this.totalPhysicalMemoryLabel = new BLabel("", BHalign.right);
        memoryPane.add(null, (BValue)this.totalPhysicalMemoryLabel);
        this.freePhysicalMemoryLabel = new BLabel("", BHalign.right);
        memoryPane.add(null, (BValue)this.freePhysicalMemoryLabel);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.physicalMemory"), (BWidget)memoryPane);
        this.otherGrid = new BGridPane(1);
        LabelUtil.addLabelWidgetPair((BPane)this.ledger, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.other"), (BWidget)this.otherGrid);
        this.buttons = new BGridPane(1);
        this.buttons.setColumnAlign(BHalign.fill);
        this.buttons.setValign(BValign.top);
        this.detailsCommand = new ConfigDetailsCommand(this);
        this.authCommand = new AuthenticationCommand();
        this.manageUsersCommand = new UserManagementCommand();
        this.sslSettingsCommand = new SSLSettingsCommand();
        this.syslogConfigurationCommand = new SyslogConfigurationCommand();
        this.updatePortCommand = new UpdatePortCommand();
        this.updateTimeCommand = new UpdateTimeCommand();
        this.logSettingsCommand = new LogSettingsCommand();
        this.daemonOutputDialogCommand = new DaemonOutputDialogCommand();
        this.systemLogDialogCommand = new SystemLogDialogCommand();
        this.runtimeProfilesCommand = new RuntimeProfileCommand();
        this.rebootCommand = new RebootCommand(this);
        this.systemPasswordCommand = new UpdateSystemPasswordCommand();
        this.commissioningCommand = new CommissioningCommand();
        this.backupCommand = new BackupCommand();
        this.advancedOptionsCommand = new AdvancedOptionsCommand();
        this.configureNreCommand = new NreConfigurationCommand();
        BGridPane contentGrid = new BGridPane(2);
        contentGrid.setRowAlign(BValign.fill);
        contentGrid.setHalign(BHalign.left);
        contentGrid.setValign(BValign.top);
        contentGrid.add(null, (BValue)new BBorderPane((BWidget)this.buttons, 4.0, 8.0, 4.0, 8.0));
        contentGrid.add(null, (BValue)new BBorderPane((BWidget)this.ledger, 0.0, 8.0, 0.0, 8.0));
        contentGrid.setStyleId("platform-admin-grid");
        BScrollPane scrollPane = new BScrollPane((BWidget)contentGrid);
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground((IStylable)scrollPane));
        this.titlePane = new BTitlePane(this.getTypeDisplayName(null), (BWidget)scrollPane);
    }

    @Override
    protected void doLoadSession(BDaemonSession session, Context cx) throws AuthenticationException {
        try {
            boolean showFileCount;
            String productName;
            BVersion modelVersion;
            String modelName;
            BDaemonPlatform platform = this.getDaemonPlatform();
            if (platform == null) {
                throw new ConnectException("Not connected to the platform!");
            }
            BPart bajaPart = platform.getSingleModulePart("baja", (DaemonSessionTaskListener)this);
            Version bajaVersion = null;
            if (bajaPart == null) {
                this.bajaVersionLabel.setText("");
            } else {
                bajaVersion = new Version(bajaPart.getVersion().getVendorVersionString());
                this.bajaVersionLabel.setText(bajaPart.getVersion().toString(cx));
            }
            String daemonVersionString = platform.getDaemonVersion();
            Version daemonVersion = null;
            if (daemonVersionString == null || "unknown".equals(daemonVersionString)) {
                this.daemonVersionLabel.setText("3.0");
            } else {
                daemonVersion = new Version(daemonVersionString);
                this.daemonVersionLabel.setText(daemonVersionString);
            }
            this.checkNreCoreVersionMismatch(daemonVersion, bajaVersion);
            try {
                XElem sysHomeElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new GetDirectoryMessage(new FilePath("!"), false, false, true, (BDaemonFileSpace)session.getFileSpace()))).parse();
                this.homeDirLabel.setText(sysHomeElem.get("path", ""));
            }
            catch (Exception ignored) {
                this.homeDirLabel.setText("");
            }
            if (platform.getIsNiagara4()) {
                try {
                    XElem userHomeElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new GetDirectoryMessage(new FilePath("~"), false, false, true, (BDaemonFileSpace)session.getFileSpace()))).parse();
                    this.userHomeDirLabel.setText(userHomeElem.get("path", ""));
                }
                catch (Exception ignored) {
                    this.userHomeDirLabel.setText("");
                }
            } else {
                if (this.userHomeDirDescription.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.userHomeDirDescription);
                }
                if (this.userHomeDirLabel.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.userHomeDirLabel);
                }
            }
            try {
                this.timeZones = DaemonTimeUtil.getLocalTimeZones((BDaemonSession)session);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load remote session timezones, using OS time zone", e);
                this.timeZones = new BTimeZone[]{DaemonTimeUtil.getOsTimeZone((BDaemonSession)session)};
            }
            BHostProperties sessionHostProperties = session.getHostProperties();
            this.addressLabel.setText(session.getRemoteHost().getNavDisplayName(null));
            this.hostIdLabel.setText(platform.getHostId());
            this.hostIdStatus = sessionHostProperties.getHostIdSettings().getHostIdStatus();
            this.hostIdStatusLabel.setText(this.getLexicon().getText("PlatformAdministration.hostIdStatus." + this.hostIdStatus.getTag()));
            this.runtimeProfilesLabel.setText(String.join((CharSequence)",", platform.getEnabledRuntimeProfileNames()));
            this.archLabel.setText(platform.getArchPart().getPartName());
            this.niagaraStationsLabel.setText(platform.getNiagaraStationsEnabled() ? this.getLexicon().getText("PlatformAdministration.niagaraStationsEnabled.enabled") : this.getLexicon().getText("PlatformAdministration.niagaraStationsEnabled.disabled"));
            if (platform.getSedonaSupported()) {
                this.sedonaStatus.setText(platform.getSedonaEnabled() ? this.getLexicon().getText("PlatformAdministration.sedonaSupport.enabled") : this.getLexicon().getText("PlatformAdministration.sedonaSupport.disabled"));
            } else {
                this.sedonaStatus.setText(this.getLexicon().getText("PlatformAdministration.sedonaSupport.unsupported"));
                if (this.sedonaStatus.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.sedonaStatus);
                }
                if (this.sedonaLabel.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.sedonaLabel);
                }
            }
            if (platform.getNiagaraR2Supported()) {
                this.niagaraR2Status.setText(platform.getNiagaraR2Enabled() ? this.getLexicon().getText("PlatformAdministration.niagaraR2Support.enabled") : this.getLexicon().getText("PlatformAdministration.niagaraR2Support.disabled"));
            } else {
                this.niagaraR2Status.setText(this.getLexicon().getText("PlatformAdministration.niagaraR2Support.unsupported"));
                if (this.niagaraR2Status.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.niagaraR2Status);
                }
                if (this.niagaraR2Label.getParent() == this.ledger) {
                    this.ledger.remove((BComplex)this.niagaraR2Label);
                }
            }
            this.setDaemonHttpPortLabels(session);
            this.checkUnknownVersions(platform);
            BOsPart osPart = platform.getOsPart();
            if (osPart == null || osPart.isNull()) {
                this.osLabel.setText(this.getLexicon().getText("PlatformAdministration.unknownValue"));
            } else {
                String osText = osPart.getDescription();
                if (osText == null || osText.trim().isEmpty()) {
                    osText = osPart.getPartName();
                }
                this.osLabel.setText(BVersion.formatNameVersion((String)osText, (BVersion)osPart.getVersion(), (Context)cx));
            }
            BNrePart nrePart = platform.getNrePart();
            if (nrePart == null || nrePart.isNull()) {
                this.nreLabel.setText(this.getLexicon().getText("PlatformAdministration.unknownValue"));
            } else {
                this.nreLabel.setText(BVersion.formatNameVersion((String)nrePart.getPartName(), (BVersion)nrePart.getVersion(), (Context)cx));
            }
            BModelPart modelPart = platform.getModelPart();
            if (modelPart == null || modelPart.isNull()) {
                modelName = this.getLexicon().getText("PlatformAdministration.noneValue");
                modelVersion = BVersion.ZERO;
            } else {
                modelName = modelPart.getPartName();
                modelVersion = modelPart.getVersion();
            }
            this.modelLabel.setText(BVersion.formatNameVersion((String)modelName, (BVersion)modelVersion, (Context)cx));
            if (modelPart == null || modelPart.isNull()) {
                productName = this.getLexicon().getText("PlatformAdministration.noneValue");
            } else {
                productName = modelPart.getDescription();
                if ("unknown".equalsIgnoreCase(productName) || "".equalsIgnoreCase(productName)) {
                    switch (modelName) {
                        case "TITAN": {
                            productName = "JACE-8000";
                            break;
                        }
                        default: {
                            productName = modelName;
                        }
                    }
                }
            }
            this.productLabel.setText(productName);
            String serialNumber = sessionHostProperties.getSerialNumber();
            if (serialNumber == null || serialNumber.isEmpty() || "unknown".equalsIgnoreCase(serialNumber)) {
                serialNumber = this.getLexicon().getText("PlatformAdministration.noneValue");
            }
            this.serialNumberLabel.setText(serialNumber);
            BVmPart vmPart = platform.getVmPart();
            if (vmPart == null || vmPart.isNull()) {
                this.vmLabel.setText(this.getLexicon().getText("PlatformAdministration.unknownValue"));
            } else if (vmPart.getUnspecified()) {
                this.vmLabel.setText(Lexicon.make((String)"platform").getText("unspecifiedVm.label"));
            } else {
                this.vmLabel.setText(BVersion.formatNameVersion((BPart)vmPart, (Context)cx));
            }
            this.numCpusLabel.setText(String.valueOf(sessionHostProperties.getNumCpus()));
            int currentCpu = sessionHostProperties.getCurrentCpuUsage();
            if (currentCpu < 0) {
                this.currentCpuLabel.setText(this.getLexicon().getText("PlatformAdministration.unavailable"));
            } else {
                this.currentCpuLabel.setText(currentCpu + "%");
            }
            int overallCpu = sessionHostProperties.getOverallCpuUsage();
            if (overallCpu < 0) {
                this.overallCpuLabel.setText(this.getLexicon().getText("PlatformAdministration.unavailable"));
            } else {
                this.overallCpuLabel.setText(overallCpu + "%");
            }
            DecimalFormat kbFormat = (DecimalFormat)DaemonFileUtil.KB_FORMAT.get();
            int freeMem = sessionHostProperties.getFreePhysicalMemory();
            if (freeMem < 0) {
                this.freePhysicalMemoryLabel.setText(TextUtil.padLeft((String)this.getLexicon().getText("PlatformAdministration.unavailable"), (int)19));
            } else {
                this.freePhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(freeMem), (int)19));
            }
            int totalMem = sessionHostProperties.getTotalPhysicalMemory();
            if (totalMem < 0) {
                this.totalPhysicalMemoryLabel.setText(TextUtil.padLeft((String)this.getLexicon().getText("PlatformAdministration.unavailable"), (int)19));
            } else {
                this.totalPhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(totalMem), (int)19));
            }
            this.filesystemPane.removeAll();
            this.filesystemPane.add(null, (BValue)new BNullWidget());
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.totalKb"), (boolean)true, (BHalign)BHalign.left));
            this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.freeKb"), (boolean)true, (BHalign)BHalign.left));
            boolean bl = showFileCount = sessionHostProperties.getOsName().startsWith("qnx-jace") || sessionHostProperties.getOsName().startsWith("tridium-qnx7") || sessionHostProperties.getIsNpsdk();
            if (showFileCount) {
                this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.currentFileCount"), (boolean)true, (BHalign)BHalign.left));
                this.filesystemPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.maxFileCount"), (boolean)true, (BHalign)BHalign.left));
            } else {
                this.filesystemPane.add(null, (BValue)new BNullWidget());
                this.filesystemPane.add(null, (BValue)new BNullWidget());
            }
            BVector filesystemAttributes = sessionHostProperties.getFilesystemAttributes();
            SlotCursor attributesCursor = filesystemAttributes.getProperties();
            while (attributesCursor.next(BFilesystemAttributes.class)) {
                Property[] attributesProperty = attributesCursor.property();
                if ((filesystemAttributes.getFlags((Slot)attributesProperty) & 4) != 0) continue;
                BFilesystemAttributes attrs = (BFilesystemAttributes)attributesCursor.get();
                String fsPropName = attributesProperty.getName();
                this.filesystemPane.add(null, (BValue)new BLabel(filesystemAttributes.getDisplayName((Slot)attributesProperty, cx), BHalign.left));
                this.filesystemPane.add(fsPropName + "total", (BValue)new BLabel(TextUtil.padLeft((String)kbFormat.format(attrs.getTotalSpace()), (int)19), BHalign.right));
                this.filesystemPane.add(fsPropName + "free", (BValue)new BLabel(TextUtil.padLeft((String)kbFormat.format(attrs.getFreeSpace()), (int)19), BHalign.right));
                if (showFileCount) {
                    String currentFileText = attrs.getCurrentFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(attrs.getCurrentFileCount());
                    String maxFileText = attrs.getMaxFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(attrs.getMaxFileCount());
                    this.filesystemPane.add(fsPropName + "currentFile", (BValue)new BLabel(TextUtil.padLeft((String)currentFileText, (int)14), BHalign.right));
                    this.filesystemPane.add(fsPropName + "maxFile", (BValue)new BLabel(TextUtil.padLeft((String)maxFileText, (int)14), BHalign.right));
                    continue;
                }
                this.filesystemPane.add(null, (BValue)new BNullWidget());
                this.filesystemPane.add(null, (BValue)new BNullWidget());
            }
            Property[] otherProps = platform.getOtherParts().getPropertiesArray();
            this.otherGrid.removeAll();
            if (otherProps.length == 0) {
                this.otherGrid.add(null, (BValue)new BLabel(this.getLexicon().getText("PlatformAdministration.noneValue")));
            } else {
                for (Property otherProp : otherProps) {
                    BStationSurrogate[] part = (BStationSurrogate[])platform.getOtherParts().get(otherProp);
                    this.otherGrid.add(null, (BValue)new BLabel(BVersion.formatNameVersion((BPart)part, (Context)cx)));
                }
            }
            this.buttons.removeAll();
            this.buttons.add(null, (BValue)new BButton(this.detailsCommand));
            if (sessionHostProperties.isNiagara4() && sessionHostProperties.supportsServlet("acctmgt")) {
                this.buttons.add(null, (BValue)new BButton(this.manageUsersCommand));
            } else {
                this.buttons.add(null, (BValue)new BButton(this.authCommand));
            }
            if (sessionHostProperties.supportsServlet("systempw")) {
                this.buttons.add(null, (BValue)new BButton(this.systemPasswordCommand));
            }
            this.buttons.add(null, (BValue)new BButton(this.updatePortCommand));
            this.buttons.add(null, (BValue)new BButton(this.sslSettingsCommand));
            this.buttons.add(null, (BValue)new BButton(this.updateTimeCommand));
            if (AdvancedOptionsPrompt.sessionSupportsAdvancedOptions(session)) {
                this.buttons.add(null, (BValue)new BButton(this.advancedOptionsCommand));
            }
            this.buttons.add(null, (BValue)new BButton(this.logSettingsCommand));
            if (sessionHostProperties.getSyslogSupported()) {
                this.buttons.add("syslogConfigurationButton", (BValue)new BButton(this.syslogConfigurationCommand));
            }
            this.buttons.add(null, (BValue)new BButton(this.daemonOutputDialogCommand));
            if (sessionHostProperties.supportsServlet("qnx") || sessionHostProperties.supportsServlet("systemlog")) {
                this.buttons.add(null, (BValue)new BButton(this.systemLogDialogCommand));
            }
            this.buttons.add(null, (BValue)new BButton(this.runtimeProfilesCommand));
            if (sessionHostProperties.supportsServlet("nreconfig")) {
                this.buttons.add(null, (BValue)new BButton(this.configureNreCommand));
            }
            this.buttons.add(null, (BValue)new BButton(this.backupCommand));
            this.buttons.add(null, (BValue)new BButton(this.commissioningCommand));
            this.buttons.add(null, (BValue)new BButton((Command)this.rebootCommand));
            BStationSurrogate[] surrogates = BStationSurrogate.makeAll((BDaemonSession)session);
            boolean anyStarting = false;
            boolean anyStopping = false;
            boolean anyRunning = false;
            for (BStationSurrogate surrogate : surrogates) {
                if (surrogate.isStationStarting()) {
                    anyStarting = true;
                    continue;
                }
                if (surrogate.isStationStopping()) {
                    anyStopping = true;
                    continue;
                }
                if (!surrogate.isStationRunning()) continue;
                anyRunning = true;
            }
            this.backupCommand.setEnabled(!anyStarting && !anyStopping && (sessionHostProperties.isNiagara4() || !anyRunning));
            this.rebootCommand.checkEnabled();
            this.updateTimeCommand.setEnabled(this.timeZones.length > 0 && !sessionHostProperties.getIsSystemTimeReadonly());
            this.checkDaemonTlsOnly(sessionHostProperties);
            this.sslSettingsCommand.setEnabled(sessionHostProperties.getSslSupported() && sessionHostProperties.getSslSettings().getSslLicensed());
            this.syslogConfigurationCommand.setEnabled(sessionHostProperties.getSyslogSupported());
            boolean canCommission = sessionHostProperties.isNiagara4() && sessionHostProperties.getAccessLevel().atLeast(BDaemonAccessLevel.full) && !sessionHostProperties.getNiagaraR2Enabled() && !session.usesLocalNiagaraHome();
            this.commissioningCommand.setEnabled(canCommission);
            this.runtimeProfilesCommand.setEnabled(sessionHostProperties.isNiagara4() && !sessionHostProperties.getNiagaraR2Enabled() && !sessionHostProperties.getIsSoftwareReadonly() && !session.usesLocalNiagaraHome());
            this.checkAuthenticationReadonly();
            this.authCommand.setEnabled(sessionHostProperties.isNiagara4() && sessionHostProperties.getAccessLevel().atLeast(BDaemonAccessLevel.restricted) && !this.authenticationReadonly);
            this.manageUsersCommand.setEnabled(sessionHostProperties.isNiagara4() && !this.authenticationReadonly);
            this.checkFactoryDefaultCredentials();
            if (sessionHostProperties.supportsServlet("qnxsshd") || sessionHostProperties.supportsServlet("sshd")) {
                boolean isLegacy = sessionHostProperties.supportsServlet("qnxsshd");
                try {
                    XElem elem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new SshdMessage(isLegacy), 0)).parse();
                    this.sshdEnabled = elem.geti("port", -1) != -1;
                }
                catch (Exception ignored) {
                    this.sshdEnabled = false;
                }
            }
            if (sessionHostProperties.supportsServlet("systempw")) {
                try {
                    XElem systemPasswordElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
                    this.factoryDefaultSystemPassword = systemPasswordElem.getb("default", false);
                    this.systemPasswordReadonly = systemPasswordElem.getb("readonly", false);
                }
                catch (Exception ignored) {
                    this.factoryDefaultSystemPassword = false;
                    this.systemPasswordReadonly = false;
                }
            }
            this.systemPasswordCommand.setEnabled(sessionHostProperties.isNiagara4() && !this.systemPasswordReadonly);
            try {
                if (sessionHostProperties.supportsServlet("debug")) {
                    XElem debugElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new DaemonDebugMessage())).parse();
                    this.daemonDebugEnabled = debugElem.getb("daemonDebug", false);
                }
            }
            catch (Exception e) {
                this.daemonDebugEnabled = false;
            }
            try {
                if (sessionHostProperties.supportsServlet("qnxinetd")) {
                    XElem elem = XParser.make((InputStream)session.getInputStream((DaemonMessage)QnxInetdMessage.getInstance())).parse();
                    this.ftpEnabled = elem.geti("fp", -1) != -1;
                    this.telnetEnabled = elem.geti("tp", -1) != -1;
                }
            }
            catch (Exception e) {
                this.ftpEnabled = false;
                this.telnetEnabled = false;
            }
            try {
                this.checkCertificateHealth(sessionHostProperties);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "error retrieving server certificate health", e);
                this.certHealth = null;
            }
            this.setContent((BWidget)this.titlePane);
            this.startRefreshTimer();
        }
        catch (ConnectException platform) {
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    protected void setDaemonHttpPortLabels(BDaemonSession session) {
        String httpsLabel = null;
        String httpLabel = null;
        BHostProperties sessionHostProperties = session.getHostProperties();
        if (sessionHostProperties.getSslSupported()) {
            BPlatformSSLSettings settings = sessionHostProperties.getSslSettings();
            if (settings.getSslLicensed()) {
                if (settings.getSslEnabled()) {
                    if (settings.getSslOnly()) {
                        httpLabel = "PlatformAdministration.port.disabled";
                    }
                } else {
                    httpsLabel = "PlatformAdministration.command.sslSettings.status.sslDisabled";
                }
            } else {
                httpsLabel = "PlatformAdministration.command.sslSettings.status.sslNotLicensed";
            }
        } else {
            httpsLabel = "PlatformAdministration.sslNotSupported";
        }
        if (httpLabel == null) {
            this.daemonHttpPortLabel.setText(String.valueOf(sessionHostProperties.getHttpPort()));
        } else {
            this.daemonHttpPortLabel.setText(this.getLexicon().getText(httpLabel, new Object[]{String.valueOf(sessionHostProperties.getHttpPort())}));
        }
        if (httpsLabel == null) {
            this.daemonHttpsPortLabel.setText(String.valueOf(sessionHostProperties.getSslSettings().getSslPort()));
        } else {
            this.daemonHttpsPortLabel.setText(TextUtil.toLowerCase((String)this.getLexicon().getText(httpsLabel)));
        }
    }

    private void checkFactoryDefaultCredentials() {
        try {
            XElem userElem;
            boolean tempDefaultCredentials = false;
            String tempDefaultUsername = null;
            XElem authInfo = XParser.make((InputStream)this.getDaemonSession().getInputStream((DaemonMessage)new CheckDefaultCredentialsMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null && (userElem = authElem.elem("user")) != null) {
                tempDefaultCredentials = userElem.getb("default", false);
                tempDefaultUsername = userElem.get("name", null);
            }
            this.factoryDefaultCredentials = tempDefaultCredentials;
            this.factoryDefaultUsername = tempDefaultUsername;
        }
        catch (Exception ignored) {
            this.factoryDefaultUsername = null;
            this.factoryDefaultCredentials = false;
        }
    }

    private void checkDaemonTlsOnly(BHostProperties hostProperties) {
        boolean daemonTlsOnly = hostProperties.getSslSupported() && hostProperties.getSslSettings().getSslLicensed() && hostProperties.getSslSettings().getSslEnabled() && hostProperties.getSslSettings().getSslOnly();
        this.updatePortCommand.setEnabled(!daemonTlsOnly);
        this.httpEnabled = !daemonTlsOnly;
    }

    private void checkAuthenticationReadonly() {
        try {
            boolean tempAuthenticationReadonly = false;
            XElem authInfo = XParser.make((InputStream)this.getDaemonSession().getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null) {
                tempAuthenticationReadonly = authElem.getb("readonly", false);
            }
            this.authenticationReadonly = tempAuthenticationReadonly;
        }
        catch (Exception ignored) {
            this.authenticationReadonly = false;
        }
    }

    private void checkCertificateHealth(BHostProperties hostProperties) throws Exception {
        try {
            if (new Version(hostProperties.getDaemonVersion()).compareTo(new Version("4.13")) >= 0) {
                XElem elem = XParser.make((InputStream)this.getDaemonSession().getInputStream((DaemonMessage)new CertHealthMessage(), "text/xml")).parse();
                this.certHealth = new ServerCertificateHealth(elem.get("requestedCert"), elem.get("returnedCert"), CertificateStatusEnum.valueOf((String)elem.get("certStatus")));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkNreCoreVersionMismatch(Version nreCoreVersion, Version bajaVersion) {
        this.nreCoreVersionMismatch = false;
        this.nreCoreBuildVersion = null;
        this.bajaBuildVersion = null;
        if (nreCoreVersion != null && bajaVersion != null) {
            int majorMinorUpdateBuild = 4;
            this.nreCoreBuildVersion = nreCoreVersion.toString(majorMinorUpdateBuild);
            this.bajaBuildVersion = bajaVersion.toString(majorMinorUpdateBuild);
            if (!this.nreCoreBuildVersion.equals(this.bajaBuildVersion)) {
                this.nreCoreVersionMismatch = true;
            }
        }
    }

    private void checkUnknownVersions(BDaemonPlatform daemonPlatform) {
        this.unknownVersionParts = new ArrayList();
        BOsPart osPart = daemonPlatform.getOsPart();
        if (osPart != null && UNKNOWN_VERSION_STRINGS.contains(osPart.getVersion().toString())) {
            this.unknownVersionParts.add((BPart)osPart);
        }
    }

    public void activated() {
        super.activated();
        if (this.getDaemonSession() != null && !this.isRefreshTimerRunning()) {
            this.startRefreshTimer();
        }
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRefresh() {
        Object object = this.RESTART_LOCK;
        synchronized (object) {
            if (this.restarting || this.getDaemonSession() == null) {
                return;
            }
            try {
                int totalMem;
                int overallCpu;
                int currentCpu;
                BHostProperties sessionHostProperties;
                String hostId;
                this.getDaemonSession().updateHostProperties();
                if (this.timeZones != null && this.timeZones.length > 0) {
                    XElem currentTimeElem = DaemonTimeUtil.getCurrentTimeElem((BDaemonSession)this.getDaemonSession());
                    BTimeZone tz = null;
                    BAbsTime dateTime = null;
                    if (currentTimeElem != null) {
                        tz = DaemonTimeUtil.getLocalTimeZone((XElem)currentTimeElem, (BTimeZone[])this.timeZones);
                        dateTime = DaemonTimeUtil.getLocalTime((BDaemonSession)this.getDaemonSession(), (XElem)currentTimeElem, (BTimeZone)tz, (BTimeZone[])this.timeZones);
                    }
                    this.tzLabel.setText(tz == null ? "" : tz.toString());
                    if (dateTime != null) {
                        this.dateLabel.setText(dateTime.toDateString(null));
                        StringBuilder timeString = new StringBuilder();
                        timeString.append(dateTime.getHour());
                        timeString.append(':');
                        if (dateTime.getMinute() < 10) {
                            timeString.append('0');
                        }
                        timeString.append(dateTime.getMinute());
                        timeString.append(" ");
                        timeString.append(dateTime.getTimeZone().getDisplayName(dateTime.inDaylightTime(), null));
                        this.timeLabel.setText(timeString.toString());
                    }
                }
                if (!(hostId = (sessionHostProperties = this.getDaemonSession().getHostProperties()).getHostId()).equals(this.hostIdLabel.getText())) {
                    this.hostIdLabel.setText(hostId);
                }
                this.hostIdStatus = sessionHostProperties.getHostIdSettings().getHostIdStatus();
                String hostIdStatusLex = this.getLexicon().getText("PlatformAdministration.hostIdStatus." + this.hostIdStatus.getTag());
                if (!hostIdStatusLex.equals(this.hostIdStatusLabel.getText())) {
                    this.hostIdStatusLabel.setText(hostIdStatusLex);
                }
                if ((currentCpu = sessionHostProperties.getCurrentCpuUsage()) >= 0) {
                    this.currentCpuLabel.setText(currentCpu + "%");
                }
                if ((overallCpu = sessionHostProperties.getOverallCpuUsage()) >= 0) {
                    this.overallCpuLabel.setText(overallCpu + "%");
                }
                DecimalFormat kbFormat = (DecimalFormat)DaemonFileUtil.KB_FORMAT.get();
                int freeMem = sessionHostProperties.getFreePhysicalMemory();
                if (freeMem >= 0) {
                    this.freePhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(freeMem), (int)19));
                }
                if ((totalMem = sessionHostProperties.getTotalPhysicalMemory()) >= 0) {
                    this.totalPhysicalMemoryLabel.setText(TextUtil.padLeft((String)kbFormat.format(totalMem), (int)19));
                }
                BVector filesystemAttributes = sessionHostProperties.getFilesystemAttributes();
                SlotCursor attributesCursor = filesystemAttributes.getProperties();
                while (attributesCursor.next(BFilesystemAttributes.class)) {
                    BLabel maxFileLabel;
                    BLabel currentFileLabel;
                    BLabel freeLabel;
                    Property attributesProperty = attributesCursor.property();
                    if ((filesystemAttributes.getFlags((Slot)attributesProperty) & 4) != 0) continue;
                    BFilesystemAttributes attrs = (BFilesystemAttributes)attributesCursor.get();
                    String fsPropName = attributesProperty.getName();
                    BLabel totalLabel = (BLabel)this.filesystemPane.get(fsPropName + "total");
                    if (totalLabel != null) {
                        totalLabel.setText(TextUtil.padLeft((String)kbFormat.format(attrs.getTotalSpace()), (int)19));
                    }
                    if ((freeLabel = (BLabel)this.filesystemPane.get(fsPropName + "free")) != null) {
                        freeLabel.setText(TextUtil.padLeft((String)kbFormat.format(attrs.getFreeSpace()), (int)19));
                    }
                    if ((currentFileLabel = (BLabel)this.filesystemPane.get(fsPropName + "currentFile")) != null) {
                        String text = attrs.getCurrentFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(attrs.getCurrentFileCount());
                        currentFileLabel.setText(TextUtil.padLeft((String)text, (int)14));
                    }
                    if ((maxFileLabel = (BLabel)this.filesystemPane.get(fsPropName + "maxFile")) == null) continue;
                    String text = attrs.getMaxFileCount() < 0L ? this.getLexicon().getText("PlatformAdministration.unavailable") : String.valueOf(attrs.getMaxFileCount());
                    maxFileLabel.setText(TextUtil.padLeft((String)text, (int)14));
                }
            }
            catch (ConnectException sessionHostProperties) {
            }
            catch (AuthenticationException ae) {
                this.reauthenticate(ae);
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        StringBuilder faultBuilder = new StringBuilder();
        if (this.factoryDefaultCredentials) {
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.defaultCredentialsWarning").getText(null));
        }
        if (this.httpEnabled) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.httpEnabled").getText(null));
        }
        if (this.sshdEnabled) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.sshdEnabledWarning").getText(null));
        }
        if (this.factoryDefaultSystemPassword) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.defaultSystemPasswordWarning").getText(null));
        }
        if (this.daemonDebugEnabled) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.daemonDebugEnabledWarning").getText(null));
        }
        if (this.telnetEnabled) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.telnetEnabledWarning").getText(null));
        }
        if (this.ftpEnabled) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.ftpEnabledWarning").getText(null));
        }
        if (this.hostIdStatus == BHostIdStatus.cloned || this.hostIdStatus == BHostIdStatus.unregistered) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)("LicenseManager.hostIDFaultCause." + this.hostIdStatus.getTag())).getText(null));
        }
        if (this.certHealth != null) {
            switch (this.certHealth.getCause()) {
                default: {
                    break;
                }
                case BAD_PASSWORD: {
                    if (faultBuilder.length() != 0) {
                        faultBuilder.append('\n');
                    }
                    faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.certHealthBadPassword").getText(null, new Object[]{this.certHealth.getRequestedCert(), this.certHealth.getReturnedCert()}));
                    break;
                }
                case BAD_KEY: {
                    if (faultBuilder.length() != 0) {
                        faultBuilder.append('\n');
                    }
                    faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.certHealthBadKey").getText(null, new Object[]{this.certHealth.getRequestedCert(), this.certHealth.getReturnedCert()}));
                    break;
                }
                case MISSING_KEY: {
                    if (faultBuilder.length() != 0) {
                        faultBuilder.append('\n');
                    }
                    faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.certHealthMissingKey").getText(null, new Object[]{this.certHealth.getRequestedCert(), this.certHealth.getReturnedCert()}));
                    break;
                }
                case BAD_DEFAULT: {
                    if (faultBuilder.length() != 0) {
                        faultBuilder.append('\n');
                    }
                    faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.certHealthBadDefault").getText(null, new Object[]{this.certHealth.getRequestedCert(), this.certHealth.getReturnedCert()}));
                }
            }
        }
        if (this.unknownVersionParts != null) {
            for (BPart unknownVersionPart : this.unknownVersionParts) {
                if (faultBuilder.length() != 0) {
                    faultBuilder.append("\n");
                }
                faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.unknownVersionWarning").getText(null, new Object[]{BPart.getPartTypeShortName((Type)unknownVersionPart.getType()), unknownVersionPart.getVersion()}));
            }
        }
        if (this.nreCoreVersionMismatch) {
            if (faultBuilder.length() != 0) {
                faultBuilder.append("\n");
            }
            faultBuilder.append(LexiconText.make((Type)TYPE, (String)"PlatformAdministration.nreCoreVersionMismatchWarning").getText(null, new Object[]{this.nreCoreBuildVersion, this.bajaBuildVersion}));
        }
        if (faultBuilder.length() != 0) {
            double w = this.getWidth();
            double h = this.getHeight();
            BLabel msg = new BLabel(faultBuilder.toString(), BHalign.left);
            msg.setImage(faultIcon);
            msg.computePreferredSize();
            double mw = msg.getPreferredWidth();
            double mh = msg.getPreferredHeight();
            double mx = Math.max(10.0, w - mw - 20.0);
            double my = Math.max(10.0, h - mh - 20.0);
            msg.setBounds(0.0, 0.0, mw, mh);
            msg.doLayout(null);
            g.setBrush(BColor.make((int)255, (int)255, (int)0, (int)180));
            g.fillRect(mx - 10.0, my - 10.0, mw + 20.0, mh + 20.0);
            g.setBrush(BColor.black);
            g.strokeRect(mx - 10.0, my - 10.0, mw + 20.0, mh + 20.0);
            g.translate(mx, my);
            msg.paint(g);
        }
    }

    public class BackupCommand
    extends AsyncCommand {
        public BackupCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.backup");
        }

        public void doInvokeAsync() {
            try {
                BStationSurrogate[] stations;
                for (BStationSurrogate station : stations = BStationSurrogate.makeAll((BDaemonSession)BPlatformAdministration.this.getDaemonSession())) {
                    if (station.isStationStarting()) {
                        BDialog.error((BWidget)this.getOwner(), (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.stationStartingTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.stationStartingMessage", new Object[]{station.getStationName()}));
                        return;
                    }
                    if (!station.isStationStopping()) continue;
                    BDialog.error((BWidget)this.getOwner(), (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.stationStoppingTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.stationStoppingMessage", new Object[]{station.getStationName()}));
                    return;
                }
                if (BStationSurrogate.isAnyStationRunning((BDaemonSession)BPlatformAdministration.this.getDaemonSession())) {
                    for (BStationSurrogate station : stations) {
                        if (!station.isStationRunning()) continue;
                        if (4 != BDialog.confirm((BWidget)this.getOwner(), (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.connectStationTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.backup.connectStationMessage", new Object[]{station.getStationName()}), (int)12)) {
                            return;
                        }
                        BOrd stationOrd = station.getFoxsOrd();
                        if (stationOrd.isNull() && (stationOrd = station.getFoxwssOrd()).isNull()) {
                            stationOrd = station.getFoxOrd();
                        }
                        OrdTarget target = null;
                        while (target == null) {
                            WbAuthenticationClient authenticationClient = new WbAuthenticationClient(this.getOwner());
                            try {
                                target = stationOrd.resolve((BObject)BLocalHost.INSTANCE, null, (AuthenticationClient)authenticationClient);
                            }
                            catch (CancelledAuthenticationException e) {
                                throw e;
                            }
                            catch (ChangeUserAuthenticationException e) {
                                AuthUtil.removeSavedUser((String)e.getAuthenticationRealm().getAuthenticationRealmName());
                            }
                            catch (AuthenticationException e) {
                                authenticationClient.setException(e);
                            }
                            catch (UnresolvedException ue) {
                                return;
                            }
                        }
                        Class cls = Sys.loadClass((String)"backup", (String)"com.tridium.backup.ui.BBackupManager");
                        Method method = cls.getMethod("stationBackupCommand", BWidget.class, BObject.class);
                        method.invoke(null, this.getOwner(), target.get());
                        return;
                    }
                } else {
                    BackupDistCommand cmd = new BackupDistCommand(this.getOwner(), BPlatformAdministration.this.getDaemonPlatform(), BPlatformAdministration.this.getCurrentContext());
                    cmd.invoke();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    public class CommissioningCommand
    extends Command {
        public CommissioningCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.commissioning");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() {
            StringBuilder lexiconKey = new StringBuilder();
            StringBuilder lexiconArg = new StringBuilder();
            if (!CommissioningWizardModel.hostModelAllowsCommissioning(BPlatformAdministration.this.getDaemonSession(), lexiconKey, lexiconArg)) {
                BDialog.error((BWidget)this.getOwner(), (Object)BPlatformAdministration.this.getLexicon().getText(lexiconKey.toString(), new Object[]{lexiconArg.toString()}));
                return null;
            }
            try {
                BDaemonSessionView.stopAllRefreshTimers(BPlatformAdministration.this.getWbShell(), BPlatformAdministration.this.getDaemonSession().getHost());
                BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), BPlatformAdministration.this.getDaemonSession(), false));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                BDaemonSessionView.startAllRefreshTimers(BPlatformAdministration.this.getWbShell(), BPlatformAdministration.this.getDaemonSession().getHost());
            }
            return null;
        }
    }

    public class SyslogConfigurationCommand
    extends Command {
        public SyslogConfigurationCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.syslogConfiguration");
        }

        public CommandArtifact doInvoke() throws Exception {
            BPlatformAdministration.this.getDaemonSession().updateHostProperties();
            BSyslogConfigurationDialog dialog = new BSyslogConfigurationDialog();
            dialog.loadValue((BObject)BPlatformAdministration.this.getDaemonSession(), BLOCK_UNTIL_LOADED_CX);
            DialogCommand[] command = new DialogCommand[]{dialog.getSaveCommand(), DialogCommand.makeCancel((BWidget)dialog)};
            String title = BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.syslogConfiguration.label");
            int retVal = BCommandDialog.open((BWidget)this.getOwner(), (String)title, (Object)dialog, (DialogCommand[])command);
            if (retVal == 1) {
                if (dialog.areSettingsChanged()) {
                    BPlatformAdministration.this.getDaemonSession().sendMessage((DaemonMessage)dialog.getMessage());
                    BPlatformAdministration.this.getDaemonSession().updateHostProperties();
                    BPlatformAdministration.this.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
                } else {
                    BDaemonSessionView.log.log(Level.FINE, "Settings were not modified");
                }
            }
            return null;
        }
    }

    public class NreConfigurationCommand
    extends Command {
        public NreConfigurationCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.nreConfiguration");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BNreConfigurationPrompt prompt = BNreConfigurationPrompt.prompt((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession());
                if (prompt != null && prompt.changesOccurred) {
                    BPlatformAdministration.this.getDaemonSession().sendMessage((DaemonMessage)prompt.updateMessage);
                    if (prompt.ramDiskChangeOccurred) {
                        if (4 == BDialog.confirm((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.nreConfiguration.finishTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.nreConfiguration.finishMessageReboot"))) {
                            BPlatformAdministration.this.rebootCommand.doReboot();
                        }
                    } else if (BPlatformAdministration.this.areAppsRunning()) {
                        if (4 == BDialog.confirm((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.nreConfiguration.finishTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.nreConfiguration.finishMessageRestart"))) {
                            if (BPlatformAdministration.this.getDaemonSession().getHostProperties().getAllowStationRestart()) {
                                BAppSurrogate[] apps;
                                for (BAppSurrogate app : apps = BPlatformAdministration.this.getAppSurrogates()) {
                                    if (!app.isAppRunning()) continue;
                                    app.restartAppAsync();
                                }
                            } else {
                                BPlatformAdministration.this.rebootCommand.doReboot();
                            }
                        }
                    } else {
                        BDialog.info((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.nreConfiguration.finishTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.nreConfiguration.finishMessage"));
                    }
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    public class AdvancedOptionsCommand
    extends Command {
        public AdvancedOptionsCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.advancedOptions");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (AdvancedOptionsPrompt.updateSettings((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession(), BPlatformAdministration.this.factoryDefaultCredentials)) {
                BPlatformAdministration.this.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
            }
            return null;
        }
    }

    private class UpdateSystemPasswordCommand
    extends Command {
        public UpdateSystemPasswordCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.systemPassword");
        }

        public CommandArtifact doInvoke() {
            boolean factorySystemPassphraseWasPresent = BPlatformAdministration.this.factoryDefaultSystemPassword;
            if (SystemPasswordPrompt.updateSettings((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession()) && factorySystemPassphraseWasPresent) {
                BPlatformAdministration.this.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
            }
            return null;
        }
    }

    public class RuntimeProfileCommand
    extends AsyncCommand {
        public RuntimeProfileCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.runtimeProfile");
        }

        public void doInvokeAsync() {
            try {
                BWizard.open((BWidget)BPlatformAdministration.this, (WizardModel)new RuntimeProfileWizardModel((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession()));
                BPlatformAdministration.this.runtimeProfilesLabel.setText(String.join((CharSequence)",", BPlatformAdministration.this.getDaemonPlatform().getEnabledRuntimeProfileNames()));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }

    private class SystemLogDialogCommand
    extends Command {
        public SystemLogDialogCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.systemLogDialog");
        }

        public CommandArtifact doInvoke() {
            BSystemLogDialog systemLogDialog = new BSystemLogDialog(this.getOwner(), BPlatformAdministration.this.getDaemonSession());
            systemLogDialog.open();
            systemLogDialog.scrollToBottom();
            return null;
        }
    }

    private class DaemonOutputDialogCommand
    extends Command {
        public DaemonOutputDialogCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.outputDialog");
        }

        public CommandArtifact doInvoke() throws Exception {
            new BOutputDialog(this.getOwner(), BPlatformAdministration.this.getDaemonSession()).open();
            return null;
        }
    }

    private class SSLSettingsCommand
    extends RestartSessionCommand {
        public SSLSettingsCommand() {
            super(BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.sslSettings");
        }

        public CommandArtifact doInvoke() throws Exception {
            BDaemonSSLSettingsView view = new BDaemonSSLSettingsView();
            view.loadValue((BObject)BPlatformAdministration.this.getDaemonSession(), BLOCK_UNTIL_LOADED_CX);
            DialogCommand[] command = new DialogCommand[]{view.getSaveCommand(), DialogCommand.makeCancel((BWidget)view)};
            String title = BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.sslSettings");
            int retVal = BCommandDialog.open((BWidget)this.getOwner(), (String)title, (Object)view, (DialogCommand[])command);
            if (retVal == 1) {
                BPlatformSSLSettings current = BPlatformAdministration.this.getDaemonPlatform().getPlatformSSLSettings();
                BPlatformSSLSettings newSettings = view.getSettings();
                if (!current.getUseExtendedMasterSecret().equals(newSettings.getUseExtendedMasterSecret())) {
                    BDialog.info((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.sslSettings.extendedMasterSecret.reboot.title"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.sslSettings.extendedMasterSecret.reboot"));
                }
                boolean updateAlgorithm = BPlatformAdministration.this.getDaemonSession().getHostProperties().isNiagara4();
                if (BPlatformAdministration.this.getDaemonSession().getRemotePort() == current.getSslPort()) {
                    this.send(new UpdateSSLSettingsMessage(newSettings, updateAlgorithm, BPlatformAdministration.this.getDaemonSession().generateSharedSecretKey("updateTlsSettings")), newSettings.getSslPort());
                } else {
                    this.send(new UpdateSSLSettingsMessage(newSettings, updateAlgorithm, BPlatformAdministration.this.getDaemonSession().generateSharedSecretKey("updateTlsSettings")), BPlatformAdministration.this.getDaemonSession().getRemotePort());
                }
            }
            return null;
        }
    }

    private class LogSettingsCommand
    extends Command {
        public LogSettingsCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.logSettings");
        }

        public CommandArtifact doInvoke() throws Exception {
            BDaemonLogSettingsView view = new BDaemonLogSettingsView();
            view.loadValue((BObject)BPlatformAdministration.this.getDaemonSession(), BLOCK_UNTIL_LOADED_CX);
            BDialog.message((BWidget)this.getOwner(), (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.logSettings.dlgTitle"), (Object)view);
            view.saveValue();
            BPlatformAdministration.this.refresh();
            return null;
        }
    }

    private class ConfigDetailsCommand
    extends AsyncCommand {
        private final DaemonSessionTaskListener taskListener;

        public ConfigDetailsCommand(DaemonSessionTaskListener taskListener) {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.configDetails");
            this.taskListener = taskListener;
        }

        public void doInvokeAsync() {
            try {
                BConfigDetailsPane pane = new BConfigDetailsPane((BRemoteDaemonPlatform)BPlatformAdministration.this.getDaemonPlatform(), BPlatformAdministration.this.getAppSurrogates(), this.taskListener);
                BCommandDialog.open((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.configDetails.label"), (Object)((Object)pane), (DialogCommand[])new DialogCommand[]{pane.getCopyCommand(), DialogCommand.makeClose((BWidget)pane)});
            }
            catch (Exception e) {
                throw new BajaRuntimeException(BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.configDetails.exception"), (Throwable)e);
            }
        }
    }

    private class AuthenticationCommand
    extends Command {
        public AuthenticationCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.updateAuth");
        }

        public CommandArtifact doInvoke() {
            boolean factoryDefaultsWerePresent = BPlatformAdministration.this.factoryDefaultCredentials;
            try {
                BDaemonSessionView.stopAllRefreshTimers(BPlatformAdministration.this.getWbShell(), BPlatformAdministration.this.getDaemonSession().getHost());
                BWizard.open((BWidget)BPlatformAdministration.this, (WizardModel)new AuthenticationWizardModel(BPlatformAdministration.this.getDaemonSession()));
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            finally {
                if (factoryDefaultsWerePresent) {
                    BPlatformAdministration.this.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
                }
                BDaemonSessionView.startAllRefreshTimers(BPlatformAdministration.this.getWbShell(), BPlatformAdministration.this.getDaemonSession().getHost());
            }
            return null;
        }
    }

    private class UserManagementCommand
    extends Command {
        public UserManagementCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.manageUsers");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            boolean factoryDefaultsWerePresent = BPlatformAdministration.this.factoryDefaultCredentials;
            try {
                BDaemonSessionView.stopAllRefreshTimers(BPlatformAdministration.this.getWbShell(), BPlatformAdministration.this.getDaemonSession().getHost());
                if (BPlatformAdministration.this.factoryDefaultCredentials) {
                    BSessionInfo sessionInfo = BPlatformAdministration.this.getDaemonSession().getSessionInfo();
                    if (sessionInfo.getUsername().equalsIgnoreCase(BPlatformAdministration.this.factoryDefaultUsername)) {
                        BDialog.open((BWidget)BPlatformAdministration.this, (String)BDaemonSessionView.lexicon.getText("UserManager.defaultCredentialsDetected.title"), (Object)BDaemonSessionView.lexicon.getText("UserManager.defaultCredentialsLoggedIn.header"), (int)1, (BImage)BDialog.WARNING_ICON, (String)null);
                    } else {
                        BDialog.open((BWidget)BPlatformAdministration.this, (String)BDaemonSessionView.lexicon.getText("UserManager.defaultCredentialsDetected.title"), (Object)BDaemonSessionView.lexicon.getText("UserManager.defaultCredentialsNotLoggedIn.header"), (int)1, (BImage)BDialog.WARNING_ICON, (String)null);
                    }
                }
                BGridPane headerContent = new BGridPane(1);
                headerContent.setColumnAlign(BHalign.left);
                if (BPlatformAdministration.this.authenticationReadonly) {
                    headerContent.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.label.readonly"), (boolean)true));
                }
                headerContent.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.label.users"), (boolean)true));
                BFlowPane header = new BFlowPane(BHalign.left);
                header.add(null, (BValue)headerContent);
                BNativeUserTable userTable = new BNativeUserTable(true);
                userTable.loadSession(BPlatformAdministration.this.getDaemonSession());
                BEdgePane userPane = new BEdgePane(null, (BWidget)userTable.getFipsCheckBox(), null, null, (BWidget)new BBorderPane((BWidget)userTable, BBorder.inset, BInsets.DEFAULT));
                BEdgePane layoutPane = new BEdgePane((BWidget)new BBorderPane((BWidget)header, 4.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)userTable.getButtonPane(), 4.0, 0.0, 0.0, 0.0), null, null, (BWidget)userPane);
                BConstrainedPane content = new BConstrainedPane((BWidget)layoutPane);
                content.setMinSize(650.0, 300.0);
                do {
                    int result;
                    BDialog.open((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("UserManager.viewDesc"), (Object)content, (int)1);
                    if (!BPlatformAdministration.this.factoryDefaultCredentials) continue;
                    BPlatformAdministration.this.checkFactoryDefaultCredentials();
                    BSessionInfo sessionInfo = BPlatformAdministration.this.getDaemonSession().getSessionInfo();
                    if (!BPlatformAdministration.this.factoryDefaultCredentials || sessionInfo.getUsername().equalsIgnoreCase(BPlatformAdministration.this.factoryDefaultUsername) || (result = BDialog.open((BWidget)BPlatformAdministration.this, (String)BDaemonSessionView.lexicon.getText("UserManager.mustRemoveDefault.title"), (Object)BDaemonSessionView.lexicon.getText("UserManager.mustRemoveDefault.header"), (int)3, (BImage)BDialog.ERROR_ICON, (String)null)) == 2) break;
                } while (BPlatformAdministration.this.factoryDefaultCredentials);
                CommandArtifact commandArtifact = null;
                return commandArtifact;
            }
            finally {
                if (factoryDefaultsWerePresent) {
                    BPlatformAdministration.this.doLoadSession(BPlatformAdministration.this.getDaemonSession(), null);
                }
                BDaemonSessionView.startAllRefreshTimers(BPlatformAdministration.this.getWbShell(), BPlatformAdministration.this.getDaemonSession().getHost());
            }
        }
    }

    private class UpdatePortCommand
    extends RestartSessionCommand {
        public UpdatePortCommand() {
            super(BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.updatePort");
        }

        public CommandArtifact doInvoke() {
            try {
                int newPort = BPortPrompt.getPort((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession().getHostProperties().getHttpPort());
                if (newPort > 0 && newPort != BPlatformAdministration.this.getDaemonSession().getHostProperties().getHttpPort()) {
                    if (BPlatformAdministration.this.getDaemonSession().getRemotePort() == BPlatformAdministration.this.getDaemonPlatform().getPort()) {
                        this.send((DaemonMessage)new UpdateDaemonMessage(newPort), newPort);
                    } else {
                        this.send((DaemonMessage)new UpdateDaemonMessage(newPort), BPlatformAdministration.this.getDaemonSession().getRemotePort());
                    }
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updatePort.errorTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updatePort.errorMessage"), (Throwable)e);
            }
            return null;
        }
    }

    private class RestartSessionCommand
    extends Command {
        public RestartSessionCommand(BPlatformAdministration platAdmin, BModule module, String label) {
            super((BWidget)platAdmin, module, label);
        }

        public void send(UpdateSSLSettingsMessage message, int port) throws ConnectException, AuthenticationException {
            BDaemonSession newSession = BPlatformAdministration.this.getDaemonSession().shouldDowngrade(message.getSettings()) ? BDaemonSession.make((BHost)BPlatformAdministration.this.getDaemonSession().getHost(), (int)BPlatformAdministration.this.getDaemonSession().getHostProperties().getHttpPort()) : BPlatformAdministration.this.getDaemonSession().newSession(port);
            this.send((DaemonMessage)message, port, newSession);
        }

        public void send(DaemonMessage message, int port) throws ConnectException, AuthenticationException {
            this.send(message, port, BPlatformAdministration.this.getDaemonSession().newSession(port));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(DaemonMessage message, int port, BDaemonSession newSession) throws ConnectException, AuthenticationException {
            BDaemonSessionView.stopAllRefreshTimers(BPlatformAdministration.this.getWbShell(), BPlatformAdministration.this.getDaemonSession().getHost());
            BUsernameAndPassword currentCredentials = (BUsernameAndPassword)BPlatformAdministration.this.getDaemonSession().getCredentials();
            BWidgetShell shell = this.getOwner().getShell();
            BUsernameAndPassword credentials = new BUsernameAndPassword(currentCredentials.getUsername(), currentCredentials.getPassword());
            Object object = BPlatformAdministration.this.RESTART_LOCK;
            synchronized (object) {
                try {
                    BPlatformAdministration.this.restarting = true;
                    this.sendMessage(message, shell);
                    newSession.setCredentials((BICredentials)credentials, false);
                    this.reconnect(credentials, shell, newSession);
                }
                catch (Exception e) {
                    BDaemonSessionView.log.log(Level.SEVERE, "Failed to send restart session command", e);
                    if (!newSession.isConnected()) {
                        newSession.getHost().removeNavChild((BINavNode)newSession);
                    }
                    throw e;
                }
                finally {
                    BPlatformAdministration.this.restarting = false;
                }
            }
            BPlatformAdministration.this.startRefreshTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendMessage(DaemonMessage message, BWidgetShell shell) throws ConnectException {
            boolean useShell = shell instanceof BWbShell;
            try {
                if (useShell) {
                    shell.enterBusy();
                }
                BPlatformAdministration.this.getDaemonSession().sendMessage(message);
                BPlatformAdministration.this.getDaemonSession().disconnect(false);
                Thread.sleep(3500L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (useShell) {
                    shell.exitBusy();
                }
            }
        }

        private void reconnect(BUsernameAndPassword credentials, BWidgetShell shell, BDaemonSession newSession) {
            if (shell instanceof BWbShell) {
                BNiagaraWbShell nwbShell;
                BWbShell wbShell = (BWbShell)shell;
                BOrd hyperlinkOrd = BOrd.make((BOrd)newSession.getAbsoluteOrd().normalize(), (OrdQuery)new ViewQuery(TYPE.toString()));
                wbShell.hyperlink((HyperlinkInfo)new NHyperlinkInfo(hyperlinkOrd, BHyperlinkMode.replace, true, (BICredentials)credentials));
                if (shell instanceof BNiagaraWbShell && (nwbShell = (BNiagaraWbShell)shell).getActiveOrdTarget() != null) {
                    nwbShell.syncTree();
                }
            }
        }
    }

    private class UpdateTimeCommand
    extends AsyncCommand {
        public UpdateTimeCommand() {
            super((BWidget)BPlatformAdministration.this, TYPE.getModule(), "PlatformAdministration.command.updateTime");
        }

        public void doInvokeAsync() {
            try {
                BTimePrompt answer = BTimePrompt.prompt((BWidget)BPlatformAdministration.this, BPlatformAdministration.this.getDaemonSession(), BPlatformAdministration.this.timeZones);
                if (answer != null) {
                    BTimeZone currentTz = DaemonTimeUtil.getLocalTimeZone((BDaemonSession)BPlatformAdministration.this.getDaemonSession());
                    BPlatformAdministration.this.getDaemonSession().sendMessage((DaemonMessage)new UpdateTimeMessage(answer.getDateTime(), answer.getBajaTimeZoneId(), answer.getTimeZone(), !BPlatformAdministration.this.getDaemonSession().getHostProperties().isNiagara4()));
                    if (!answer.getTimeZone().getId().equals(answer.getBajaTimeZoneId())) {
                        BDialog.warning((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.usingUtcTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.usingUtcMessage", new Object[]{answer.getBajaTimeZoneId(), answer.getTimeZone()}));
                    } else if (!currentTz.getId().equals(answer.getTimeZone().getId())) {
                        if (BPlatformAdministration.this.getDaemonSession().getHostProperties().getModelName().equals("JNXS")) {
                            if (4 == BDialog.confirm((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.tzTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.nxs.tzMessage", new Object[]{answer.getBajaTimeZoneId()}))) {
                                BPlatformAdministration.this.rebootCommand.doReboot();
                                return;
                            }
                        } else if (BPlatformAdministration.this.areAppsRunning()) {
                            BDialog.warning((BWidget)BPlatformAdministration.this, (String)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.tzTitle"), (Object)BPlatformAdministration.this.getLexicon().getText("PlatformAdministration.command.updateTime.tzMessage", new Object[]{answer.getBajaTimeZoneId()}));
                        }
                    }
                    BPlatformAdministration.this.refresh();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
        }
    }
}

