/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="poolSize", type="int", defaultValue="1024", facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS }, new BIDataValue[] { BUnit.getUnit(\"megabyte\") })")}), @NiagaraProperty(name="textFont", type="BFont", defaultValue="BFont.NULL"), @NiagaraProperty(name="systemBarBrush", type="BBrush", defaultValue="BColor.white.toBrush()"), @NiagaraProperty(name="heapBarBrush", type="BBrush", defaultValue="BColor.whiteSmoke.toBrush()"), @NiagaraProperty(name="metaBarBrush", type="BBrush", defaultValue="BColor.lightGrey.toBrush()"), @NiagaraProperty(name="codeBarBrush", type="BBrush", defaultValue="BColor.darkGrey.toBrush()"), @NiagaraProperty(name="ramBarBrush", type="BBrush", defaultValue="BColor.grey.toBrush()")})
public class BNreMemoryPoolBar
extends BWidget {
    @Generated
    public static final Property poolSize = BNreMemoryPoolBar.newProperty((int)0, (int)1024, (BFacets)BFacets.make((String[])new String[]{"units"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"megabyte")}));
    @Generated
    public static final Property textFont = BNreMemoryPoolBar.newProperty((int)0, (BValue)BFont.NULL, null);
    @Generated
    public static final Property systemBarBrush = BNreMemoryPoolBar.newProperty((int)0, (BValue)BColor.white.toBrush(), null);
    @Generated
    public static final Property heapBarBrush = BNreMemoryPoolBar.newProperty((int)0, (BValue)BColor.whiteSmoke.toBrush(), null);
    @Generated
    public static final Property metaBarBrush = BNreMemoryPoolBar.newProperty((int)0, (BValue)BColor.lightGrey.toBrush(), null);
    @Generated
    public static final Property codeBarBrush = BNreMemoryPoolBar.newProperty((int)0, (BValue)BColor.darkGrey.toBrush(), null);
    @Generated
    public static final Property ramBarBrush = BNreMemoryPoolBar.newProperty((int)0, (BValue)BColor.grey.toBrush(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNreMemoryPoolBar.class);
    private final Object valuesMonitor = new Object();
    private double systemReserveValue = 0.0;
    private double heapValue = 0.0;
    private double metaValue = 0.0;
    private double codeValue = 0.0;
    private double ramValue = 0.0;
    public static BNreMemoryPoolBar NULL_BAR = new BNreMemoryPoolBar();
    int version = 0;
    boolean ramDiskPresent = false;

    @Generated
    public int getPoolSize() {
        return this.getInt(poolSize);
    }

    @Generated
    public void setPoolSize(int v) {
        this.setInt(poolSize, v, null);
    }

    @Generated
    public BFont getTextFont() {
        return (BFont)this.get(textFont);
    }

    @Generated
    public void setTextFont(BFont v) {
        this.set(textFont, (BValue)v, null);
    }

    @Generated
    public BBrush getSystemBarBrush() {
        return (BBrush)this.get(systemBarBrush);
    }

    @Generated
    public void setSystemBarBrush(BBrush v) {
        this.set(systemBarBrush, (BValue)v, null);
    }

    @Generated
    public BBrush getHeapBarBrush() {
        return (BBrush)this.get(heapBarBrush);
    }

    @Generated
    public void setHeapBarBrush(BBrush v) {
        this.set(heapBarBrush, (BValue)v, null);
    }

    @Generated
    public BBrush getMetaBarBrush() {
        return (BBrush)this.get(metaBarBrush);
    }

    @Generated
    public void setMetaBarBrush(BBrush v) {
        this.set(metaBarBrush, (BValue)v, null);
    }

    @Generated
    public BBrush getCodeBarBrush() {
        return (BBrush)this.get(codeBarBrush);
    }

    @Generated
    public void setCodeBarBrush(BBrush v) {
        this.set(codeBarBrush, (BValue)v, null);
    }

    @Generated
    public BBrush getRamBarBrush() {
        return (BBrush)this.get(ramBarBrush);
    }

    @Generated
    public void setRamBarBrush(BBrush v) {
        this.set(ramBarBrush, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNreMemoryPoolBar() {
    }

    public BNreMemoryPoolBar(int max, int version, boolean ramDiskPresent) {
        this.setPoolSize(max);
        this.version = version;
        this.ramDiskPresent = ramDiskPresent;
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.version >= 2 ? 785.0 : 675.0, 50.0);
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        BBrush systemReserveBrush = this.getSystemBarBrush();
        BBrush heapBrush = this.getHeapBarBrush();
        BBrush metaBrush = this.getMetaBarBrush();
        BBrush codeBrush = this.getCodeBarBrush();
        BBrush ramBrush = this.getRamBarBrush();
        int systemWidth = this.version >= 2 ? (int)Math.floor(this.getPercentSystem() * w) : 0;
        int heapWidth = (int)Math.floor(this.getPercentHeap() * w);
        int metaWidth = (int)Math.floor(this.getPercentMeta() * w);
        int codeWidth = (int)Math.floor(this.getPercentCode() * w);
        int ramWidth = this.ramDiskPresent ? (int)Math.floor(this.getPercentRAM() * w) : 0;
        g.setBrush(this.ramDiskPresent ? ramBrush : codeBrush);
        g.fillRect(0.0, 0.0, w, h);
        if (this.version >= 2) {
            g.setBrush(systemReserveBrush);
            g.fillRect(0.0, 0.0, (double)systemWidth, h);
        }
        g.setBrush(heapBrush);
        g.fillRect((double)systemWidth, 0.0, (double)heapWidth, h);
        g.setBrush(metaBrush);
        g.fillRect((double)(systemWidth + heapWidth), 0.0, (double)metaWidth, h);
        g.setBrush(codeBrush);
        g.fillRect((double)(systemWidth + heapWidth + metaWidth), 0.0, (double)codeWidth, h);
        if (this.ramDiskPresent) {
            g.setBrush(ramBrush);
            g.fillRect((double)(systemWidth + heapWidth + metaWidth + codeWidth), 0.0, (double)ramWidth, h);
        }
        g.setBrush(BColor.black);
        g.strokeRect(0.0, 0.0, w - 1.0, h - 1.0);
        if (this.version >= 2) {
            g.strokeLine((double)systemWidth, 0.0, (double)systemWidth, h);
        }
        g.strokeLine((double)(systemWidth + heapWidth), 0.0, (double)(systemWidth + heapWidth), h);
        g.strokeLine((double)(systemWidth + heapWidth + metaWidth), 0.0, (double)(systemWidth + heapWidth + metaWidth), h);
        if (this.ramDiskPresent) {
            g.strokeLine((double)(systemWidth + heapWidth + metaWidth + codeWidth), 0.0, (double)(systemWidth + heapWidth + metaWidth + codeWidth), h);
        }
    }

    public int getSystemReserveValue() {
        return (int)this.systemReserveValue;
    }

    public int getHeapValue() {
        return (int)this.heapValue;
    }

    public int getMetaValue() {
        return (int)this.metaValue;
    }

    public int getCodeValue() {
        return (int)this.codeValue;
    }

    public int getRAMValue() {
        return (int)this.ramValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if (v > this.getPoolSize()) {
                v = this.getPoolSize();
            }
            this.systemReserveValue = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeapValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if (v > this.getPoolSize()) {
                v = this.getPoolSize();
            }
            this.heapValue = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if (v > this.getPoolSize()) {
                v = this.getPoolSize();
            }
            this.metaValue = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodeValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if (v > this.getPoolSize()) {
                v = this.getPoolSize();
            }
            this.codeValue = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRAMValue(int v) {
        Object object = this.valuesMonitor;
        synchronized (object) {
            if (v < 0) {
                v = 0;
            } else if (v > this.getPoolSize()) {
                v = this.getPoolSize();
            }
            this.ramValue = v;
        }
    }

    public double getPercentSystem() {
        return this.systemReserveValue / (double)this.getPoolSize();
    }

    public double getPercentHeap() {
        return this.heapValue / (double)this.getPoolSize();
    }

    public double getPercentMeta() {
        return this.metaValue / (double)this.getPoolSize();
    }

    public double getPercentCode() {
        return this.codeValue / (double)this.getPoolSize();
    }

    public double getPercentRAM() {
        return this.ramValue / (double)this.getPoolSize();
    }
}

