/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platform.tcpip.link.BLinkCfgHostSettings;
import com.tridium.platform.tcpip.link.LinkCfgUtil;
import com.tridium.platform.ui.tcpip.BTcpIpHostEditor;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.nio.charset.StandardCharsets;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.xml.XWriter;

public final class TcpIpStep
extends CommissioningWizardStep {
    private final BTcpIpHostEditor editor;

    public TcpIpStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
        BGridPane headers = new BGridPane(1);
        headers.setHalign(BHalign.left);
        headers.add(null, (BValue)LabelUtil.makeLabel((LexiconText)this.getLexiconText("CommissioningWizard.tcpip.header"), (boolean)false));
        this.editor = new BTcpIpHostEditor();
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.editor, 5.0, 0.0, 0.0, 0.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BButtonPane buttons = new BButtonPane(new Command[]{new UndoChanges()});
        this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)headers, 0.0, 0.0, 4.0, 0.0), (BWidget)new BBorderPane((BWidget)buttons, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)scrollPane));
        this.editor.setReadonly(false);
    }

    @Override
    public String getStepName() {
        return "tcpip";
    }

    @Override
    public String getSectionName() {
        return "tcpip";
    }

    @Override
    public void enter() {
        if (this.wizardModel.tcpIpSettings == null) {
            try {
                this.wizardModel.originalTcpIpSettings = new BTcpIpHostSettings();
                TcpUtil.loadFromSession((BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings, (BDaemonSession)this.wizardModel.daemonSession);
                if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("dhcpd")) {
                    this.wizardModel.dhcpdHostSettings = new BDhcpdHostSettings();
                    DhcpdUtil.loadFromSession((BDhcpdHostSettings)this.wizardModel.dhcpdHostSettings, (BDaemonSession)this.wizardModel.daemonSession);
                    DhcpdUtil.loadDhcpdConfFile((BDhcpdHostSettings)this.wizardModel.dhcpdHostSettings, (BDaemonSession)this.wizardModel.daemonSession);
                    DhcpdUtil.copyDhcpdSlotToAdapters((BDhcpdHostSettings)this.wizardModel.dhcpdHostSettings, (BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings);
                }
                if (this.wizardModel.daemonSession.getHostProperties().supportsServlet("linkcfg")) {
                    this.wizardModel.linkCfgHostSettings = new BLinkCfgHostSettings();
                    LinkCfgUtil.loadFromSession((BLinkCfgHostSettings)this.wizardModel.linkCfgHostSettings, (BDaemonSession)this.wizardModel.daemonSession);
                    LinkCfgUtil.loadLinkCfgFile((BLinkCfgHostSettings)this.wizardModel.linkCfgHostSettings, (BDaemonSession)this.wizardModel.daemonSession);
                    LinkCfgUtil.copyLinkCfgSlotToHost((BLinkCfgHostSettings)this.wizardModel.linkCfgHostSettings, (BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings);
                }
                this.wizardModel.tcpIpSettings = (BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings.newCopy();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        this.editor.loadValue((BObject)this.wizardModel.tcpIpSettings.newCopy());
    }

    @Override
    public boolean exit(int direction) {
        if (direction == 2) {
            try {
                BTcpIpAdapterSettings adapter;
                SlotCursor c;
                boolean allowMultipleOverride;
                this.wizardModel.hostFileDirty = this.editor.isHostFileDirty();
                BTcpIpHostSettings hostSettings = (BTcpIpHostSettings)this.editor.saveValue();
                BHostProperties props = this.wizardModel.daemonSession.getHostProperties();
                if (props.getOsName().startsWith("win") && hostSettings.getHostName().length() > 15) {
                    throw new CannotSaveException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.invalidHostName"));
                }
                boolean bl = allowMultipleOverride = props.getOsName().startsWith("qnx-jace") || props.getOsName().startsWith("tridium-qnx7");
                if (!hostSettings.getAllowMultipleAutoIPv4Adapters() || allowMultipleOverride) {
                    int dhcpCount = 0;
                    c = hostSettings.getAdapters().getProperties();
                    while (c.next(BTcpIpAdapterSettings.class)) {
                        adapter = (BTcpIpAdapterSettings)c.get();
                        if (!adapter.getIsAdapterEnabled() || !adapter.getIsDhcpEnabled()) continue;
                        ++dhcpCount;
                    }
                    if (dhcpCount > 1) {
                        throw new CannotSaveException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleDhcpAdapters"));
                    }
                }
                if (!hostSettings.getAllowMultipleAutoIPv6Adapters() || allowMultipleOverride) {
                    int autoIpv6Count = 0;
                    c = hostSettings.getAdapters().getProperties();
                    while (c.next(BTcpIpAdapterSettings.class)) {
                        adapter = (BTcpIpAdapterSettings)c.get();
                        if (!adapter.getIsAdapterEnabled() || !adapter.getIsIpv6Enabled() || !adapter.getIsIpv6DhcpEnabled()) continue;
                        ++autoIpv6Count;
                    }
                    if (autoIpv6Count > 1) {
                        throw new CannotSaveException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleAutoIPv6Adapters"));
                    }
                }
                this.wizardModel.tcpIpSettings = hostSettings;
                ByteBuffer buffer = new ByteBuffer();
                XWriter out = new XWriter(buffer.getOutputStream());
                TcpUtil.getHostSettingsXml((BTcpIpHostSettings)this.wizardModel.tcpIpSettings).write(out);
                out.flush();
                String newHostSettingsString = new String(buffer.getBytes(), 0, buffer.getLength(), StandardCharsets.UTF_8);
                buffer = new ByteBuffer();
                out = new XWriter(buffer.getOutputStream());
                TcpUtil.getHostSettingsXml((BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings).write(out);
                out.flush();
                String originalHostSettingsString = new String(buffer.getBytes(), 0, buffer.getLength(), StandardCharsets.UTF_8);
                boolean bl2 = this.wizardModel.updateTcpIpSettings = !newHostSettingsString.equals(originalHostSettingsString) || this.wizardModel.hostFileDirty;
                if (this.wizardModel.dhcpdHostSettings != null) {
                    DhcpdUtil.copyDhcpdSlotFromAdapters((BDhcpdHostSettings)this.wizardModel.dhcpdHostSettings, (BTcpIpHostSettings)this.wizardModel.tcpIpSettings);
                    this.wizardModel.updateDhcpdSettings = true;
                }
                if (this.wizardModel.linkCfgHostSettings != null) {
                    LinkCfgUtil.copyLinkCfgSlotFromHost((BLinkCfgHostSettings)this.wizardModel.linkCfgHostSettings, (BTcpIpHostSettings)this.wizardModel.tcpIpSettings);
                    this.wizardModel.updateLinkSettings = true;
                }
            }
            catch (CannotSaveException cse) {
                if (!cse.isSilent()) {
                    BDialog.error((BWidget)this.wizardModel.owner, (Object)((Object)cse));
                }
                this.editor.setModified();
                return false;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        return true;
    }

    @Override
    public int getMode() {
        return 3;
    }

    @Override
    public boolean isSkipped() {
        return this.wizardModel.skipTcp;
    }

    private class UndoChanges
    extends Command {
        public UndoChanges() {
            super(TcpIpStep.this.wizardModel.owner, Lexicon.make((String)"platDaemon"), "CommissioningWizard.tcpStep.revert");
        }

        public CommandArtifact doInvoke() {
            TcpIpStep.this.editor.loadValue((BObject)TcpIpStep.this.wizardModel.originalTcpIpSettings);
            return null;
        }
    }
}

