/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.nre.subscription.AccessTokenApi;
import com.tridium.nre.subscription.DeviceCodeApi;
import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.nre.subscription.RegistrationApi;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.nre.util.LicenseMode;
import com.tridium.nre.util.NiagaraFiles;
import com.tridium.platDaemon.ui.FipsOptionsHelper;
import com.tridium.platDaemon.ui.HostNotFipsReadyItem;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.commissioningwizard.LicenseSelection;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseList;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseModel;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.web.BUrlTextField;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

public class LicenseStep
extends CommissioningWizardStep {
    private NoInstallCommand noInstallCommand;
    private InstallFileCommand installFileCommand;
    private ChooseLicenseFileStep chooseFileStep;
    private InstallSubscriptionCommand installSubscriptionCommand;
    private List<InstallOnlineCommand> installOnlineCommands;
    private ToggleCommandGroup<ToggleCommand> commandGroup;

    public LicenseStep(CommissioningWizardModel wizardModel) {
        super(wizardModel);
        boolean requiredSubscription = wizardModel.daemonSession.getHostProperties().getRequireSubscription();
        this.commandGroup = new ToggleCommandGroup();
        if (requiredSubscription && SubscriptionLicenseUtil.isSubscriptionLicensingSupported()) {
            BIndentPane requiredSubscriptionIndentPane = new BIndentPane();
            this.addInstalledLicenses(requiredSubscriptionIndentPane, 0, LicenseMode.SUBSCRIPTION);
            requiredSubscriptionIndentPane.indent();
            if (wizardModel.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isOk()) {
                this.noInstallCommand = new NoInstallCommand();
                requiredSubscriptionIndentPane.add((BWidget)new BRadioButton((ToggleCommand)this.noInstallCommand, true, false));
                this.commandGroup.add((ToggleCommand)this.noInstallCommand);
                this.noInstallCommand.setSelected(true);
            } else {
                this.installSubscriptionCommand = new InstallSubscriptionCommand();
                requiredSubscriptionIndentPane.add((BWidget)new BRadioButton((ToggleCommand)this.installSubscriptionCommand, true, false));
                this.commandGroup.add((ToggleCommand)this.installSubscriptionCommand);
                wizardModel.setLicenseSelection(this.installSubscriptionCommand);
                requiredSubscriptionIndentPane.indent(2);
                requiredSubscriptionIndentPane.add(this.getLexiconText("CommissioningWizard.license.subscriptionNote"));
                requiredSubscriptionIndentPane.unindent(2);
            }
            wizardModel.skipLicense = false;
            wizardModel.requireLicense = true;
            wizardModel.enableLicense = false;
            this.setContent((BWidget)requiredSubscriptionIndentPane);
            return;
        }
        this.chooseFileStep = new ChooseLicenseFileStep(wizardModel);
        this.nextStep = this.chooseFileStep;
        this.chooseFileStep.priorStep = this;
        ChooseCertificateFileStep certFileStep = new ChooseCertificateFileStep(wizardModel);
        this.chooseFileStep.nextStep = certFileStep;
        certFileStep.priorStep = this.chooseFileStep;
        this.lastStep = certFileStep;
        wizardModel.portalAvailable = PortalLicenseUtil.isApiAvailable() && PortalLicenseUtil.requestLicensesOnline();
        wizardModel.licenseReadonly = wizardModel.daemonSession.getHostProperties().getIsLicenseReadonly();
        this.loadCurrentLicenses();
        List<LicenseModel> portalLicenses = this.loadPortalLicenses();
        List<LicenseInfo> dbLicenses = this.loadDbLicenses();
        LicenseSync<LicenseInfo> dbLicenseSync = LicenseStep.syncLicenses(wizardModel, dbLicenses);
        BIndentPane indentPane = new BIndentPane();
        Version wbBajaVersion = Sys.getRegistry().getModule("baja", RuntimeProfile.rt).getVendorVersion();
        wbBajaVersion = new Version(new int[]{wbBajaVersion.major(), wbBajaVersion.minor()});
        int licenseCount = wizardModel.currentLicenses.size();
        Set<String> missingCerts = this.updateCertsToInstall(null, true);
        HashSet<String> unavailableCerts = new HashSet<String>(missingCerts);
        unavailableCerts.removeAll(wizardModel.availableCertVendors);
        if (wizardModel.daemonSession.getHostProperties().getHostIdSettings().getLicenseMode() == LicenseMode.SUBSCRIPTION) {
            this.addInstalledLicenses(indentPane, licenseCount, LicenseMode.SUBSCRIPTION);
        } else if (licenseCount != 0) {
            this.addInstalledLicenses(indentPane, licenseCount, LicenseMode.PERPETUAL);
        } else if (wizardModel.licenseReadonly) {
            indentPane.add(this.getLexiconText("CommissioningWizard.license.readonlyHeader"));
        } else {
            indentPane.add(this.getLexiconText("CommissioningWizard.license.noLicenses"));
        }
        indentPane.indent();
        if (wizardModel.licenseReadonly) {
            wizardModel.skipLicense = true;
            wizardModel.requireLicense = false;
            wizardModel.enableLicense = false;
            wizardModel.setLicenseSelection(new NoInstallCommand());
        } else {
            if (missingCerts.size() > 0) {
                wizardModel.skipLicense = false;
                wizardModel.requireLicense = true;
                wizardModel.enableLicense = false;
            }
            if (wizardModel.currentLicenseVersion != null) {
                if (wbBajaVersion.compareTo(wizardModel.currentLicenseVersion) > 0) {
                    wizardModel.skipLicense = false;
                    wizardModel.requireLicense = true;
                    wizardModel.enableLicense = false;
                }
                this.noInstallCommand = new NoInstallCommand();
                indentPane.add((BWidget)new BRadioButton((ToggleCommand)this.noInstallCommand, true, false));
                this.commandGroup.add((ToggleCommand)this.noInstallCommand);
            }
            this.installFileCommand = new InstallFileCommand();
            indentPane.add((BWidget)new BRadioButton((ToggleCommand)this.installFileCommand, true, false));
            this.commandGroup.add((ToggleCommand)this.installFileCommand);
            this.installOnlineCommands = new ArrayList<InstallOnlineCommand>();
            if (wizardModel.portalAvailable) {
                for (LicenseModel model : portalLicenses) {
                    LicenseSync<LicenseInfo> portalLicenseSync = LicenseStep.syncLicenses(wizardModel, model.getLicenseInfos());
                    if (!this.outOfSync(portalLicenseSync)) continue;
                    InstallOnlineCommand installOnline = new InstallOnlineCommand(model, portalLicenseSync);
                    this.installOnlineCommands.add(installOnline);
                    wizardModel.setLicenseSelection(installOnline);
                    wizardModel.skipLicense = false;
                    wizardModel.requireLicense = true;
                    wizardModel.enableLicense = false;
                    indentPane.add((BWidget)new BRadioButton((ToggleCommand)installOnline, true, false));
                    this.addLicenseSummary(indentPane, portalLicenseSync);
                    this.commandGroup.add((ToggleCommand)installOnline);
                }
            }
            if (this.outOfSync(dbLicenseSync)) {
                Set<String> unavailableAfterDbSync = this.getMissingCerts(dbLicenseSync, true);
                unavailableAfterDbSync.removeAll(wizardModel.availableCertVendors);
                if (unavailableAfterDbSync.size() == 0) {
                    InstallDbCommand installDb = new InstallDbCommand(dbLicenseSync);
                    indentPane.add((BWidget)new BRadioButton((ToggleCommand)installDb, true, false));
                    this.addLicenseSummary(indentPane, dbLicenseSync);
                    this.commandGroup.add((ToggleCommand)installDb);
                    if (wizardModel.getLicenseSelection() == this.noInstallCommand) {
                        wizardModel.setLicenseSelection(installDb);
                        wizardModel.skipLicense = false;
                        wizardModel.requireLicense = true;
                        wizardModel.enableLicense = false;
                    }
                }
            }
            if (SubscriptionLicenseUtil.isSubscriptionLicensingSupported()) {
                this.installSubscriptionCommand = new InstallSubscriptionCommand();
                indentPane.add((BWidget)new BRadioButton((ToggleCommand)this.installSubscriptionCommand, true, false));
                this.commandGroup.add((ToggleCommand)this.installSubscriptionCommand);
                wizardModel.setLicenseSelection(this.installSubscriptionCommand);
                indentPane.indent(2);
                indentPane.add(this.getLexiconText("CommissioningWizard.license.subscriptionNote"));
                indentPane.unindent(2);
            }
            indentPane.unindent();
            if (wizardModel.requireLicense) {
                indentPane.add((BWidget)new BBox(0.0, 6.0));
                indentPane.add(this.getLexiconText("CommissioningWizard.license.versionNote"), new Object[]{wbBajaVersion});
            }
            if (missingCerts.size() > 0) {
                indentPane.add((BWidget)new BBox(0.0, 6.0));
                indentPane.add(this.getLexiconText("CommissioningWizard.license.certHeader"));
                indentPane.indent();
                missingCerts.forEach(arg_0 -> ((BIndentPane)indentPane).add(arg_0));
                indentPane.unindent();
                indentPane.add(this.getLexiconText("CommissioningWizard.license.certFooter"));
            }
            if (wizardModel.getLicenseSelection() == null) {
                if (wizardModel.currentLicenseVersion == null) {
                    if (wizardModel.portalAvailable && this.installOnlineCommands.size() > 0) {
                        this.installOnlineCommands.get(0).setSelected(true);
                    } else {
                        this.installFileCommand.setSelected(true);
                    }
                } else {
                    this.noInstallCommand.setSelected(true);
                }
            }
            wizardModel.setLicenseSelection((LicenseSelection)this.commandGroup.getSelected());
        }
        this.setContent((BWidget)indentPane);
    }

    @Override
    public boolean checkNext() {
        if (this.commandGroup.getSelected() == this.installSubscriptionCommand) {
            BDialog.info((BWidget)this.wizardModel.owner, (Object)this.getLexiconText("CommissioningWizard.license.subscriptionDialog").getText(null));
        }
        return super.checkNext();
    }

    private void addInstalledLicenses(BIndentPane indentPane, int licenseCount, LicenseMode mode) {
        indentPane.add(this.getLexiconText("CommissioningWizard.license.listHeader"));
        indentPane.indent();
        if (mode == LicenseMode.SUBSCRIPTION) {
            indentPane.add(this.getLexiconText("CommissioningWizard.review.subscription"));
            indentPane.add(LEX.getText("CommissioningWizard.deviceRegistrationStep.license.deviceStatus", new Object[]{LEX.getText("PlatformAdministration.hostIdStatus." + this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().getTag())}));
            if (this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isOk()) {
                indentPane.add(LEX.getText("CommissioningWizard.deviceRegistrationStep.success.hostId", new Object[]{this.wizardModel.daemonSession.getHostProperties().getHostId()}));
            }
        } else {
            for (int i = 0; i < licenseCount; ++i) {
                LicenseInfo info = this.wizardModel.currentLicenses.get(i);
                indentPane.add(info.toString());
            }
        }
        indentPane.unindent();
        indentPane.add((BWidget)new BBox(0.0, 6.0));
        if (this.wizardModel.licenseReadonly) {
            indentPane.add(this.getLexiconText("CommissioningWizard.license.readonlyHeader"));
        } else {
            indentPane.add(this.getLexiconText("CommissioningWizard.license.choicesHeader"));
        }
    }

    private void addLicenseSummary(BIndentPane indent, LicenseSync<?> sync) {
        int i;
        indent.indent(2);
        for (i = 0; i < sync.toAdd.size(); ++i) {
            indent.add(sync.toAdd.get(i).toString());
        }
        for (i = 0; i < sync.toUpdate.size(); ++i) {
            indent.add(sync.toUpdate.get(i).toString());
        }
        indent.unindent(2);
    }

    Set<String> getMissingCerts() {
        return this.getMissingCerts(this.wizardModel.getLicenseSelection() == null ? null : this.wizardModel.getLicenseSelection().getLicenseSync(), false);
    }

    Set<String> getMissingCerts(LicenseSync<LicenseInfo> pendingUpdates, boolean updateFromPortal) {
        HashSet<String> missingCerts = new HashSet<String>();
        this.wizardModel.currentLicenses.stream().map(li -> li.vendorLicense.getVendor()).forEach(missingCerts::add);
        if (pendingUpdates != null) {
            pendingUpdates.toAdd.stream().map(li -> li.vendorLicense.getVendor()).forEach(missingCerts::add);
            pendingUpdates.toUpdate.stream().map(li -> li.vendorLicense.getVendor()).forEach(missingCerts::add);
            pendingUpdates.toRemove.stream().map(li -> li.vendorLicense.getVendor()).forEach(missingCerts::remove);
        }
        this.wizardModel.currentCertificates.stream().map(ci -> ci.vendorCertificate.getVendor()).forEach(missingCerts::remove);
        if (updateFromPortal && this.wizardModel.portalAvailable) {
            HashSet<String> toDownload = new HashSet<String>(missingCerts);
            this.wizardModel.localCertificates.stream().map(ci -> ci.vendorCertificate.getVendor()).forEach(toDownload::remove);
            if (toDownload.size() > 0) {
                try {
                    boolean isPerpetual = this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual();
                    boolean isNiagaraHomeReadonly = this.wizardModel.daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
                    for (XElem newCertElem : PortalLicenseUtil.getCertificates((String[])toDownload.toArray(new String[0]))) {
                        CertificateInfo newCert = new CertificateInfo(newCertElem, null);
                        BIFile certFile = BFileSystem.INSTANCE.makeFile(newCert.getInstalledFilePath(true, isPerpetual, isNiagaraHomeReadonly), null);
                        try (OutputStream out = certFile.getOutputStream();
                             XWriter writer = new XWriter(out);){
                            newCertElem.write(writer);
                            this.wizardModel.localCertificates.add(newCert);
                            this.wizardModel.availableCertVendors.add(newCert.vendorCertificate.getVendor());
                        }
                    }
                }
                catch (Exception e) {
                    this.wizardModel.portalAvailable = false;
                }
            }
        }
        return missingCerts;
    }

    private Set<String> updateCertsToInstall() {
        return this.updateCertsToInstall(this.wizardModel.getLicenseSelection() == null ? null : this.wizardModel.getLicenseSelection().getLicenseSync(), true);
    }

    private Set<String> updateCertsToInstall(LicenseSync<LicenseInfo> pendingUpdates, boolean updateFromPortal) {
        if (pendingUpdates != null) {
            ArrayList<LicenseInfo> fipsLicenses = new ArrayList<LicenseInfo>();
            for (LicenseInfo licenseInfo : pendingUpdates.toAdd) {
                if (licenseInfo.vendorLicense.getFeature("fips140-2") == null) continue;
                fipsLicenses.add(licenseInfo);
            }
            for (LicenseInfo licenseInfo : pendingUpdates.toUpdate) {
                if (licenseInfo.vendorLicense.getFeature("fips140-2") == null) continue;
                fipsLicenses.add(licenseInfo);
            }
            this.wizardModel.forceChangeUsers = false;
            if (!fipsLicenses.isEmpty()) {
                ArrayList<HostNotFipsReadyItem> errorItems = new ArrayList<HostNotFipsReadyItem>();
                if (!FipsOptionsHelper.getInstance().isHostFipsReady(this.wizardModel.daemonSession, errorItems::add)) {
                    BDialog.warning((BWidget)this.wizardModel.owner, (String)CommissioningWizardModel.lex.getText("CommissioningWizard.license.fipsNotReady.title"), (Object)this.buildFipsPane(fipsLicenses, errorItems));
                    this.wizardModel.isFips = true;
                    for (HostNotFipsReadyItem errorItem : errorItems) {
                        if (errorItem instanceof HostNotFipsReadyItem.SystemPassphraseNotFipsReady) {
                            if (!this.wizardModel.daemonSession.getHostProperties().supportsServlet("systempw")) continue;
                            this.wizardModel.skipSystemPassword = false;
                            continue;
                        }
                        if (!(errorItem instanceof HostNotFipsReadyItem.UsersNotFipsReady)) continue;
                        this.wizardModel.skipConfigUsers = false;
                        if (!this.wizardModel.forceChangeListFilled) {
                            this.wizardModel.forceChangeUserList.addAll(((HostNotFipsReadyItem.UsersNotFipsReady)errorItem).getUserList());
                            this.wizardModel.forceChangeListFilled = true;
                        }
                        this.wizardModel.forceChangeUsers = true;
                    }
                }
            }
        }
        Set<String> missingCerts = this.getMissingCerts(pendingUpdates, updateFromPortal);
        this.wizardModel.certificatesToInstall.clear();
        this.wizardModel.certificatesToInstall.addAll(this.wizardModel.localCertificates.stream().filter(localCert -> missingCerts.contains(localCert.vendorCertificate.getVendor())).collect(Collectors.toList()));
        return missingCerts;
    }

    @Override
    public String getStepName() {
        return "license";
    }

    @Override
    public String getSectionName() {
        return "license";
    }

    @Override
    public boolean exit(int direction) {
        this.wizardModel.setLicenseSelection((LicenseSelection)this.commandGroup.getSelected());
        this.updateCertsToInstall();
        return true;
    }

    @Override
    public boolean isSkipped() {
        return this.wizardModel.skipLicense;
    }

    @Override
    public int getMode() {
        return 3;
    }

    private boolean outOfSync(LicenseSync<?> sync) {
        return sync != null && !sync.unchanged();
    }

    private void loadCurrentLicenses() {
        BIFile brandProps;
        String hostId = this.wizardModel.daemonSession.getHostProperties().getHostId();
        this.wizardModel.currentLicenses.clear();
        if (this.wizardModel.licenseReadonly) {
            this.wizardModel.skipLicense = true;
            this.wizardModel.requireLicense = false;
            this.wizardModel.enableLicense = false;
        }
        boolean isPerpetual = this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual();
        boolean isNiagaraHomeReadonly = this.wizardModel.daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
        BDirectory remoteLicDir = (BDirectory)this.wizardModel.daemonSession.getFileSpace().findFile(SystemFilePaths.getLicensesDirPath((boolean)true, (boolean)isPerpetual, (boolean)isNiagaraHomeReadonly));
        if (remoteLicDir == null) {
            if (!this.wizardModel.licenseReadonly) {
                this.wizardModel.skipLicense = false;
                this.wizardModel.requireLicense = true;
                this.wizardModel.enableLicense = false;
            }
            return;
        }
        BINavNode[] remoteLicenses = remoteLicDir.getNavChildren();
        if (remoteLicenses == null) {
            if (!this.wizardModel.licenseReadonly) {
                this.wizardModel.skipLicense = false;
                this.wizardModel.requireLicense = true;
                this.wizardModel.enableLicense = false;
            }
            return;
        }
        BDirectory remoteDir = (BDirectory)this.wizardModel.daemonSession.getFileSpace().findFile(SystemFilePaths.getCertificatesDirPath((boolean)true, (boolean)isPerpetual, (boolean)isNiagaraHomeReadonly));
        boolean isLocalPerpetual = SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.PERPETUAL;
        this.wizardModel.localCertificates = this.getCertificates((BDirectory)BFileSystem.INSTANCE.findFile(SystemFilePaths.getCertificatesDirPath((boolean)true, (boolean)isLocalPerpetual, (boolean)NiagaraFiles.isNiagaraHomeReadonly())));
        this.wizardModel.currentCertificates = this.getCertificates(remoteDir);
        this.wizardModel.availableCertVendors = new HashSet<String>();
        this.wizardModel.localCertificates.stream().map(ci -> ci.vendorCertificate.getVendor()).forEach(this.wizardModel.availableCertVendors::add);
        this.wizardModel.currentCertificates.stream().map(ci -> ci.vendorCertificate.getVendor()).forEach(this.wizardModel.availableCertVendors::add);
        boolean anyMissingCerts = false;
        String brand = null;
        for (BINavNode remoteLicense : remoteLicenses) {
            BIFile remoteLicenseFile;
            if (!(remoteLicense instanceof BIFile) || !"license".equalsIgnoreCase((remoteLicenseFile = (BIFile)remoteLicense).getExtension())) continue;
            try {
                LicenseInfo info = new LicenseInfo(remoteLicenseFile);
                if (!hostId.equals(info.vendorLicense.getHostId())) continue;
                if (brand == null) {
                    brand = info.getBrand();
                }
                if (info.vendorLicense.getVendor().equalsIgnoreCase("tridium") && !info.isExpired()) {
                    this.wizardModel.currentLicenseVersion = info.vendorLicense.getVersion();
                }
                this.wizardModel.currentLicenses.add(info);
                if (this.wizardModel.availableCertVendors.contains(info.vendorLicense.getVendor())) continue;
                anyMissingCerts = true;
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Exception occurred while parsing remote license '" + remoteLicenseFile.getFileName() + "'", e);
            }
        }
        if (brand == null && (brandProps = this.wizardModel.daemonSession.getFileSpace().findFile(SystemFilePaths.getBrandPropsPath((boolean)true))) != null) {
            try {
                Properties props = new Properties();
                try (InputStream in = brandProps.getInputStream();){
                    props.load(in);
                    brand = props.getProperty("brand.id", null);
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                if (!this.wizardModel.licenseReadonly) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Exception occurred while determining remote brand, forcing license install", e);
                    }
                    this.wizardModel.skipLicense = false;
                    this.wizardModel.requireLicense = true;
                    this.wizardModel.enableLicense = false;
                }
                throw new BajaRuntimeException((Throwable)e);
            }
        }
        if (!this.wizardModel.licenseReadonly) {
            if (this.wizardModel.currentLicenseVersion == null || anyMissingCerts) {
                this.wizardModel.skipLicense = false;
                this.wizardModel.requireLicense = true;
                this.wizardModel.enableLicense = false;
            } else {
                this.wizardModel.requireLicense = false;
                this.wizardModel.enableLicense = true;
            }
        }
        this.wizardModel.brandId = brand;
    }

    private List<CertificateInfo> getCertificates(BDirectory dir) {
        ArrayList<CertificateInfo> result = new ArrayList<CertificateInfo>();
        if (dir != null) {
            for (BIFile remoteFile : dir.listFiles()) {
                if (remoteFile.getExtension() == null || !remoteFile.getExtension().equals("certificate")) continue;
                try {
                    result.add(new CertificateInfo(remoteFile));
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
        }
        return result;
    }

    private List<LicenseInfo> loadDbLicenses() {
        ArrayList<LicenseInfo> result = new ArrayList<LicenseInfo>();
        String remoteHostId = this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getPerpetualHostId();
        for (VendorLicense lic : LicenseDatabase.LOCAL_INSTANCE.getLicenses(remoteHostId, this.wizardModel.brandId)) {
            result.add(new LicenseInfo(lic, null));
        }
        return result;
    }

    private List<LicenseModel> loadPortalLicenses() {
        if (!this.wizardModel.portalAvailable) {
            return Collections.emptyList();
        }
        String remoteHostId = this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getPerpetualHostId();
        try {
            return PortalLicenseUtil.getExistingLicenses((String)remoteHostId, (String)this.wizardModel.brandId, (Version)Sys.getBajaVersion());
        }
        catch (Exception ex) {
            this.wizardModel.portalAvailable = false;
            return Collections.emptyList();
        }
    }

    private static LicenseSync<LicenseInfo> syncLicenses(CommissioningWizardModel wizardModel, List<LicenseInfo> availableList) {
        String hostId = wizardModel.daemonSession.getHostProperties().getHostIdSettings().getPerpetualHostId();
        LicenseInfo[] current = wizardModel.currentLicenses.toArray(new LicenseInfo[0]);
        LicenseInfo[] toInstall = availableList.toArray(new LicenseInfo[0]);
        return PortalLicenseUtil.syncLicenses((String)hostId, (LicenseInfo[])current, (LicenseInfo[])toInstall);
    }

    private BWidget buildFipsPane(List<LicenseInfo> licenseInfos, List<HostNotFipsReadyItem> notFipsReadyItems) {
        BIndentPane indentPane = new BIndentPane();
        indentPane.add(CommissioningWizardModel.lex.getText("CommissioningWizard.license.fipsNotReady.details"));
        indentPane.add((BWidget)new BBox(0.0, 3.0));
        indentPane.add(CommissioningWizardModel.lex.getText("CommissioningWizard.license.fipsNotReady.licenses"));
        indentPane.indent();
        for (LicenseInfo licenseInfo : licenseInfos) {
            indentPane.add(licenseInfo.getInstalledFileName());
        }
        indentPane.unindent();
        indentPane.add((BWidget)new BBox(0.0, 3.0));
        indentPane.add(CommissioningWizardModel.lex.getText("CommissioningWizard.license.fipsNotReady.items"));
        indentPane.indent();
        for (HostNotFipsReadyItem notFipsReadyItem : notFipsReadyItems) {
            indentPane.add(notFipsReadyItem.getDescriptionWidget());
        }
        return new BBorderPane((BWidget)indentPane, 5.0, 5.0, 5.0, 5.0);
    }

    private class LicenseFileTableModel
    extends TableModel {
        private List<LicenseInfo> items = new ArrayList<LicenseInfo>();
        private CommissioningWizardModel wizardModel;

        public LicenseFileTableModel(CommissioningWizardModel pWizardModel) {
            this.wizardModel = pWizardModel;
        }

        public int getRowCount() {
            return this.items.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseLicenseFile.col.vendor");
                }
                case 1: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseLicenseFile.col.version");
                }
                case 2: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseLicenseFile.col.expiration");
                }
                case 3: {
                    return "";
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            LicenseInfo li = this.getLicenseInfo(row);
            switch (col) {
                case 0: {
                    return li.vendorLicense.getVendor();
                }
                case 1: {
                    return li.vendorLicense.getVersion();
                }
                case 2: {
                    return li.formatExpirationDate(null);
                }
                case 3: {
                    if (this.wizardModel.availableCertVendors.contains(li.vendorLicense.getVendor())) {
                        return "";
                    }
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseLicenseFile.cell.missingCert");
                }
            }
            return null;
        }

        public void load() {
            this.items.clear();
            if (this.wizardModel.getFileLicenseSync() != null) {
                this.items.addAll(this.wizardModel.getFileLicenseSync().toUpdate);
                this.items.addAll(this.wizardModel.getFileLicenseSync().toAdd);
            }
            this.updateTable(true);
        }

        public void save() {
            this.wizardModel.setFileLicenseSync((LicenseSync<LicenseInfo>)LicenseStep.syncLicenses(this.wizardModel, this.items));
        }

        public LicenseInfo add(BIFile file) {
            try {
                LicenseInfo result = this.accept(file);
                if (result != null) {
                    this.items.add(result);
                    LicenseStep.this.chooseFileStep.checkMode();
                    this.updateTable();
                }
                return result;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public void remove(Object o) {
            this.items.remove((LicenseInfo)o);
            this.updateTable();
        }

        private LicenseInfo accept(BIFile file) {
            try {
                String hostId = this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getPerpetualHostId();
                LicenseInfo checkItem = new LicenseInfo(file);
                if (hostId.equals(checkItem.vendorLicense.getHostId())) {
                    if (checkItem.allowsLocalWbAccess()) {
                        for (int i = 0; i < this.items.size(); ++i) {
                            LicenseInfo existingItem = this.getLicenseInfo(i);
                            if (!existingItem.vendorLicense.getVendor().equals(checkItem.vendorLicense.getVendor())) continue;
                            return null;
                        }
                    } else {
                        BDialog.error((BWidget)this.wizardModel.owner, (String)CommissioningWizardModel.lex.getText("LicenseManager.noAccess.title"), (Object)CommissioningWizardModel.lex.getText("LicenseManager.noAccess.message", new Object[]{checkItem.file.getFilePath().getBody()}));
                        return null;
                    }
                    return checkItem;
                }
                BDialog.error((BWidget)this.wizardModel.owner, (String)CommissioningWizardModel.lex.getText("LicenseManager.badHostId.title"), (Object)CommissioningWizardModel.lex.getText("LicenseManager.badHostId.message"));
                return null;
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("platDaemon", "LicenseManager.addLicenseException", (Throwable)e);
            }
        }

        public LicenseInfo getLicenseInfo(int row) {
            return this.items.get(row);
        }
    }

    private class LicenseFileCellRenderer
    extends TableCellRenderer {
        private final BBrush errorForeground;

        public LicenseFileCellRenderer() {
            BLabel styleMe = new BLabel("");
            StyleUtils.addStyleClass((IStylable)styleMe, (String)"error");
            this.errorForeground = Theme.label().getTextBrush((IStylable)styleMe);
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 3) {
                return this.errorForeground;
            }
            return super.getForeground(cell);
        }
    }

    public static class LicenseDialogModel
    extends BFileChooserListView.ListModel {
        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return UiLexicon.bajaui().getText("fileChooser.name");
                }
                case 1: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseLicenseFile.vendorLabel");
                }
                case 2: {
                    return CommissioningWizardStep.LEX.getText("LicenseManager.hostIDLabel");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BIFile file = (BIFile)this.kids[row];
            switch (col) {
                case 0: {
                    return super.getValueAt(row, col);
                }
                case 1: {
                    try {
                        if (file.getExtension() == null || !file.getExtension().equals("license")) {
                            return "";
                        }
                        XElem licenseElem = XParser.make((InputStream)file.getInputStream()).parse(true);
                        return licenseElem.get("vendor", "");
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
                case 2: {
                    try {
                        if (file.getExtension() == null || !file.getExtension().equals("license")) {
                            return "";
                        }
                        XElem licenseElem = XParser.make((InputStream)file.getInputStream()).parse(true);
                        return licenseElem.get("hostId", "");
                    }
                    catch (Exception e) {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private static class LicenseFileFilter
    extends ExtFileFilter {
        private String hostId;

        public LicenseFileFilter(String pHostId) {
            super("TODO", "license");
            this.hostId = pHostId;
        }

        public boolean accept(BIFile file) {
            if (!super.accept(file)) {
                return false;
            }
            try {
                LicenseInfo license = new LicenseInfo(file);
                return this.hostId.equals(license.vendorLicense.getHostId()) && license.allowsLocalWbAccess();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    private class AddLicenseFileCommand
    extends Command {
        private ChooseLicenseFileStep step;

        public AddLicenseFileCommand(BWidget pOwner, ChooseLicenseFileStep pStep) {
            super(pOwner, CommissioningWizardModel.lex.getText("CommissioningWizard.chooseLicenseFile.add"), null, null, null);
            this.step = pStep;
        }

        public CommandArtifact doInvoke() {
            try {
                boolean isPerpetual = this.step.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual();
                boolean isNiagaraHomeReadonly = LicenseStep.this.wizardModel.daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
                BDirectory currentSelection = FavoriteDirectory.loadByPath((String)BLicenseList.TYPE.toString(), (String)"lastLicenseDirBrowsed", (FilePath)SystemFilePaths.getLicensesDirPath((boolean)true, (boolean)isPerpetual, (boolean)isNiagaraHomeReadonly));
                ExtFileFilter licenseFilter = new ExtFileFilter("TODO", "license");
                BIFile[] licenses = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)CommissioningWizardStep.LEX.getText("LicenseManager.importFileDialog.icon")), (String)CommissioningWizardStep.LEX.getText("LicenseManager.importFileDialog.title"), (String)CommissioningWizardStep.LEX.getText("LicenseManager.importFileDialog.message", new Object[]{this.step.wizardModel.daemonSession.getRemoteAddressString()}), (BIFile)currentSelection, (IFileFilter)licenseFilter, (IFileFilter)new LicenseFileFilter(this.step.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getPerpetualHostId()), (BFileChooserListView.ListModel)new LicenseDialogModel());
                FilePath savePath = null;
                if (licenses != null) {
                    for (BIFile license : licenses) {
                        savePath = license.getFilePath().getParent();
                        this.step.tableModel.add(license);
                        this.step.checkMode();
                        this.step.tableModel.updateTable(true);
                    }
                }
                if (savePath != null) {
                    FavoriteDirectory.savePath((String)BLicenseList.TYPE.toString(), (String)"lastLicenseDirBrowsed", savePath);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class AddCertificateFileCommand
    extends Command {
        private Runnable updateModel;

        public AddCertificateFileCommand(BWidget pOwner, Runnable pUpdateModel) {
            super(pOwner, CommissioningWizardModel.lex.getText("CommissioningWizard.chooseLicenseFile.addCert"), null, null, null);
            this.updateModel = pUpdateModel;
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory currentSelection = FavoriteDirectory.loadByPath((String)"commissioning", (String)"lastCertDirBrowsed", (FilePath)new FilePath("~"));
                ExtFileFilter certFilter = new ExtFileFilter("TODO", "certificate");
                BIFile[] certFiles = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)CommissioningWizardStep.LEX.getText("LicenseManager.importFileDialog.icon")), (String)CommissioningWizardStep.LEX.getText("LicenseManager.importFileDialog.title"), (String)CommissioningWizardStep.LEX.getText("LicenseManager.importFileDialog.message", new Object[]{LicenseStep.this.wizardModel.daemonSession.getRemoteAddressString()}), (BIFile)currentSelection, (IFileFilter)certFilter, (IFileFilter)certFilter);
                FilePath savePath = null;
                if (certFiles != null) {
                    boolean isPerpetual = LicenseStep.this.wizardModel.daemonSession.getHostProperties().getHostIdSettings().getHostIdStatus().isPerpetual();
                    boolean isNiagaraHomeReadonly = LicenseStep.this.wizardModel.daemonSession.getHostProperties().getIsNiagaraHomeReadonly();
                    boolean anyAdded = false;
                    for (BIFile certFile : certFiles) {
                        savePath = certFile.getFilePath().getParent();
                        CertificateInfo maybeAdd = new CertificateInfo(certFile);
                        if (LicenseStep.this.wizardModel.availableCertVendors.contains(maybeAdd.vendorCertificate.getVendor())) continue;
                        BIFile newCopy = BFileSystem.INSTANCE.makeFile(maybeAdd.getInstalledFilePath(true, isPerpetual, isNiagaraHomeReadonly));
                        try (BufferedInputStream in = new BufferedInputStream(certFile.getInputStream());
                             BufferedOutputStream out = new BufferedOutputStream(newCopy.getOutputStream());){
                            FileUtil.pipe((InputStream)in, (OutputStream)out);
                            LicenseStep.this.wizardModel.availableCertVendors.add(maybeAdd.vendorCertificate.getVendor());
                            LicenseStep.this.wizardModel.localCertificates.add(maybeAdd);
                            anyAdded = true;
                        }
                    }
                    if (anyAdded) {
                        this.updateModel.run();
                    }
                }
                if (savePath != null) {
                    FavoriteDirectory.savePath((String)"commissioning", (String)"lastCertDirBrowsed", savePath);
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class RemoveLicenseCommand
    extends Command {
        private ChooseLicenseFileStep step;

        public RemoveLicenseCommand(BWidget pOwner, ChooseLicenseFileStep pStep) {
            super(pOwner, CommissioningWizardModel.lex.getText("CommissioningWizard.chooseLicenseFile.remove"), null, null, null);
            this.step = pStep;
        }

        public CommandArtifact doInvoke() {
            try {
                int[] rows = this.step.tableModel.getTable().getSelection().getRows();
                if (rows == null) {
                    return null;
                }
                Object[] objects = new Object[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    objects[i] = this.step.tableModel.getLicenseInfo(rows[i]);
                }
                for (Object object : objects) {
                    this.step.tableModel.remove(object);
                    this.step.checkMode();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (Throwable)t);
            }
            return null;
        }
    }

    private class ChooseLicenseFileStep
    extends CommissioningWizardStep {
        private LicenseFileTableModel tableModel;
        private BLabel noTridiumLicenseLabel;
        private AddCertificateFileCommand addCert;
        private int mode;

        public ChooseLicenseFileStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
            this.mode = 1;
            this.tableModel = new LicenseFileTableModel(wizardModel);
            BTable table = new BTable((TableModel)this.tableModel);
            table.setCellRenderer((TableCellRenderer)new LicenseFileCellRenderer());
            BButtonPane buttons = new BButtonPane();
            CommandBindings bindings = new CommandBindings();
            Command c = new AddLicenseFileCommand(wizardModel.owner, this);
            bindings.addCommand(c, BCommandEnablePolicy.always);
            buttons.add(c);
            this.addCert = new AddCertificateFileCommand(wizardModel.owner, this::checkMode);
            buttons.add((Command)this.addCert);
            c = new RemoveLicenseCommand(wizardModel.owner, this);
            bindings.addCommand(c, BCommandEnablePolicy.anySelection);
            buttons.add(c);
            table.setController((TableController)new CommandBindings.TableController(bindings));
            table.setSelection((TableSelection)new CommandBindings.TableSelection(bindings));
            BIndentPane header = new BIndentPane();
            header.add(LEX.getText("CommissioningWizard.chooseLicenseFile.header"));
            BGridPane footer = new BGridPane(1);
            footer.setValign(BValign.top);
            footer.setHalign(BHalign.center);
            footer.setColumnAlign(BHalign.center);
            footer.setStretchColumn(0);
            this.noTridiumLicenseLabel = new BLabel(LEX.getText("CommissioningWizard.chooseLicenseFile.noTridiumLicense"), BHalign.left);
            StyleUtils.addStyleClass((IStylable)this.noTridiumLicenseLabel, (String)"warning");
            footer.add(null, (BValue)this.noTridiumLicenseLabel);
            footer.add(null, (BValue)buttons);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)header, 0.0, 0.0, 4.0, 0.0), (BWidget)new BBorderPane((BWidget)footer, 5.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)table, BBorder.inset, BInsets.DEFAULT)));
        }

        @Override
        public String getStepName() {
            return "chooseLicenseFile";
        }

        @Override
        public String getSectionName() {
            return "license";
        }

        @Override
        public void enter() {
            this.tableModel.load();
            this.checkMode();
        }

        @Override
        public boolean exit(int direction) {
            this.tableModel.save();
            LicenseStep.this.updateCertsToInstall();
            return true;
        }

        @Override
        public int getMode() {
            return this.mode;
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.skipLicense || this.wizardModel.getLicenseSelection() != LicenseStep.this.installFileCommand;
        }

        private void setMode(int value) {
            if (this.mode != value) {
                this.mode = value;
                if (this.wizardModel.getCurrentStep() == this) {
                    this.wizardModel.update(this.mode);
                }
            }
        }

        public void checkMode() {
            int m = 1;
            boolean tridiumLicenseFound = this.wizardModel.currentLicenseVersion != null;
            HashSet<String> missingCerts = new HashSet<String>();
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                missingCerts.add(this.tableModel.getLicenseInfo((int)i).vendorLicense.getVendor());
                if (!this.tableModel.getLicenseInfo((int)i).vendorLicense.getVendor().equalsIgnoreCase("tridium")) continue;
                tridiumLicenseFound = true;
            }
            this.noTridiumLicenseLabel.setVisible(!tridiumLicenseFound);
            missingCerts.removeAll(this.wizardModel.availableCertVendors);
            if (missingCerts.size() == 0) {
                this.addCert.setEnabled(false);
                if (tridiumLicenseFound) {
                    m |= 2;
                }
            } else {
                this.addCert.setEnabled(true);
            }
            this.tableModel.updateTable();
            this.setMode(m);
        }
    }

    public class DeviceRegistrationStep
    extends CommissioningWizardStep {
        private final BIcon warnIcon;
        private int mode;
        private BTextField subscriptionKey;
        private boolean isRegistrationSuccessful;

        public DeviceRegistrationStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
            this.warnIcon = BIcon.std((String)"warning.png");
            this.mode = 3;
        }

        @Override
        public String getStepName() {
            return "deviceRegistrationStep";
        }

        @Override
        public String getSectionName() {
            return "license";
        }

        @Override
        public boolean isSkipped() {
            return this.wizardModel.getLicenseSelection() != LicenseStep.this.installSubscriptionCommand;
        }

        @Override
        public int getMode() {
            return this.mode;
        }

        private void setMode(int value) {
            if (this.mode != value) {
                this.mode = value;
                if (this.wizardModel.getCurrentStep() == this) {
                    this.wizardModel.update(this.mode);
                }
            }
        }

        @Override
        public void enter() {
            if (this.isRegistrationSuccessful) {
                this.setContent(this.buildSuccessStep());
                return;
            }
            DeviceCodeApi deviceCodeApi = new DeviceCodeApi();
            EntitlementApi.EntitlementStatus deviceCodeStatus = deviceCodeApi.getDeviceCode();
            if (deviceCodeStatus == null || deviceCodeStatus.getUserCode() == null || deviceCodeStatus.getVerificationUri() == null || deviceCodeStatus.getDeviceCode() == null) {
                this.setContent(this.buildFailureStep());
                return;
            }
            this.setContent(this.buildUserCodeStep(deviceCodeStatus.getUserCode(), deviceCodeStatus.getVerificationUri()));
            AccessTokenApi.Poll.start((String)deviceCodeStatus.getDeviceCode(), (int)deviceCodeStatus.getInterval());
        }

        public BWidget buildUserCodeStep(String userCode, String url) {
            BIndentPane header = new BIndentPane();
            BLabel keyHeader = new BLabel(LEX.getText("CommissioningWizard.deviceRegistrationStep.subscriptionKey.header"));
            keyHeader.setFont(Theme.label().getBoldText());
            header.add(null, (BValue)keyHeader);
            BLabel keyLabel = new BLabel(LEX.getText("CommissioningWizard.deviceRegistrationStep.subscriptionKey.label"));
            keyLabel.setFont(Theme.gridPane().getBoldText());
            BGridPane headerGrid = new BGridPane(2);
            headerGrid.add(null, (BValue)keyLabel);
            this.subscriptionKey = new BTextField();
            headerGrid.add(null, (BValue)this.subscriptionKey);
            header.add(null, (BValue)headerGrid);
            BIndentPane content = new BIndentPane();
            BLabel urlLab = new BLabel(LEX.getText("CommissioningWizard.deviceRegistrationStep.VerificationURL.label"));
            urlLab.setFont(Theme.gridPane().getBoldText());
            BBorderPane urlLabel = new BBorderPane((BWidget)urlLab, 0.0, 6.0, 0.0, 0.0);
            BLabel codeLabel = new BLabel(LEX.getText("CommissioningWizard.deviceRegistrationStep.code.label"));
            codeLabel.setFont(Theme.gridPane().getBoldText());
            BGridPane gridPane = new BGridPane(2);
            gridPane.setRowGap(4.0);
            gridPane.add(null, (BValue)urlLabel);
            gridPane.add(null, (BValue)new BUrlTextField(url, 60));
            gridPane.add(null, (BValue)codeLabel);
            gridPane.add(null, (BValue)new BTextField(userCode, 60, false));
            content.add(null, (BValue)gridPane);
            BIndentPane footer = new BIndentPane();
            BLabel label = new BLabel(LEX.getText("CommissioningWizard.deviceRegistrationStep.instructions.header"));
            label.setFont(Theme.label().getBoldText());
            footer.add(null, (BValue)label);
            BLabel instructions = new BLabel(LEX.getText("CommissioningWizard.deviceRegistrationStep.instructions"));
            instructions.setHalign(BHalign.left);
            footer.add(null, (BValue)instructions);
            return new BEdgePane((BWidget)new BBorderPane((BWidget)header, 5.0, 0.0, 0.0, 0.0), (BWidget)new BBorderPane((BWidget)footer, 0.0, 0.0, 5.0, 0.0), (BWidget)new BBorderPane((BWidget)content, 10.0, 0.0, 0.0, 0.0), null, null);
        }

        public BWidget buildSuccessStep() {
            BIndentPane content = new BIndentPane();
            BLabel heading = new BLabel(LEX.getText("CommissioningWizard.deviceRegistrationStep.success.heading"));
            heading.setFont(Theme.gridPane().getBoldText());
            content.add((BWidget)heading);
            content.indent();
            content.add(LEX.getText("CommissioningWizard.deviceRegistrationStep.success.status"));
            content.add(LEX.getText("CommissioningWizard.deviceRegistrationStep.success.licenseKey", new Object[]{this.wizardModel.getLicenseKey()}));
            content.add(LEX.getText("CommissioningWizard.deviceRegistrationStep.success.hostId", new Object[]{this.wizardModel.getRemoteDeviceNreId()}));
            content.add(LEX.getText("CommissioningWizard.deviceRegistrationStep.success.modelName", new Object[]{this.wizardModel.daemonSession.getHostProperties().getModelName()}));
            content.add(LEX.getText("CommissioningWizard.deviceRegistrationStep.success.productName", new Object[]{this.wizardModel.daemonSession.getHostProperties().getProductName()}));
            return new BBorderPane((BWidget)content);
        }

        public BWidget buildFailureStep() {
            this.setMode(0);
            BIndentPane content = new BIndentPane();
            BLabel errorLabel = new BLabel(BImage.make((BIcon)this.warnIcon), LEX.getText("CommissioningWizard.deviceRegistrationStep.failure.message"));
            content.add((BWidget)errorLabel);
            return new BBorderPane((BWidget)content);
        }

        private boolean registerDevice() {
            RegistrationApi api = new RegistrationApi();
            String nreId = SubscriptionLicenseUtil.generateNreIdForRemoteDevice((String)this.subscriptionKey.getText());
            this.wizardModel.setRemoteDeviceNreId(nreId);
            this.wizardModel.setLicenseKey(this.subscriptionKey.getText());
            EntitlementApi.EntitlementStatus registrationStatus = api.registerRemoteDevice(AccessTokenApi.getAccessTokenPollStatus(), this.subscriptionKey.getText(), nreId, this.wizardModel.daemonSession.getHostProperties().getModelName(), this.wizardModel.daemonSession.getHostProperties().getProductName());
            if (!registrationStatus.isSuccess()) {
                this.setContent(this.buildFailureStep());
            } else if (!this.isRegistrationSuccessful) {
                BDialog.info((BWidget)this.getWidget(), (Object)LEX.getText("CommissioningWizard.deviceRegistrationStep.success.message"));
            }
            return registrationStatus.isSuccess();
        }

        @Override
        public boolean cancel() {
            AccessTokenApi.Poll.stop();
            return super.cancel();
        }

        @Override
        public boolean checkBack() {
            boolean checkBack = super.checkBack();
            if (checkBack) {
                AccessTokenApi.Poll.stop();
            }
            return checkBack;
        }

        @Override
        public boolean checkNext() {
            if (!SubscriptionLicenseUtil.isKeyValid((String)this.subscriptionKey.getText())) {
                BDialog.error((BWidget)this.getWidget(), (Object)LEX.getText("CommissioningWizard.deviceRegistrationStep.subscriptionKey.Invalid.message"));
                return false;
            }
            if (AccessTokenApi.isAccessTokenPollComplete()) {
                if (AccessTokenApi.getAccessTokenPollStatus().isSuccess()) {
                    this.isRegistrationSuccessful = this.registerDevice();
                    return this.isRegistrationSuccessful;
                }
                this.setContent(this.buildFailureStep());
                return false;
            }
            BDialog.info((BWidget)this.getWidget(), (Object)LEX.getText("CommissioningWizard.deviceRegistrationStep.pendingApproval.message"));
            return false;
        }
    }

    private class MissingCertTableModel
    extends TableModel {
        List<String> missingCerts = new ArrayList<String>();

        private MissingCertTableModel() {
        }

        public boolean hasMissingCerts() {
            return !LicenseStep.this.wizardModel.availableCertVendors.containsAll(this.missingCerts);
        }

        public void reload() {
            this.missingCerts.clear();
            Set<String> asSet = LicenseStep.this.getMissingCerts();
            asSet.removeAll(LicenseStep.this.wizardModel.availableCertVendors);
            this.missingCerts.addAll(asSet);
            this.updateTable(true);
        }

        public int getRowCount() {
            return this.missingCerts.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseCertFile.vendor");
                }
                case 1: {
                    return CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseCertFile.status");
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.missingCerts.get(row);
                }
                case 1: {
                    return LicenseStep.this.wizardModel.availableCertVendors.contains(this.missingCerts.get(row)) ? CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseCertFile.available") : CommissioningWizardStep.LEX.getText("CommissioningWizard.chooseCertFile.missing");
                }
            }
            return null;
        }
    }

    private class MissingCertTableRenderer
    extends TableCellRenderer {
        private final BBrush errorForeground;

        public MissingCertTableRenderer() {
            BLabel styleMe = new BLabel("");
            StyleUtils.addStyleClass((IStylable)styleMe, (String)"error");
            this.errorForeground = Theme.label().getTextBrush((IStylable)styleMe);
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            if (cell.column == 1 && !LicenseStep.this.wizardModel.availableCertVendors.contains(((MissingCertTableModel)this.getTable().getModel()).missingCerts.get(cell.row))) {
                return this.errorForeground;
            }
            return super.getForeground(cell);
        }
    }

    private class ChooseCertificateFileStep
    extends CommissioningWizardStep {
        private LicenseSync<LicenseInfo> lastLicenseSync;
        private MissingCertTableModel tableModel;
        private int mode;
        private Command addCert;

        public ChooseCertificateFileStep(CommissioningWizardModel wizardModel) {
            super(wizardModel);
            this.lastLicenseSync = null;
            this.mode = 1;
            BFlowPane header = new BFlowPane(BHalign.left);
            header.add(null, (BValue)new BLabel(LEX.getText("CommissioningWizard.chooseCertFile.header"), BHalign.left));
            this.tableModel = new MissingCertTableModel();
            BTable table = new BTable((TableModel)this.tableModel);
            table.setCellRenderer((TableCellRenderer)new MissingCertTableRenderer());
            BButtonPane buttons = new BButtonPane();
            this.addCert = new AddCertificateFileCommand(wizardModel.owner, this::checkMode);
            buttons.add(this.addCert);
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)header, 0.0, 0.0, 4.0, 0.0), (BWidget)new BBorderPane((BWidget)buttons, 5.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)table, BBorder.inset, BInsets.DEFAULT)));
        }

        @Override
        public String getStepName() {
            return "chooseCertFile";
        }

        @Override
        public String getSectionName() {
            return "license";
        }

        @Override
        public void enter() {
            this.checkMode();
        }

        @Override
        public boolean exit(int direction) {
            Set<String> missingCerts = LicenseStep.this.getMissingCerts();
            this.wizardModel.certificatesToInstall.clear();
            this.wizardModel.certificatesToInstall.addAll(this.wizardModel.localCertificates.stream().filter(localCert -> missingCerts.contains(localCert.vendorCertificate.getVendor())).collect(Collectors.toList()));
            return true;
        }

        private void setMode(int value) {
            if (this.mode != value) {
                this.mode = value;
                if (this.wizardModel.getCurrentStep() == this) {
                    this.wizardModel.update(this.mode);
                }
            }
        }

        public void checkMode() {
            int m = 1;
            if (this.tableModel.hasMissingCerts()) {
                this.addCert.setEnabled(true);
            } else {
                this.addCert.setEnabled(false);
                m |= 2;
            }
            this.tableModel.updateTable();
            this.setMode(m);
        }

        @Override
        public int getMode() {
            this.initStep();
            return this.mode;
        }

        @Override
        public boolean isSkipped() {
            if (this.wizardModel.portalAvailable && !(this.wizardModel.getLicenseSelection() instanceof InstallFileCommand)) {
                return true;
            }
            this.initStep();
            return !this.tableModel.hasMissingCerts();
        }

        private void initStep() {
            if (!this.wizardModel.getLicenseSelection().getLicenseSync().matches(this.lastLicenseSync)) {
                this.tableModel.reload();
                this.lastLicenseSync = this.wizardModel.getLicenseSelection().getLicenseSync().newCopy();
            }
        }
    }

    private class InstallSubscriptionCommand
    extends ToggleCommand
    implements LicenseSelection {
        public InstallSubscriptionCommand() {
            super(LicenseStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.license.installSubscription"), null, null, null);
        }

        @Override
        public LicenseSync<LicenseInfo> getLicenseSync() {
            return LicenseSync.noChanges();
        }

        @Override
        public String getReviewHeader() {
            return CommissioningWizardStep.LEX.getText("CommissioningWizard.license.installSubscription");
        }

        @Override
        public LicenseMode getSelectedLicenseMode() {
            return LicenseMode.SUBSCRIPTION;
        }
    }

    private class InstallDbCommand
    extends ToggleCommand
    implements LicenseSelection {
        private LicenseSync<LicenseInfo> sync;

        public InstallDbCommand(LicenseSync<LicenseInfo> sync) {
            super(LicenseStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.license.installDb"), null, null, null);
            this.sync = sync;
        }

        @Override
        public LicenseSync<LicenseInfo> getLicenseSync() {
            return this.sync;
        }

        @Override
        public String getReviewHeader() {
            return this.getLabel();
        }

        @Override
        public LicenseMode getSelectedLicenseMode() {
            return LicenseMode.PERPETUAL;
        }
    }

    private class InstallOnlineCommand
    extends ToggleCommand
    implements LicenseSelection {
        private LicenseSync<LicenseInfo> sync;

        public InstallOnlineCommand(LicenseModel model, LicenseSync<LicenseInfo> sync) {
            super(LicenseStep.this.wizardModel.owner, model.hasDescription() ? CommissioningWizardStep.LEX.getText("CommissioningWizard.license.installOnlineModel", new Object[]{model.toString()}) : CommissioningWizardStep.LEX.getText("CommissioningWizard.license.installOnline"), null, null, null);
            this.sync = sync;
        }

        @Override
        public LicenseSync<LicenseInfo> getLicenseSync() {
            return this.sync;
        }

        @Override
        public String getReviewHeader() {
            return this.getLabel();
        }

        @Override
        public boolean showNoChangesDetailsInReview() {
            return true;
        }

        @Override
        public LicenseMode getSelectedLicenseMode() {
            return LicenseMode.PERPETUAL;
        }
    }

    private class InstallFileCommand
    extends ToggleCommand
    implements LicenseSelection {
        public InstallFileCommand() {
            super(LicenseStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.license.installFile"), null, null, null);
        }

        @Override
        public LicenseSync<LicenseInfo> getLicenseSync() {
            return LicenseStep.this.wizardModel.getFileLicenseSync();
        }

        @Override
        public String getReviewHeader() {
            return CommissioningWizardStep.LEX.getText("CommissioningWizard.license.installFile");
        }

        @Override
        public LicenseMode getSelectedLicenseMode() {
            return LicenseMode.PERPETUAL;
        }
    }

    private class NoInstallCommand
    extends ToggleCommand
    implements LicenseSelection {
        public NoInstallCommand() {
            super(LicenseStep.this.wizardModel.owner, CommissioningWizardStep.LEX.getText("CommissioningWizard.license.noInstall"), null, null, null);
        }

        @Override
        public LicenseSync<LicenseInfo> getLicenseSync() {
            return LicenseSync.noChanges();
        }

        @Override
        public LicenseMode getSelectedLicenseMode() {
            return null;
        }

        @Override
        public String getReviewHeader() {
            return CommissioningWizardStep.LEX.getText("CommissioningWizard.review.nochange");
        }
    }
}

