/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.install.BDaemonPlatform;
import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platDaemon.ConfigDetails;
import com.tridium.platDaemon.ui.BConsoleSelection;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.console.BApplicationDirector;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BStationSurrogate;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.view.BIWbViewExporter;

@NiagaraType(agent={@AgentOn(types={"platDaemon:PlatformAdministration"})})
@NiagaraProperties(value={@NiagaraProperty(name="showPlatformDetails", type="boolean", defaultValue="true"), @NiagaraProperty(name="daemonOutputSelection", type="BConsoleSelection", defaultValue="BConsoleSelection.doNotDisplay"), @NiagaraProperty(name="daemonOutputLimit", type="int", defaultValue="4096"), @NiagaraProperty(name="appOutputSelection", type="BConsoleSelection", defaultValue="BConsoleSelection.doNotDisplay"), @NiagaraProperty(name="requestStationThreadDump", type="boolean", defaultValue="false"), @NiagaraProperty(name="appOutputLimit", type="int", defaultValue="4096")})
public class BPlatformTextSummary
extends BExporter
implements BIWbViewExporter {
    @Generated
    public static final Property showPlatformDetails = BPlatformTextSummary.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property daemonOutputSelection = BPlatformTextSummary.newProperty((int)0, (BValue)BConsoleSelection.doNotDisplay, null);
    @Generated
    public static final Property daemonOutputLimit = BPlatformTextSummary.newProperty((int)0, (int)4096, null);
    @Generated
    public static final Property appOutputSelection = BPlatformTextSummary.newProperty((int)0, (BValue)BConsoleSelection.doNotDisplay, null);
    @Generated
    public static final Property requestStationThreadDump = BPlatformTextSummary.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property appOutputLimit = BPlatformTextSummary.newProperty((int)0, (int)4096, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatformTextSummary.class);

    @Generated
    public boolean getShowPlatformDetails() {
        return this.getBoolean(showPlatformDetails);
    }

    @Generated
    public void setShowPlatformDetails(boolean v) {
        this.setBoolean(showPlatformDetails, v, null);
    }

    @Generated
    public BConsoleSelection getDaemonOutputSelection() {
        return (BConsoleSelection)this.get(daemonOutputSelection);
    }

    @Generated
    public void setDaemonOutputSelection(BConsoleSelection v) {
        this.set(daemonOutputSelection, (BValue)v, null);
    }

    @Generated
    public int getDaemonOutputLimit() {
        return this.getInt(daemonOutputLimit);
    }

    @Generated
    public void setDaemonOutputLimit(int v) {
        this.setInt(daemonOutputLimit, v, null);
    }

    @Generated
    public BConsoleSelection getAppOutputSelection() {
        return (BConsoleSelection)this.get(appOutputSelection);
    }

    @Generated
    public void setAppOutputSelection(BConsoleSelection v) {
        this.set(appOutputSelection, (BValue)v, null);
    }

    @Generated
    public boolean getRequestStationThreadDump() {
        return this.getBoolean(requestStationThreadDump);
    }

    @Generated
    public void setRequestStationThreadDump(boolean v) {
        this.setBoolean(requestStationThreadDump, v, null);
    }

    @Generated
    public int getAppOutputLimit() {
        return this.getInt(appOutputLimit);
    }

    @Generated
    public void setAppOutputLimit(int v) {
        this.setInt(appOutputLimit, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BTextFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "txt";
    }

    public void export(ExportOp op) throws Exception {
        BAppSurrogate surrogate;
        String header;
        PrintWriter out = new PrintWriter(op.getOutputStream());
        BDaemonSessionView view = (BDaemonSessionView)op.get();
        if (this.getShowPlatformDetails()) {
            ConfigDetails.printDetails((BDaemonPlatform)view.getDaemonPlatform(), (BAppSurrogate[])view.getAppSurrogates(), (PrintWriter)out);
        }
        if (this.getDaemonOutputSelection() != BConsoleSelection.doNotDisplay) {
            out.println();
            header = this.getLexicon().getText("PlatformTextSummary.daemonOutputHeader");
            out.println(header);
            out.println(BPlatformTextSummary.getDashes(header));
            try (Reader daemonConsoleOutputReader = this.getDaemonConsoleOutput(view);){
                this.sendConsoleOutput(out, daemonConsoleOutputReader, this.getDaemonOutputSelection(), this.getDaemonOutputLimit());
            }
            out.println();
            out.println(BPlatformTextSummary.getDashes(header));
        }
        if (this.getAppOutputSelection() != BConsoleSelection.doNotDisplay && (surrogate = this.getSelectedAppSurrogate(view)) != null) {
            if (surrogate instanceof BStationSurrogate && this.getRequestStationThreadDump()) {
                ((BStationSurrogate)surrogate).dumpThreads();
                Thread.sleep(1000L);
            }
            out.println();
            header = this.getLexicon().getText("PlatformTextSummary.appOutputHeader", new Object[]{surrogate.toString((Context)op)});
            out.println(header);
            out.println(BPlatformTextSummary.getDashes(header));
            try (Reader appConsoleOutputReader = this.getAppConsoleOutput(view, surrogate);){
                this.sendConsoleOutput(out, appConsoleOutputReader, this.getAppOutputSelection(), this.getAppOutputLimit());
            }
            out.println();
            out.println(BPlatformTextSummary.getDashes(header));
        }
        out.flush();
    }

    protected void sendConsoleOutput(PrintWriter exportOut, Reader consoleIn, BConsoleSelection selection, int limit) throws Exception {
        if (selection == BConsoleSelection.doNotDisplay) {
            return;
        }
        if (selection == BConsoleSelection.allContents) {
            this.pipe(consoleIn, exportOut);
        } else {
            StringWriter temp = new StringWriter();
            this.pipe(consoleIn, temp);
            temp.flush();
            String truncated = temp.toString();
            if (selection == BConsoleSelection.lastNBytes) {
                if (limit <= 0) {
                    throw new IllegalArgumentException();
                }
                if (truncated.length() > limit) {
                    truncated = truncated.substring(truncated.length() - limit);
                }
            } else {
                int idx = truncated.lastIndexOf("Full thread dump");
                if (idx > 0) {
                    truncated = truncated.substring(idx);
                }
            }
            try (StringReader reader = new StringReader(truncated);){
                this.pipe(reader, exportOut);
            }
        }
    }

    protected void pipe(Reader in, Writer out) throws IOException {
        char[] buf = new char[1024];
        try {
            int numRead;
            while ((numRead = in.read(buf, 0, 1024)) >= 0) {
                if (numRead <= 0) continue;
                out.write(buf, 0, numRead);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private static String getDashes(String textToUnderline) {
        if (textToUnderline == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < textToUnderline.length(); ++i) {
            result.append('-');
        }
        return result.toString();
    }

    protected BAppSurrogate getSelectedAppSurrogate(BDaemonSessionView view) {
        if (view instanceof BApplicationDirector) {
            return ((BApplicationDirector)view).getSelectedAppSurrogate();
        }
        BAppSurrogate[] surrogates = view.getAppSurrogates();
        if (surrogates == null || surrogates.length == 0) {
            return null;
        }
        for (int i = 0; i < surrogates.length; ++i) {
            if (!surrogates[i].isAppRunning()) continue;
            return surrogates[i];
        }
        return surrogates[0];
    }

    protected Reader getAppConsoleOutput(BDaemonSessionView view, BAppSurrogate surrogate) throws ConnectException, AuthenticationException {
        return new InputStreamReader(surrogate.getAppOutput(false));
    }

    protected Reader getDaemonConsoleOutput(BDaemonSessionView view) throws ConnectException, AuthenticationException {
        return new InputStreamReader(new BDaemonSurrogate(view.getDaemonSession()).getDaemonOutput(false, false));
    }
}

