/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.DaemonNavListModel;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.IDaemonSessionView;
import com.tridium.platform.BSessionNavNode;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.bookmark.BookmarkUtil;
import com.tridium.workbench.shell.BViewTab;
import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.list.ListModel;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleDaemonDropDownModified", flags=4), @NiagaraAction(name="handleHostPropertiesChanged", flags=4), @NiagaraAction(name="refresh", flags=20)})
public abstract class BDaemonSessionView
extends BWbComponentView
implements IDaemonSessionView {
    @Generated
    public static final Action handleDaemonDropDownModified = BDaemonSessionView.newAction((int)4, null);
    @Generated
    public static final Action handleHostPropertiesChanged = BDaemonSessionView.newAction((int)4, null);
    @Generated
    public static final Action refresh = BDaemonSessionView.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDaemonSessionView.class);
    protected boolean loading = false;
    private BDaemonSession session;
    private ValueLoader loader = null;
    private boolean canceled = false;
    private SessionSurrogates surrogates;
    private Clock.Ticket refreshTicket = null;
    private final DaemonSessionTaskHandler sessionTaskHandler;
    private final BToolBar toolBar;
    private final SessionHomeCommand sessionHomeCommand;
    private final BListDropDown daemonDropDown;
    private final DaemonNavListModel daemonDropDownModel;
    private final Queue refreshQueue = new CoalesceQueue(10);
    private Worker refreshWorker = null;
    public static final Logger log = Logger.getLogger("platDaemon");
    public static final Lexicon lexicon = Lexicon.make((String)"platDaemon");
    private static final long REFRESH_MILLIS = 5000L;
    private static final int MAX_REFRESH_QUEUE_SIZE = 10;
    private static final String BLOCK_UNTIL_LOADED_STRING = "blockUntilLoaded";
    protected static final Context BLOCK_UNTIL_LOADED_CX = BFacets.make((String)"blockUntilLoaded", (String)"true");

    @Generated
    public void handleDaemonDropDownModified() {
        this.invoke(handleDaemonDropDownModified, null, null);
    }

    @Generated
    public void handleHostPropertiesChanged() {
        this.invoke(handleHostPropertiesChanged, null, null);
    }

    @Generated
    public void refresh() {
        this.invoke(refresh, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDaemonSessionView() {
        this.toolBar = new BToolBar();
        this.daemonDropDown = new BListDropDown();
        this.toolBar.add(null, (BValue)this.daemonDropDown);
        this.sessionHomeCommand = new SessionHomeCommand((BWidget)this.toolBar);
        this.toolBar.add("sessionHome", (Command)this.sessionHomeCommand);
        this.daemonDropDownModel = new DaemonNavListModel();
        this.daemonDropDown.getList().setModel((ListModel)this.daemonDropDownModel);
        this.linkTo("daemonDropDownModified", (BComponent)this.daemonDropDown, (Slot)BDropDown.valueModified, (Slot)handleDaemonDropDownModified);
        this.sessionTaskHandler = new DaemonSessionTaskHandler((BWidget)this);
    }

    protected final void doLoadValue(BObject value, Context cx) throws Exception {
        this.canceled = false;
        if (value instanceof BDaemonSession) {
            this.session = (BDaemonSession)value;
        } else {
            BSessionNavNode node = (BSessionNavNode)value;
            this.session = (BDaemonSession)node.getNavSession();
        }
        this.surrogates = new SessionSurrogates(this.session);
        this.linkTo(null, (BComponent)this.session.getHostProperties(), (Slot)BHostProperties.hostPropertiesChanged, (Slot)handleHostPropertiesChanged);
        this.loading = true;
        this.daemonDropDown.setSelectedItem((Object)this.session.getRemoteAddressString());
        this.sessionHomeCommand.setSession(this.session);
        if (this.loader != null && this.loader.isAlive()) {
            this.loader.interrupt();
        }
        this.loader = new ValueLoader(cx);
        if (cx != null && cx.getFacet(BLOCK_UNTIL_LOADED_STRING) != null) {
            this.loader.run();
        } else {
            this.loader.start();
        }
    }

    public BToolBar getViewToolBar() {
        return this.toolBar;
    }

    public void deactivated() {
        super.deactivated();
        this.canceled = true;
        if (this.loader != null && this.loader.isAlive()) {
            this.loader.interrupt();
        }
    }

    @Override
    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    @Override
    public BAppSurrogate[] getAppSurrogates() throws AuthenticationException {
        try {
            return this.getAppSurrogatesWithExceptions();
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public BDaemonPlatform getDaemonPlatform() throws AuthenticationException, ConnectException {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.getDaemonSession(), (DaemonSessionTaskListener)this);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    protected boolean isViewLoading() {
        return this.loading;
    }

    public BDaemonSurrogate getDaemonSurrogate(boolean load) throws AuthenticationException {
        try {
            return this.surrogates.getDaemonSurrogate(load);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public BVector getAppSurrogateVector(boolean load) throws AuthenticationException {
        try {
            return this.surrogates.getVector(load);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public boolean areAppsRunning() throws AuthenticationException {
        try {
            return this.surrogates.areAppsRunning();
        }
        catch (ConnectException connectException) {
            return false;
        }
    }

    public BAppSurrogate[] getAppSurrogatesWithExceptions() throws ConnectException, AuthenticationException {
        return this.surrogates.getAll();
    }

    public BStationSurrogate getStationSurrogate(String name, boolean forceLoad) throws AuthenticationException {
        try {
            return (BStationSurrogate)this.surrogates.get(BStationSurrogate.TYPE, name, forceLoad);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public void resetAppSurrogates() throws AuthenticationException {
        try {
            this.surrogates.reset();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void resetCanceled() {
        this.canceled = false;
    }

    public void cancel() {
        this.canceled = true;
    }

    protected void promptForReboot(boolean optional) {
        block5: {
            if (optional && !this.session.usesLocalNiagaraHome() && 4 != BDialog.confirm((BWidget)this, (String)lexicon.getText("DaemonSessionView.reboot.promptTitle", new Object[]{this.session.getRemoteAddressString()}), (Object)lexicon.getText("DaemonSessionView.reboot.promptMessage", new Object[]{this.session.getRemoteAddressString()}), (int)12)) {
                return;
            }
            if (this.session.usesLocalNiagaraHome()) {
                BDialog.message((BWidget)this, (String)lexicon.getText("DaemonSessionView.rebootLocal.title"), (Object)lexicon.getText("DaemonSessionView.rebootLocal.message"));
                return;
            }
            try {
                BWidgetShell shell = this.getShell();
                this.session.sendRebootRequest();
                if (shell != null) {
                    BDialog.message((BWidget)shell, (String)lexicon.getText("DaemonSessionView.reboot.notifyTitle", new Object[]{this.session.getRemoteAddressString()}), (Object)lexicon.getText("DaemonSessionView.reboot.notifyMessage", new Object[]{this.session.getRemoteAddressString()}));
                }
            }
            catch (AuthenticationException authenticationException) {
                if (!log.isLoggable(Level.FINEST)) break block5;
                log.finest("Authentication exception occurred while sending reboot request (" + (Object)((Object)authenticationException) + ")");
            }
        }
    }

    public boolean reauthenticate(AuthenticationException authenticationException) {
        return AuthUtil.challenge((BWidget)this.getWbShell(), (AuthenticationException)authenticationException);
    }

    public void startRefreshTimer() {
        if (log.isLoggable(Level.FINEST)) {
            String hostString = this.session != null ? this.session.getHost().toString() : "Uninitialized host";
            log.finest("Starting refresh timer for view '" + this + "' on host '" + hostString + "'");
        }
        if (this.isRunning()) {
            this.refresh();
            if (this.refreshWorker == null) {
                this.refreshWorker = new Worker((Worker.ITodo)this.refreshQueue);
            }
            if (!this.refreshWorker.isRunning()) {
                this.refreshWorker.start(this.getClass().getSimpleName() + ":refreshWorker");
            }
            if (this.refreshTicket == null && this.isRunning()) {
                this.refreshTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)5000L), (Action)refresh, null);
            }
        }
    }

    public void stopRefreshTimer() {
        if (log.isLoggable(Level.FINEST)) {
            String hostString = this.session != null ? this.session.getHost().toString() : "Uninitialized host";
            log.finest("Stopping refresh timer for view '" + this + "' on host '" + hostString + "'");
        }
        if (this.refreshTicket != null) {
            if (this.refreshWorker != null && this.refreshWorker.isRunning()) {
                this.refreshWorker.stop();
                this.refreshWorker = null;
            }
            this.refreshTicket.cancel();
            this.refreshTicket = null;
        }
    }

    public boolean isRefreshTimerRunning() {
        return this.refreshTicket != null;
    }

    public static void stopAllRefreshTimers(BWbShell shell, BHost host) {
        BViewTab[] tabs;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stopping all refresh timers on host '" + host + "'");
        }
        for (BViewTab tab : tabs = BookmarkUtil.tabs((BWbShell)shell)) {
            BDaemonSessionView daemonSessionView;
            if (!(tab.getView() instanceof BDaemonSessionView) || !(daemonSessionView = (BDaemonSessionView)tab.getView()).getDaemonSession().getHost().equals((Object)host)) continue;
            daemonSessionView.stopRefreshTimer();
        }
    }

    public static void startAllRefreshTimers(BWbShell shell, BHost host) {
        BViewTab[] tabs;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Starting all refresh timers on host '" + host + "'");
        }
        for (BViewTab tab : tabs = BookmarkUtil.tabs((BWbShell)shell)) {
            BDaemonSessionView daemonSessionView;
            if (!(tab.getView() instanceof BDaemonSessionView) || !(daemonSessionView = (BDaemonSessionView)tab.getView()).getDaemonSession().getHost().equals((Object)host)) continue;
            daemonSessionView.startRefreshTimer();
        }
    }

    protected void doLoadSession(BDaemonSession value, Context cx) {
    }

    public void doHandleDaemonDropDownModified() {
        if (this.isViewLoading()) {
            return;
        }
        BDaemonSession newSession = this.daemonDropDownModel.getSession(this.daemonDropDown.getSelectedIndex());
        this.getWbShell().hyperlink(BOrd.make((BOrd)newSession.getAbsoluteOrd(), (OrdQuery)new ViewQuery(this.getType().toString())));
    }

    public void doHandleHostPropertiesChanged() {
    }

    public void doRefresh() throws Exception {
    }

    public void taskStarted(DaemonSessionTask task) {
        this.sessionTaskHandler.taskStarted(task);
    }

    public void taskUpdated(DaemonSessionTask task) {
        this.sessionTaskHandler.taskUpdated(task);
    }

    public void taskFinished(DaemonSessionTask task) {
        this.sessionTaskHandler.taskFinished(task);
    }

    public boolean isCancelEnabled() {
        return this.sessionTaskHandler.isCancelEnabled();
    }

    public void setCancelEnabled(boolean value) {
        this.sessionTaskHandler.setCancelEnabled(value);
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(refresh)) {
            try {
                this.refreshQueue.enqueue(() -> {
                    try {
                        this.doRefresh();
                    }
                    catch (Exception e) {
                        log.severe("Error refreshing daemonSessionView: " + (e.getMessage() != null ? e.getMessage() : ""));
                    }
                });
            }
            catch (QueueFullException queueFullException) {
                // empty catch block
            }
            return null;
        }
        return super.post(action, arg, cx);
    }

    private class ValueLoader
    extends Thread {
        private final Context cx;
        private final BWbShell shell;

        private ValueLoader(Context pContext) {
            super("DaemonSessionView$ValueLoader");
            this.cx = pContext;
            this.shell = BDaemonSessionView.this.getWbShell();
        }

        @Override
        public void run() {
            boolean repeat = true;
            while (repeat) {
                repeat = false;
                try {
                    if (this.shell != null) {
                        this.shell.enterBusy();
                    }
                    BDaemonSessionView.this.doLoadSession(BDaemonSessionView.this.session, this.cx);
                }
                catch (AuthenticationException authenticationException) {
                    if (!BDaemonSessionView.this.reauthenticate(authenticationException)) continue;
                    repeat = true;
                }
                catch (Exception exception) {
                    if (this.shell != null) {
                        BDialog.error((BWidget)this.shell, (String)lexicon.getText("DaemonSessionView.loadError.dlgTitle"), (Object)lexicon.getText("DaemonSessionView.loadError.dlgMessage"), (Throwable)exception);
                        continue;
                    }
                    log.log(Level.WARNING, lexicon.getText("DaemonSessionView.loadError.dlgMessage"), log.isLoggable(Level.FINE) ? exception : null);
                }
                finally {
                    BDaemonSessionView.this.loading = false;
                    if (this.shell == null) continue;
                    this.shell.exitBusy();
                }
            }
        }
    }

    private class SessionHomeCommand
    extends Command {
        private BOrd ord;

        private SessionHomeCommand(BWidget owner) {
            super(owner, null);
        }

        private void setSession(BDaemonSession session) {
            this.ord = session.getAbsoluteOrd();
        }

        public CommandArtifact doInvoke() {
            BDaemonSessionView.this.getWbShell().hyperlink(this.ord);
            return null;
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"platform.png"));
        }
    }
}

