/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel.authn;

import com.tridium.authn.ScramServerCallback;
import com.tridium.crypto.core.bundle.CryptographicAlgorithmBundle;
import com.tridium.nre.auth.NiagaraStationAlgorithmBundle;
import com.tridium.nre.auth.ScramAlgorithmBundle;
import com.tridium.nre.auth.ScramServer;
import com.tridium.tunnel.TunnelException;
import com.tridium.tunnel.TunnelUtils;
import java.io.IOException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAes256Pbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.BPasswordCache;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tunnel.authn.BTunnelCallbackHandler;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraType(agent={@AgentOn(types={"baja:DigestAuthenticationScheme"})})
public class BTunnelDigestCallbackHandler
extends BTunnelCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BTunnelDigestCallbackHandler.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof ScramServerCallback) {
                ScramServer scramServer = new ScramServer((ScramAlgorithmBundle)NiagaraStationAlgorithmBundle.getInstance(), (ScramServer.IUserKeyFactory)new TunnelUserKeyFactory());
                try {
                    String clientFirstMessage = TunnelUtils.readAuthData(this.dataInputStream);
                    String username = ScramServer.extractUsername((String)clientFirstMessage);
                    String serverFirstMessage = scramServer.createServerFirstMessage(clientFirstMessage);
                    TunnelUtils.writeAuthData(this.dataOutputStream, serverFirstMessage);
                    String clientFinalMessage = TunnelUtils.readAuthData(this.dataInputStream);
                    String serverFinalMessage = scramServer.createServerFinalMessage(clientFinalMessage);
                    TunnelUtils.writeAuthData(this.dataOutputStream, serverFinalMessage);
                    ((ScramServerCallback)callback).setUsername(username);
                    ((ScramServerCallback)callback).setServer(scramServer);
                    continue;
                }
                catch (TunnelException e) {
                    throw new IOException(e);
                }
            }
            throw new UnsupportedCallbackException(callback, "Callback " + callback.getClass().getName() + " is not supported.");
        }
    }

    protected class TunnelUserKeyFactory
    implements ScramServer.IUserKeyFactory {
        public String getUserKey(String username) {
            BUserService service = (BUserService)Sys.getService((Type)BUserService.TYPE);
            BUser user = service.getUser(username);
            try {
                if (user == null || !service.canLogin(user)) {
                    BAes256Pbkdf2HmacSha256PasswordEncoder encoder = BAes256Pbkdf2HmacSha256PasswordEncoder.makeFake((String)username);
                    return CryptographicAlgorithmBundle.extractData((String)encoder.getValue());
                }
                BAes256Pbkdf2HmacSha256PasswordEncoder.makeFake((String)username);
                BAes256Pbkdf2HmacSha256PasswordEncoder encoder = (BAes256Pbkdf2HmacSha256PasswordEncoder)((BPasswordCache)user.getAuthenticator()).getPasswordEncoder();
                return CryptographicAlgorithmBundle.extractData((String)encoder.getValue());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not generate user key", e);
            }
        }
    }
}

